/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.prefs;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.prefs.DefaultPrefsContainer;
import com.mathworks.widgets.prefs.PrefsContainer;
import com.mathworks.widgets.prefs.PrefsModel;
import com.mathworks.widgets.prefs.PrefsNavigationEvent;
import com.mathworks.widgets.prefs.PrefsNavigationListener;
import com.mathworks.widgets.prefs.PrefsNavigationTree;
import com.mathworks.widgets.prefs.PrefsNavigator;
import com.mathworks.widgets.prefs.PrefsNode;
import com.mathworks.widgets.prefs.PrefsUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class GenericPrefsDialog {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.widgets.prefs.resources.RES_Prefs");
    private static final Dimension MIN_COMPONENT_SIZE = new Dimension(530, 500);
    private static final Dimension MAX_COMPONENT_SIZE = new Dimension(678, 740);
    private static final Dimension MIN_SIZE = new Dimension(550, 640);
    private static final Dimension MAX_SIZE = new Dimension((int)WindowUtils.getScreenBounds().getWidth() - 20, (int)WindowUtils.getScreenBounds().getHeight() - 20);
    private final ResourceBundle fRes;
    private final PrefsNavigator fNavigator;
    private final PrefsContainer fContainer;
    private final PrefsModel fModel;
    private final Window fWindow;
    private static final String OK_COMMAND = "OK";
    private static final String CANCEL_COMMAND = "Cancel";
    private static final String APPLY_COMMAND = "Apply";
    private static final String HELP_COMMAND = "Help";
    private static final int PANEL_SPACE = 5;
    private static final int MAC_BUTTON_GAP = 18;

    public GenericPrefsDialog(Type type, String string, PrefsModel prefsModel) {
        this(type, string, prefsModel, new PrefsNavigationTree(prefsModel).getNavigator(), new DefaultPrefsContainer(prefsModel, MIN_COMPONENT_SIZE, MAX_COMPONENT_SIZE, string), sRes, null);
    }

    public GenericPrefsDialog(Type type, String string, PrefsModel prefsModel, MJFrame mJFrame) {
        this(type, string, prefsModel, new PrefsNavigationTree(prefsModel).getNavigator(), new DefaultPrefsContainer(prefsModel, MIN_COMPONENT_SIZE, MAX_COMPONENT_SIZE, string), sRes, mJFrame);
    }

    public GenericPrefsDialog(Type type, String string, String string2, PrefsModel prefsModel) {
        this(type, string, prefsModel, new PrefsNavigationTree(prefsModel).getNavigator(), new DefaultPrefsContainer(prefsModel, MIN_COMPONENT_SIZE, MAX_COMPONENT_SIZE, string2), sRes, null);
    }

    public GenericPrefsDialog(Type type, String string, PrefsModel prefsModel, Dimension dimension, Dimension dimension2) {
        this(type, string, prefsModel, new PrefsNavigationTree(prefsModel).getNavigator(), new DefaultPrefsContainer(prefsModel, dimension, dimension2, string), sRes, null);
    }

    public GenericPrefsDialog(Type type, String string, String string2, PrefsModel prefsModel, Dimension dimension, Dimension dimension2) {
        this(type, string, prefsModel, new PrefsNavigationTree(prefsModel).getNavigator(), new DefaultPrefsContainer(prefsModel, dimension, dimension2, string2), sRes, null);
    }

    public GenericPrefsDialog(Type type, String string, PrefsModel prefsModel, PrefsNavigator prefsNavigator, PrefsContainer prefsContainer) {
        this(type, string, prefsModel, prefsNavigator, prefsContainer, sRes, null);
    }

    public GenericPrefsDialog(Type type, String string, PrefsModel prefsModel, PrefsNavigator prefsNavigator, PrefsContainer prefsContainer, ResourceBundle resourceBundle, MJFrame mJFrame) {
        this.fRes = resourceBundle;
        this.fModel = prefsModel;
        this.fNavigator = prefsNavigator;
        this.fContainer = prefsContainer;
        if (type == Type.FRAME) {
            this.fWindow = new MJFrame();
            this.setup(((RootPaneContainer)((Object)this.fWindow)).getContentPane(), mJFrame);
            ((MJFrame)this.fWindow).setCloseOnEscapeEnabled(true);
            ((Frame)this.fWindow).setTitle(string);
            ((JFrame)this.fWindow).setDefaultCloseOperation(2);
        } else if (type == Type.DIALOG) {
            this.fWindow = new MJDialog();
            this.setup(((RootPaneContainer)((Object)this.fWindow)).getContentPane(), mJFrame);
            ((MJDialog)this.fWindow).setCloseOnEscapeEnabled(true);
            ((Dialog)this.fWindow).setTitle(string);
            ((JDialog)this.fWindow).setDefaultCloseOperation(2);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Window getWindow() {
        return this.fWindow;
    }

    public PrefsNavigator getNavigator() {
        return this.fNavigator;
    }

    public PrefsModel getModel() {
        return this.fModel;
    }

    public PrefsContainer getContainer() {
        return this.fContainer;
    }

    public void refresh() {
        this.fNavigator.refresh();
    }

    private void setup(Container container, MJFrame mJFrame) {
        JComponent jComponent = this.fContainer.getComponent();
        final JComponent jComponent2 = this.fNavigator.getComponent();
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.setBorder(Borders.DIALOG_BORDER);
        container.add((Component)mJPanel, "Center");
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel2.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5), BorderFactory.createEtchedBorder()));
        MJScrollPane mJScrollPane = new MJScrollPane(jComponent2){

            public Dimension getPreferredSize() {
                return jComponent2.getPreferredSize();
            }
        };
        mJScrollPane.setBorder(BorderFactory.createEmptyBorder());
        if (PlatformInfo.isMacintosh()) {
            mJScrollPane.setVerticalScrollBarPolicy(20);
        }
        mJScrollPane.setHorizontalScrollBarPolicy(31);
        mJScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        mJPanel2.add((Component)mJScrollPane, (Object)"Center");
        mJPanel.add((Component)mJPanel2, (Object)"West");
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout(5, 10));
        mJPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        mJPanel3.add((Component)jComponent, (Object)"Center");
        mJPanel.add((Component)mJPanel3, (Object)"Center");
        MJButton mJButton = new MJButton(this.fRes.getString("button.ok"));
        mJButton.setName(OK_COMMAND);
        mJButton.getAccessibleContext().setAccessibleName(OK_COMMAND);
        mJButton.setActionCommand(OK_COMMAND);
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericPrefsDialog.this.doOk();
            }
        });
        MJButton mJButton2 = new MJButton(this.fRes.getString("button.cancel"));
        mJButton2.setName(CANCEL_COMMAND);
        mJButton2.getAccessibleContext().setAccessibleName(CANCEL_COMMAND);
        mJButton2.setActionCommand(CANCEL_COMMAND);
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericPrefsDialog.this.fContainer.dispose();
                GenericPrefsDialog.this.fNavigator.dispose();
                GenericPrefsDialog.this.fWindow.dispose();
            }
        });
        MJButton mJButton3 = new MJButton(this.fRes.getString("button.apply"));
        mJButton3.setName(APPLY_COMMAND);
        mJButton3.getAccessibleContext().setAccessibleName(APPLY_COMMAND);
        mJButton3.setActionCommand(APPLY_COMMAND);
        mJButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericPrefsDialog.this.doApply();
            }
        });
        final MJHelpButton mJHelpButton = new MJHelpButton();
        mJHelpButton.setName(HELP_COMMAND);
        mJHelpButton.getAccessibleContext().setAccessibleName(HELP_COMMAND);
        mJHelpButton.setActionCommand(HELP_COMMAND);
        mJHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenericPrefsDialog.this.doHelp();
            }
        });
        JPanel jPanel = PlatformInfo.isMacintosh() ? ButtonBarFactory.buildHelpBar((JButton)mJHelpButton, (JButton)mJButton3, (JButton)mJButton2, (JButton)mJButton) : ButtonBarFactory.buildRightAlignedBar((JButton)mJButton, (JButton)mJButton2, (JButton)mJButton3, (JButton)mJHelpButton);
        mJPanel.add((Component)jPanel, (Object)"South");
        this.fNavigator.addNavigationListener(new PrefsNavigationListener(){

            @Override
            public void nodeDisplayed(PrefsNavigationEvent prefsNavigationEvent) {
                GenericPrefsDialog.this.fContainer.display(prefsNavigationEvent.getNode());
                mJHelpButton.setEnabled(prefsNavigationEvent.getNode().isEditable() && prefsNavigationEvent.getNode().getEditorPanel().getHelp() != null);
            }

            public void nodeTurnedOn(PrefsNavigationEvent prefsNavigationEvent) {
            }

            public void nodeTurnedOff(PrefsNavigationEvent prefsNavigationEvent) {
            }
        });
        this.fWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                GenericPrefsDialog.this.doCancel();
            }
        });
        Font font = UIManager.getFont("Panel.font");
        FontMetrics fontMetrics = this.fWindow.getFontMetrics(font);
        int n = PlatformInfo.isMacintosh() ? 37 : 40;
        int n2 = PlatformInfo.isMacintosh() ? 72 : 80;
        int n3 = (int)Math.max((double)(fontMetrics.getHeight() * n), MIN_SIZE.getHeight());
        int n4 = (int)Math.max((double)(fontMetrics.stringWidth("M") * n2), MIN_SIZE.getWidth());
        Dimension dimension = new Dimension(n4, n3);
        dimension = GenericPrefsDialog.boundSize(dimension);
        Dimension dimension2 = new Dimension((int)jPanel.getPreferredSize().getWidth() + 2 * this.fWindow.getInsets().left + 2 * mJPanel.getInsets().left + UIManager.getInt("ScrollBar.width"), n3 / 2);
        this.fWindow.setSize(dimension);
        WindowUtils.setChildLocationWithinParent((Window)mJFrame, (Window)this.fWindow);
        ((RootPaneContainer)((Object)this.fWindow)).getRootPane().setDefaultButton((JButton)mJButton);
        this.fWindow.setMinimumSize(dimension2);
        WindowUtils.ensureOnScreen((Window)this.fWindow);
    }

    protected static Dimension boundSize(Dimension dimension) {
        return new Dimension((int)Math.max(MIN_SIZE.getWidth(), Math.min(dimension.getWidth(), MAX_SIZE.getWidth())), (int)Math.max(MIN_SIZE.getHeight(), Math.min(dimension.getHeight(), MAX_SIZE.getHeight())));
    }

    public void doOk() {
        if (this.doApply()) {
            for (PrefsNode prefsNode : this.fModel.getAllNodesWithComponents()) {
                prefsNode.resetEditorPanel();
            }
            this.fContainer.dispose();
            this.fNavigator.dispose();
            this.fWindow.dispose();
        }
    }

    public void doCancel() {
        for (PrefsNode prefsNode : this.fModel.getDirtyNodes()) {
            prefsNode.cancelChanges();
        }
        for (PrefsNode prefsNode : this.fModel.getAllNodesWithComponents()) {
            prefsNode.resetEditorPanel();
        }
        this.fContainer.dispose();
        this.fNavigator.dispose();
    }

    public boolean doApply() {
        for (PrefsNode prefsNode : this.fModel.getDirtyNodes()) {
            if (prefsNode.validateChanges()) continue;
            return false;
        }
        for (PrefsNode prefsNode : this.fModel.getDirtyNodes()) {
            prefsNode.commitChanges();
        }
        return true;
    }

    public void doHelp() {
        PrefsNode prefsNode = this.fNavigator.getSelectedNode();
        if (prefsNode != null && prefsNode.getEditorPanel().getHelp() != null) {
            prefsNode.getEditorPanel().doHelp();
        }
    }

    public void show(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PrefsNode prefsNode = PrefsUtils.findByDelimitedPath(GenericPrefsDialog.this.fModel, string, "/");
                if (prefsNode != null) {
                    GenericPrefsDialog.this.fNavigator.show(prefsNode);
                    GenericPrefsDialog.this.fContainer.display(prefsNode);
                }
                GenericPrefsDialog.this.show();
            }
        });
    }

    public void show() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GenericPrefsDialog.this.fWindow.setVisible(true);
            }
        });
    }

    public boolean isVisible() {
        return this.fWindow.isVisible();
    }

    public static enum Type {
        FRAME,
        DIALOG;

    }
}

