/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.login;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.internal.loginws.client.v2.LoginServiceClient;
import com.mathworks.mlwebservices.WSEndPoints;
import com.mathworks.widgets.ComponentBuilder;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.login.AuthenticationListener;
import com.mathworks.widgets.login.AuthenticationRegistrar;
import com.mathworks.widgets.login.AuthenticationResponse;
import com.mathworks.widgets.login.DefaultPersistenceStrategy;
import com.mathworks.widgets.login.HyperlinkHandlerClient;
import com.mathworks.widgets.login.LoginFonts;
import com.mathworks.widgets.login.LoginLabel;
import com.mathworks.widgets.login.LoginPersistenceStrategy;
import com.mathworks.widgets.login.LoginResultWrapper;
import com.mathworks.widgets.login.LoginServiceWrapper;
import com.mathworks.widgets.login.LoginUtils;
import com.mathworks.widgets.login.ProxySettings;
import com.mathworks.widgets.login.WebServiceError;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public final class UniversalLoginComponent
implements ComponentBuilder {
    static final String DEFAULT_WS_ENDPOINT = WSEndPoints.getLoginWSEndPoint();
    static final String DEFAULT_CLIENT_STRING = LoginUtils.getString("ws.login.clientstring");
    private static final Color HEADER_COLOR = new Color(213, 112, 0);
    private static String sWsEndpoint = DEFAULT_WS_ENDPOINT;
    private final JPanel fPanel;
    private final JPanel fErrorMessagePanel = new JPanel();
    private final JLabel fErrorMessageLabel = new LoginLabel();
    private final JTextField fEmailTextField = new JTextField();
    private final JPasswordField fPasswordField = new JPasswordField();
    private final AbstractButton fRememberLoginCheckBox = new JCheckBox();
    private final JButton fLoginButton = new JButton();
    private final LoginPersistenceStrategy fPersistenceStrategy;
    private final HyperlinkHandlerClient fHyperlinkHandlerClient = new LoginHyperlinkHandlerClient();
    private String fToken;
    private AuthenticationListener fAuthenticationListener;
    private LoginServiceClient fLoginService;

    public UniversalLoginComponent(String string, AuthenticationListener authenticationListener, ProxySettings proxySettings) {
        this(string, authenticationListener, LoginDisplayType.LOGIN_AND_BENEFITS, proxySettings);
    }

    public UniversalLoginComponent(String string, AuthenticationListener authenticationListener, LoginDisplayType loginDisplayType, ProxySettings proxySettings) {
        this(string, authenticationListener, loginDisplayType, new DefaultPersistenceStrategy(), proxySettings);
    }

    public UniversalLoginComponent(String string, AuthenticationListener authenticationListener, LoginDisplayType loginDisplayType, LoginPersistenceStrategy loginPersistenceStrategy, ProxySettings proxySettings) {
        assert (SwingUtilities.isEventDispatchThread()) : "UniversalLoginComponent must be created on the EDT.";
        assert (string != null) : "UniversalLoginComponent must be created with non-null clientString.";
        assert (authenticationListener != null) : "UniversalLoginComponent must be created with non-null AuthenticationListener.";
        assert (loginPersistenceStrategy != null) : "UniversalLoginComponent must be created with non-null LoginPersistenceStrategy.";
        this.fPersistenceStrategy = loginPersistenceStrategy;
        this.setAuthenticationListener(authenticationListener);
        String string2 = UniversalLoginComponent.getClientVersion(string);
        this.fLoginService = LoginServiceWrapper.getDefaultLoginService(sWsEndpoint, string2, proxySettings);
        this.fPanel = this.createComponent(loginDisplayType);
    }

    public UniversalLoginComponent(String string, AuthenticationListener authenticationListener, LoginDisplayType loginDisplayType, LoginPersistenceStrategy loginPersistenceStrategy, String string2, ProxySettings proxySettings) {
        assert (SwingUtilities.isEventDispatchThread()) : "UniversalLoginComponent must be created on the EDT.";
        assert (string != null) : "UniversalLoginComponent must be created with non-null clientString.";
        assert (authenticationListener != null) : "UniversalLoginComponent must be created with non-null AuthenticationListener.";
        assert (loginPersistenceStrategy != null) : "UniversalLoginComponent must be created with non-null LoginPersistenceStrategy.";
        assert (string2 != null) : "UniversalLoginComponent must be created with non-null Web-Service Login Endpoint.";
        this.fPersistenceStrategy = loginPersistenceStrategy;
        this.setAuthenticationListener(authenticationListener);
        String string3 = UniversalLoginComponent.getClientVersion(string);
        sWsEndpoint = string2;
        this.fLoginService = LoginServiceWrapper.getDefaultLoginService(sWsEndpoint, string3, proxySettings);
        this.fPanel = this.createComponent(loginDisplayType);
    }

    public UniversalLoginComponent(AuthenticationListener authenticationListener, LoginDisplayType loginDisplayType, LoginPersistenceStrategy loginPersistenceStrategy, LoginServiceClient loginServiceClient) {
        assert (SwingUtilities.isEventDispatchThread()) : "UniversalLoginComponent must be created on the EDT.";
        assert (authenticationListener != null) : "UniversalLoginComponent must be created with non-null AuthenticationListener.";
        assert (loginPersistenceStrategy != null) : "UniversalLoginComponent must be created with non-null LoginPersistenceStrategy.";
        assert (loginServiceClient != null) : "UniversalLoginComponent must be created with non-null LoginServiceClient.";
        this.fPersistenceStrategy = loginPersistenceStrategy;
        this.setAuthenticationListener(authenticationListener);
        this.fLoginService = loginServiceClient;
        this.fPanel = this.createComponent(loginDisplayType);
    }

    static String getClientVersion(String string) {
        String string2 = string != null && string.length() > 0 ? LoginUtils.getClientVersion(string) : LoginUtils.getClientVersion(DEFAULT_CLIENT_STRING);
        return string2;
    }

    private JPanel createComponent(LoginDisplayType loginDisplayType) {
        if (!this.fPersistenceStrategy.readRememberLogin()) {
            this.resetLoginTokenAndUsername();
        }
        JPanel jPanel = new JPanel();
        jPanel.setName("UniversalLoginComponent");
        jPanel.getAccessibleContext().setAccessibleName("UniversalLoginComponent");
        switch (loginDisplayType) {
            case LOGIN: {
                this.buildErrorMessagePanel(jPanel);
                JPanel jPanel2 = this.createInputPanel(true, loginDisplayType);
                JPanel jPanel3 = this.createAccountPanel();
                JTextArea jTextArea = UniversalLoginComponent.createLegalDisclaimer(jPanel, 5);
                UniversalLoginComponent.layoutLoginPanel(jPanel, this.fErrorMessagePanel, jPanel2, jTextArea, jPanel3);
                break;
            }
            case LOGIN_AND_BENEFITS: {
                this.buildErrorMessagePanel(jPanel);
                JPanel jPanel4 = this.createInputPanel(true, loginDisplayType);
                JPanel jPanel5 = this.createBenefitsPanel();
                JTextArea jTextArea = UniversalLoginComponent.createLegalDisclaimer(jPanel, 2);
                UniversalLoginComponent.layoutLoginBenefitsPanel(jPanel, this.fErrorMessagePanel, jPanel4, jTextArea, jPanel5);
                break;
            }
            case SHORT_LOGIN: {
                this.buildErrorMessagePanel(jPanel);
                JPanel jPanel6 = this.createInputPanel(false, loginDisplayType);
                JPanel jPanel7 = this.createBrandingImage();
                JTextArea jTextArea = UniversalLoginComponent.createLegalDisclaimerInu(jPanel, 1);
                UniversalLoginComponent.layoutShortLoginPanel(jPanel, this.fErrorMessagePanel, jPanel6, jTextArea, jPanel7);
            }
        }
        return jPanel;
    }

    private Object buildErrorMessagePanel(Component component) {
        this.fErrorMessagePanel.setLayout(new FlowLayout());
        this.fErrorMessagePanel.setBackground(component.getBackground());
        this.fErrorMessagePanel.setForeground(component.getForeground());
        this.fErrorMessagePanel.add(new JLabel(CommonIcon.ERROR.getIcon()));
        this.fErrorMessageLabel.setName("ErrorMessageLabel");
        this.fErrorMessageLabel.getAccessibleContext().setAccessibleName("ErrorMessageLabel");
        this.fErrorMessagePanel.add(this.fErrorMessageLabel);
        this.fErrorMessagePanel.setName("ErrorMessagePanel");
        this.fErrorMessagePanel.getAccessibleContext().setAccessibleName("ErrorMessagePanel");
        this.fErrorMessagePanel.setOpaque(true);
        this.fErrorMessagePanel.setVisible(false);
        return this.fErrorMessagePanel;
    }

    private JPanel createAccountPanel() {
        JLabel jLabel = UniversalLoginComponent.createAccountTitleLabel();
        HyperlinkTextLabel hyperlinkTextLabel = this.createAccountLabel();
        JPanel jPanel = new JPanel();
        jPanel.setName("LoginCreateAccountPanel");
        jPanel.getAccessibleContext().setAccessibleName("LoginCreateAccountPanel");
        jPanel.setLayout(new FlowLayout());
        jPanel.add(jLabel);
        jPanel.add(hyperlinkTextLabel.getComponent());
        return jPanel;
    }

    private static JLabel createAccountTitleLabel() {
        return new LoginLabel(LoginUtils.getString("universalLogin.account.title"), "CreateAccountTitleLabel", "CreateAccountTitleLabel", LoginFonts.getTitleFont(), Color.BLACK);
    }

    private static JLabel createAccountTitleLabel(Color color) {
        return new LoginLabel(LoginUtils.getString("universalLogin.account.title"), "CreateAccountTitleLabel", "CreateAccountTitleLabel", LoginFonts.getTitleFont(), color);
    }

    private HyperlinkTextLabel createAccountLabel() {
        String string = LoginUtils.getHyperlinkHtml(LoginUtils.getString("universalLogin.account.creation.url"), LoginUtils.getString("universalLogin.account.create.text"));
        HyperlinkTextLabel.HyperlinkHandler hyperlinkHandler = LoginUtils.getBrowserHyperlinkHandler(this.fHyperlinkHandlerClient);
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string, hyperlinkHandler, false, "CreateAccountLabel", "CreateAccountLabel");
        hyperlinkTextLabel.setFont(LoginFonts.getDefaultFont());
        return hyperlinkTextLabel;
    }

    private static JTextArea createLegalDisclaimer(Component component, int n) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(LoginUtils.getString("legal.disclaimer"));
        jTextArea.setName("LegalDisclaimer");
        jTextArea.getAccessibleContext().setAccessibleName("LegalDisclaimer");
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setRows(n);
        jTextArea.setBackground(component.getBackground());
        jTextArea.setFont(LoginFonts.getDefaultFont().deriveFont(2));
        jTextArea.setForeground(component.getForeground());
        jTextArea.setEditable(false);
        jTextArea.setOpaque(true);
        return jTextArea;
    }

    private static JTextArea createLegalDisclaimerInu(Component component, int n) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(LoginUtils.getString("universalLogin.disclaimer.inu"));
        jTextArea.setName("LegalDisclaimer");
        jTextArea.getAccessibleContext().setAccessibleName("LegalDisclaimer");
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setRows(n);
        jTextArea.setBackground(component.getBackground());
        jTextArea.setFont(LoginFonts.getDefaultFont().deriveFont(2));
        jTextArea.setForeground(component.getForeground());
        jTextArea.setEditable(false);
        jTextArea.setOpaque(true);
        jTextArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        return jTextArea;
    }

    private JPanel createBrandingImage() {
        ClassLoader classLoader = UniversalLoginComponent.class.getClassLoader();
        URL uRL = classLoader.getResource(LoginUtils.getString("universalLogin.image"));
        JLabel jLabel = uRL == null ? new JLabel(new ImageIcon()) : new JLabel(new ImageIcon(uRL));
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        return jPanel;
    }

    private JPanel createInputPanel(Boolean bl, LoginDisplayType loginDisplayType) {
        JPanel jPanel = new JPanel();
        jPanel.setName("LoginInputPanel");
        jPanel.getAccessibleContext().setAccessibleName("LoginInputPanel");
        LoginAction loginAction = new LoginAction();
        LoginLabel loginLabel = new LoginLabel(LoginUtils.getString("universalLogin.label.email"), "EmailAddressLabel", "EmailAddressLabel", LoginFonts.getTitleFont());
        LoginLabel loginLabel2 = new LoginLabel(LoginUtils.getString("universalLogin.label.password"), "PasswordLabel", "PasswordLabel", LoginFonts.getTitleFont());
        this.fEmailTextField.addActionListener(loginAction);
        this.fEmailTextField.setText(this.fPersistenceStrategy.readMwaUserName());
        this.fEmailTextField.setFont(LoginFonts.getDefaultFont());
        this.fEmailTextField.setName("EmailTextField");
        this.fEmailTextField.getAccessibleContext().setAccessibleName("EmailTextField");
        this.fPasswordField.addActionListener(loginAction);
        this.fPasswordField.setName("PasswordTextField");
        this.fPasswordField.getAccessibleContext().setAccessibleName("PasswordTextField");
        this.fRememberLoginCheckBox.setText(LoginUtils.getString("universalLogin.remember.login"));
        this.fRememberLoginCheckBox.setFont(LoginFonts.getDefaultFont());
        this.fRememberLoginCheckBox.setSelected(this.fPersistenceStrategy.readRememberLogin());
        this.fRememberLoginCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UniversalLoginComponent.this.fPersistenceStrategy.writeRememberLogin(UniversalLoginComponent.this.fRememberLoginCheckBox.isSelected());
            }
        });
        this.fRememberLoginCheckBox.setOpaque(false);
        this.fRememberLoginCheckBox.setName("RememberLoginCheckBox");
        this.fRememberLoginCheckBox.getAccessibleContext().setAccessibleName("RememberLoginCheckBox");
        this.fLoginButton.setAction(loginAction);
        if (loginDisplayType == LoginDisplayType.SHORT_LOGIN) {
            this.fLoginButton.setText(LoginUtils.getString("universalLogin.button.oktext"));
        } else {
            this.fLoginButton.setText(LoginUtils.getString("universalLogin.button.login"));
        }
        this.fLoginButton.setFont(LoginFonts.getDefaultFont());
        this.fLoginButton.setName("LoginButton");
        this.fLoginButton.getAccessibleContext().setAccessibleName("LoginButton");
        String string = LoginUtils.getHyperlinkHtml(LoginUtils.getString("universalLogin.forgot.password.url"), LoginUtils.getString("universalLogin.forgot.password"));
        HyperlinkTextLabel.HyperlinkHandler hyperlinkHandler = LoginUtils.getBrowserHyperlinkHandler(this.fHyperlinkHandlerClient);
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string, hyperlinkHandler, false, "ForgotPasswordLabel", "ForgotPasswordLabel");
        hyperlinkTextLabel.setFont(LoginFonts.getDefaultFont());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(new JLabel(CommonIcon.HELP.getIcon()));
        jPanel2.add(hyperlinkTextLabel.getComponent());
        jPanel2.setName("ForgotPasswordPanel");
        jPanel2.getAccessibleContext().setAccessibleName("ForgotPasswordPanel");
        FormLayout formLayout = new FormLayout("left:pref, right:pref:grow", "pref, 4dlu, pref, 4dlu, pref, 4dlu, pref, 4dlu, pref, 4dlu, pref, 8dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)loginLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.fEmailTextField, cellConstraints.xywh(1, 3, 2, 1));
        panelBuilder.add((Component)loginLabel2, cellConstraints.xy(1, 5));
        panelBuilder.add((Component)this.fPasswordField, cellConstraints.xywh(1, 7, 2, 1));
        panelBuilder.add((Component)this.fLoginButton, cellConstraints.xywh(2, 9, 1, 1, "r, b"));
        if (bl.booleanValue()) {
            panelBuilder.add((Component)this.fRememberLoginCheckBox, cellConstraints.xy(1, 11));
        }
        panelBuilder.add((Component)jPanel2, cellConstraints.xy(1, 13));
        return jPanel;
    }

    private JPanel createBenefitsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setName("LoginBenefitsPanel");
        jPanel.getAccessibleContext().setAccessibleName("LoginBenefitsPanel");
        JLabel jLabel = UniversalLoginComponent.createAccountTitleLabel(HEADER_COLOR);
        LoginLabel loginLabel = new LoginLabel(LoginUtils.getString("universalLogin.benefits.title"), "ViewBenefitsTitleLabel", "ViewBenefitsTitleLabel", LoginFonts.getTitleFont(), HEADER_COLOR);
        LoginLabel loginLabel2 = new LoginLabel(LoginUtils.getString("universalLogin.benefits.licenseduser"), "LicensedUserLabel", "LicensedUserLabel");
        String string = "\u25aa  ";
        LoginLabel loginLabel3 = new LoginLabel(string + LoginUtils.getString("universalLogin.benefits.line1"), "BenefitLabel1", "BenefitLabel1");
        LoginLabel loginLabel4 = new LoginLabel(string + LoginUtils.getString("universalLogin.benefits.line2"), "BenefitLabel2", "BenefitLabel2");
        LoginLabel loginLabel5 = new LoginLabel(string + LoginUtils.getString("universalLogin.benefits.line3"), "BenefitLabel3", "BenefitLabel3");
        LoginLabel loginLabel6 = new LoginLabel(string + LoginUtils.getString("universalLogin.benefits.line4"), "BenefitLabel4", "BenefitLabel4");
        LoginLabel loginLabel7 = new LoginLabel(string + LoginUtils.getString("universalLogin.benefits.line5"), "BenefitLabel5", "BenefitLabel5");
        LoginLabel loginLabel8 = new LoginLabel(string + LoginUtils.getString("universalLogin.benefits.line6"), "BenefitLabel6", "BenefitLabel6");
        LoginLabel loginLabel9 = new LoginLabel(string + LoginUtils.getString("universalLogin.benefits.line7"), "BenefitLabel7", "BenefitLabel7");
        HyperlinkTextLabel hyperlinkTextLabel = this.createAccountLabel();
        String string2 = LoginUtils.getHyperlinkHtml(LoginUtils.getString("universalLogin.view.benefits.url"), LoginUtils.getString("universalLogin.benefits.viewall"));
        HyperlinkTextLabel.HyperlinkHandler hyperlinkHandler = LoginUtils.getBrowserHyperlinkHandler(this.fHyperlinkHandlerClient);
        HyperlinkTextLabel hyperlinkTextLabel2 = new HyperlinkTextLabel(string2, hyperlinkHandler, false, "ViewBenefitsLabel", "ViewBenefitsLabel");
        hyperlinkTextLabel2.setFont(LoginFonts.getDefaultFont());
        FormLayout formLayout = new FormLayout("10dlu, pref:grow", "pref, pref, 8dlu, pref, pref, pref, pref, pref, pref, pref, pref, pref, 6dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(1, 1, 2, 1));
        panelBuilder.add((Component)hyperlinkTextLabel.getComponent(), cellConstraints.xywh(1, 2, 2, 1));
        panelBuilder.add((Component)loginLabel, cellConstraints.xywh(1, 4, 2, 1));
        panelBuilder.add((Component)loginLabel3, cellConstraints.xywh(1, 5, 2, 1));
        panelBuilder.add((Component)loginLabel4, cellConstraints.xywh(1, 6, 2, 1));
        panelBuilder.add((Component)loginLabel5, cellConstraints.xywh(1, 7, 2, 1));
        panelBuilder.add((Component)loginLabel6, cellConstraints.xywh(1, 8, 2, 1));
        panelBuilder.add((Component)loginLabel7, cellConstraints.xywh(1, 9, 2, 1));
        panelBuilder.add((Component)loginLabel8, cellConstraints.xywh(1, 10, 2, 1));
        panelBuilder.add((Component)loginLabel9, cellConstraints.xywh(1, 11, 2, 1));
        panelBuilder.add((Component)hyperlinkTextLabel2.getComponent(), cellConstraints.xywh(1, 12, 2, 1));
        panelBuilder.add((Component)loginLabel2, cellConstraints.xy(2, 14));
        return jPanel;
    }

    private static void layoutLoginPanel(JPanel jPanel, Component component, Component component2, Component component3, Component component4) {
        FormLayout formLayout = new FormLayout("pref:grow", "pref, 2dlu, pref, 2dlu, pref, 4dlu, pref:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add(component, cellConstraints.xy(1, 1, "l, t"));
        panelBuilder.add(component4, cellConstraints.xy(1, 3, "l, t"));
        panelBuilder.add(component2, cellConstraints.xy(1, 5, "l, t"));
        panelBuilder.add(component3, cellConstraints.xy(1, 7));
    }

    private static void layoutShortLoginPanel(JPanel jPanel, Component component, Component component2, Component component3, Component component4) {
        JPanel jPanel2 = new JPanel();
        FormLayout formLayout = new FormLayout("pref:grow", "pref, 2dlu, pref, 2dlu:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel2);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add(component, cellConstraints.xy(1, 1, "l, t"));
        panelBuilder.add(component2, cellConstraints.xy(1, 3, "l, t"));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "West");
        jPanel.add(component4, "East");
        jPanel.add(component3, "South");
    }

    private static void layoutLoginBenefitsPanel(JPanel jPanel, Component component, Component component2, Component component3, Component component4) {
        JPanel jPanel2 = new JPanel();
        FormLayout formLayout = new FormLayout("pref, 8dlu, pref", "pref, 2dlu, pref:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, jPanel2);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add(component, cellConstraints.xy(1, 1, "l, t"));
        panelBuilder.add(component2, cellConstraints.xy(1, 3, "l, t"));
        panelBuilder.add(component4, cellConstraints.xywh(3, 1, 1, 3, "l, t"));
        FormLayout formLayout2 = new FormLayout("pref", "pref, 4dlu, pref:grow");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2, jPanel);
        panelBuilder2.setDefaultDialogBorder();
        CellConstraints cellConstraints2 = new CellConstraints();
        panelBuilder2.add((Component)jPanel2, cellConstraints2.xy(1, 1));
        panelBuilder2.add(component3, cellConstraints2.xy(1, 3));
    }

    void clearPanel() {
        assert (SwingUtilities.isEventDispatchThread());
        this.clearErrorMessage();
        this.fEmailTextField.setText(this.fPersistenceStrategy.readMwaUserName());
        this.fPasswordField.setText("");
        this.fRememberLoginCheckBox.setSelected(this.fPersistenceStrategy.readRememberLogin());
    }

    void requestFocus() {
        this.fEmailTextField.requestFocus();
    }

    @Override
    public JComponent getComponent() {
        return this.fPanel;
    }

    public void setVisible(boolean bl) {
        this.fPanel.setVisible(bl);
    }

    JButton getDefaultButton() {
        return this.fLoginButton;
    }

    synchronized void setAuthenticationListener(AuthenticationListener authenticationListener) {
        assert (SwingUtilities.isEventDispatchThread()) : "AuthenticationListener must be set on the EDT.";
        this.fAuthenticationListener = authenticationListener;
    }

    synchronized AuthenticationListener getAuthenticationListener() {
        return this.fAuthenticationListener;
    }

    private static boolean isValidEmailOrPassword(CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    static String formatLoginError(Collection<WebServiceError> collection) {
        if (collection == null || collection.isEmpty()) {
            return LoginUtils.getString("universalLogin.general.execption");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (WebServiceError webServiceError : collection) {
            stringBuilder.append(webServiceError.getDescription()).append('\n');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private void saveUserPrefs() {
        if (this.fPersistenceStrategy.readRememberLogin()) {
            this.fPersistenceStrategy.writeMwaUserName(this.fEmailTextField.getText());
            if (this.fToken != null) {
                this.fPersistenceStrategy.writeLoginToken(this.fToken);
            }
        } else {
            this.resetLoginTokenAndUsername();
        }
    }

    private void resetLoginTokenAndUsername() {
        this.fPersistenceStrategy.writeLoginToken("");
        this.fPersistenceStrategy.writeMwaUserName("");
    }

    private void setToken(String string) {
        this.fToken = string;
    }

    private void displayErrorMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UniversalLoginComponent.this.fErrorMessageLabel.setText(string);
                UniversalLoginComponent.this.fErrorMessagePanel.setVisible(true);
                Container container = UniversalLoginComponent.this.getComponent().getParent();
                do {
                    if (!(container instanceof Window)) continue;
                    Window window = (Window)container;
                    window.validate();
                    window.pack();
                    break;
                } while ((container = container.getParent()) != null);
            }
        });
    }

    private void clearErrorMessage() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UniversalLoginComponent.this.fErrorMessageLabel.setText("");
                UniversalLoginComponent.this.fErrorMessagePanel.setVisible(false);
                Container container = UniversalLoginComponent.this.getComponent().getParent();
                do {
                    if (!(container instanceof Window)) continue;
                    Window window = (Window)container;
                    window.validate();
                    window.pack();
                    break;
                } while ((container = container.getParent()) != null);
            }
        });
    }

    public static String getWsEndpoint() {
        return sWsEndpoint;
    }

    public static void setWsEndpoint(String string) {
        sWsEndpoint = string;
    }

    private class LoginHyperlinkHandlerClient
    implements HyperlinkHandlerClient {
        private LoginHyperlinkHandlerClient() {
        }

        @Override
        public void handleError(String string) {
            UniversalLoginComponent.this.displayErrorMessage(string);
        }
    }

    private class GetTokenWorker
    extends SwingWorker<Boolean, Object> {
        private String iEmailAddress;
        private String iPassword;
        private String iToken;
        private String iMessage;

        private GetTokenWorker(String string, String string2) {
            this.iEmailAddress = string;
            this.iPassword = string2;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            boolean bl;
            assert (UniversalLoginComponent.this.fLoginService != null);
            LoginResultWrapper loginResultWrapper = LoginServiceWrapper.getInstance().getToken(this.iEmailAddress, this.iPassword, UniversalLoginComponent.this.fLoginService);
            this.iToken = loginResultWrapper.getToken();
            if (this.iToken != null) {
                UniversalLoginComponent.this.setToken(this.iToken);
                UniversalLoginComponent.this.saveUserPrefs();
                bl = true;
            } else {
                List<WebServiceError> list = loginResultWrapper.getErrors();
                this.iMessage = UniversalLoginComponent.formatLoginError(list);
                bl = false;
            }
            return bl;
        }

        @Override
        protected void done() {
            try {
                boolean bl = (Boolean)this.get();
                if (bl) {
                    AuthenticationResponse authenticationResponse = new AuthenticationResponse(this.iToken, this.iEmailAddress);
                    if (UniversalLoginComponent.this.getAuthenticationListener() != null) {
                        UniversalLoginComponent.this.getAuthenticationListener().authenticated(authenticationResponse);
                    }
                    AuthenticationRegistrar.notifyAllAuthenticationListeners(authenticationResponse);
                } else {
                    UniversalLoginComponent.this.displayErrorMessage(this.iMessage);
                }
            }
            catch (InterruptedException interruptedException) {
                UniversalLoginComponent.this.displayErrorMessage(interruptedException.getMessage());
            }
            catch (ExecutionException executionException) {
                UniversalLoginComponent.this.displayErrorMessage(executionException.getMessage());
            }
        }
    }

    private class LoginAction
    extends AbstractAction {
        private LoginAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UniversalLoginComponent.this.clearErrorMessage();
            String string = UniversalLoginComponent.this.fEmailTextField.getText();
            char[] cArray = UniversalLoginComponent.this.fPasswordField.getPassword();
            String string2 = new String(cArray);
            if (UniversalLoginComponent.isValidEmailOrPassword(string) && UniversalLoginComponent.isValidEmailOrPassword(string2)) {
                GetTokenWorker getTokenWorker = new GetTokenWorker(string, string2);
                getTokenWorker.execute();
            } else {
                String string3 = LoginUtils.getString("universalLogin.invalid.username");
                UniversalLoginComponent.this.displayErrorMessage(string3);
            }
        }
    }

    public static enum LoginDisplayType {
        LOGIN,
        LOGIN_AND_BENEFITS,
        SHORT_LOGIN;

    }
}

