/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.login;

import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.mlwebservices.WSEndPoints;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.login.HyperlinkHandlerClient;
import com.mathworks.widgets.login.LoginResourceBundle;
import java.awt.Desktop;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class LoginUtils {
    private static LoginResourceBundle sResBundle = new LoginResourceBundle();

    private LoginUtils() {
    }

    static String getString(String string) {
        return sResBundle.getString(string);
    }

    public static String getClientVersion(String string) {
        return string + '-' + LoginUtils.getReleaseNumber();
    }

    private static String getReleaseNumber() {
        return InstutilResourceKeys.RELEASE.getString(new Object[0]);
    }

    public static String getHyperlinkHtml(String string, String string2) {
        return "<a href=\"" + string + "\">" + string2 + "</a>";
    }

    public static HyperlinkTextLabel.HyperlinkHandler getBrowserHyperlinkHandler(final HyperlinkHandlerClient hyperlinkHandlerClient) {
        return new HyperlinkTextLabel.HyperlinkHandler(){

            @Override
            public void processHyperlink(String string) {
                try {
                    LoginUtils.browseInDefaultBrowser(string);
                }
                catch (IOException iOException) {
                    hyperlinkHandlerClient.handleError(iOException.getMessage());
                }
                catch (URISyntaxException uRISyntaxException) {
                    hyperlinkHandlerClient.handleError(uRISyntaxException.getMessage());
                }
            }
        };
    }

    public static void browseInDefaultBrowser(String string) throws URISyntaxException, IOException {
        Object object;
        if (string == null || string.length() <= 0) {
            return;
        }
        String string2 = string;
        try {
            object = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            string2 = WSEndPoints.getMathWorksEndPoint() + string;
        }
        if (Desktop.isDesktopSupported()) {
            object = Desktop.getDesktop();
            URI uRI = new URI(string2);
            ((Desktop)object).browse(uRI);
        }
    }
}

