/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.login;

import com.mathworks.widgets.login.AuthenticationListener;
import com.mathworks.widgets.login.AuthenticationResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.Validate;

public class AuthenticationRegistrar {
    private static Set<AuthenticationListener> sAuthenticationListeners = Collections.synchronizedSet(new HashSet());

    private AuthenticationRegistrar() {
    }

    public static void addAuthenticationListener(AuthenticationListener authenticationListener) {
        Validate.notNull((Object)authenticationListener, (String)"Authentication Listeners may not be null.");
        sAuthenticationListeners.add(authenticationListener);
    }

    public static void removeAuthenticationListener(AuthenticationListener authenticationListener) {
        sAuthenticationListeners.add(authenticationListener);
    }

    public static void notifyAllAuthenticationListeners(AuthenticationResponse authenticationResponse) {
        AuthenticationRegistrar.notifyAuthenticationListeners(authenticationResponse, null);
    }

    public static void notifyOtherAuthenticationListeners(AuthenticationResponse authenticationResponse, AuthenticationListener authenticationListener) {
        AuthenticationRegistrar.notifyAuthenticationListeners(authenticationResponse, authenticationListener);
    }

    private static void notifyAuthenticationListeners(final AuthenticationResponse authenticationResponse, final AuthenticationListener authenticationListener) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ArrayList arrayList = new ArrayList(sAuthenticationListeners);
                for (AuthenticationListener authenticationListener2 : arrayList) {
                    if (authenticationListener != null && authenticationListener2.equals(authenticationListener)) continue;
                    if (AuthenticationRegistrar.isAuthenticated(authenticationResponse)) {
                        authenticationListener2.authenticated(authenticationResponse);
                        continue;
                    }
                    authenticationListener2.notAuthenticated();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static boolean isAuthenticated(AuthenticationResponse authenticationResponse) {
        return authenticationResponse != null && authenticationResponse.getToken() != null && authenticationResponse.getToken().length() > 0;
    }
}

