/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.border.DashedBorder;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTLayoutLibrary;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class DTOrganizeLayoutsDialog
extends MJDialog
implements ListSelectionListener {
    private DTLayoutLibrary fLibrary;
    private Desktop fDesktop;
    private MJTable fLayoutList;
    private MJButton fRenameButton;
    private MJButton fDeleteButton;
    private CustomEditor fCellEditor;

    DTOrganizeLayoutsDialog(DTLayoutLibrary dTLayoutLibrary, Desktop desktop, Frame frame) {
        super(frame, desktop.getString("title.OrganizeLayouts"), true);
        this.fDesktop = desktop;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        jComponent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.fLibrary = dTLayoutLibrary;
        this.fLayoutList = new CustomTable(dTLayoutLibrary.userLayoutCount(), 1);
        this.fCellEditor = new CustomEditor();
        TableModel tableModel = this.fLayoutList.getModel();
        int n = dTLayoutLibrary.userLayoutCount();
        for (int i = 0; i < n; ++i) {
            tableModel.setValueAt(dTLayoutLibrary.getUserLayoutName(i), i, 0);
        }
        this.fLayoutList.setRightSelectionEnabled(true);
        this.fLayoutList.setSelectionMode(0);
        this.fLayoutList.setRowSelectionAllowed(true);
        this.fLayoutList.setTableHeader(null);
        this.fLayoutList.setShowGrid(false);
        this.fLayoutList.getColumnModel().getColumn(0).setCellRenderer(new CustomRenderer());
        this.fLayoutList.getColumnModel().getColumn(0).setCellEditor(this.fCellEditor);
        this.fLayoutList.getSelectionModel().addListSelectionListener(this);
        this.fLayoutList.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 127) {
                    DTOrganizeLayoutsDialog.this.delete();
                } else if (n == 27) {
                    DTOrganizeLayoutsDialog.this.dispose();
                } else if (n == 9) {
                    DTOrganizeLayoutsDialog.this.fLayoutList.transferFocus();
                    keyEvent.consume();
                }
            }
        });
        this.fLayoutList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showContextMenu(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showContextMenu(mouseEvent);
                }
            }

            private void showContextMenu(MouseEvent mouseEvent) {
                MJPopupMenu mJPopupMenu = new MJPopupMenu();
                MJMenuItem mJMenuItem = new MJMenuItem(DTOrganizeLayoutsDialog.this.fDesktop.getString("button.Rename"));
                mJMenuItem.setEnabled(DTOrganizeLayoutsDialog.this.fLayoutList.getSelectedRow() != -1);
                mJMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DTOrganizeLayoutsDialog.this.rename();
                    }
                });
                mJPopupMenu.add((JMenuItem)mJMenuItem);
                mJMenuItem = new MJMenuItem(DTOrganizeLayoutsDialog.this.fDesktop.getString("button.Delete"));
                mJMenuItem.setEnabled(DTOrganizeLayoutsDialog.this.fLayoutList.getSelectedRow() != -1);
                mJMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DTOrganizeLayoutsDialog.this.delete();
                    }
                });
                mJPopupMenu.add((JMenuItem)mJMenuItem);
                mJPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        });
        Box box = Box.createVerticalBox();
        MJLabel mJLabel = new MJLabel(this.fDesktop.getString("title.SavedLayouts"));
        mJLabel.setAlignmentX(0.0f);
        box.add((Component)mJLabel);
        box.add(Box.createVerticalStrut(3));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fLayoutList);
        mJScrollPane.getHorizontalScrollBar().setFocusable(false);
        mJScrollPane.getVerticalScrollBar().setFocusable(false);
        mJScrollPane.getViewport().setBackground(this.fLayoutList.getBackground());
        mJScrollPane.setHorizontalScrollBarPolicy(30);
        mJScrollPane.setVerticalScrollBarPolicy(20);
        mJScrollPane.setAlignmentX(0.0f);
        box.add((Component)mJScrollPane);
        jComponent.add((Component)box, "Center");
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new BoxLayout((Container)mJPanel, 1));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        mJPanel.add(Box.createVerticalGlue());
        this.fRenameButton = new MJButton(this.fDesktop.getString("button.Rename"));
        this.fRenameButton.setEnabled(false);
        this.fRenameButton.setMaximumSize(new Dimension(1000, 1000));
        this.fRenameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DTOrganizeLayoutsDialog.this.rename();
            }
        });
        mJPanel.add((Component)this.fRenameButton);
        mJPanel.add(Box.createVerticalStrut(15));
        this.fDeleteButton = new MJButton(this.fDesktop.getString("button.Delete"));
        this.fDeleteButton.setEnabled(false);
        this.fDeleteButton.setMaximumSize(new Dimension(1000, 1000));
        this.fDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DTOrganizeLayoutsDialog.this.delete();
            }
        });
        mJPanel.add((Component)this.fDeleteButton);
        mJPanel.add(Box.createVerticalGlue());
        jComponent.add((Component)mJPanel, "West");
        mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new BoxLayout((Container)mJPanel, 0));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 0));
        mJPanel.add(Box.createHorizontalGlue());
        MJButton mJButton = new MJButton(this.fDesktop.getString("button.Close"));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DTOrganizeLayoutsDialog.this.dispose();
            }
        });
        mJPanel.add((Component)mJButton);
        jComponent.add((Component)mJPanel, "South");
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = this.fLayoutList.getSelectedRowCount() > 0;
        this.fRenameButton.setEnabled(bl);
        this.fDeleteButton.setEnabled(bl);
    }

    private void delete() {
        int n;
        if (this.fLayoutList.isEditing()) {
            this.fCellEditor.cancelCellEditing();
        }
        if ((n = this.fLayoutList.getSelectedRow()) == -1) {
            return;
        }
        String string = (String)this.fLayoutList.getModel().getValueAt(n, 0);
        Object[] objectArray = new Object[]{string};
        String string2 = MessageFormat.format(this.fDesktop.getString("message.ConfirmDelete"), objectArray);
        int n2 = MJOptionPane.showConfirmDialog((Component)((Object)this), (Object)string2, (String)this.fDesktop.getString("title.DeleteLayout"), (int)0);
        if (n2 == 0) {
            ((DefaultTableModel)this.fLayoutList.getModel()).removeRow(n);
            this.fLibrary.removeUserLayout(string);
        }
    }

    private void rename() {
        int n = this.fLayoutList.getSelectedRow();
        if (n != -1) {
            this.fLayoutList.editCellAt(n, 0);
            this.fCellEditor.startCellEditing();
        }
    }

    class CustomEditor
    extends DefaultCellEditor {
        MJTextField fTextField;
        int fEditRow;

        CustomEditor() {
            super((JTextField)new MJTextField());
            this.fTextField = (MJTextField)this.getComponent();
            this.fTextField.setBorder(BorderFactory.createLineBorder(Color.black));
        }

        void startCellEditing() {
            this.fTextField.requestFocus();
            this.fTextField.selectAll();
        }

        @Override
        public boolean stopCellEditing() {
            boolean bl = true;
            this.fEditRow = DTOrganizeLayoutsDialog.this.fLayoutList.getEditingRow();
            String string = (String)this.getCellEditorValue();
            String string2 = DTOrganizeLayoutsDialog.this.fLibrary.getUserLayoutName(this.fEditRow);
            if (!string2.equals(string)) {
                int n = DTOrganizeLayoutsDialog.this.fLibrary.userLayoutCount();
                for (int i = 0; i < n && bl; ++i) {
                    if (i == this.fEditRow || !DTOrganizeLayoutsDialog.this.fLibrary.getUserLayoutName(i).equalsIgnoreCase(string)) continue;
                    Object[] objectArray = new Object[]{string};
                    String string3 = MessageFormat.format(DTOrganizeLayoutsDialog.this.fDesktop.getString("message.DuplicateLayout"), objectArray);
                    MJOptionPane.showMessageDialog((Component)((Object)DTOrganizeLayoutsDialog.this), (Object)string3, (String)DTOrganizeLayoutsDialog.this.fDesktop.getString("title.RenameLayout"), (int)2);
                    bl = false;
                }
                if (bl && !(bl = DTOrganizeLayoutsDialog.this.fLibrary.renameUserLayout(this.fEditRow, string))) {
                    Object[] objectArray = new Object[]{string};
                    String string4 = MessageFormat.format(DTOrganizeLayoutsDialog.this.fDesktop.getString("message.InvalidLayout"), objectArray);
                    MJOptionPane.showMessageDialog((Component)((Object)DTOrganizeLayoutsDialog.this), (Object)string4, (String)DTOrganizeLayoutsDialog.this.fDesktop.getString("title.RenameLayout"), (int)2);
                }
            }
            if (bl) {
                return super.stopCellEditing();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DTOrganizeLayoutsDialog.this.fLayoutList.getSelectionModel().setSelectionInterval(CustomEditor.this.fEditRow, CustomEditor.this.fEditRow);
                    CustomEditor.this.fTextField.requestFocus();
                }
            });
            return false;
        }
    }

    class CustomRenderer
    extends MJLabel
    implements TableCellRenderer {
        CustomRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            Border border = null;
            if (bl2) {
                if (PlatformInfo.isMacintosh()) {
                    if (!bl) {
                        border = BorderFactory.createCompoundBorder((Border)new DashedBorder(Color.white, Color.black), BorderFactory.createEmptyBorder(1, 3, 1, 3));
                    }
                } else {
                    border = BorderFactory.createCompoundBorder((Border)new DashedBorder((Color)SystemColor.textHighlight, new Color(247, 219, 148)), BorderFactory.createEmptyBorder(1, 3, 1, 3));
                }
            }
            if (border == null) {
                border = BorderFactory.createEmptyBorder(2, 4, 2, 4);
            }
            this.setBorder(border);
            this.setText((String)object);
            return this;
        }
    }

    class CustomTable
    extends MJTable {
        CustomTable(int n, int n2) {
            super(n, n2);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getID() == 501 && SwingUtilities.isLeftMouseButton(mouseEvent) && (n = this.rowAtPoint(mouseEvent.getPoint())) != -1 && n == DTOrganizeLayoutsDialog.this.fLayoutList.getSelectedRow()) {
                DTOrganizeLayoutsDialog.this.fLayoutList.editCellAt(n, 0);
                DTOrganizeLayoutsDialog.this.fCellEditor.startCellEditing();
                mouseEvent.consume();
                return;
            }
            super.processMouseEvent(mouseEvent);
        }

        public Dimension getPreferredScrollableViewportSize() {
            int n;
            int n2;
            TableModel tableModel = this.getModel();
            TableCellRenderer tableCellRenderer = this.getCellRenderer(0, 0);
            int n3 = 100;
            for (n2 = 0; n2 < this.getRowCount(); ++n2) {
                Object object = tableModel.getValueAt(n2, 0);
                n = tableCellRenderer.getTableCellRendererComponent((JTable)((Object)this), (Object)object, (boolean)false, (boolean)false, (int)n2, (int)0).getPreferredSize().width + 2;
                if (n <= n3) continue;
                n3 = n;
            }
            n2 = WindowUtils.getScreenBounds().width - 10;
            if (n3 > n2) {
                n3 = n2;
            }
            int n4 = Math.min(this.getRowCount(), 20);
            n = n4 * this.getRowHeight();
            return new Dimension(n3, n);
        }
    }
}

