/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTGroupAdapter;
import com.mathworks.widgets.desk.DTGroupEvent;
import com.mathworks.widgets.desk.DTGroupListener;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Timer;

class DTLayoutSaveManager {
    private Desktop fDesktop;
    private DTClientListener fClientListener;
    private DTGroupListener fGroupListener;
    private DTLocation.Listener fLocationListener;
    private DTDocumentContainer.ArrangementListener fArrangementListener;
    private boolean fIsSaveEnabled;
    private Timer fSaveTimer;
    private boolean fHasSaved;
    private static final int SAVE_DELAY = 500;

    DTLayoutSaveManager(Desktop desktop) {
        this.fDesktop = desktop;
        this.fClientListener = new LocalClientListener();
        this.fGroupListener = new LocalGroupListener();
        this.fArrangementListener = new LocalArrangementListener();
        this.fLocationListener = new LocalLocationListener();
        this.fSaveTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DTLayoutSaveManager.this.shouldSave()) {
                    DTLayoutSaveManager.this.performSave();
                }
            }
        });
        this.fSaveTimer.setRepeats(false);
    }

    void setSaveEnabled(boolean bl) {
        if (this.fIsSaveEnabled != bl) {
            this.fIsSaveEnabled = bl;
            if (bl) {
                this.initiateSave();
            } else if (this.fSaveTimer.isRunning()) {
                this.fSaveTimer.stop();
            }
        }
    }

    void addClient(DTClient dTClient) {
        dTClient.addClientListener(this.fClientListener);
    }

    void removeClient(DTClient dTClient) {
        dTClient.removeClientListener(this.fClientListener);
    }

    void addGroup(DTGroup dTGroup) {
        dTGroup.addListener(this.fGroupListener);
    }

    void removeGroup(DTGroup dTGroup) {
        dTGroup.removeListener(this.fGroupListener);
    }

    void setMainFrameLocation(DTLocation dTLocation) {
        dTLocation.addChangeListener(this.fLocationListener);
    }

    void initiateSave() {
        if (this.shouldSave()) {
            if (this.fSaveTimer.isRunning()) {
                this.fSaveTimer.restart();
            } else {
                this.fSaveTimer.start();
            }
        }
    }

    private boolean shouldSave() {
        return this.fIsSaveEnabled && this.fDesktop.getLayoutSavePolicy() == Desktop.LayoutSavePolicy.UPON_CHANGE;
    }

    private void performSave() {
        if (!this.fHasSaved) {
            File file = this.fDesktop.getInitFile(false);
            if (file != null) {
                String string = file.getPath() + ".prev";
                File file2 = new File(string);
                if (file2.exists()) {
                    file2.delete();
                }
                file.renameTo(file2);
            }
            this.fHasSaved = true;
        }
        this.fDesktop.saveLayout(null);
    }

    private class LocalArrangementListener
    implements DTDocumentContainer.ArrangementListener {
        private LocalArrangementListener() {
        }

        @Override
        public void arrangementChanged(DTDocumentContainer dTDocumentContainer, int n, int n2) {
            DTLayoutSaveManager.this.initiateSave();
        }
    }

    private class LocalLocationListener
    implements DTLocation.Listener {
        private LocalLocationListener() {
        }

        @Override
        public void locationChanged(DTLocation dTLocation, DTLocation.ChangeType changeType) {
            DTLayoutSaveManager.this.initiateSave();
        }
    }

    private class LocalGroupListener
    extends DTGroupAdapter {
        private LocalGroupListener() {
        }

        @Override
        public void groupDocked(DTGroupEvent dTGroupEvent) {
            DTLayoutSaveManager.this.initiateSave();
        }

        @Override
        public void groupUndocked(DTGroupEvent dTGroupEvent) {
            DTLayoutSaveManager.this.initiateSave();
        }

        @Override
        public void groupRelocated(DTGroupEvent dTGroupEvent) {
            DTLayoutSaveManager.this.initiateSave();
        }

        @Override
        public void groupResized(DTGroupEvent dTGroupEvent) {
            DTLayoutSaveManager.this.initiateSave();
        }

        @Override
        public void groupClosed(DTGroupEvent dTGroupEvent) {
            DTGroup dTGroup = DTLayoutSaveManager.this.fDesktop.getGroup(dTGroupEvent.getGroupTitle());
            if (dTGroup != null && dTGroup.hasDocumentContainer()) {
                dTGroup.getDocumentContainer().removeArrangementListener(DTLayoutSaveManager.this.fArrangementListener);
            }
            DTLayoutSaveManager.this.initiateSave();
        }

        @Override
        public void groupOpened(DTGroupEvent dTGroupEvent) {
            DTGroup dTGroup = DTLayoutSaveManager.this.fDesktop.getGroup(dTGroupEvent.getGroupTitle());
            if (dTGroup != null && dTGroup.hasDocumentContainer()) {
                dTGroup.getDocumentContainer().addArrangementListener(DTLayoutSaveManager.this.fArrangementListener);
            }
            DTLayoutSaveManager.this.initiateSave();
        }

        @Override
        public void groupActivated(DTGroupEvent dTGroupEvent) {
            DTGroup dTGroup = DTLayoutSaveManager.this.fDesktop.getGroup(dTGroupEvent.getGroupTitle());
            if (dTGroup != null && DTLayoutSaveManager.this.fDesktop.isGroupDocked(dTGroup)) {
                DTLayoutSaveManager.this.initiateSave();
            }
        }
    }

    private class LocalClientListener
    extends DTClientAdapter {
        private LocalClientListener() {
        }

        @Override
        public void clientDocked(DTClientEvent dTClientEvent) {
            DTLayoutSaveManager.this.initiateSave();
        }

        @Override
        public void clientUndocking(DTClientEvent dTClientEvent) {
            DTLayoutSaveManager.this.initiateSave();
        }

        @Override
        public void clientRelocated(DTClientEvent dTClientEvent) {
            DTLayoutSaveManager.this.initiateSave();
        }

        @Override
        public void clientResized(DTClientEvent dTClientEvent) {
            DTLayoutSaveManager.this.initiateSave();
        }

        @Override
        public void clientOpened(DTClientEvent dTClientEvent) {
            DTLayoutSaveManager.this.initiateSave();
        }

        @Override
        public void clientClosed(DTClientEvent dTClientEvent) {
            DTLayoutSaveManager.this.initiateSave();
        }

        @Override
        public void clientActivated(DTClientEvent dTClientEvent) {
            if (DTLayoutSaveManager.this.fDesktop.isClientDocked(dTClientEvent.getClient())) {
                DTLayoutSaveManager.this.initiateSave();
            }
        }
    }
}

