/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.MoveIcon;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.KeyControlledDragger;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJGrip;
import com.mathworks.mwswing.MJLayeredPane;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJRadioButtonMenuItem;
import com.mathworks.mwswing.MJScrollStrip;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MouseLatch;
import com.mathworks.mwswing.NarrowButtonBorder;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTDragDetector;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTMenu;
import com.mathworks.widgets.desk.DTMenuBar;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTNotifyingList;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTTitleButton;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.desk.TargetedAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

class DTDocumentBar
extends MJPanel
implements DTNotifyingList.Listener<DTClient> {
    private ContentPanel fContentPanel;
    private MJScrollStrip fScroller;
    private MJGrip fGrip;
    private MJButton fNewDocumentButton;
    private MJPanel fFiller;
    private MouseListener fButtonMouseListener = new MouseLatch((MouseListener)new ButtonMouseListener());
    private MouseListener fHeaderMouseListener = new MouseLatch((MouseListener)new HeaderMouseListener());
    private DTDocumentContainer fContainer;
    private List<DTGroup> fGroups = new ArrayList<DTGroup>();
    private DTGroup fUnnamedGroup;
    private int fOrientation;
    private int fMaxWidth;
    private boolean fMultipleGroups;
    private MouseInputListener fBarResizer = new BarResizer();
    private MouseInputListener fButtonResizer = new ButtonResizer();
    private MouseInputListener fBarDragDetector = new BarDragDetector();
    private MouseInputListener fButtonDragDetector = new ButtonDragDetector();
    private ButtonDragger fButtonDragger;
    private DropTarget fDropTarget;
    private DocumentButton fPressedButton;
    static final Icon SMALL_CLOSE_ICON = new ImageIcon(DTDocumentBar.class.getResource("resources/smallclose.gif"));
    static final Border NARROW_BUTTON_BORDER = new NarrowButtonBorder();
    private static Icon sWhiteCloseIcon;
    private static Insets sUndockCloseInsets;
    private static Insets sButtonInsets;
    private static Insets sNoCloseButtonInsets;
    private static final boolean sButtonsAtLeft;
    private static final Dimension BUTTON_DRAG_THRESHOLD;
    private static final int MINIMUM_WIDTH = 64;
    private static final int MOVE_BACK = 1;
    private static final int MOVE_AHEAD = 2;
    private static final int MOVE_TO_BEGIN = 3;
    private static final int MOVE_TO_END = 4;
    private static Icon sMoveUpIcon;
    private static Icon sMoveDownIcon;
    private static Icon sMoveToTopIcon;
    private static Icon sMoveToBottomIcon;
    private static Icon sMoveLeftIcon;
    private static Icon sMoveRightIcon;
    private static Icon sMoveToBeginIcon;
    private static Icon sMoveToEndIcon;
    private static Color sLastColorToTweak;
    private static Color sLastTweakedColor;
    private static final Color MAC_SELECTED_BACKGROUND_TOP_COLOR;
    private static final Color MAC_SELECTED_BACKGROUND_BOTTOM_COLOR;
    private static final Color MAC_LEFT_OR_TOP_BORDER_COLOR;
    private static final Color MAC_RIGHT_OR_BOTTOM_BORDER_COLOR;

    DTDocumentBar(DTDocumentContainer dTDocumentContainer, int n, int n2, boolean bl) {
        this.fContainer = dTDocumentContainer;
        this.fOrientation = n;
        this.fMaxWidth = n2;
        this.fMultipleGroups = bl;
        this.setLayout(null);
        this.fContentPanel = new ContentPanel();
        this.fScroller = new MJScrollStrip(n, (Component)((Object)this.fContentPanel), true);
        this.fScroller.getViewport().setBackground(UIManager.getColor("control"));
        this.add((Component)this.fScroller);
        MouseLatch mouseLatch = new MouseLatch((MouseListener)new ContextMouseListener());
        this.fGrip = new MJGrip(n == 1 ? 0 : 1);
        this.fGrip.addMouseListener((MouseListener)mouseLatch);
        this.add((Component)this.fGrip);
        this.fFiller = new MJPanel();
        this.add((Component)this.fFiller);
        this.addMouseListener(this.fBarResizer);
        this.addMouseMotionListener(this.fBarResizer);
        this.addMouseListener((MouseListener)mouseLatch);
        this.fGrip.addMouseListener((MouseListener)this.fBarDragDetector);
        this.fGrip.addMouseMotionListener((MouseMotionListener)this.fBarDragDetector);
        this.fFiller.addMouseListener((MouseListener)this.fBarDragDetector);
        this.fFiller.addMouseMotionListener((MouseMotionListener)this.fBarDragDetector);
        this.fFiller.addMouseListener((MouseListener)mouseLatch);
    }

    void setOrientation(int n) {
        if (n != this.fOrientation) {
            this.fOrientation = n;
            this.fContentPanel.updateOrientation();
            this.fGrip.setOrientation(this.fOrientation == 1 ? 0 : 1);
            this.fScroller.setOrientation(n);
        }
    }

    int getOrientation() {
        return this.fOrientation;
    }

    void setNewAction(Action action) {
        if (this.fNewDocumentButton != null) {
            if (action != null) {
                this.fNewDocumentButton.setAction(action);
            } else {
                this.remove((Component)this.fNewDocumentButton);
                this.fNewDocumentButton = null;
            }
        } else if (action != null) {
            this.fNewDocumentButton = new MJButton(action);
            MJToolBar.configureButton((MJButton)this.fNewDocumentButton);
            this.add((Component)this.fNewDocumentButton);
        }
    }

    int getMaxWidth() {
        return this.fMaxWidth;
    }

    void setMaxWidth(int n) {
        this.fMaxWidth = n;
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension dimension = this.fContentPanel.getPreferredSize();
        if (this.fNewDocumentButton != null) {
            Dimension dimension2 = this.fNewDocumentButton.getPreferredSize();
            if (this.fOrientation == 0) {
                if (dimension2.height > dimension.height) {
                    dimension.height = dimension2.height;
                }
            } else if (dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        if (dimension.width > this.fMaxWidth) {
            dimension.width = this.fMaxWidth;
        }
        return dimension;
    }

    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Insets insets = this.getInsets();
        int n3 = n - insets.left - insets.right;
        int n4 = n2 - insets.top - insets.bottom;
        Dimension dimension = this.fGrip.getPreferredSize();
        Dimension dimension2 = this.fContentPanel.getPreferredSize();
        Dimension dimension3 = this.fNewDocumentButton == null ? new Dimension() : this.fNewDocumentButton.getPreferredSize();
        int n5 = insets.left;
        int n6 = insets.top;
        if (this.fOrientation == 0) {
            this.fGrip.setBounds(n5, n6, dimension.width, n4);
            int n7 = Math.min(dimension2.width, n3 - dimension.width - dimension3.width);
            this.fScroller.setBounds(n5 += dimension.width, n6, n7, n4);
            n5 += n7;
            if (this.fNewDocumentButton != null) {
                this.fNewDocumentButton.setBounds(n5, n6, dimension3.width, n4);
                n5 += dimension3.width;
            }
            this.fFiller.setBounds(n5, n6, n - insets.right - n5, n4);
        } else {
            this.fGrip.setBounds(n5, n6, n3, dimension.height);
            int n8 = Math.min(dimension2.height, n4 - dimension.height - dimension3.height);
            this.fScroller.setBounds(n5, n6 += dimension.height, n3, n8);
            n6 += n8;
            if (this.fNewDocumentButton != null) {
                this.fNewDocumentButton.setBounds(n5, n6, n3, dimension3.height);
                n6 += dimension3.height;
            }
            this.fFiller.setBounds(n5, n6, n3, n2 - insets.bottom - n6);
        }
    }

    private void revalidateChildren() {
        this.fContentPanel.revalidate();
        int n = this.fContentPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            ((JComponent)this.fContentPanel.getComponent(i)).revalidate();
        }
    }

    void addGroup(DTGroup dTGroup) {
        if (this.fGroups.contains(dTGroup)) {
            return;
        }
        if (this.fButtonDragger != null) {
            this.fButtonDragger.abortDrag();
        }
        int n = this.fGroups.size();
        if (this.fUnnamedGroup != null) {
            --n;
        } else if (dTGroup.getTitle() == null) {
            this.fUnnamedGroup = dTGroup;
        }
        this.fGroups.add(n, dTGroup);
        this.fContentPanel.add((Component)((Object)new GroupPanel(dTGroup)), n);
        this.fContentPanel.revalidate();
        dTGroup.getDockedDocuments().addListener(this);
    }

    void removeGroup(DTGroup dTGroup) {
        if (this.fButtonDragger != null) {
            this.fButtonDragger.abortDrag();
        }
        dTGroup.getDockedDocuments().removeListener(this);
        int n = this.fGroups.indexOf(dTGroup);
        if (n != -1) {
            this.fGroups.remove(n);
            this.fContentPanel.remove(n);
        }
        if (dTGroup == this.fUnnamedGroup) {
            this.fUnnamedGroup = null;
        }
        this.fContentPanel.revalidate();
        this.fContentPanel.repaint();
    }

    boolean isEmpty() {
        return this.fContentPanel.getComponentCount() == 0 && this.fNewDocumentButton == null;
    }

    @Override
    public void objectAdded(DTNotifyingList dTNotifyingList, DTClient dTClient, int n) {
        if (this.fButtonDragger != null) {
            this.fButtonDragger.abortDrag();
        }
        int n2 = this.fGroups.indexOf(dTClient.getGroup());
        int n3 = 2 * n + (this.fMultipleGroups ? 1 : 0);
        GroupPanel groupPanel = (GroupPanel)((Object)this.fContentPanel.getComponent(n2));
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setVisible(this.fOrientation == 0 && (this.fMultipleGroups || n > 0) && !PlatformInfo.isMacintosh());
        jSeparator.addMouseListener(this.fButtonResizer);
        jSeparator.addMouseMotionListener(this.fButtonResizer);
        groupPanel.add(jSeparator, n3++);
        DocumentButton documentButton = new DocumentButton(dTClient);
        documentButton.addMouseListener(this.fButtonMouseListener);
        documentButton.addMouseListener(this.fButtonDragDetector);
        documentButton.addMouseMotionListener(this.fButtonDragDetector);
        groupPanel.add((Component)((Object)documentButton), n3);
        groupPanel.revalidate();
        SwingUtilities.invokeLater(new ViewAdjuster((Component)((Object)documentButton)));
    }

    @Override
    public void objectRemoved(DTNotifyingList dTNotifyingList, DTClient dTClient, int n) {
        if (this.fButtonDragger != null) {
            this.fButtonDragger.abortDrag();
        }
        int n2 = this.fGroups.indexOf(dTClient.getGroup());
        int n3 = 2 * n + (this.fMultipleGroups ? 1 : 0);
        GroupPanel groupPanel = (GroupPanel)((Object)this.fContentPanel.getComponent(n2));
        groupPanel.remove(n3);
        DocumentButton documentButton = (DocumentButton)((Object)groupPanel.getComponent(n3));
        groupPanel.remove(n3);
        groupPanel.invalidate();
        documentButton.cleanup();
        this.fContentPanel.revalidate();
        this.fContentPanel.repaint();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void objectMoved(DTNotifyingList dTNotifyingList, DTClient dTClient, int n, int n2) {
        int n3;
        int n4;
        if (this.fButtonDragger != null) {
            this.fButtonDragger.abortDrag();
        }
        if (n < n2) {
            n4 = n2 - n;
            n3 = 2;
        } else {
            n4 = n - n2;
            n3 = -2;
        }
        int n5 = this.fGroups.indexOf(dTClient.getGroup());
        int n6 = 2 * n + (this.fMultipleGroups ? 1 : 0) + 1;
        GroupPanel groupPanel = (GroupPanel)((Object)this.fContentPanel.getComponent(n5));
        DocumentButton documentButton = (DocumentButton)((Object)groupPanel.getComponent(n6));
        Action action = documentButton.getAction();
        for (int i = 0; i < n4; ++i) {
            DocumentButton documentButton2 = (DocumentButton)((Object)groupPanel.getComponent(n6 += n3));
            documentButton.setAction(documentButton2.getAction());
            documentButton.setClient(documentButton2.getClient());
            documentButton = documentButton2;
        }
        documentButton.setAction(action);
        documentButton.setClient(dTClient);
    }

    @Override
    public void objectsReordered(DTNotifyingList dTNotifyingList) {
        if (dTNotifyingList.isEmpty()) {
            return;
        }
        if (this.fButtonDragger != null) {
            this.fButtonDragger.abortDrag();
        }
        DTGroup dTGroup = ((DTClient)dTNotifyingList.get(0)).getGroup();
        int n = this.fGroups.indexOf(dTGroup);
        int n2 = 1 + (this.fMultipleGroups ? 1 : 0);
        GroupPanel groupPanel = (GroupPanel)((Object)this.fContentPanel.getComponent(n));
        int n3 = 0;
        int n4 = dTNotifyingList.size();
        while (n3 < n4) {
            DTClient dTClient = (DTClient)dTNotifyingList.get(n3);
            MJAbstractAction mJAbstractAction = dTClient.getSelectAction();
            DocumentButton documentButton = (DocumentButton)((Object)groupPanel.getComponent(n2));
            if (documentButton.getAction() != mJAbstractAction) {
                documentButton.setAction((Action)mJAbstractAction);
                documentButton.setClient(dTClient);
            }
            ++n3;
            n2 += 2;
        }
    }

    public void clientSelected(DTClient dTClient) {
        int n;
        if (this.fButtonDragger != null) {
            this.fButtonDragger.abortDrag();
        }
        if ((n = this.fGroups.indexOf(dTClient.getGroup())) >= 0 && n < this.fContentPanel.getComponentCount()) {
            GroupPanel groupPanel = (GroupPanel)((Object)this.fContentPanel.getComponent(n));
            int n2 = groupPanel.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                final Component component = groupPanel.getComponent(i);
                if (!(component instanceof DocumentButton) || ((DocumentButton)((Object)component)).fClient != dTClient) continue;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DTDocumentBar.this.fPressedButton == null || DTDocumentBar.this.fPressedButton == component) {
                            DTDocumentBar.this.fScroller.ensureVisible(component);
                        }
                    }
                });
                break;
            }
        }
    }

    Iterator<DTClient> getClientIterator() {
        return new ClientIterator();
    }

    int getGroupCount() {
        return this.fGroups.size();
    }

    Iterator<DTGroup> getGroupIterator() {
        return this.fGroups.iterator();
    }

    DTClient getSelectedDocument() {
        DocumentButton documentButton = this.getSelectedButton();
        return documentButton != null ? documentButton.getClient() : null;
    }

    private DocumentButton getSelectedButton() {
        for (int i = 0; i < this.fContentPanel.getComponentCount(); ++i) {
            Component component = this.fContentPanel.getComponent(i);
            if (!(component instanceof GroupPanel)) continue;
            for (int j = 0; j < ((Container)component).getComponentCount(); ++j) {
                DocumentButton documentButton;
                Component component2 = ((Container)component).getComponent(j);
                if (!(component2 instanceof DocumentButton) || !(documentButton = (DocumentButton)((Object)component2)).isSelected()) continue;
                return documentButton;
            }
        }
        return null;
    }

    DTGroup getSelectedGroup() {
        DTClient dTClient = this.getSelectedDocument();
        return dTClient != null ? dTClient.getGroup() : null;
    }

    Action getAlphabetizeAction() {
        DTGroup dTGroup = this.fGroups.size() == 1 ? this.fGroups.get(0) : this.getSelectedGroup();
        return dTGroup == null ? null : dTGroup.getAlphabetizeAction();
    }

    Action[] getDocumentMoveActions() {
        DTClient dTClient = this.getSelectedDocument();
        return dTClient != null && this.buttonMovePermitted(dTClient) ? this.getDocumentMoveActions(dTClient) : new Action[]{};
    }

    boolean buttonMovePermitted(DTClient dTClient) {
        return dTClient.getGroup().permitUserDocumentBarReordering();
    }

    Action[] getDocumentMoveActions(DTClient dTClient) {
        DTGroup dTGroup = dTClient.getGroup();
        int n = dTGroup.getDockedDocuments().size();
        int n2 = dTGroup.getDockedDocuments().indexOf(dTClient);
        boolean bl = n2 == 0;
        boolean bl2 = n2 == n - 1;
        Action[] actionArray = new Action[]{new MoveDocumentAction(dTGroup, 1, n2, n2 - 1, !bl), new MoveDocumentAction(dTGroup, 2, n2, n2 + 1, !bl2), new MoveDocumentAction(dTGroup, 3, n2, 0, !bl), new MoveDocumentAction(dTGroup, 4, n2, n - 1, !bl2)};
        return actionArray;
    }

    Action[] getGroupMoveActions() {
        DTGroup dTGroup = this.getSelectedGroup();
        return dTGroup != null ? this.getGroupMoveActions(dTGroup) : new Action[]{};
    }

    Action[] getGroupMoveActions(DTGroup dTGroup) {
        int n = this.fGroups.indexOf(dTGroup);
        int n2 = this.fGroups.size();
        boolean bl = n == 0;
        boolean bl2 = n == n2 - 1;
        Action[] actionArray = new Action[4];
        actionArray[0] = new MoveGroupAction(1, n, n - 1, !bl);
        actionArray[0] = new MoveGroupAction(2, n, n + 1, !bl2);
        actionArray[0] = new MoveGroupAction(3, n, 0, !bl);
        actionArray[0] = new MoveGroupAction(4, n, n2 - 1, !bl2);
        return actionArray;
    }

    Action[] getHypotheticalDocumentMoveActions() {
        Action[] actionArray = new Action[]{new HypotheticalMoveAction(1, 1), new HypotheticalMoveAction(1, 0), new HypotheticalMoveAction(2, 1), new HypotheticalMoveAction(2, 0), new HypotheticalMoveAction(3, -1), new HypotheticalMoveAction(4, -1)};
        return actionArray;
    }

    Action getAdjustWidthAction() {
        return PlatformInfo.isMacintosh() ? null : new AdjustWidthAction();
    }

    private void moveGroup(int n, int n2) {
        DTGroup dTGroup = this.fGroups.get(n);
        this.fGroups.remove(n);
        this.fGroups.add(n2, dTGroup);
        Component component = this.fContentPanel.getComponent(n);
        this.fContentPanel.remove(n);
        this.fContentPanel.add(component, n2);
        this.fContentPanel.revalidate();
        this.fContentPanel.repaint();
    }

    void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
        if (this.fDropTarget == null) {
            this.fDropTarget = new DropTarget();
            this.fDropTarget.setComponent((Component)((Object)this));
        }
        this.fDropTarget.addDropTargetListener(dropTargetListener);
    }

    void removeDropTargetListener(DropTargetListener dropTargetListener) {
        if (this.fDropTarget != null) {
            this.fDropTarget.removeDropTargetListener(dropTargetListener);
        }
    }

    private boolean isEntirelyVisible(Component component) {
        Rectangle rectangle = this.fScroller.getViewRect();
        Rectangle rectangle2 = component.getBounds();
        rectangle2 = SwingUtilities.convertRectangle(component.getParent(), rectangle2, (Component)((Object)this.fContentPanel));
        return rectangle.contains(rectangle2);
    }

    private static Color tweakBackground(Color color) {
        if (!color.equals(sLastColorToTweak)) {
            sLastColorToTweak = color;
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            fArray[2] = fArray[2] >= 0.9f || PlatformInfo.isMacintosh() && fArray[2] >= 0.75f ? fArray[2] * 0.9f : fArray[2] * 1.07f;
            fArray[1] = fArray[1] * 0.7f;
            sLastTweakedColor = Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
        }
        return sLastTweakedColor;
    }

    static boolean wantsToHandle(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        return component instanceof DocumentButton || component.getParent() instanceof DocumentButton;
    }

    private String getMoveLabel(int n) {
        if (this.fOrientation == 1) {
            switch (n) {
                case 1: {
                    return this.fContainer.getDesktop().getString("menuitem.Up");
                }
                case 2: {
                    return this.fContainer.getDesktop().getString("menuitem.Down");
                }
                case 3: {
                    return this.fContainer.getDesktop().getString("menuitem.ToTop");
                }
                case 4: {
                    return this.fContainer.getDesktop().getString("menuitem.ToBottom");
                }
            }
        } else {
            switch (n) {
                case 1: {
                    return this.fContainer.getDesktop().getString("menuitem.Left");
                }
                case 2: {
                    return this.fContainer.getDesktop().getString("menuitem.Right");
                }
                case 3: {
                    return this.fContainer.getDesktop().getString("menuitem.ToBeginning");
                }
                case 4: {
                    return this.fContainer.getDesktop().getString("menuitem.ToEnd");
                }
            }
        }
        return null;
    }

    private Icon getMoveIcon(int n) {
        if (this.fOrientation == 1) {
            switch (n) {
                case 1: {
                    if (sMoveUpIcon == null) {
                        sMoveUpIcon = DTUtilities.createContrastingIcon(MoveIcon.MOVE_UP.getIcon());
                    }
                    return sMoveUpIcon;
                }
                case 2: {
                    if (sMoveDownIcon == null) {
                        sMoveDownIcon = DTUtilities.createContrastingIcon(MoveIcon.MOVE_DOWN.getIcon());
                    }
                    return sMoveDownIcon;
                }
                case 3: {
                    if (sMoveToTopIcon == null) {
                        sMoveToTopIcon = DTUtilities.createContrastingIcon(MoveIcon.MOVE_TOP.getIcon());
                    }
                    return sMoveToTopIcon;
                }
                case 4: {
                    if (sMoveToBottomIcon == null) {
                        sMoveToBottomIcon = DTUtilities.createContrastingIcon(MoveIcon.MOVE_BOTTOM.getIcon());
                    }
                    return sMoveToBottomIcon;
                }
            }
        } else {
            switch (n) {
                case 1: {
                    if (sMoveLeftIcon == null) {
                        sMoveLeftIcon = DTUtilities.createContrastingIcon(MoveIcon.MOVE_LEFT.getIcon());
                    }
                    return sMoveLeftIcon;
                }
                case 2: {
                    if (sMoveRightIcon == null) {
                        sMoveRightIcon = DTUtilities.createContrastingIcon(MoveIcon.MOVE_RIGHT.getIcon());
                    }
                    return sMoveRightIcon;
                }
                case 3: {
                    if (sMoveToBeginIcon == null) {
                        sMoveToBeginIcon = DTUtilities.createContrastingIcon(MoveIcon.MOVE_BEGIN.getIcon());
                    }
                    return sMoveToBeginIcon;
                }
                case 4: {
                    if (sMoveToEndIcon == null) {
                        sMoveToEndIcon = DTUtilities.createContrastingIcon(MoveIcon.MOVE_END.getIcon());
                    }
                    return sMoveToEndIcon;
                }
            }
        }
        return null;
    }

    private KeyStroke getMoveAccelerator(int n, int n2) {
        if (n2 == 1) {
            switch (n) {
                case 1: {
                    return KeyStroke.getKeyStroke(38, 10);
                }
                case 2: {
                    return KeyStroke.getKeyStroke(40, 10);
                }
                case 3: {
                    return KeyStroke.getKeyStroke(33, 10);
                }
                case 4: {
                    return KeyStroke.getKeyStroke(34, 10);
                }
            }
        } else {
            switch (n) {
                case 1: {
                    return KeyStroke.getKeyStroke(37, 10);
                }
                case 2: {
                    return KeyStroke.getKeyStroke(39, 10);
                }
                case 3: {
                    return KeyStroke.getKeyStroke(33, 10);
                }
                case 4: {
                    return KeyStroke.getKeyStroke(34, 10);
                }
            }
        }
        return null;
    }

    void barDragEnded() {
        this.fScroller.setScrollOnMouseOver(true);
    }

    static {
        sUndockCloseInsets = new Insets(0, -1, 0, 0);
        sButtonsAtLeft = PlatformInfo.isMacintosh();
        BUTTON_DRAG_THRESHOLD = new Dimension(10, 6);
        MAC_SELECTED_BACKGROUND_TOP_COLOR = new Color(0x999999);
        MAC_SELECTED_BACKGROUND_BOTTOM_COLOR = new Color(0xE4E4E4);
        MAC_LEFT_OR_TOP_BORDER_COLOR = new Color(135, 136, 136, 150);
        MAC_RIGHT_OR_BOTTOM_BORDER_COLOR = new Color(225, 225, 225, 150);
        if (PlatformInfo.isMacintosh()) {
            sUndockCloseInsets = new Insets(0, 2, 0, 2);
        }
    }

    private class KeyControlledResizer
    extends KeyControlledDragger {
        private KeyControlledResizer() {
        }

        protected Cursor getDragCursor() {
            return Cursor.getPredefinedCursor(11);
        }

        protected Point getDragStartPoint() {
            Point point = new Point(this.fInvoker.getWidth() / 2, this.fInvoker.getHeight() / 2);
            if (this.fInvoker instanceof DTDocumentBar) {
                point.x = DTDocumentBar.this.fContainer.getBarPosition() == 3 ? 2 : this.fInvoker.getWidth() - 2;
            }
            SwingUtilities.convertPointToScreen(point, this.fInvoker);
            return point;
        }

        protected Point getNextPoint(Point point, int n) {
            if (n == 1 || n == 5) {
                return point;
            }
            return super.getNextPoint(point, n);
        }
    }

    private class AdjustWidthAction
    extends MJAbstractAction {
        AdjustWidthAction() {
            super(DTDocumentBar.this.fContainer.getDesktop().getString("menu.ButtonWidth"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            if (DTDocumentBar.this.fOrientation == 0) {
                DocumentButton documentButton = DTDocumentBar.this.getSelectedButton();
                if (documentButton != null && DTDocumentBar.this.isEntirelyVisible((Component)((Object)documentButton))) {
                    Container container = documentButton.getParent();
                    for (int i = 0; i < container.getComponentCount() - 1; ++i) {
                        if (container.getComponent(i) != documentButton) continue;
                        object = container.getComponent(i + 1);
                        break;
                    }
                } else {
                    block1: for (int i = 0; i < DTDocumentBar.this.fContentPanel.getComponentCount(); ++i) {
                        Component component = DTDocumentBar.this.fContentPanel.getComponent(i);
                        if (!(component instanceof GroupPanel)) continue;
                        for (int j = 0; j < ((Container)component).getComponentCount(); ++j) {
                            Component component2 = ((Container)component).getComponent(j);
                            if (!(component2 instanceof JSeparator) || !DTDocumentBar.this.isEntirelyVisible(component2)) continue;
                            object = component2;
                            continue block1;
                        }
                    }
                }
            } else {
                object = DTDocumentBar.this;
            }
            if (object != null) {
                new KeyControlledResizer().activate((Component)object);
            }
        }
    }

    class LiveButtonDragger
    extends ButtonDragger {
        int fInitialCoord;
        int fLowerLimit;
        int fUpperLimit;
        Rectangle fInitialBounds;
        Rectangle fViewRect;
        JSeparator fDragSeparator;

        LiveButtonDragger(DocumentButton documentButton, MouseEvent mouseEvent, MouseEvent mouseEvent2) {
            super(documentButton);
            this.fDragButton.setBeingDragged(true);
            Component component = (Component)mouseEvent.getSource();
            Point point = SwingUtilities.convertPoint(component, mouseEvent.getPoint(), (Component)((Object)DTDocumentBar.this.fContentPanel));
            this.fInitialCoord = DTDocumentBar.this.fOrientation == 1 ? point.y : point.x;
            this.fInitialBounds = documentButton.getBounds();
            if (DTDocumentBar.this.fOrientation == 1) {
                this.fLowerLimit = this.fGroupPanel.getComponent(1).getY() + this.fGroupPanel.getY();
                this.fUpperLimit = this.fGroupPanel.getY() + this.fGroupPanel.getHeight() - this.fInitialBounds.height - 2;
            } else {
                this.fLowerLimit = this.fGroupPanel.getComponent(1).getX() + this.fGroupPanel.getX();
                this.fUpperLimit = this.fGroupPanel.getX() + this.fGroupPanel.getWidth() - this.fInitialBounds.width - 2;
            }
            ((DTDocumentBar)DTDocumentBar.this).fContentPanel.fSuppressLayout = true;
            this.fGroupPanel.fSuppressLayout = true;
            this.fInitialBounds.x += this.fGroupPanel.getX();
            this.fInitialBounds.y += this.fGroupPanel.getY();
            this.fDragSeparator = (JSeparator)this.fGroupPanel.getComponent(2 * this.fCurrentIndex + (DTDocumentBar.this.fMultipleGroups ? 1 : 0));
            DTDocumentBar.this.fContentPanel.add((Component)((Object)this.fDragButton), JLayeredPane.DRAG_LAYER);
            this.fDragButton.setBounds(this.fInitialBounds);
            this.fViewRect = DTDocumentBar.this.fScroller.getViewRect();
            this.mouseDragged(mouseEvent2);
        }

        @Override
        void endDrag() {
            ((DTDocumentBar)DTDocumentBar.this).fContentPanel.fSuppressLayout = false;
            this.fGroupPanel.fSuppressLayout = false;
            int n = 2 * this.fInitialIndex + (DTDocumentBar.this.fMultipleGroups ? 1 : 0);
            this.fGroupPanel.remove(this.fDragSeparator);
            this.fGroupPanel.add(this.fDragSeparator, n++);
            this.fGroupPanel.add((Component)((Object)this.fDragButton), n);
            this.fDragButton.setBeingDragged(false);
            super.endDrag();
        }

        @Override
        void dragButton(int n, int n2) {
            int n3;
            int n4 = this.fInitialBounds.x;
            int n5 = this.fInitialBounds.y;
            if (DTDocumentBar.this.fOrientation == 1) {
                int n6 = n2 - this.fInitialCoord;
                n5 += n6;
                if (n6 > 0) {
                    if (n5 > this.fUpperLimit) {
                        n5 = this.fUpperLimit;
                    }
                } else if (n5 < this.fLowerLimit) {
                    n5 = this.fLowerLimit;
                }
                n3 = n5 >= this.fDragButton.getY() ? 1 : -1;
            } else {
                int n7 = n - this.fInitialCoord;
                n4 += n7;
                if (n7 > 0) {
                    if (n4 > this.fUpperLimit) {
                        n4 = this.fUpperLimit;
                    }
                } else if (n4 < this.fLowerLimit) {
                    n4 = this.fLowerLimit;
                }
                n3 = n4 >= this.fDragButton.getX() ? 1 : -1;
            }
            this.fDragButton.setLocation(n4, n5);
            if (n3 > 0) {
                int n8 = this.fCurrentIndex;
                int n9 = 2 * n8 + (DTDocumentBar.this.fMultipleGroups ? 1 : 0) + (n8 >= this.fInitialIndex ? 1 : 0);
                if (n9 < this.fGroupPanel.getComponentCount() - 1) {
                    JSeparator jSeparator = (JSeparator)this.fGroupPanel.getComponent(n9++);
                    DocumentButton documentButton = (DocumentButton)((Object)this.fGroupPanel.getComponent(n9));
                    if (DTDocumentBar.this.fOrientation == 1) {
                        int n10 = documentButton.getY();
                        int n11 = n10 + (documentButton.getHeight() >> 1) + this.fGroupPanel.getY();
                        if (n5 + this.fInitialBounds.height > n11) {
                            documentButton.setLocation(documentButton.getX(), n10 -= this.fInitialBounds.height);
                            n10 = jSeparator.getY() - this.fInitialBounds.height;
                            jSeparator.setLocation(jSeparator.getX(), n10);
                            ++this.fCurrentIndex;
                            this.fLockToBar = true;
                            DTDocumentBar.this.fContentPanel.repaint(0L, n4, n10, this.fInitialBounds.width, this.fInitialBounds.height + documentButton.getHeight() + jSeparator.getHeight());
                        }
                    } else {
                        int n12 = documentButton.getX();
                        int n13 = n12 + (documentButton.getWidth() >> 1) + this.fGroupPanel.getX();
                        if (n4 + this.fInitialBounds.width > n13) {
                            documentButton.setLocation(n12 -= this.fInitialBounds.width, documentButton.getY());
                            n12 = jSeparator.getX() - this.fInitialBounds.width;
                            jSeparator.setLocation(n12, jSeparator.getY());
                            ++this.fCurrentIndex;
                            this.fLockToBar = true;
                            DTDocumentBar.this.fContentPanel.repaint(0L, n12, n5, this.fInitialBounds.width + documentButton.getWidth() + jSeparator.getWidth(), this.fInitialBounds.height);
                        }
                    }
                }
            } else {
                int n14 = this.fCurrentIndex - 1;
                int n15 = 2 * n14 + (DTDocumentBar.this.fMultipleGroups ? 1 : 0) + (n14 >= this.fInitialIndex ? 1 : 0);
                if (n14 >= 0) {
                    JSeparator jSeparator = (JSeparator)this.fGroupPanel.getComponent(n15++);
                    DocumentButton documentButton = (DocumentButton)((Object)this.fGroupPanel.getComponent(n15));
                    if (DTDocumentBar.this.fOrientation == 1) {
                        int n16 = documentButton.getY();
                        int n17 = n16 + (documentButton.getHeight() >> 1) + this.fGroupPanel.getY();
                        if (n5 < n17) {
                            documentButton.setLocation(documentButton.getX(), n16 += this.fInitialBounds.height);
                            n16 = jSeparator.getY() + this.fInitialBounds.height;
                            jSeparator.setLocation(jSeparator.getX(), n16);
                            --this.fCurrentIndex;
                            this.fLockToBar = true;
                            DTDocumentBar.this.fContentPanel.repaint(0L, n4, n16 - this.fInitialBounds.height, this.fInitialBounds.width, this.fInitialBounds.height + documentButton.getHeight() + jSeparator.getHeight());
                        }
                    } else {
                        int n18 = documentButton.getX();
                        int n19 = n18 + (documentButton.getWidth() >> 1) + this.fGroupPanel.getX();
                        if (n4 < n19) {
                            documentButton.setLocation(n18 += this.fInitialBounds.width, documentButton.getY());
                            n18 = jSeparator.getX() + this.fInitialBounds.width;
                            jSeparator.setLocation(n18, jSeparator.getY());
                            --this.fCurrentIndex;
                            this.fLockToBar = true;
                            DTDocumentBar.this.fContentPanel.repaint(0L, n18 - this.fInitialBounds.width, n5, this.fInitialBounds.width + documentButton.getWidth() + jSeparator.getWidth(), this.fInitialBounds.height);
                        }
                    }
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n;
            int n2;
            if (this.fInitialCoord == -1) {
                return;
            }
            Rectangle rectangle = this.fViewRect;
            this.fViewRect = DTDocumentBar.this.fScroller.getViewRect();
            if (this.fViewRect.x == rectangle.x && this.fViewRect.y == rectangle.y) {
                return;
            }
            if (DTDocumentBar.this.fOrientation == 1) {
                n2 = this.fViewRect.x + (this.fViewRect.width >> 1);
                n = this.fViewRect.y > rectangle.y ? this.fViewRect.y + this.fViewRect.height - 1 : this.fViewRect.y + 1;
            } else {
                n = this.fViewRect.y + (this.fViewRect.height >> 1);
                n2 = this.fViewRect.x > rectangle.x ? this.fViewRect.x + this.fViewRect.width - 1 : this.fViewRect.x + 1;
            }
            this.dragButton(n2, n);
        }
    }

    abstract class ButtonDragger
    extends MouseInputAdapter
    implements ChangeListener {
        DTClient fDragClient;
        GroupPanel fGroupPanel;
        DocumentButton fDragButton;
        int fInitialIndex;
        int fCurrentIndex;
        boolean fLockToBar;

        ButtonDragger(DocumentButton documentButton) {
            this.fDragButton = documentButton;
            this.fDragClient = documentButton.getClient();
            this.fGroupPanel = (GroupPanel)((Object)documentButton.getParent());
            this.fCurrentIndex = this.fInitialIndex = this.fDragClient.getGroup().getDockedDocuments().indexOf(this.fDragClient);
            this.fDragButton.addMouseListener(this);
            this.fDragButton.addMouseMotionListener(this);
            DTDocumentBar.this.fScroller.addViewportChangeListener((ChangeListener)this);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Point point = SwingUtilities.convertPoint(component, mouseEvent.getPoint(), (Component)((Object)DTDocumentBar.this.fContentPanel));
            if (!(this.fLockToBar || point.x >= 0 && point.x <= DTDocumentBar.this.fContentPanel.getWidth() && point.y >= 0 && point.y <= DTDocumentBar.this.fContentPanel.getHeight())) {
                this.abortDrag();
                DTDocumentBar.this.fContainer.startClientDrag(this.fDragClient, component);
            } else {
                this.dragButton(point.x, point.y);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() || MJUtilities.isPopupSuccesor((MouseEvent)mouseEvent)) {
                return;
            }
            this.endDrag();
        }

        abstract void dragButton(int var1, int var2);

        void abortDrag() {
            this.fCurrentIndex = this.fInitialIndex;
            this.endDrag();
        }

        void endDrag() {
            DTDocumentBar.this.fButtonDragger = null;
            if (this.fInitialIndex != this.fCurrentIndex) {
                DTGroup dTGroup = this.fDragClient.getGroup();
                DTNotifyingList<DTClient> dTNotifyingList = dTGroup.getDockedDocuments();
                dTNotifyingList.move(this.fInitialIndex, this.fCurrentIndex);
                dTGroup.setAlphabetizeDocuments(false);
            }
            this.fDragButton.removeMouseListener(this);
            this.fDragButton.removeMouseMotionListener(this);
            DTDocumentBar.this.fScroller.removeViewportChangeListener((ChangeListener)this);
        }
    }

    private class ButtonDragDetector
    extends DTDragDetector {
        ButtonDragDetector() {
            this.fDragThreshold = BUTTON_DRAG_THRESHOLD;
        }

        @Override
        protected Object getLoad(MouseEvent mouseEvent) {
            DocumentButton documentButton = (DocumentButton)mouseEvent.getSource();
            DTClient dTClient = documentButton.getClient();
            return dTClient.getGroup().permitUserDocumentBarReordering() ? dTClient : null;
        }

        @Override
        protected void startDrag(MouseEvent mouseEvent) {
            if (!(this.fLoad instanceof DTClient)) {
                return;
            }
            super.startDrag(mouseEvent);
            DTClient dTClient = (DTClient)this.fLoad;
            DocumentButton documentButton = (DocumentButton)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint((Component)((Object)documentButton), point, (Component)((Object)DTDocumentBar.this));
            if (DTDocumentBar.this.contains(point)) {
                DTDocumentBar.this.fButtonDragger = new LiveButtonDragger(documentButton, this.fPressedEvent, mouseEvent);
            } else {
                DTDocumentBar.this.fContainer.startClientDrag(dTClient, (Component)((Object)documentButton));
            }
        }

        @Override
        protected String getHint(MouseEvent mouseEvent) {
            DTClient dTClient = (DTClient)this.getLoad(mouseEvent);
            if (dTClient == null) {
                return null;
            }
            if (!dTClient.permitUserUndock() && DTDocumentBar.this.fContainer.getArrangement() == 1 && DTDocumentBar.this.fContainer.getDocumentCount() == 1) {
                return null;
            }
            Object[] objectArray = new Object[]{dTClient.getShortTitle()};
            return MessageFormat.format(DTDocumentBar.this.fContainer.getDesktop().getString("status.ToMoveThisOrButton"), objectArray);
        }
    }

    private class BarDragDetector
    extends DTDragDetector {
        private BarDragDetector() {
        }

        @Override
        protected String getHint(MouseEvent mouseEvent) {
            return DTDocumentBar.this.fContainer.getDesktop().getString("status.ToMoveDocumentBar");
        }

        @Override
        protected void startDrag(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            super.startDrag(mouseEvent);
            DTDocumentBar.this.fContainer.startBarDrag((Component)mouseEvent.getSource());
            DTDocumentBar.this.fScroller.setScrollOnMouseOver(false);
        }
    }

    private class ButtonResizer
    extends MouseInputAdapter {
        boolean fIsSizing;
        List<Integer> fButtonWidths;
        List<Integer> fPreferredWidths;
        int fBelowPreferredCount;
        int fAboveMinimumCount;
        int fCurrentCursor = 0;
        int fInitialX;
        int fInitialMax;

        private ButtonResizer() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            this.fIsSizing = true;
            this.fButtonWidths = new ArrayList<Integer>();
            this.fPreferredWidths = new ArrayList<Integer>();
            this.fBelowPreferredCount = 0;
            this.fAboveMinimumCount = 0;
            GroupPanel groupPanel = (GroupPanel)((Object)component.getParent());
            for (int i = 0; i < DTDocumentBar.this.fContentPanel.getComponentCount(); ++i) {
                Component component2 = DTDocumentBar.this.fContentPanel.getComponent(i);
                if (component2 instanceof GroupPanel) {
                    for (int j = 0; j < ((Container)component2).getComponentCount(); ++j) {
                        Component component3 = ((Container)component2).getComponent(j);
                        if (component3 instanceof DocumentButton) {
                            int n = component3.getWidth();
                            int n2 = ((DocumentButton)((Object)component3)).getTruePreferredWidth();
                            this.fButtonWidths.add(n);
                            this.fPreferredWidths.add(n2);
                            if (n < n2) {
                                ++this.fBelowPreferredCount;
                            }
                            if (n > 64) {
                                ++this.fAboveMinimumCount;
                            }
                        }
                        if (component3 == component) break;
                    }
                }
                if (component2 == groupPanel) break;
            }
            this.fInitialX = SwingUtilities.convertPoint((Component)component, (Point)mouseEvent.getPoint(), (Component)((Object)DTDocumentBar.this)).x;
            this.fInitialMax = DTDocumentBar.this.fMaxWidth;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.fIsSizing) {
                this.updateCursor(this.overSeparator(mouseEvent));
                this.endSizing();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.fIsSizing) {
                this.updateCursor(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.fIsSizing) {
                this.updateCursor(false);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.updateCursor(this.overSeparator(mouseEvent));
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            if (!this.fIsSizing) {
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            int n2 = SwingUtilities.convertPoint((Component)component, (Point)mouseEvent.getPoint(), (Component)((Object)DTDocumentBar.this)).x;
            int n3 = n2 - this.fInitialX;
            if (n3 > 0) {
                if (this.fBelowPreferredCount == 0) {
                    return;
                }
                boolean bl = true;
                int n4 = 0;
                n = this.fInitialMax + n3 / this.fBelowPreferredCount;
                while (n4 < n3 && bl) {
                    bl = false;
                    n4 = 0;
                    for (int i = 0; i < this.fButtonWidths.size(); ++i) {
                        int n5;
                        int n6 = this.fButtonWidths.get(i);
                        if (n6 >= (n5 = this.fPreferredWidths.get(i).intValue())) continue;
                        if (n5 <= n) {
                            n4 += n5 - n6;
                            continue;
                        }
                        n4 += n - this.fInitialMax;
                        bl = true;
                    }
                    ++n;
                }
            } else {
                if (this.fAboveMinimumCount == 0) {
                    return;
                }
                int n7 = 0;
                for (n = this.fInitialMax + n3 / this.fAboveMinimumCount; n7 > n3 && n > 64; --n) {
                    n7 = 0;
                    for (int n8 : this.fButtonWidths) {
                        if (n8 <= 64 || n8 <= n) continue;
                        n7 += n - n8;
                    }
                }
                if (n < 64) {
                    n = 64;
                }
            }
            if (n != DTDocumentBar.this.fMaxWidth) {
                DTDocumentBar.this.fMaxWidth = n;
                DTDocumentBar.this.revalidateChildren();
                DTDocumentBar.this.revalidate();
                DTDocumentBar.this.repaint();
            }
        }

        private void endSizing() {
            this.fIsSizing = false;
            this.fButtonWidths = null;
            this.fPreferredWidths = null;
            this.fBelowPreferredCount = 0;
            this.fAboveMinimumCount = 0;
        }

        boolean overSeparator(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Point point = SwingUtilities.convertPoint(component, mouseEvent.getPoint(), (Component)((Object)DTDocumentBar.this));
            Component component2 = SwingUtilities.getDeepestComponentAt((Component)((Object)DTDocumentBar.this), point.x, point.y);
            return component2 instanceof JSeparator;
        }

        void updateCursor(boolean bl) {
            int n;
            int n2 = n = bl ? 11 : 0;
            if (n != this.fCurrentCursor) {
                DTDocumentBar.this.setCursor(Cursor.getPredefinedCursor(n));
                this.fCurrentCursor = n;
            }
        }
    }

    private class BarResizer
    extends MouseInputAdapter {
        boolean fIsSizing;
        int fDragEdge = -1;
        int fCurrentCursor = 0;
        int fInitialX;
        int fInitialWidth;
        int fInitialMax;

        private BarResizer() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.fIsSizing = true;
            this.fDragEdge = this.overEdge(mouseEvent);
            if (this.fDragEdge != -1) {
                Component component = (Component)mouseEvent.getSource();
                this.fInitialX = SwingUtilities.convertPoint((Component)component, (Point)mouseEvent.getPoint(), (Component)((Object)((DTDocumentBar)DTDocumentBar.this).fContainer)).x;
                this.fInitialWidth = DTDocumentBar.this.getWidth();
                this.fInitialMax = DTDocumentBar.this.fMaxWidth;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.fIsSizing) {
                this.updateCursor(this.overEdge(mouseEvent));
                this.endSizing();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.fIsSizing) {
                this.updateCursor(this.overEdge(mouseEvent));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.fIsSizing) {
                this.updateCursor(-1);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = this.overEdge(mouseEvent);
            this.updateCursor(n);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.fIsSizing) {
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            int n = SwingUtilities.convertPoint((Component)component, (Point)mouseEvent.getPoint(), (Component)((Object)((DTDocumentBar)DTDocumentBar.this).fContainer)).x;
            int n2 = n - this.fInitialX;
            int n3 = this.fInitialWidth;
            n3 = this.fDragEdge == 7 ? (n3 -= n2) : (n3 += n2);
            int n4 = DTDocumentBar.this.fMaxWidth;
            if (n3 < DTDocumentBar.this.fMaxWidth) {
                n4 = n3;
                if (n4 < 64) {
                    n4 = 64;
                }
            } else if (n3 > DTDocumentBar.this.fMaxWidth) {
                n4 = n3;
            }
            if (n4 != DTDocumentBar.this.fMaxWidth) {
                DTDocumentBar.this.fMaxWidth = n4;
                DTDocumentBar.this.revalidateChildren();
                DTDocumentBar.this.fContainer.revalidate();
                DTDocumentBar.this.fContainer.repaint();
            }
        }

        private void endSizing() {
            int n;
            this.fIsSizing = false;
            this.fDragEdge = -1;
            int n2 = DTDocumentBar.this.getWidth();
            int n3 = n = n2 < this.fInitialMax ? this.fInitialMax : n2;
            if (DTDocumentBar.this.fMaxWidth > n) {
                DTDocumentBar.this.fMaxWidth = n;
            }
        }

        int overEdge(MouseEvent mouseEvent) {
            if (DTDocumentBar.this.fOrientation == 0) {
                return -1;
            }
            Insets insets = DTDocumentBar.this.getInsets();
            if (insets.left > insets.right) {
                return mouseEvent.getX() <= insets.left ? 7 : -1;
            }
            return mouseEvent.getX() >= DTDocumentBar.this.getWidth() - insets.right ? 3 : -1;
        }

        void updateCursor(int n) {
            int n2 = 0;
            if (n == 3) {
                n2 = 11;
            } else if (n == 7) {
                n2 = 10;
            }
            if (n2 != this.fCurrentCursor) {
                DTDocumentBar.this.setCursor(Cursor.getPredefinedCursor(n2));
                this.fCurrentCursor = n2;
            }
        }
    }

    class ClientIterator
    implements Iterator<DTClient> {
        Iterator<DTGroup> fGroupIterator;
        Iterator<DTClient> fClientIterator;

        ClientIterator() {
            this.fGroupIterator = DTDocumentBar.this.fGroups.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.fGroupIterator.hasNext() || this.fClientIterator != null && this.fClientIterator.hasNext();
        }

        @Override
        public DTClient next() {
            DTOccupant dTOccupant;
            if (this.fClientIterator == null) {
                dTOccupant = this.fGroupIterator.next();
                this.fClientIterator = ((DTGroup)dTOccupant).getDockedDocuments().iterator();
            }
            dTOccupant = this.fClientIterator.next();
            if (!this.fClientIterator.hasNext()) {
                this.fClientIterator = null;
            }
            return dTOccupant;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MoveGroupAction
    extends MJAbstractAction {
        int fFromIndex;
        int fToIndex;

        MoveGroupAction(int n, int n2, int n3, boolean bl) {
            this.setName(DTDocumentBar.this.getMoveLabel(n));
            this.putValue("SmallIcon", DTDocumentBar.this.getMoveIcon(n));
            this.setEnabled(bl);
            this.fFromIndex = n2;
            this.fToIndex = n3;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTDocumentBar.this.moveGroup(this.fFromIndex, this.fToIndex);
        }
    }

    private class HypotheticalMoveAction
    extends MJAbstractAction {
        int iMoveID;
        int iOrientation;

        HypotheticalMoveAction(int n, int n2) {
            this.iOrientation = n2;
            this.setName("move" + Integer.toString(n) + Integer.toString(n2));
            this.putValue("AcceleratorKey", DTDocumentBar.this.getMoveAccelerator(n, n2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.iOrientation == -1 || this.iOrientation == DTDocumentBar.this.fOrientation) {
                Object object = this.getValue("AcceleratorKey");
                for (Action action : DTDocumentBar.this.getDocumentMoveActions()) {
                    if (!action.isEnabled() || !object.equals(action.getValue("AcceleratorKey"))) continue;
                    action.actionPerformed(actionEvent);
                    break;
                }
                if ((((KeyStroke)object).getModifiers() & 8) != 0) {
                    KeyEventDispatcher keyEventDispatcher = new KeyEventDispatcher(){

                        @Override
                        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                            if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 18) {
                                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
                                return true;
                            }
                            return false;
                        }
                    };
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(keyEventDispatcher);
                }
            }
        }
    }

    private class MoveDocumentAction
    extends MJAbstractAction {
        DTGroup fGroup;
        int fFromIndex;
        int fToIndex;

        MoveDocumentAction(DTGroup dTGroup, int n, int n2, int n3, boolean bl) {
            this.fGroup = dTGroup;
            this.setName(DTDocumentBar.this.getMoveLabel(n));
            this.putValue("SmallIcon", DTDocumentBar.this.getMoveIcon(n));
            this.setEnabled(bl);
            this.fFromIndex = n2;
            this.fToIndex = n3;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fGroup.setAlphabetizeDocuments(false);
            this.fGroup.getDockedDocuments().move(this.fFromIndex, this.fToIndex);
        }
    }

    private class HeaderMouseListener
    extends ContextMouseListener {
        private HeaderMouseListener() {
        }

        @Override
        void showMenu(MouseEvent mouseEvent) {
            MJMenu mJMenu;
            Component component = (Component)mouseEvent.getSource();
            GroupHeader groupHeader = (GroupHeader)((Object)(component instanceof GroupHeader ? component : SwingUtilities.getAncestorOfClass(GroupHeader.class, component)));
            if (groupHeader == null) {
                return;
            }
            DTGroup dTGroup = groupHeader.fGroup;
            MJPopupMenu mJPopupMenu = new MJPopupMenu();
            mJPopupMenu.setCleanupUponClose(true);
            String string = dTGroup.getTitle();
            if (string != null) {
                mJPopupMenu.add((Action)dTGroup.getUndockAction());
                mJPopupMenu.add((Action)dTGroup.getCloseDockedAction());
                mJPopupMenu.addSeparator();
            }
            mJPopupMenu.add((JMenuItem)new MJCheckBoxMenuItem((Action)dTGroup.getAlphabetizeAction()));
            if (string != null) {
                Object[] objectArray = new Object[]{string};
                mJMenu = new MJMenu(MessageFormat.format(DTDocumentBar.this.fContainer.getDesktop().getString("menu.MoveThisOnBar"), objectArray));
                Action[] actionArray = DTDocumentBar.this.getGroupMoveActions(dTGroup);
                int n = actionArray.length;
                for (int i = 0; i < n; ++i) {
                    Action action = actionArray[i];
                    mJMenu.add(action);
                }
                mJPopupMenu.add((JMenuItem)mJMenu);
            }
            mJMenu = new MJMenu(DTDocumentBar.this.fContainer.getDesktop().getString("menu.BarPosition"));
            for (JComponent jComponent : this.createPositionMenuItems()) {
                mJMenu.add((Component)jComponent);
            }
            mJPopupMenu.add((JMenuItem)mJMenu);
            mJPopupMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class ButtonMouseListener
    extends ContextMouseListener {
        private ButtonMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            DTDocumentBar.this.fPressedButton = (DocumentButton)mouseEvent.getSource();
            super.mousePressed(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            DTDocumentBar.this.fPressedButton = null;
            super.mouseReleased(mouseEvent);
        }

        @Override
        void showMenu(MouseEvent mouseEvent) {
            Object[] objectArray;
            DTGroup dTGroup;
            Object object2;
            Action action;
            Action action2;
            DocumentButton documentButton = (DocumentButton)mouseEvent.getSource();
            DTClient dTClient = documentButton.fClient;
            DTMenu dTMenu = new DTMenu("");
            if (DTDocumentBar.this.fNewDocumentButton != null) {
                dTMenu.add(DTDocumentBar.this.fNewDocumentButton.getAction());
                dTMenu.addSeparator();
            }
            boolean bl = false;
            if (dTClient.permitUserUndock()) {
                dTMenu.add((Action)dTClient.getUndockAction());
                bl = true;
            }
            if (dTClient.permitUserClose()) {
                dTMenu.add((Action)dTClient.getCloseAction());
                bl = true;
            }
            if (!((action2 = DTDocumentBar.this.fContainer.getCloseAllExceptAction(dTClient)) instanceof TargetedAction) || ((TargetedAction)((Object)action2)).hasAnyTargets()) {
                dTMenu.add(action2);
                bl = true;
            }
            if (!((action = DTDocumentBar.this.fContainer.getCloseAllAction()) instanceof TargetedAction) || ((TargetedAction)((Object)action)).hasAnyTargets()) {
                object2 = new ChildAction(DTDocumentBar.this.fContainer.getCloseAllAction());
                object2.setName(DTDocumentBar.this.fContainer.getDesktop().getString("action.CloseAll"));
                dTMenu.add((Action)object2);
                bl = true;
            }
            if (!((object2 = DTDocumentBar.this.fContainer.getCloseSelectAction(dTClient)) instanceof TargetedAction) || ((TargetedAction)object2).hasAnyTargets()) {
                dTMenu.add((Action)object2);
                bl = true;
            }
            if (bl) {
                dTMenu.addSeparator();
            }
            if ((dTGroup = dTClient.getGroup()).permitUserDocumentBarReordering()) {
                dTMenu.add((JMenuItem)new MJCheckBoxMenuItem((Action)dTGroup.getAlphabetizeAction()));
                objectArray = new Object[]{dTClient.getShortTitle()};
                MJMenu object = new MJMenu(MessageFormat.format(DTDocumentBar.this.fContainer.getDesktop().getString("menu.MoveThisOnBar"), objectArray));
                Action[] mJPopupMenu = DTDocumentBar.this.getDocumentMoveActions(dTClient);
                int n = mJPopupMenu.length;
                for (int i = 0; i < n; ++i) {
                    Action action3 = mJPopupMenu[i];
                    object.add(action3);
                }
                dTMenu.add((JMenuItem)object);
                DTMenuMergeTag.MOVE_ON_BAR.setTag((JMenuItem)object);
            }
            objectArray = new MJMenu(DTDocumentBar.this.fContainer.getDesktop().getString("menu.BarPosition"));
            for (JComponent jComponent : this.createPositionMenuItems()) {
                objectArray.add((Component)jComponent);
            }
            dTMenu.add((JMenuItem)objectArray);
            DTMenuMergeTag.BAR_POSITION.setTag((JMenuItem)objectArray);
            JMenu jMenu = dTClient.getContextMenu();
            if (jMenu != null) {
                dTMenu.merge(jMenu);
            }
            MJPopupMenu mJPopupMenu = new MJPopupMenu();
            mJPopupMenu.setCleanupUponClose(true);
            for (Component component : dTMenu.getMenuComponents()) {
                mJPopupMenu.add(component);
            }
            mJPopupMenu.show((Component)((Object)documentButton), mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                DocumentButton documentButton = (DocumentButton)mouseEvent.getSource();
                DTClient dTClient = documentButton.fClient;
                if (dTClient.permitUserClose()) {
                    ActionEvent actionEvent = new ActionEvent(documentButton, 0, "Close", mouseEvent.getModifiers());
                    dTClient.getCloseAction().actionPerformed(actionEvent);
                }
            }
        }
    }

    private class ContextMouseListener
    extends MouseAdapter {
        private ContextMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.checkContextTrigger(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkContextTrigger(mouseEvent);
        }

        void checkContextTrigger(MouseEvent mouseEvent) {
            Component component;
            Point point;
            if (mouseEvent.isPopupTrigger() && DTDocumentBar.this.contains(point = SwingUtilities.convertPoint(component = mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), (Component)((Object)DTDocumentBar.this)))) {
                this.showMenu(mouseEvent);
                mouseEvent.consume();
            }
        }

        void showMenu(MouseEvent mouseEvent) {
            Object object;
            Component component = (Component)mouseEvent.getSource();
            MJPopupMenu mJPopupMenu = new MJPopupMenu();
            mJPopupMenu.setCleanupUponClose(true);
            if (DTDocumentBar.this.fNewDocumentButton != null) {
                mJPopupMenu.add(DTDocumentBar.this.fNewDocumentButton.getAction());
                mJPopupMenu.addSeparator();
            }
            boolean bl = false;
            Action action = DTDocumentBar.this.fContainer.getCloseAllAction();
            if (!(action instanceof TargetedAction) || ((TargetedAction)((Object)action)).hasAnyTargets()) {
                object = new ChildAction(DTDocumentBar.this.fContainer.getCloseAllAction());
                object.setName(DTDocumentBar.this.fContainer.getDesktop().getString("action.CloseAll"));
                mJPopupMenu.add((Action)object);
                bl = true;
            }
            if (!((object = DTDocumentBar.this.fContainer.getCloseSelectAction()) instanceof TargetedAction) || ((TargetedAction)object).hasAnyTargets()) {
                mJPopupMenu.add((Action)object);
                bl = true;
            }
            if (bl) {
                mJPopupMenu.addSeparator();
            }
            if (DTDocumentBar.this.fMultipleGroups) {
                for (JComponent jComponent : this.createPositionMenuItems()) {
                    mJPopupMenu.add((Component)jComponent);
                }
            } else {
                Action action2;
                if (!DTDocumentBar.this.fGroups.isEmpty() && (action2 = DTDocumentBar.this.getAlphabetizeAction()) != null) {
                    mJPopupMenu.add((JMenuItem)new MJCheckBoxMenuItem(action2));
                }
                action2 = new MJMenu(DTDocumentBar.this.fContainer.getDesktop().getString("menu.BarPosition"));
                for (JComponent jComponent : this.createPositionMenuItems()) {
                    action2.add(jComponent);
                }
                mJPopupMenu.add((JMenuItem)((Object)action2));
            }
            mJPopupMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
        }

        JComponent[] createPositionMenuItems() {
            Window window = SwingUtilities.windowForComponent((Component)((Object)DTDocumentBar.this));
            boolean bl = window instanceof JFrame && ((JFrame)window).getJMenuBar() != null && DTMenuBar.findMenu(((JFrame)window).getJMenuBar(), DTMenuMergeTag.DESKTOP) != null;
            JComponent[] jComponentArray = new JComponent[bl ? 6 : 4];
            ButtonGroup buttonGroup = new ButtonGroup();
            jComponentArray[0] = new MJRadioButtonMenuItem(DTDocumentBar.this.fContainer.getBarToNorthAction());
            buttonGroup.add((AbstractButton)jComponentArray[0]);
            jComponentArray[1] = new MJRadioButtonMenuItem(DTDocumentBar.this.fContainer.getBarToSouthAction());
            buttonGroup.add((AbstractButton)jComponentArray[1]);
            jComponentArray[2] = new MJRadioButtonMenuItem(DTDocumentBar.this.fContainer.getBarToEastAction());
            buttonGroup.add((AbstractButton)jComponentArray[2]);
            jComponentArray[3] = new MJRadioButtonMenuItem(DTDocumentBar.this.fContainer.getBarToWestAction());
            buttonGroup.add((AbstractButton)jComponentArray[3]);
            if (bl) {
                jComponentArray[4] = new JSeparator();
                jComponentArray[5] = new MJRadioButtonMenuItem(DTDocumentBar.this.fContainer.getBarHideAction());
                buttonGroup.add((AbstractButton)jComponentArray[5]);
            }
            return jComponentArray;
        }
    }

    class BorderedSeparator
    extends JSeparator {
        BorderedSeparator() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            Insets insets = this.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
    }

    private class GroupHeader
    extends MJPanel {
        DTGroup fGroup;

        GroupHeader(DTGroup dTGroup) {
            this.fGroup = dTGroup;
            String string = dTGroup.getTitle();
            this.setName(string + "Header");
            this.addMouseListener(DTDocumentBar.this.fHeaderMouseListener);
            this.setLayout(new BorderLayout());
            this.setBorder();
            if (string != null) {
                MJButton mJButton = new MJButton(dTGroup.getTitle(), dTGroup.getSmallIcon());
                mJButton.setFocusTraversable(false);
                mJButton.setFlyOverAppearance(true);
                mJButton.setDefaultCapable(false);
                mJButton.setFont(mJButton.getFont().deriveFont(1));
                mJButton.setMargin(new Insets(0, 0, 0, 0));
                mJButton.addMouseListener(DTDocumentBar.this.fHeaderMouseListener);
                mJButton.addActionListener((ActionListener)dTGroup.getSelectAction());
                if (sButtonsAtLeft) {
                    mJButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
                }
                this.add((Component)mJButton, "Center");
                Box box = Box.createHorizontalBox();
                box.add(Box.createHorizontalStrut(4));
                DTTitleButton dTTitleButton = new DTTitleButton(1);
                this.configureUndockCloseButton(dTTitleButton);
                dTTitleButton.addActionListener((ActionListener)dTGroup.getUndockAction());
                dTTitleButton.setToolTipText(dTGroup.getUndockAction().getTip());
                dTTitleButton.setName(dTGroup.getUndockAction().getValue("ComponentName") + "Button");
                DTTitleButton dTTitleButton2 = new DTTitleButton(5);
                this.configureUndockCloseButton(dTTitleButton2);
                dTTitleButton2.addActionListener((ActionListener)dTGroup.getCloseDockedAction());
                dTTitleButton2.setToolTipText(dTGroup.getCloseDockedAction().getTip());
                dTTitleButton2.setName(dTGroup.getCloseAction().getValue("ComponentName") + "Button");
                if (PlatformInfo.isMacintosh()) {
                    box.add((Component)((Object)dTTitleButton2));
                    box.add((Component)((Object)dTTitleButton));
                } else {
                    box.add((Component)((Object)dTTitleButton));
                    box.add((Component)((Object)dTTitleButton2));
                }
                if (sButtonsAtLeft) {
                    box.add(Box.createHorizontalStrut(4));
                }
                this.add(box, sButtonsAtLeft ? "West" : "East");
            }
            this.setAlignmentX(0.0f);
        }

        void setBorder() {
            if (DTDocumentBar.this.fOrientation == 1) {
                this.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 1));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
            }
        }

        void updateOrientation() {
            this.setBorder();
        }

        void configureUndockCloseButton(MJButton mJButton) {
            mJButton.setMargin(sUndockCloseInsets);
            if (PlatformInfo.isMacintosh()) {
                mJButton.setBorderPainted(false);
            } else {
                mJButton.setFlyOverAppearance(true);
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (DTDocumentBar.this.fOrientation == 1) {
                Insets insets = DTDocumentBar.this.getInsets();
                int n = DTDocumentBar.this.fMaxWidth - insets.left - insets.right;
                if (dimension.width > n) {
                    dimension.width = n;
                }
            }
            return dimension;
        }
    }

    private class DocumentButton
    extends MJToggleButton
    implements PropertyChangeListener {
        DTClient fClient;
        MJButton fCloseButton;
        boolean fBeingDragged;
        boolean fComputingSize;

        DocumentButton(DTClient dTClient) {
            this.setOpaque(true);
            this.fClient = dTClient;
            this.setAction((Action)dTClient.getSelectAction());
            this.setFocusTraversable(false);
            this.setFlyOverAppearance(true);
            this.setHorizontalAlignment(2);
            this.fCloseButton = new MJButton(){

                public Color getBackground() {
                    Container container = this.getParent();
                    if (container == null) {
                        return super.getBackground();
                    }
                    return DTDocumentBar.tweakBackground(container.getBackground());
                }
            };
            if (PlatformInfo.isMacintosh()) {
                this.setContentAreaFilled(false);
                this.setOpaque(false);
                this.setBorderPainted(false);
                this.setRolloverEnabled(true);
                this.setFont(this.getFont().deriveFont(this.getFont().getSize() - 2));
                this.fCloseButton.setBorderPainted(false);
                this.fCloseButton.setIcon((Icon)CommonIcon.DOT_CLOSE.getIcon());
                this.fCloseButton.setRolloverIcon((Icon)CommonIcon.DOT_CLOSE_OVER.getIcon());
                this.fCloseButton.setPressedIcon((Icon)CommonIcon.DOT_CLOSE_PRESSED.getIcon());
                this.fCloseButton.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        DocumentButton.this.repaint();
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        DocumentButton.this.repaint();
                    }
                });
            } else {
                this.setFlyOverAppearance(true);
                Icon icon = SMALL_CLOSE_ICON;
                if (this.fCloseButton.getBackground().equals(Color.black)) {
                    if (sWhiteCloseIcon == null) {
                        sWhiteCloseIcon = new ImageIcon(DTDocumentBar.class.getResource("resources/smallwhiteclose.gif"));
                    }
                    icon = sWhiteCloseIcon;
                }
                this.fCloseButton.setIcon(icon);
                this.fCloseButton.setBorder(NARROW_BUTTON_BORDER);
                this.fCloseButton.setFlyOverAppearance(true);
            }
            this.fCloseButton.setActionCommand("Close");
            this.fCloseButton.setDefaultCapable(false);
            this.fCloseButton.setFocusTraversable(false);
            this.fCloseButton.setMargin(sUndockCloseInsets);
            this.setClient(dTClient);
            this.add((Component)this.fCloseButton);
            if (sButtonInsets == null) {
                int n;
                int n2 = n = PlatformInfo.isMacintosh() ? 2 : 0;
                if (sButtonsAtLeft) {
                    sButtonInsets = new Insets(n, this.fCloseButton.getPreferredSize().width + 6, n, 0);
                } else {
                    sButtonInsets = new Insets(n, 4, n, this.fCloseButton.getPreferredSize().width + 6);
                }
            }
            if (sNoCloseButtonInsets == null) {
                int n = PlatformInfo.isMacintosh() ? 2 : 0;
                sNoCloseButtonInsets = new Insets(n, 4, n, 4);
            }
            this.setMargin(this.fCloseButton.isVisible() ? sButtonInsets : sNoCloseButtonInsets);
        }

        protected void paintComponent(Graphics graphics) {
            if (PlatformInfo.isMacintosh()) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                Point point = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(point, (Component)((Object)this));
                if (this.getModel().isPressed()) {
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, MAC_SELECTED_BACKGROUND_TOP_COLOR.darker(), 0.0f, this.getHeight(), MAC_SELECTED_BACKGROUND_BOTTOM_COLOR);
                    graphics2D.setPaint(gradientPaint);
                } else if (this.isSelected()) {
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, MAC_SELECTED_BACKGROUND_TOP_COLOR, 0.0f, this.getHeight(), MAC_SELECTED_BACKGROUND_BOTTOM_COLOR);
                    graphics2D.setPaint(gradientPaint);
                } else if (this.contains(point)) {
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, this.getHeight(), MAC_SELECTED_BACKGROUND_BOTTOM_COLOR);
                    graphics2D.setPaint(gradientPaint);
                } else {
                    graphics2D.setPaint(this.getParent().getBackground());
                }
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (DTDocumentBar.this.getOrientation() == 0) {
                    graphics2D.setColor(MAC_LEFT_OR_TOP_BORDER_COLOR);
                    graphics2D.drawLine(0, 0, 0, this.getHeight());
                    graphics2D.setColor(MAC_RIGHT_OR_BOTTOM_BORDER_COLOR);
                    graphics2D.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight());
                } else {
                    graphics2D.setColor(MAC_LEFT_OR_TOP_BORDER_COLOR);
                    graphics2D.drawLine(0, 0, this.getWidth(), 0);
                    graphics2D.setColor(MAC_RIGHT_OR_BOTTOM_BORDER_COLOR);
                    graphics2D.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
                }
                graphics2D.dispose();
            }
            super.paintComponent(graphics);
        }

        public boolean isBorderPainted() {
            return !PlatformInfo.isMacintosh() && super.isBorderPainted();
        }

        void setClient(DTClient dTClient) {
            if (this.fClient != null) {
                this.fClient.removePropertyListener(this);
                this.fCloseButton.removeActionListener((ActionListener)this.fClient.getCloseAction());
            }
            if (dTClient != null) {
                dTClient.addPropertyListener(this);
                this.fCloseButton.setName("CloseDocument" + dTClient.getComponentName());
                this.fCloseButton.addActionListener((ActionListener)dTClient.getCloseAction());
                this.fCloseButton.setVisible(dTClient.permitUserClose());
            }
            this.fClient = dTClient;
        }

        DTClient getClient() {
            return this.fClient;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.fClient != propertyChangeEvent.getSource()) {
                return;
            }
            if (DTClientProperty.PERMIT_USER_CLOSE.toString().equals(propertyChangeEvent.getPropertyName())) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.fCloseButton.setVisible(bl);
                this.setMargin(bl ? sButtonInsets : sNoCloseButtonInsets);
            }
        }

        public String getToolTipText() {
            Window window = SwingUtilities.windowForComponent((Component)((Object)this));
            if (window != null && !window.isActive()) {
                return null;
            }
            String string = super.getToolTipText();
            this.fComputingSize = true;
            Dimension dimension = super.getPreferredSize();
            this.fComputingSize = false;
            return string == null || string.equals(this.getText()) && dimension.width <= this.getWidth() + this.fCloseButton.getPreferredSize().width + 4 ? null : string;
        }

        public Dimension getPreferredSize() {
            this.fComputingSize = true;
            Dimension dimension = super.getPreferredSize();
            this.fComputingSize = false;
            if (this.fCloseButton.isVisible()) {
                dimension.width += this.fCloseButton.getPreferredSize().width + 4;
            }
            if (DTDocumentBar.this.fOrientation == 1 || !PlatformInfo.isMacintosh()) {
                Insets insets = DTDocumentBar.this.getInsets();
                int n = DTDocumentBar.this.fMaxWidth - insets.left - insets.right;
                if (dimension.width > n) {
                    dimension.width = n;
                }
            }
            if (PlatformInfo.isMacintosh()) {
                dimension.height = this.getFontMetrics(this.getFont()).getHeight() + this.getInsets().top + this.getInsets().bottom;
                dimension.height = this.getFontMetrics(this.getFont()).getHeight() + 4;
            }
            return dimension;
        }

        public Dimension getMaximumSize() {
            this.fComputingSize = true;
            Dimension dimension = super.getMaximumSize();
            this.fComputingSize = false;
            dimension.width = 10000;
            return dimension;
        }

        public Dimension getMinimumSize() {
            this.fComputingSize = true;
            Dimension dimension = super.getMinimumSize();
            this.fComputingSize = false;
            return dimension;
        }

        int getTruePreferredWidth() {
            this.fComputingSize = true;
            int n = super.getPreferredSize().width;
            this.fComputingSize = false;
            return n;
        }

        public String getText() {
            String string = super.getText();
            if (this.fComputingSize && this.fClient != null && this.fClient.appendsAsteriskWhenDirty() && string != null && string.length() > 0 && string.charAt(string.length() - 1) != '*') {
                string = string + '*';
            }
            return string;
        }

        public int getComponentCount() {
            if (this.fComputingSize) {
                return 0;
            }
            return super.getComponentCount();
        }

        public void doLayout() {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = this.fCloseButton.getPreferredSize().width + 4;
            if (sButtonsAtLeft) {
                this.fCloseButton.setBounds(2, 2, n3 - 4, n2 - 4);
            } else {
                this.fCloseButton.setBounds(n - n3 - 2, 2, n3, n2 - 4);
            }
        }

        void cleanup() {
            this.setClient(null);
            MJUtilities.dispose((AbstractButton)((Object)this));
        }

        void setBeingDragged(boolean bl) {
            this.fBeingDragged = bl;
            this.getModel().setArmed(!bl);
            this.setFlyOverAppearance(!bl);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (!this.fBeingDragged || mouseEvent.getID() != 504) {
                super.processMouseEvent(mouseEvent);
            }
        }

        public void setText(String string) {
            super.setText(string);
            DTDocumentBar.this.revalidate();
            DTDocumentBar.this.repaint();
            if (DTDocumentBar.this.fOrientation == 1) {
                DTDocumentBar.this.fContainer.revalidate();
                DTDocumentBar.this.fContainer.repaint();
            }
        }
    }

    class GroupPanel
    extends MJPanel {
        DTGroup fGroup;
        JComponent fEndSeparator;
        boolean fSuppressLayout;

        GroupPanel(DTGroup dTGroup) {
            this.fGroup = dTGroup;
            this.setLayout(new BoxLayout((Container)((Object)this), DTDocumentBar.this.fOrientation == 0 ? 0 : 1));
            if (DTDocumentBar.this.fMultipleGroups) {
                GroupHeader groupHeader = new GroupHeader(dTGroup);
                this.add((Component)((Object)groupHeader));
            }
            this.fEndSeparator = PlatformInfo.isMacintosh() ? new JLabel() : new BorderedSeparator();
            this.configureEndSeparator();
            this.fEndSeparator.addMouseListener(DTDocumentBar.this.fButtonResizer);
            this.fEndSeparator.addMouseMotionListener(DTDocumentBar.this.fButtonResizer);
            this.add(this.fEndSeparator);
        }

        void configureEndSeparator() {
            if (PlatformInfo.isMacintosh()) {
                if (DTDocumentBar.this.fOrientation == 1) {
                    this.fEndSeparator.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, MAC_LEFT_OR_TOP_BORDER_COLOR));
                    this.fEndSeparator.setPreferredSize(new Dimension(1, 1));
                } else {
                    this.fEndSeparator.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, MAC_LEFT_OR_TOP_BORDER_COLOR));
                    this.fEndSeparator.setPreferredSize(new Dimension(1, 1));
                }
            } else if (DTDocumentBar.this.fOrientation == 1) {
                this.fEndSeparator.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 1));
                ((JSeparator)this.fEndSeparator).setOrientation(0);
            } else {
                this.fEndSeparator.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
                ((JSeparator)this.fEndSeparator).setOrientation(1);
            }
        }

        void updateOrientation() {
            this.setLayout(new BoxLayout((Container)((Object)this), DTDocumentBar.this.fOrientation == 0 ? 0 : 1));
            if (DTDocumentBar.this.fMultipleGroups) {
                ((GroupHeader)((Object)this.getComponent(0))).updateOrientation();
            }
            this.configureEndSeparator();
            int n = this.getComponentCount() - 1;
            for (int i = 1; i < n; ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JSeparator)) continue;
                component.setVisible(DTDocumentBar.this.fOrientation == 0 && !PlatformInfo.isMacintosh());
            }
        }

        public void doLayout() {
            if (!this.fSuppressLayout) {
                super.doLayout();
            }
            if (PlatformInfo.isMacintosh()) {
                if (DTDocumentBar.this.fOrientation == 1) {
                    this.fEndSeparator.setLocation(0, this.fEndSeparator.getY());
                    this.fEndSeparator.setSize(this.getWidth(), this.fEndSeparator.getHeight());
                } else {
                    this.fEndSeparator.setLocation(this.fEndSeparator.getX(), 0);
                    this.fEndSeparator.setSize(this.fEndSeparator.getWidth(), this.getHeight());
                }
            }
        }
    }

    class ContentPanel
    extends MJLayeredPane
    implements Scrollable {
        boolean fSuppressLayout;

        ContentPanel() {
            this.setLayout(new BoxLayout((Container)((Object)this), DTDocumentBar.this.fOrientation == 0 ? 0 : 1));
        }

        void updateOrientation() {
            this.setLayout(new BoxLayout((Container)((Object)this), DTDocumentBar.this.fOrientation == 0 ? 0 : 1));
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                GroupPanel groupPanel = (GroupPanel)((Object)this.getComponent(i));
                groupPanel.updateOrientation();
            }
        }

        public void doLayout() {
            if (!this.fSuppressLayout) {
                super.doLayout();
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            int n3;
            int n4 = n3 = n2 < 0 ? -1 : 1;
            if (n == 1) {
                int n5 = rectangle.x + rectangle.width / 2;
                if (n2 > 0) {
                    Component component = this.getGrandChildAt(n5, rectangle.y + 1);
                    if (component != null) {
                        n3 = component.getParent().getY() + component.getY() + component.getHeight() - rectangle.y;
                    }
                } else {
                    Component component = this.getGrandChildAt(n5, rectangle.y - 1);
                    if (component != null) {
                        n3 = component.getParent().getY() + component.getY() - rectangle.y;
                    }
                }
            } else {
                int n6 = rectangle.y + rectangle.height / 2;
                if (n2 > 0) {
                    Component component = this.getGrandChildAt(rectangle.x + 1, n6);
                    if (component != null) {
                        n3 = component.getParent().getX() + component.getX() + component.getWidth() - rectangle.x;
                    }
                } else {
                    Component component = this.getGrandChildAt(rectangle.x - 1, n6);
                    if (component != null) {
                        n3 = component.getParent().getX() + component.getX() - rectangle.x;
                    }
                }
            }
            return n3;
        }

        Component getGrandChildAt(int n, int n2) {
            Component component = null;
            Component component2 = this.getComponentAt(n, n2);
            if (component2 instanceof GroupPanel) {
                component = component2.getComponentAt(n -= component2.getX(), n2 -= component2.getY());
            }
            return component;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return this.getScrollableUnitIncrement(rectangle, n, n2);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return DTDocumentBar.this.fOrientation == 1;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return DTDocumentBar.this.fOrientation == 0;
        }
    }

    private class ViewAdjuster
    implements Runnable {
        Component fComponent;

        ViewAdjuster(Component component) {
            this.fComponent = component;
        }

        @Override
        public void run() {
            if (this.fComponent.getParent() != null) {
                DTDocumentBar.this.fScroller.ensureVisible(this.fComponent);
            }
        }
    }
}

