/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.mwswing.StringTrimmer;
import com.mathworks.util.ClassLoaderBridge;
import com.mathworks.util.NativeMacObjC;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientFrame;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTClientPropertyProvider;
import com.mathworks.widgets.desk.DTCloseReplyListener;
import com.mathworks.widgets.desk.DTContainer;
import com.mathworks.widgets.desk.DTFloatingLocation;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTGroupProperty;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTKeyBindings;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTNestedLocation;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.DTPropertyBridge;
import com.mathworks.widgets.desk.DTRecoverable;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarContainer;
import com.mathworks.widgets.desk.DTUnableToOpenException;
import com.mathworks.widgets.desk.DTUtilities;
import com.mathworks.widgets.desk.DTWindowActivator;
import com.mathworks.widgets.desk.DeferredRunnable;
import com.mathworks.widgets.desk.Desktop;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.DataFormatException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DTClient
extends DTOccupant
implements ItemListener,
Comparable,
DTWindowActivator,
DTToolBarContainer.Listener {
    private Component fComponent;
    private String fUntitle;
    private String fGroupName;
    private boolean fIsSingleton = true;
    private DTGroup fGroup;
    private boolean fOfferToggle;
    private Vector<DTClientListener> fListeners;
    private DTFloatingLocation fLastFloatingInLocation;
    private DTLocation.Listener fLocationListener = new LocationListener();
    private ActionListener fPreSelectionListener;
    private boolean fDockStateChangePending;
    private boolean fSaveStatusBarVisible = true;
    private String fComponentClassName;
    private SimpleElement fInitialDataElement;
    private boolean fShowPending;
    private boolean fWasShowingWhenCloseInitiated;
    private boolean fSuppressFocusRequestUponFrameSelect;
    private boolean fHidden;
    private boolean fIsPreparingToShow;
    private Component fSavedFocusOwner;
    private static Map<Icon, Icon> sReducedIcons = new HashMap<Icon, Icon>();
    static final String CLIENT_TAG = "Client";
    private static final String CLASS_ATTRIBUTE = "Class";
    private static final String GROUP_ATTRIBUTE = "Group";
    private static final String SINGLETON_ATTRIBUTE = "Singleton";
    private static final String STATUS_BAR_ATTRIBUTE = "StatusBarShowing";
    private static final String FLOATING_IN_VALUE = "floatingIn";
    private static final String CLIENT_DATA_TAG = "ClientData";
    private static final String OFFER_TOGGLE_ATTRIBUTE = "OfferToggle";

    DTClient(Desktop desktop, Component component, String string) {
        super(desktop);
        this.fTitle = string;
        this.setComponent(component);
    }

    public DTClient(Desktop desktop, String string, String string2) {
        super(desktop);
        this.fComponentClassName = string;
        this.fTitle = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientListener(DTClientListener dTClientListener) {
        if (this.fListeners == null) {
            this.fListeners = new Vector();
        }
        Vector<DTClientListener> vector = this.fListeners;
        synchronized (vector) {
            if (!this.fListeners.contains(dTClientListener)) {
                this.fListeners.add(dTClientListener);
            }
        }
    }

    public void removeClientListener(DTClientListener dTClientListener) {
        if (this.fListeners != null) {
            this.fListeners.remove(dTClientListener);
        }
    }

    public synchronized void addPreSelectionListener(ActionListener actionListener) {
        this.fPreSelectionListener = AWTEventMulticaster.add(this.fPreSelectionListener, actionListener);
    }

    public synchronized void removePreSelectionListener(ActionListener actionListener) {
        this.fPreSelectionListener = AWTEventMulticaster.remove(this.fPreSelectionListener, actionListener);
    }

    public final void setComponent(Component component) {
        if (this.fComponent != component) {
            Object object;
            if (component instanceof DTRecoverable && this.fInitialDataElement != null) {
                ((DTRecoverable)((Object)component)).restoreState(this.fInitialDataElement);
                this.fInitialDataElement = null;
            }
            if (this.fPropertyProvider != null) {
                this.fPropertyProvider.removePropertyChangeListener(this);
                this.fPropertyProvider = null;
            }
            if (component != null && !(component instanceof ConstructorErrorLabel)) {
                Class<?> clazz = component.getClass();
                this.fComponentClassName = clazz.getName();
                if (component instanceof DTClientPropertyProvider) {
                    this.setPropertyProvider(new DTPropertyBridge((DTClientPropertyProvider)((Object)component)));
                } else if (component instanceof JComponent) {
                    this.setPropertyProvider(new DTPropertyBridge((JComponent)component));
                }
                if (this.fPropertyProvider != null) {
                    object = (Boolean)this.fPropertyProvider.getProperty(DTClientProperty.MULTIPLE_INSTANCES);
                    if (object != null) {
                        this.fIsSingleton = !((Boolean)object).booleanValue();
                    }
                    this.fPropertyProvider.addPropertyChangeListener(this);
                }
            }
            boolean bl = this.fComponent != null;
            this.fComponent = component;
            if (this.fInternalFrame != null) {
                ((DTClientFrame)this.fInternalFrame).updateClientComponent();
            }
            if (!this.isSingleton()) {
                this.fDesktop.getWindowRegistry().addActivator(this);
                if (this.fLocation == null) {
                    this.fDesktop.getWindowRegistry().setVisible(this, false);
                }
            }
            if (bl) {
                object = DTClientProperty.getClientPropertyList();
                Iterator<DTProperty> iterator = object.iterator();
                while (iterator.hasNext()) {
                    DTProperty dTProperty = iterator.next();
                    Object object2 = this.getProperty(dTProperty);
                    if (object2 == null || object2 == dTProperty.getDefaultValue()) continue;
                    this.propertyChange(new PropertyChangeEvent(component, dTProperty.toString(), dTProperty.getDefaultValue(), object2));
                }
            }
            this.updateShortTitle();
        }
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public String getComponentClassName() {
        return this.fComponentClassName;
    }

    public void setComponentClassName(String string) {
        this.fComponentClassName = string;
    }

    String getComponentName() {
        String string = null;
        if (this.fComponent != null) {
            string = this.fComponent.getName();
        }
        if (string == null) {
            string = this.getShortTitle();
        }
        return string == null ? "UnnamedClient" : string;
    }

    Component createComponent() {
        Component component;
        block16: {
            component = null;
            try {
                Class[] classArray;
                Class clazz = ClassLoaderBridge.findClass((String)this.fComponentClassName);
                if (clazz == null) break block16;
                if (this.fInitialDataElement != null) {
                    try {
                        Object[] objectArray;
                        classArray = new Class[]{SimpleElement.class};
                        Constructor constructor = clazz.getConstructor(classArray);
                        if (constructor != null && (component = (Component)constructor.newInstance(objectArray = new Object[]{this.fInitialDataElement})) != null) {
                            this.fInitialDataElement = null;
                            return component;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                try {
                    classArray = clazz.getMethod("getInstance", new Class[0]);
                    if (classArray != null) {
                        int n = classArray.getModifiers();
                        if (!Modifier.isPublic(n)) {
                            this.fDesktop.getErrorReportingStream().println(this.fComponentClassName + " has a getInstance method but it's not public");
                        } else if (!Modifier.isStatic(n)) {
                            this.fDesktop.getErrorReportingStream().println(this.fComponentClassName + " has a getInstance method but it's not static");
                        } else {
                            component = (Component)classArray.invoke(null, new Object[0]);
                        }
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (component == null) {
                    component = (Component)clazz.newInstance();
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (throwable instanceof InvocationTargetException) {
                    throwable2 = ((InvocationTargetException)throwable).getTargetException();
                }
                if (!(throwable2 instanceof DTUnableToOpenException)) {
                    this.reportCreateError(this.fComponentClassName, throwable2);
                }
                component = null;
            }
        }
        return component;
    }

    void createSurrogateComponent() {
        if (this.fComponent == null) {
            this.fComponent = new SurrogateComponent();
        }
    }

    boolean hasSurrogateComponent() {
        return this.fComponent instanceof SurrogateComponent;
    }

    @Override
    Object createPropertyProvider() {
        if (this.fComponent == null || this.hasSurrogateComponent()) {
            Component component = this.fDesktop.createClientComponentWrapper(this);
            if (component == null) {
                return null;
            }
            this.setComponent(component);
            this.fDesktop.registerClientComponent(this);
        }
        return this.fPropertyProvider;
    }

    @Override
    protected void flush() {
        super.flush();
        if (this.isGuest() && !this.isSessionGuest() && this.fComponent instanceof DTRecoverable) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Element element = document.createElement(CLIENT_DATA_TAG);
                ((DTRecoverable)((Object)this.fComponent)).saveState(document, element);
                this.fInitialDataElement = new SimpleElement(element);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!this.isSingleton()) {
            this.fDesktop.getWindowRegistry().removeActivator(this);
        }
        if (this.fListeners != null) {
            this.fListeners.clear();
        }
        this.fComponent = null;
        this.fGroup = null;
        this.fSavedFocusOwner = null;
    }

    void setSingletonIndex(int n) {
        if (this.fSelectAction == null) {
            this.getSelectAction();
        }
        ((ClientSelectAction)this.fSelectAction).updateIndex(n);
    }

    @Override
    public DTInternalFrame getInternalFrame() {
        return this.getClientFrame();
    }

    DTClientFrame getClientFrame() {
        if (this.fInternalFrame == null) {
            this.setInternalFrame(new DTClientFrame(this));
            this.fInternalFrame.addItemListener(this);
            this.fInternalFrame.getToolBarContainer().addListener(this);
        }
        return (DTClientFrame)this.fInternalFrame;
    }

    @Override
    void setSelected(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            if (this.fIsPreparingToShow) {
                return;
            }
            this.prepareToShow();
        }
        if (bl && this.fPreSelectionListener != null && !this.fInternalFrame.isShowing()) {
            this.fPreSelectionListener.actionPerformed(new ActionEvent(this, 1001, "preselection"));
        }
        boolean bl4 = this.fSuppressFocusRequestUponFrameSelect = (!bl2 || bl3) && bl && this.fInternalFrame != null && this.fInternalFrame.isShowing();
        if (bl && bl2 && this.getInternalFrame().isSelected()) {
            this.requestFocusLater();
        } else {
            if (!bl) {
                this.saveFocus();
            } else if (bl2 && bl3) {
                this.requestFocus();
            }
            this.getInternalFrame().setSelected(bl);
        }
    }

    @Override
    public boolean isSelected() {
        return this.fInternalFrame != null && this.fInternalFrame.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void prepareToShow() {
        if (this.fComponent instanceof SurrogateComponent && !this.fDesktop.isClosing()) {
            this.fIsPreparingToShow = true;
            DTFrame dTFrame = this.fDesktop.getMainFrame();
            if (dTFrame != null) {
                GlobalCursor.setWait((Window)((Object)dTFrame));
            }
            try {
                Object object = this.fDesktop.createClientComponentWrapper(this);
                if (object == null) {
                    Object[] objectArray = new Object[]{this.getShortTitle()};
                    String string = MessageFormat.format(this.getDesktop().getString("error.CreationFailed"), objectArray);
                    object = new ConstructorErrorLabel(string);
                }
                this.setComponent((Component)object);
                this.fDesktop.registerClientComponent(this);
            }
            finally {
                if (dTFrame != null) {
                    GlobalCursor.clear((Window)((Object)dTFrame));
                }
                this.fIsPreparingToShow = false;
            }
        }
    }

    @Override
    void requestFocus() {
        this.requestFocus(false);
    }

    void requestFocus(boolean bl) {
        if (this.fComponent != null) {
            Component component;
            Component component2 = component = bl ? null : KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (component == null || component instanceof JScrollBar || component == this.fInternalFrame || !SwingUtilities.isDescendingFrom(component, (Component)((Object)this.fInternalFrame))) {
                if (PlatformInfo.isMacintosh() && !this.fDesktop.hasMainFrame()) {
                    NativeMacObjC.macActivateIgnoringOtherApps();
                }
                if (this.fSavedFocusOwner != null && this.fSavedFocusOwner.isShowing() && SwingUtilities.isDescendingFrom(this.fSavedFocusOwner, (Component)((Object)this.fInternalFrame))) {
                    this.fSavedFocusOwner.requestFocus();
                } else {
                    this.fComponent.requestFocus();
                }
                this.fSavedFocusOwner = null;
            }
        }
    }

    boolean requestFocusInWindow() {
        return this.requestFocusInWindow(false);
    }

    boolean requestFocusInWindow(boolean bl) {
        boolean bl2 = false;
        if (this.fComponent != null) {
            Component component;
            Component component2 = component = bl ? null : KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (component == null || component instanceof JScrollBar || component == this.fInternalFrame || !SwingUtilities.isDescendingFrom(component, (Component)((Object)this.fInternalFrame))) {
                bl2 = this.fSavedFocusOwner != null && this.fSavedFocusOwner.isShowing() && SwingUtilities.isDescendingFrom(this.fSavedFocusOwner, (Component)((Object)this.fInternalFrame)) ? this.fSavedFocusOwner.requestFocusInWindow() : this.fComponent.requestFocusInWindow();
                this.fSavedFocusOwner = null;
            }
        }
        return bl2;
    }

    void saveFocus() {
        if (this.isSelected()) {
            this.fSavedFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (this.fSavedFocusOwner != null && (this.fSavedFocusOwner instanceof DTClientFrame || !SwingUtilities.isDescendingFrom(this.fSavedFocusOwner, (Component)((Object)this.fInternalFrame)))) {
                this.fSavedFocusOwner = null;
            }
        }
    }

    @Override
    void requestFocusLater() {
        SwingUtilities.invokeLater(new DeferredFocusRequest());
    }

    void setGroup(DTGroup dTGroup) {
        this.fGroup = dTGroup;
    }

    public DTGroup getGroup() {
        return this.fGroup;
    }

    boolean offerToggle() {
        return this.fOfferToggle;
    }

    @Override
    String getConstrainedTitle() {
        return this.isSingleton() ? this.getShortTitle() : DTUtilities.constrainTitle(this.getShortTitle());
    }

    @Override
    synchronized void setLocation(DTLocation dTLocation) {
        if (dTLocation == this.fLocation && !this.fHidden) {
            return;
        }
        if (!this.isSingleton()) {
            this.fDesktop.getWindowRegistry().setVisible(this, !this.fHidden && dTLocation != null);
        }
        this.fHidden = false;
        DTLocation dTLocation2 = this.fLastLocation;
        if (this.fLocation != null) {
            this.fLocation.removeChangeListener(this.fLocationListener);
        }
        super.setLocation(dTLocation);
        if (dTLocation != null) {
            dTLocation.addChangeListener(this.fLocationListener);
            this.fShowPending = false;
            if (!this.fIsOpen) {
                this.fIsOpen = true;
                this.fireClientEvent(new DTClientEvent(this.fComponent, 10));
            }
            if (dTLocation.isDocked() && (dTLocation2 == null || !dTLocation2.isDocked() || this.fDockStateChangePending)) {
                this.fireClientEvent(new DTClientEvent(this.fComponent, 5));
            } else if (!dTLocation.isDocked() && (dTLocation2 != null && dTLocation2.isDocked() || this.fDockStateChangePending)) {
                this.fireClientEvent(new DTClientEvent(this.fComponent, 7));
            }
            this.fDockStateChangePending = false;
            DTClientEvent dTClientEvent = new DTClientEvent(this.fComponent, 8);
            dTClientEvent.setData(dTLocation);
            this.fireClientEvent(dTClientEvent);
        }
    }

    void setHidden(boolean bl) {
        this.fHidden = bl;
    }

    synchronized void setLocationHidden(DTLocation dTLocation) {
        this.fHidden = true;
        this.fLocation = dTLocation;
    }

    synchronized DTFloatingLocation getLastFloatingInLocation() {
        return this.fLastFloatingInLocation;
    }

    @Override
    public synchronized void setLastDockedLocation(DTLocation dTLocation) {
        super.setLastDockedLocation(dTLocation);
        if (dTLocation instanceof DTFloatingLocation) {
            this.fLastFloatingInLocation = (DTFloatingLocation)dTLocation;
        }
    }

    boolean isHidden() {
        return this.fHidden;
    }

    private boolean isReallyShowing() {
        return this.fLocation != null && (this.fLocation.isDocked() || this.fLocation.getFrame() != null && this.fLocation.getFrame().isVisible());
    }

    boolean showPending() {
        return this.fShowPending;
    }

    void setShowPending() {
        this.fShowPending = true;
    }

    void saveStatusBarVisible(boolean bl) {
        this.fSaveStatusBarVisible = bl;
    }

    boolean wasStatusBarVisible() {
        return this.fSaveStatusBarVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int canClose(DTCloseReplyListener dTCloseReplyListener) {
        int n = super.canClose(dTCloseReplyListener);
        this.fWasShowingWhenCloseInitiated = this.isReallyShowing();
        DTClientEvent dTClientEvent = new DTClientEvent(this.fComponent, 11);
        if (this.fListeners != null) {
            if (this.fPropertyProvider == null) {
                this.fireClientEvent(dTClientEvent);
            } else {
                DTClientListener[] dTClientListenerArray;
                dTClientEvent.setData(dTCloseReplyListener);
                Vector<DTClientListener> vector = this.fListeners;
                synchronized (vector) {
                    dTClientListenerArray = new DTClientListener[this.fListeners.size()];
                    dTClientListenerArray = this.fListeners.toArray(dTClientListenerArray);
                }
                for (int i = 0; i < dTClientListenerArray.length && n != 0; ++i) {
                    dTClientListenerArray[i].clientClosing(dTClientEvent);
                    if (this.fPropertyProvider == null) continue;
                    Object object = this.fPropertyProvider.getProperty(DTClientProperty.VETO_CLOSE);
                    if (object != null && !object.equals(Boolean.FALSE)) {
                        n = 0;
                        continue;
                    }
                    Object object2 = this.fPropertyProvider.getProperty(DTClientProperty.DEFER_CLOSE);
                    if (object2 == null) continue;
                    n = 2;
                }
            }
        }
        if (n != 2) {
            this.fCloseReplyListener = null;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void close() {
        this.fIsOpen = false;
        if (!this.isSingleton() && !this.isReallyShowing() && this.fWasShowingWhenCloseInitiated && !this.fDesktop.isClosing()) {
            return;
        }
        if (this.hasBeenFlushed()) {
            return;
        }
        DTClientEvent dTClientEvent = new DTClientEvent(this.fComponent, 12);
        this.fIsClosing = true;
        if (this.isSingleton()) {
            this.fDesktop.setClientShowing(this, false, null, false);
            this.fireClientEvent(dTClientEvent);
        } else {
            DTClientListener[] dTClientListenerArray;
            if (this.fListeners == null) {
                dTClientListenerArray = new DTClientListener[]{};
            } else {
                DTClientListener[] dTClientListenerArray2 = this.fListeners;
                // MONITORENTER : this.fListeners
                dTClientListenerArray = new DTClientListener[this.fListeners.size()];
                dTClientListenerArray = this.fListeners.toArray(dTClientListenerArray);
                // MONITOREXIT : dTClientListenerArray2
            }
            this.fDesktop.getWindowRegistry().removeActivator(this);
            this.fDesktop.removeClient(this);
            for (DTClientListener dTClientListener : dTClientListenerArray) {
                dTClientListener.clientClosed(dTClientEvent);
            }
        }
        this.fIsClosing = false;
    }

    void attemptClose() {
        if (this.hasBeenFlushed() || this.fIsClosing || this.fCloseReplyListener != null) {
            return;
        }
        this.fIsClosing = true;
        this.fWasSelectedWhenCloseInitiated = this.isSelected();
        if (this.canClose()) {
            this.close();
        }
        this.fIsClosing = false;
    }

    public String toString() {
        return this.getShortTitle();
    }

    @Override
    public String getShortTitle() {
        String string = null;
        if (this.fPropertyProvider != null) {
            string = (String)this.fPropertyProvider.getProperty(DTClientProperty.SHORT_TITLE);
        }
        if (string == null) {
            string = this.getTitle();
        }
        if (string == null || string.length() == 0) {
            if (this.fUntitle == null) {
                DTGroup dTGroup;
                this.fUntitle = MJUtilities.intlString((String)"window.Untitled");
                String string2 = this.getGroupName();
                int n = 0;
                if (string2 != null && (dTGroup = this.fDesktop.getGroup(string2)) != null) {
                    n = dTGroup.updateUntitledClientCount();
                }
                if (n == 0) {
                    n = this.fDesktop.updateUntitledClientCount();
                }
                if (n > 1) {
                    this.fUntitle = this.fUntitle + " " + n;
                }
            }
            string = this.fUntitle;
        }
        return string;
    }

    @Override
    Icon getSmallIcon() {
        Icon icon = super.getSmallIcon();
        if (icon == null && (icon = this.getIcon()) != null) {
            icon = this.reduceIcon(icon);
        }
        return icon;
    }

    private Icon reduceIcon(Icon icon) {
        if (icon instanceof ImageIcon && (icon.getIconWidth() > 16 || icon.getIconHeight() > 16)) {
            Icon icon2 = sReducedIcons.get(icon);
            if (icon2 == null) {
                Image image = ((ImageIcon)icon).getImage();
                Image image2 = image.getScaledInstance(16, 16, 4);
                icon2 = new ImageIcon(image2);
                sReducedIcons.put(icon, icon2);
            }
            icon = icon2;
        }
        return icon;
    }

    @Override
    String getDefaultToolBarLabel() {
        if (this.fIsSingleton) {
            return this.getShortTitle();
        }
        if (this.fGroup != null) {
            return this.fGroup.getTitle();
        }
        return "";
    }

    @Override
    boolean isSingleton() {
        return this.fIsSingleton;
    }

    @Override
    public String getGroupName() {
        if (this.fGroupName == null && this.fPropertyProvider != null) {
            Object object = this.fPropertyProvider.getProperty(DTClientProperty.GROUP);
            if (object instanceof String) {
                this.fGroupName = (String)object;
            } else if (object instanceof DTGroupPropertyProvider) {
                this.fGroupName = (String)((DTGroupPropertyProvider)object).getGroupProperty(DTProperty.NAME);
                if (this.fGroupName == null) {
                    this.fGroupName = (String)((DTGroupPropertyProvider)object).getGroupProperty(DTGroupProperty.TITLE);
                }
            }
        }
        return this.fGroupName;
    }

    DTGroupPropertyProvider getGroupPropertyProvider() {
        Object object;
        DTGroupPropertyProvider dTGroupPropertyProvider = null;
        if (this.fPropertyProvider != null && (object = this.fPropertyProvider.getProperty(DTClientProperty.GROUP)) instanceof DTGroupPropertyProvider) {
            dTGroupPropertyProvider = (DTGroupPropertyProvider)object;
        }
        return dTGroupPropertyProvider;
    }

    boolean isAutoReopenEnabled() {
        return (!this.hasBeenFlushed() || this.fPropertyProvider != null) && !this.getBooleanProperty(DTClientProperty.DONT_REOPEN);
    }

    boolean canReopen() {
        return this.isAutoReopenEnabled() || this.fComponent instanceof DTRecoverable;
    }

    boolean permitCloseUponLayout() {
        return this.getBooleanProperty(DTClientProperty.PERMIT_CLOSE_UPON_LAYOUT);
    }

    @Override
    boolean onTopWhenUndocked() {
        if (this.getPropertyProvider() != null && this.getPropertyProvider().getProperty(DTProperty.ON_TOP_WHEN_UNDOCKED) != null) {
            return super.onTopWhenUndocked();
        }
        return this.isSingleton() && this.fDesktop.undockSingletonsOnTop();
    }

    StringTrimmer getTitleTrimmer() {
        StringTrimmer stringTrimmer = null;
        if (this.fPropertyProvider != null) {
            stringTrimmer = (StringTrimmer)this.fPropertyProvider.getProperty(DTClientProperty.TITLE_TRIMMER);
        }
        return stringTrimmer;
    }

    boolean treatAsHeavyweight() {
        return this.fDesktop.accommodateHeavyweightClients() && this.mayHaveHeavyContent();
    }

    boolean wantsTopSeparator() {
        return this.getBooleanProperty(DTClientProperty.WANT_TOP_SEPARATOR);
    }

    boolean maintainAspectRatio() {
        return this.getBooleanProperty(DTClientProperty.MAINTAIN_ASPECT_RATIO);
    }

    boolean wantsControlKeys() {
        return this.getBooleanProperty(DTClientProperty.WANT_ALL_CONTROL_KEYS);
    }

    boolean honorPreferredSizeWhenDocked() {
        return this.getBooleanProperty(DTClientProperty.HONOR_PREFERRED_SIZE_WHEN_DOCKED);
    }

    boolean appendsAsteriskWhenDirty() {
        return this.getBooleanProperty(DTClientProperty.APPENDS_ASTERISK_WHEN_DIRTY);
    }

    List<Action> getContextActions() {
        JMenuBar jMenuBar;
        ArrayList<Action> arrayList = new ArrayList<Action>();
        Action[] actionArray = (Action[])this.getProperty(DTClientProperty.CONTEXT_ACTIONS);
        if (actionArray != null) {
            arrayList.addAll(Arrays.asList(actionArray));
        }
        if ((jMenuBar = this.getMenuBar()) != null) {
            for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
                JMenu jMenu = jMenuBar.getMenu(i);
                for (Component component : jMenu.getMenuComponents()) {
                    DTMenuMergeTag dTMenuMergeTag;
                    Action action;
                    if (!(component instanceof JMenuItem) || (action = ((JMenuItem)component).getAction()) == null || (dTMenuMergeTag = DTMenuMergeTag.getTag(action)) == null) continue;
                    action.putValue("toolName", dTMenuMergeTag.toString());
                    arrayList.add(action);
                }
            }
            DTMenuMergeTag.CLOSE.setTag((Action)this.getCloseAction());
            arrayList.add((Action)this.getCloseAction());
            actionArray = arrayList.toArray(new Action[arrayList.size()]);
        }
        return arrayList;
    }

    @Override
    protected DTOccupant.OccupantAction createOpenAction() {
        return new ClientOpenAction();
    }

    @Override
    protected DTOccupant.OccupantAction createCloseAction() {
        return new ClientCloseAction();
    }

    @Override
    protected DTOccupant.OccupantAction createDockAction() {
        return new ClientDockAction();
    }

    @Override
    protected DTOccupant.OccupantAction createUndockAction() {
        return new ClientUndockAction();
    }

    @Override
    protected DTOccupant.OccupantAction createMinimizeAction() {
        return new ClientMinimizeAction();
    }

    @Override
    protected DTOccupant.OccupantAction createMaximizeAction() {
        return new ClientMaximizeAction();
    }

    @Override
    protected DTOccupant.OccupantAction createSelectAction() {
        return new ClientSelectAction();
    }

    @Override
    protected DTOccupant.OccupantAction createToggleAction() {
        return new ClientToggleAction();
    }

    public boolean equals(Object object) {
        String string;
        String string2;
        if (!(object instanceof DTClient)) {
            return false;
        }
        DTClient dTClient = (DTClient)object;
        if (!this.fComponentClassName.equals(dTClient.fComponentClassName)) {
            return false;
        }
        if (!this.isSingleton() && this.fComponent != dTClient.fComponent) {
            return false;
        }
        String string3 = this.getGroupName();
        if (!(string3 == (string2 = dTClient.getGroupName()) || string3 != null && string3.equals(string2))) {
            return false;
        }
        String string4 = this.getNameForCompare();
        return string4 == (string = dTClient.getNameForCompare()) || string4 != null && string4.equals(string);
    }

    public int hashCode() {
        int n = this.fComponentClassName.hashCode();
        if (this.getGroupName() != null) {
            n = 37 * n + this.getGroupName().hashCode();
        }
        if (this.getNameForCompare() != null) {
            n = 37 * n + this.getNameForCompare().hashCode();
        }
        return n;
    }

    private String getNameForCompare() {
        return this.isSingleton() ? this.getName() : this.getTitle();
    }

    void updateFrom(DTClient dTClient) {
        if (dTClient.fInitialDataElement != null && this.fComponent instanceof DTRecoverable) {
            ((DTRecoverable)((Object)this.fComponent)).restoreState(dTClient.fInitialDataElement);
            this.fInitialDataElement = null;
        } else {
            this.fInitialDataElement = dTClient.fInitialDataElement;
        }
        this.fShowPending = dTClient.fShowPending;
        this.fSelectionOrder = dTClient.fSelectionOrder;
        this.fToolBarState = dTClient.fToolBarState;
        if (dTClient.fLastLocation != null) {
            if (this.fLastLocation != null && this.fLastLocation.isDocked() != dTClient.fLastLocation.isDocked()) {
                this.fDockStateChangePending = true;
            }
            this.fLastLocation = dTClient.fLastLocation;
        }
        if (dTClient.fLastDockedLocation != null) {
            this.fLastDockedLocation = dTClient.fLastDockedLocation;
        }
        if (dTClient.fLastNestedLocation != null) {
            this.fLastNestedLocation = dTClient.fLastNestedLocation;
        }
        if (dTClient.fLastUndockedLocation != null) {
            this.fLastUndockedLocation = dTClient.fLastUndockedLocation;
            this.fSaveStatusBarVisible = dTClient.fSaveStatusBarVisible;
        }
        if (dTClient.fLastFloatingInLocation != null) {
            this.fLastFloatingInLocation = dTClient.fLastFloatingInLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireClientEvent(DTClientEvent dTClientEvent) {
        if (this.fListeners == null) {
            return;
        }
        DTClientListener[] dTClientListenerArray = this.fListeners;
        synchronized (this.fListeners) {
            DTClientListener[] dTClientListenerArray2 = new DTClientListener[this.fListeners.size()];
            dTClientListenerArray2 = this.fListeners.toArray(dTClientListenerArray2);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            block17: for (DTClientListener dTClientListener : dTClientListenerArray2) {
                switch (dTClientEvent.getType()) {
                    case 1: {
                        dTClientListener.clientActivating(dTClientEvent);
                        continue block17;
                    }
                    case 2: {
                        dTClientListener.clientActivated(dTClientEvent);
                        continue block17;
                    }
                    case 3: {
                        dTClientListener.clientDeactivated(dTClientEvent);
                        continue block17;
                    }
                    case 4: {
                        dTClientListener.clientDocking(dTClientEvent);
                        continue block17;
                    }
                    case 5: {
                        dTClientListener.clientDocked(dTClientEvent);
                        continue block17;
                    }
                    case 6: {
                        dTClientListener.clientUndocking(dTClientEvent);
                        continue block17;
                    }
                    case 7: {
                        dTClientListener.clientUndocked(dTClientEvent);
                        continue block17;
                    }
                    case 8: {
                        dTClientListener.clientRelocated(dTClientEvent);
                        continue block17;
                    }
                    case 9: {
                        if (!(dTClientListener instanceof DTClientAdapter)) continue block17;
                        ((DTClientAdapter)dTClientListener).clientResized(dTClientEvent);
                        continue block17;
                    }
                    case 10: {
                        dTClientListener.clientOpened(dTClientEvent);
                        continue block17;
                    }
                    case 11: {
                        dTClientListener.clientClosing(dTClientEvent);
                        continue block17;
                    }
                    case 12: {
                        dTClientListener.clientClosed(dTClientEvent);
                    }
                }
            }
            return;
        }
    }

    @Override
    public void activate() {
        if (this.hasBeenFlushed()) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DTClient.this.activate();
                }
            });
            return;
        }
        if (this.fPreSelectionListener != null) {
            this.fPreSelectionListener.actionPerformed(new ActionEvent(this, 1001, "preselection"));
        }
        if (!this.isSelected()) {
            this.setSelected(true);
        } else {
            this.fDesktop.toFront(this, DTContainer.Scope.FRAME);
            this.requestFocusLater();
        }
    }

    public int compareTo(Object object) {
        DTClient dTClient = (DTClient)object;
        return this.getShortTitle().compareToIgnoreCase(dTClient.getShortTitle());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doPropertyChange(propertyChangeEvent);
        } else {
            SwingUtilities.invokeLater(new DeferredPropertyChange(propertyChangeEvent));
        }
    }

    @Override
    protected void doPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        if (this.hasBeenFlushed()) {
            return;
        }
        if (DTProperty.TITLE.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.updateTitle();
        } else if (DTClientProperty.SHORT_TITLE.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.updateShortTitle();
        } else if (DTProperty.SMALL_ICON.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.updateIcon((Icon)propertyChangeEvent.getNewValue());
        } else if (DTProperty.TOOL_BAR.toString().equals(propertyChangeEvent.getPropertyName())) {
            this.notifyToolBars(this.isSelected());
        } else if (DTClientProperty.DOCKABLE.toString().equals(propertyChangeEvent.getPropertyName()) && !(bl = ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) && this.fLocation != null && this.fLocation.isDocked()) {
            this.fDesktop.setClientDocked(this, false);
        }
        super.doPropertyChange(propertyChangeEvent);
    }

    private void updateTitle() {
        if (this.fPropertyProvider.getProperty(DTClientProperty.SHORT_TITLE) == null) {
            this.fDesktop.getWindowRegistry().nameChange(this);
        }
    }

    private void updateShortTitle() {
        this.fDesktop.getWindowRegistry().nameChange(this);
    }

    private void updateIcon(Icon icon) {
    }

    private void notifyToolBars(boolean bl) {
        JToolBar[] jToolBarArray;
        for (JToolBar jToolBar : jToolBarArray = this.getToolBars()) {
            if (!(jToolBar instanceof MJToolBar)) continue;
            ((MJToolBar)jToolBar).setArmed(bl);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        Boolean bl;
        Boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = itemEvent.getStateChange() == 1;
        if (bl3) {
            this.fireClientEvent(new DTClientEvent(this.fComponent, 1));
            bl2 = Boolean.FALSE;
            bl = Boolean.TRUE;
            n = 2;
            if (this.fSelectAction != null) {
                this.fSelectAction.setSelected(true);
            }
        } else {
            bl2 = Boolean.TRUE;
            bl = Boolean.FALSE;
            n = 3;
            if (this.fSelectAction != null && !this.isDockedAndMaximized()) {
                this.fSelectAction.setSelected(false);
            }
        }
        this.forwardPropertyChange(new PropertyChangeEvent(this, "Occupant Selected", bl2, bl));
        this.fireClientEvent(new DTClientEvent(this.fComponent, n));
        this.notifyToolBars(bl3);
        if (itemEvent.getStateChange() == 1 && this.fComponent != null && !this.fSuppressFocusRequestUponFrameSelect) {
            SwingUtilities.invokeLater(new DeferredFocusRequest(3));
        }
        this.fSuppressFocusRequestUponFrameSelect = false;
    }

    private boolean isDockedAndMaximized() {
        return this.fLocation != null && this.fLocation.isDocked() && this.fLocation.isMaximized();
    }

    @Override
    public void toolBarStateChanged(Object object) {
        if (!this.fIsSingleton && this.fGroup != null && this.fLocation != null && this.fLocation.isDocked() && this.fLocation.getFrame().isMainFrame()) {
            this.fGroup.updateToolBarState(object);
        }
    }

    @Override
    public DTToolBarConfiguration getToolBarConfiguration(String string) {
        if (this.isSingleton() || this.fGroup == null) {
            return super.getToolBarConfiguration(string);
        }
        return this.fGroup.getToolBarConfiguration(string);
    }

    Element toXML(Document document) {
        return this.toXML(document, true);
    }

    Element toXML(Document document, boolean bl) {
        Element element;
        Element element2 = document.createElement(CLIENT_TAG);
        if (this.fIsSingleton) {
            element2.setAttribute("Name", this.getName());
        }
        element2.setAttribute("Title", this.fIsSingleton ? this.getShortTitle() : this.getTitle());
        element2.setAttribute(CLASS_ATTRIBUTE, this.getComponentClassName());
        if (this.getGroupName() != null) {
            element2.setAttribute(GROUP_ATTRIBUTE, this.getGroupName());
        }
        element2.setAttribute(SINGLETON_ATTRIBUTE, this.isSingleton() ? "yes" : "no");
        element2.setAttribute("Guest", this.isGuest() ? "yes" : "no");
        element2.setAttribute("Show", this.fLocation != null || !this.fIsSingleton ? "yes" : "no");
        element2.setAttribute("Dock", this.fLastLocation != this.fLastUndockedLocation ? "yes" : "no");
        element2.setAttribute(STATUS_BAR_ATTRIBUTE, this.fSaveStatusBarVisible ? "yes" : "no");
        if (this.fSelectionOrder > 0 && this.fLocation != null && this.fLocation.isDocked()) {
            element2.setAttribute("SelectionOrder", Integer.toString(this.fSelectionOrder));
        }
        if (this.fIsSingleton) {
            this.saveToolBarState();
        }
        if (this.fToolBarState != null) {
            element = DTToolBarContainer.stateToXML(this.fToolBarState, document);
            element2.appendChild(element);
        }
        if (this.fLastDockedLocation != null && (this.fLastDockedLocation == this.fLastLocation || bl)) {
            element = this.fLastDockedLocation.toXML(document);
            element.setAttribute("Context", "docked");
            element2.appendChild(element);
        }
        if (this.fLastUndockedLocation != null && (this.fLastUndockedLocation == this.fLastLocation || bl)) {
            element = this.fLastUndockedLocation.toXML(document);
            element.setAttribute("Context", "undocked");
            element2.appendChild(element);
        }
        if (this.fLastNestedLocation != null) {
            element = this.fLastNestedLocation.toXML(document);
            element.setAttribute("Context", "nested");
            element2.appendChild(element);
        }
        if (this.fLastFloatingInLocation != null) {
            element = this.fLastFloatingInLocation.toXML(document);
            element.setAttribute("Context", FLOATING_IN_VALUE);
            element2.appendChild(element);
        }
        if (this.fComponent instanceof DTRecoverable) {
            Element element3 = document.createElement(CLIENT_DATA_TAG);
            ((DTRecoverable)((Object)this.fComponent)).saveState(document, element3);
            element2.appendChild(element3);
        } else if (this.fInitialDataElement != null) {
            Element element4 = this.fInitialDataElement.convert(document);
            element2.appendChild(element4);
        }
        return element2;
    }

    DTClient(Desktop desktop, SimpleElement simpleElement) throws DataFormatException {
        super(desktop);
        Object object;
        SimpleNodeList simpleNodeList;
        Object object2;
        String string;
        String string2;
        assert (CLIENT_TAG.equals(simpleElement.getTagName()));
        if (simpleElement.hasAttribute("Name")) {
            this.fName = simpleElement.getAttribute("Name");
        }
        if (simpleElement.hasAttribute("Title")) {
            this.fTitle = simpleElement.getAttribute("Title");
        }
        if (simpleElement.hasAttribute("TitleResource")) {
            string2 = simpleElement.getAttribute("TitleResource");
            int n = string2.indexOf(58);
            if (n == -1) {
                throw new DataFormatException("Invalid TitleResource: " + string2);
            }
            string = string2.substring(0, n);
            object2 = string2.substring(n + 1);
            this.fTitle = ResourceBundle.getBundle(string).getString((String)object2);
        }
        this.fComponentClassName = simpleElement.getAttribute(CLASS_ATTRIBUTE);
        if (simpleElement.hasAttribute(GROUP_ATTRIBUTE)) {
            this.fGroupName = simpleElement.getAttribute(GROUP_ATTRIBUTE);
        }
        this.fIsSingleton = !"no".equalsIgnoreCase(string2 = simpleElement.getAttribute(SINGLETON_ATTRIBUTE));
        string2 = simpleElement.getAttribute("Guest");
        this.fIsGuest = "yes".equalsIgnoreCase(string2);
        string2 = simpleElement.getAttribute(OFFER_TOGGLE_ATTRIBUTE);
        this.fOfferToggle = "yes".equals(string2);
        string2 = simpleElement.getAttribute("Show");
        this.fShowPending = "yes".equalsIgnoreCase(string2);
        string2 = simpleElement.getAttribute(STATUS_BAR_ATTRIBUTE);
        this.fSaveStatusBarVisible = !"no".equalsIgnoreCase(string2);
        string2 = simpleElement.getAttribute("SelectionOrder");
        if (string2 != null && string2.length() > 0) {
            try {
                this.fSelectionOrder = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException("Invalid SelectionOrder: " + string2);
            }
        }
        if (!desktop.useToolstrip() && (simpleNodeList = simpleElement.getChildrenByTagName("ToolBars")).getLength() > 0) {
            string = (SimpleElement)simpleNodeList.item(0);
            this.fToolBarState = DTToolBarContainer.stateFromXML((SimpleElement)string);
            object2 = DTToolBarContainer.keysFromState(this.fToolBarState);
            object = DTToolBarContainer.labelsFromState(this.fToolBarState);
            for (int i = 0; i < object2.size(); ++i) {
                String string3 = (String)object2.get(i);
                String string4 = (String)object.get(i);
                if (string3 == null || string4 == null || desktop.getToolBarRegistry().isRegistered(string3)) continue;
                DTOccupant.ToolBarData toolBarData = new DTOccupant.ToolBarData(this);
                toolBarData.iLabel = string4;
                this.fToolBarDataMap.put(string3, toolBarData);
                desktop.getToolBarRegistry().register(string3, this);
            }
        }
        SimpleNodeList simpleNodeList2 = simpleElement.getChildrenByTagName("Location");
        int n = simpleNodeList2.getLength();
        for (int i = 0; i < n; ++i) {
            object = (SimpleElement)simpleNodeList2.item(i);
            DTLocation dTLocation = DTLocation.fromXML((SimpleElement)object);
            string2 = object.getAttribute("Context");
            if ("docked".equalsIgnoreCase(string2)) {
                this.fLastDockedLocation = dTLocation;
                continue;
            }
            if ("undocked".equalsIgnoreCase(string2)) {
                this.fLastUndockedLocation = (DTFloatingLocation)dTLocation;
                continue;
            }
            if ("nested".equalsIgnoreCase(string2)) {
                this.fLastNestedLocation = (DTNestedLocation)dTLocation;
                continue;
            }
            if (!FLOATING_IN_VALUE.equalsIgnoreCase(string2)) continue;
            this.fLastFloatingInLocation = (DTFloatingLocation)dTLocation;
        }
        string2 = simpleElement.getAttribute("Dock");
        this.fLastLocation = "yes".equalsIgnoreCase(string2) ? this.fLastDockedLocation : this.fLastUndockedLocation;
        SimpleNodeList simpleNodeList3 = simpleElement.getChildrenByTagName(CLIENT_DATA_TAG);
        if (simpleNodeList3.getLength() > 0) {
            this.fInitialDataElement = (SimpleElement)simpleNodeList3.item(0);
        }
    }

    class ClientToggleAction
    extends DTOccupant.ToggleAction {
        public ClientToggleAction() {
            super(DTClient.this);
            this.updateEnabling();
        }

        @Override
        void updateName(String string) {
            this.setName(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (DTClient.this.fLocation == null) {
                DTFrame dTFrame = DTClient.this.fDesktop.getMainFrame();
                if (dTFrame != null) {
                    GlobalCursor.setWait((Window)((Object)dTFrame));
                }
                try {
                    DTClient.this.fDesktop.setClientShowing(DTClient.this, true, null, true);
                }
                finally {
                    if (dTFrame != null) {
                        GlobalCursor.clear((Window)((Object)dTFrame));
                    }
                }
            } else {
                DTClient.this.attemptClose();
                if (DTClient.this.isShowing()) {
                    this.setSelected(true);
                }
            }
        }

        @Override
        void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            if (DTProperty.PERMIT_USER_CLOSE.toString().equals(propertyChangeEvent.getPropertyName())) {
                this.updateEnabling();
            }
        }

        void updateEnabling() {
            this.setEnabled(DTClient.this.permitUserClose() && (!DTClient.this.fIsSingleton || DTClient.this.fGroup == null || DTClient.this.fGroup.getLocation() != null));
        }
    }

    class ClientSelectAction
    extends DTOccupant.SelectAction {
        int fIndex;

        public ClientSelectAction() {
            super(DTClient.this);
            this.fIndex = -1;
            if (DTClient.this.isSingleton()) {
                this.fIndex = DTClient.this.fDesktop.getSingletons().indexOf(DTClient.this);
            }
            this.setAccelerator();
            this.setTip(DTClient.this.getTitle());
            this.setSelected(DTClient.this.isSelected() || DTClient.this.isDockedAndMaximized());
        }

        @Override
        void updateName(String string) {
            this.setName(string);
        }

        public void setName(String string) {
            string = DTClient.this.isSingleton() ? this.createName(string, this.fIndex) : DTClient.this.getShortTitle();
            super.setName(string);
        }

        void setIcon(Icon icon) {
            this.putValue("SmallIcon", icon);
        }

        void setAccelerator() {
            KeyStroke keyStroke = null;
            if (this.fIndex != -1 && this.fIndex < 9) {
                keyStroke = KeyStroke.getKeyStroke(48 + this.fIndex, MENU_SHORTCUT_KEY_MASK);
            }
            this.setAccelerator(keyStroke);
        }

        void updateIndex(int n) {
            if (n != this.fIndex) {
                this.fIndex = n;
                this.setName(DTClient.this.getShortTitle());
                this.setAccelerator();
            }
        }

        String createName(String string, int n) {
            if (PlatformInfo.isMacintosh() || DTClient.this.fDesktop.useToolstrip()) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(string.length() + 3);
            char c = ' ';
            if (n < 9) {
                c = Character.forDigit(n, 10);
                stringBuffer.append('&');
            }
            stringBuffer.append(c);
            stringBuffer.append(' ');
            stringBuffer.append(string);
            return stringBuffer.toString();
        }

        @Override
        void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            if (DTProperty.TITLE.toString().equals(propertyChangeEvent.getPropertyName())) {
                this.setTip(DTClient.this.getTitle());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTClient.this.activate();
            if (DTClient.this.isSelected()) {
                this.setSelected(true);
            }
        }
    }

    class ClientMaximizeAction
    extends DTOccupant.MaximizeAction {
        ClientMaximizeAction() {
            super(DTClient.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DTClient.this.getLocation() == null) {
                return;
            }
            DTClient.this.fDesktop.setClientMaximized(DTClient.this, !DTClient.this.getLocation().isMaximized());
        }
    }

    class ClientMinimizeAction
    extends DTOccupant.MinimizeAction {
        ClientMinimizeAction() {
            super(DTClient.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DTClient.this.getLocation() == null) {
                return;
            }
            boolean bl = !DTClient.this.getLocation().isMinimized();
            DTClient.this.fDesktop.setClientMinimized(DTClient.this, bl, this.iEdge);
            if (!bl) {
                DTClient.this.fDesktop.setClientSelected(DTClient.this, true);
            }
        }
    }

    class ClientUndockAction
    extends DTOccupant.UndockAction {
        ClientUndockAction() {
            super(DTClient.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTClient.this.fDesktop.setClientDocked(DTClient.this, false);
        }
    }

    class ClientDockAction
    extends DTOccupant.DockAction {
        public ClientDockAction() {
            super(DTClient.this);
            this.setEnabled(DTClient.this.isDockable());
        }

        @Override
        void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            if (DTClientProperty.DOCKABLE.toString().equals(propertyChangeEvent.getPropertyName())) {
                this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DTClient.this.fDesktop.setClientDocked(DTClient.this, true);
        }
    }

    class ClientCloseAction
    extends DTOccupant.CloseAction {
        public ClientCloseAction() {
            super(DTClient.this);
            DTKeyBindings.getInstance().getManager().addKeyBindingAndActionInfo("MATLABDesktop", "close-item", (ExtendedAction)this);
            this.setComponentName("Close" + DTClient.this.getName());
            this.updateName(DTClient.this.getConstrainedTitle());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent == null) {
                return;
            }
            if (!DTClient.this.allowForcedClose() || (actionEvent.getModifiers() & 2) == 0 || !"Close".equals(actionEvent.getActionCommand())) {
                DTClient.this.attemptClose();
            } else {
                DTClient.this.fWasShowingWhenCloseInitiated = DTClient.this.isReallyShowing();
                DTClient.this.close();
            }
        }
    }

    class ClientOpenAction
    extends DTOccupant.OpenAction {
        ClientOpenAction() {
            super(DTClient.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (DTClient.this.isShowing()) {
                DTClient.this.activate();
            } else {
                DTFrame dTFrame = DTClient.this.fDesktop.getMainFrame();
                if (dTFrame != null) {
                    GlobalCursor.setWait((Window)((Object)dTFrame));
                }
                try {
                    DTClient.this.fDesktop.setClientShowing(DTClient.this, true, null, true);
                }
                finally {
                    if (dTFrame != null) {
                        GlobalCursor.clear((Window)((Object)dTFrame));
                    }
                }
            }
        }
    }

    private class SurrogateComponent
    extends JPanel {
        private SurrogateComponent() {
        }
    }

    private class DeferredFocusRequest
    extends DeferredRunnable {
        DeferredFocusRequest() {
        }

        DeferredFocusRequest(int n) {
            super(n);
        }

        @Override
        protected void doTask() {
            boolean bl;
            boolean bl2 = bl = !DTClient.this.hasBeenFlushed() && DTClient.this.isSelected();
            if (!bl && DTClient.this.fInternalFrame != null) {
                Window window = SwingUtilities.windowForComponent((Component)((Object)DTClient.this.fInternalFrame));
                boolean bl3 = bl = window != null && !window.isActive();
            }
            if (bl) {
                DTClient.this.requestFocus();
            }
        }
    }

    private class DeferredPropertyChange
    implements Runnable {
        PropertyChangeEvent fEvent;

        DeferredPropertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.fEvent = propertyChangeEvent;
        }

        @Override
        public void run() {
            DTClient.this.doPropertyChange(this.fEvent);
        }
    }

    private class LocationListener
    implements DTLocation.Listener {
        private LocationListener() {
        }

        @Override
        public void locationChanged(DTLocation dTLocation, DTLocation.ChangeType changeType) {
            if (DTClient.this.fComponent != null && !(DTClient.this.fComponent instanceof SurrogateComponent) && !DTClient.this.isClosing()) {
                DTClientEvent dTClientEvent = null;
                if (changeType == DTLocation.ChangeType.MOVE) {
                    dTClientEvent = new DTClientEvent(DTClient.this.fComponent, 8);
                } else if (changeType == DTLocation.ChangeType.RESIZE) {
                    dTClientEvent = new DTClientEvent(DTClient.this.fComponent, 9);
                }
                if (dTClientEvent != null) {
                    dTClientEvent.setData(dTLocation);
                }
                DTClient.this.fireClientEvent(dTClientEvent);
            }
        }
    }

    private class ConstructorErrorLabel
    extends MJLabel {
        ConstructorErrorLabel(String string) {
            super(string, 0);
        }
    }
}

