/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.common.icons.IconContainer;
import com.mathworks.common.icons.IconEnumerationUtils;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.util.PlatformInfo;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public enum ComponentIcon implements IconContainer
{
    CHECK_BOX{

        @Override
        public JComponent createComponent() {
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setSelected(true);
            jCheckBox.setOpaque(false);
            return jCheckBox;
        }
    }
    ,
    COMBO_BOX(PlatformInfo.isMacintosh() ? "maccombobox" : null){

        @Override
        public JComponent createComponent() {
            JComboBox jComboBox = new JComboBox();
            Dimension dimension = jComboBox.getPreferredSize();
            if (dimension.height > 20) {
                dimension.height = 20;
            }
            dimension.width = 40;
            jComboBox.setPreferredSize(dimension);
            return jComboBox;
        }
    }
    ,
    EDITABLE_COMBO_BOX(PlatformInfo.isMacintosh() ? "maceditcombobox" : null){

        @Override
        public JComponent createComponent() {
            JComboBox jComboBox = new JComboBox();
            jComboBox.setEditable(true);
            Dimension dimension = jComboBox.getPreferredSize();
            if (dimension.height > 20) {
                dimension.height = 20;
            }
            dimension.width = 40;
            jComboBox.setPreferredSize(dimension);
            return jComboBox;
        }
    }
    ,
    RADIO_BUTTON{

        @Override
        public JComponent createComponent() {
            JRadioButton jRadioButton = new JRadioButton();
            jRadioButton.setSelected(true);
            jRadioButton.setOpaque(false);
            return jRadioButton;
        }
    }
    ,
    SLIDER{

        @Override
        public JComponent createComponent() {
            JSlider jSlider = new JSlider();
            Dimension dimension = jSlider.getPreferredSize();
            if (dimension.width > 40) {
                dimension.width = 40;
            }
            jSlider.setPreferredSize(dimension);
            jSlider.setOpaque(false);
            return jSlider;
        }
    }
    ,
    SEPARATOR{

        @Override
        public JComponent createComponent() {
            Dimension dimension = new Dimension(12, 16);
            MJToolBar.VisibleSeparator visibleSeparator = new MJToolBar.VisibleSeparator(0, dimension);
            visibleSeparator.setPreferredSize(dimension);
            return visibleSeparator;
        }
    }
    ,
    SPINNER(PlatformInfo.isMacintosh() ? "macspinner" : null){

        @Override
        public JComponent createComponent() {
            JSpinner jSpinner = new JSpinner();
            Dimension dimension = jSpinner.getPreferredSize();
            dimension.width = 40;
            jSpinner.setPreferredSize(dimension);
            return jSpinner;
        }
    }
    ,
    EDITABLE_SPINNER(PlatformInfo.isMacintosh() ? "maceditspinner" : null){

        @Override
        public JComponent createComponent() {
            JSpinner jSpinner = new JSpinner();
            jSpinner.setEditor(new JTextField(1));
            Dimension dimension = jSpinner.getPreferredSize();
            dimension.width = 40;
            jSpinner.setPreferredSize(dimension);
            return jSpinner;
        }
    }
    ,
    TEXT_FIELD{

        @Override
        public JComponent createComponent() {
            JTextField jTextField = new JTextField(2);
            Dimension dimension = jTextField.getPreferredSize();
            if (dimension.height > 20) {
                dimension.height = 20;
                jTextField.setPreferredSize(dimension);
            }
            return jTextField;
        }
    };

    private static final int WIDTH_LIMIT = 40;
    private static final int HEIGHT_LIMIT = 20;
    private ImageIcon fIcon;
    private String fName;

    private ComponentIcon() {
    }

    private ComponentIcon(String string2) {
        this.fName = string2;
    }

    public ImageIcon getIcon() {
        if (this.fName != null) {
            return IconEnumerationUtils.getIcon((String)"/com/mathworks/widgets/desk/resources/", (String)this.fName);
        }
        if (this.fIcon == null) {
            this.fIcon = ComponentIcon.createIcon(this.createComponent());
        }
        return this.fIcon;
    }

    public ImageIcon getIcon(int n) {
        JComponent jComponent = this.createComponent();
        return ComponentIcon.createIcon(this.createComponent(), new Dimension(jComponent.getPreferredSize().width, n));
    }

    abstract JComponent createComponent();

    public static ImageIcon createIcon(JComponent jComponent) {
        Dimension dimension = jComponent.getPreferredSize();
        return ComponentIcon.createIcon(jComponent, dimension);
    }

    private static ImageIcon createIcon(JComponent jComponent, Dimension dimension) {
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(jComponent.getForeground());
        graphics2D.setFont(jComponent.getFont());
        jComponent.setSize(dimension);
        jComponent.validate();
        jComponent.doLayout();
        jComponent.paint(graphics2D);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }
}

