/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.Prefs;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class WindowPositionUtils {
    private static final String WINDOW_PREFIX = "window.";

    private WindowPositionUtils() {
    }

    public static void positionWindow(Window window, String string) {
        WindowPositionUtils.positionWindow(window, string, null, null);
    }

    public static void positionWindow(Window window, String string, Rectangle rectangle) {
        WindowPositionUtils.positionWindow(window, string, null, rectangle);
    }

    public static void positionWindow(Window window, String string, Component component) {
        WindowPositionUtils.positionWindow(window, string, component, null);
    }

    public static void positionWindow(Window window, String string, Component component, Rectangle rectangle) {
        if (string == null) {
            throw new IllegalArgumentException("Window preference key must not be null");
        }
        String string2 = WINDOW_PREFIX + string;
        Rectangle rectangle2 = Prefs.getRectanglePref((String)string2, (Rectangle)rectangle);
        if (rectangle2 != null) {
            window.setSize(rectangle2.getSize());
            window.setLocation(rectangle2.getLocation());
            WindowUtils.ensureTitleOnScreen((Window)window);
        } else {
            if (rectangle == null || rectangle.getHeight() <= 0.0 || rectangle.getWidth() <= 0.0) {
                window.pack();
            }
            window.setLocationRelativeTo(component);
        }
        WindowPositionUtils.attachWindowPositionListener(window, string2);
    }

    private static void attachWindowPositionListener(final Window window, final String string) {
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                WindowPositionUtils.saveWindowPosition(window, string);
                window.removeWindowListener(this);
            }
        });
    }

    private static void saveWindowPosition(Window window, String string) {
        if (window.getWidth() > 0 && window.getHeight() > 0) {
            Rectangle rectangle = new Rectangle(window.getX(), window.getY(), window.getWidth(), window.getHeight());
            Prefs.setRectanglePref((String)string, (Rectangle)rectangle);
        }
    }
}

