/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.widgets.ClosablePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ClosablePanelContainer
extends MJPanel {
    private final Vector fClosablePanels = new Vector();
    private final MJPanel fInnerPanel = new MJPanel();
    private final MJScrollPane fSp;

    public ClosablePanelContainer() {
        this.fInnerPanel.setLayout((LayoutManager)new BoxLayout((Container)this.fInnerPanel, 1));
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add((Component)this.fInnerPanel, (Object)"North");
        Color color = UIManager.getColor("List.background");
        mJPanel.setBackground(color);
        this.fSp = new MJScrollPane((Component)mJPanel);
        this.fSp.setHorizontalScrollBarPolicy(31);
        this.fSp.getVerticalScrollBar().setUnitIncrement(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.fSp, "Center");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void addPanel(String string, String string2, JComponent jComponent) {
        this.checkArguments(string, string2, jComponent);
        ClosablePanel closablePanel = new ClosablePanel(string, string2, jComponent);
        closablePanel.setEnabled(this.isEnabled());
        this.fClosablePanels.add(closablePanel);
        this.fInnerPanel.add((Component)((Object)closablePanel));
    }

    public void insertPanel(String string, String string2, JComponent jComponent, int n) {
        this.checkArguments(string, string2, jComponent);
        ClosablePanel closablePanel = new ClosablePanel(string, string2, jComponent);
        closablePanel.setEnabled(this.isEnabled());
        this.fClosablePanels.insertElementAt(closablePanel, n);
        if (SwingUtilities.isEventDispatchThread()) {
            this.rebuildLayout();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClosablePanelContainer.this.rebuildLayout();
                }
            });
        }
    }

    public void removePanel(String string) {
        ClosablePanel closablePanel = this.findPanelNamed(string);
        if (closablePanel == null) {
            return;
        }
        this.fClosablePanels.remove((Object)closablePanel);
        if (SwingUtilities.isEventDispatchThread()) {
            this.rebuildLayout();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClosablePanelContainer.this.rebuildLayout();
                }
            });
        }
    }

    public boolean isPanelOpen(String string) {
        ClosablePanel closablePanel = this.findPanelNamed(string);
        if (closablePanel == null) {
            throw new NoSuchElementException();
        }
        return closablePanel.isOpen();
    }

    public void setPanelOpen(String string, final boolean bl) {
        final ClosablePanel closablePanel = this.findPanelNamed(string);
        if (closablePanel == null) {
            throw new NoSuchElementException();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            closablePanel.setOpen(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    closablePanel.setOpen(bl);
                }
            });
        }
    }

    public boolean isPanelVisible(String string) {
        ClosablePanel closablePanel = this.findPanelNamed(string);
        if (closablePanel == null) {
            throw new NoSuchElementException();
        }
        return closablePanel.isVisible();
    }

    public void setPanelVisible(String string, final boolean bl) {
        final ClosablePanel closablePanel = this.findPanelNamed(string);
        if (closablePanel == null) {
            throw new NoSuchElementException();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            closablePanel.setVisible(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    closablePanel.setVisible(bl);
                }
            });
        }
    }

    public int getPanelCount() {
        return this.fClosablePanels.size();
    }

    public void setEnabled(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            super.setEnabled(bl);
            Iterator iterator = this.getPanelIterator();
            while (iterator.hasNext()) {
                ClosablePanel closablePanel = (ClosablePanel)((Object)iterator.next());
                closablePanel.setEnabled(bl);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClosablePanelContainer.super.setEnabled(bl);
                    Iterator iterator = ClosablePanelContainer.this.getPanelIterator();
                    while (iterator.hasNext()) {
                        ClosablePanel closablePanel = (ClosablePanel)((Object)iterator.next());
                        closablePanel.setEnabled(bl);
                    }
                }
            });
        }
    }

    protected void rebuildLayout() {
        this.fInnerPanel.removeAll();
        Iterator iterator = this.getPanelIterator();
        while (iterator.hasNext()) {
            ClosablePanel closablePanel = (ClosablePanel)((Object)iterator.next());
            this.fInnerPanel.add((Component)((Object)closablePanel));
        }
    }

    private Iterator getPanelIterator() {
        return this.fClosablePanels.iterator();
    }

    private ClosablePanel findPanelNamed(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.getPanelIterator();
        while (iterator.hasNext()) {
            ClosablePanel closablePanel = (ClosablePanel)((Object)iterator.next());
            if (!closablePanel.getName().equals(string)) continue;
            return closablePanel;
        }
        return null;
    }

    private void checkArguments(String string, String string2, JComponent jComponent) {
        if (string == null || string2 == null || jComponent == null) {
            throw new IllegalArgumentException("Null arguments not allowed.");
        }
        Iterator iterator = this.getPanelIterator();
        while (iterator.hasNext()) {
            ClosablePanel closablePanel = (ClosablePanel)((Object)iterator.next());
            if (closablePanel.getName().equals(string)) {
                throw new IllegalArgumentException("A panel with the same name already exists.");
            }
            if (!closablePanel.getComponent().equals(jComponent)) continue;
            throw new IllegalArgumentException("A panel with the same JComponent already exists.");
        }
    }
}

