/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.propertyeditors;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Callback;
import com.mathworks.toolbox.shared.controllib.propertyeditors.LineEditorPanel;
import com.mathworks.util.Log;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.SwingUtilities;

public class LineEditorPanelPeer {
    private Callback fLineColorCallback = new Callback();
    private Callback fLineStyleCallback = new Callback();
    private Callback fLineWidthCallback = new Callback();
    private Callback fMarkerStyleCallback = new Callback();
    private LineEditorPanel fPanel = null;

    public LineEditorPanel createPanel() {
        AWTUtilities.InvocationRunnable invocationRunnable = new AWTUtilities.InvocationRunnable(){

            public Object runWithOutput() {
                LineEditorPanel lineEditorPanel = new LineEditorPanel();
                lineEditorPanel.createLineColorListener(LineEditorPanelPeer.this.fLineColorCallback);
                lineEditorPanel.createLineStyleListener(LineEditorPanelPeer.this.fLineStyleCallback);
                lineEditorPanel.createLineWidthListener(LineEditorPanelPeer.this.fLineWidthCallback);
                lineEditorPanel.createMarkerStyleListener(LineEditorPanelPeer.this.fMarkerStyleCallback);
                return lineEditorPanel;
            }
        };
        try {
            this.fPanel = (LineEditorPanel)((Object)AWTUtilities.invokeAndWait((AWTUtilities.InvocationRunnable)invocationRunnable));
        }
        catch (Throwable throwable) {
            Log.logThrowable((Throwable)throwable);
        }
        return this.fPanel;
    }

    public LineEditorPanel getPanel() {
        return this.fPanel;
    }

    public Callback getLineColorCallback() {
        return this.fLineColorCallback;
    }

    public Callback getLineStyleCallback() {
        return this.fLineStyleCallback;
    }

    public Callback getLineWidthCallback() {
        return this.fLineWidthCallback;
    }

    public Callback getMarkerStyleCallback() {
        return this.fMarkerStyleCallback;
    }

    public String getLineStyleData() {
        return this.fPanel.getLineStyleData();
    }

    public String getLineWidthData() {
        return this.fPanel.getLineWidthData();
    }

    public String getMarkerStyleData() {
        return this.fPanel.getMarkerStyleData();
    }

    public Color getLineColorData() {
        return this.fPanel.getLineColorData();
    }

    public Color getBackground() {
        return this.fPanel.getBackground();
    }

    public Color getPopupColor() {
        return this.fPanel.getPopupColor();
    }

    public String getName() {
        return this.fPanel.getName();
    }

    public Boolean getEnable() {
        return this.fPanel.isEnabled();
    }

    public Dimension getPreferredSize() {
        return this.fPanel.getPreferredSize();
    }

    public void setLineColorData(final Color color) {
        this.fPanel.disableLineColorListener();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LineEditorPanelPeer.this.fPanel.setLineColorData(color);
                LineEditorPanelPeer.this.fPanel.restoreLineColorListener();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setLineColorDataEmpty() {
        this.fPanel.disableLineColorListener();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LineEditorPanelPeer.this.fPanel.setLineColorData(null);
                LineEditorPanelPeer.this.fPanel.restoreLineColorListener();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setLineStyleData(final String string) {
        this.fPanel.disableLineStyleListener();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LineEditorPanelPeer.this.fPanel.setLineStyleData(string);
                LineEditorPanelPeer.this.fPanel.restoreLineStyleListener();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setLineWidthData(final String string) {
        this.fPanel.disableLineWidthListener();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LineEditorPanelPeer.this.fPanel.setLineWidthData(string);
                LineEditorPanelPeer.this.fPanel.restoreLineWidthListener();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setMarkerStyleData(final String string) {
        this.fPanel.disableMarkerStyleListener();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LineEditorPanelPeer.this.fPanel.setMarkerStyleData(string);
                LineEditorPanelPeer.this.fPanel.restoreMarkerStyleListener();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setBackground(final Color color) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LineEditorPanelPeer.this.fPanel.setBackgroundColor(color);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setPopupColor(final Color color) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LineEditorPanelPeer.this.fPanel.setPopupColor(color);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setToolTips(final String string, final String string2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LineEditorPanelPeer.this.fPanel.setToolTips(string, string2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setBorder(final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LineEditorPanelPeer.this.fPanel.setBorder(bl);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setNames(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LineEditorPanelPeer.this.fPanel.setNames(string);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void enableWidgets(final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LineEditorPanelPeer.this.fPanel.enableWidgets(bl);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }
}

