/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.SearchField;
import com.mathworks.search.lucene.IndexLocation;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.store.Directory;

public class LuceneIndexUtils {
    private LuceneIndexUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends SearchField> Map<T, Boolean> validateSearchFields(IndexLocation location, Collection<T> fieldsToCheck) throws IOException {
        LinkedHashMap<SearchField, Boolean> results = new LinkedHashMap<SearchField, Boolean>();
        IndexReader reader = IndexReader.open((Directory)location.getSearchDirectory());
        try {
            for (SearchField field : fieldsToCheck) {
                results.put(field, LuceneIndexUtils.checkField(reader, field));
            }
            LinkedHashMap<SearchField, Boolean> linkedHashMap = results;
            return linkedHashMap;
        }
        finally {
            reader.close();
        }
    }

    private static boolean checkField(IndexReader reader, SearchField field) {
        Collection all = reader.getFieldNames(IndexReader.FieldOption.ALL);
        if (!all.contains(field.getFieldName())) {
            return false;
        }
        IndexReader.FieldOption fieldOption = field.isIndexed() ? IndexReader.FieldOption.INDEXED : IndexReader.FieldOption.UNINDEXED;
        Collection byStatus = reader.getFieldNames(fieldOption);
        return byStatus.contains(field.getFieldName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> getSearchFieldStatistics(IndexLocation location, SearchField field) throws IOException {
        IndexReader reader = IndexReader.open((Directory)location.getSearchDirectory());
        try {
            Map<String, Integer> map = LuceneIndexUtils.getSearchFieldStatistics(reader, field);
            return map;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Integer> getSearchFieldStatistics(IndexReader reader, SearchField field) throws IOException {
        LinkedHashMap<String, Integer> stats = new LinkedHashMap<String, Integer>();
        String fieldName = field.getFieldName();
        TermEnum terms = reader.terms(new Term(fieldName, ""));
        try {
            while (fieldName.equals(terms.term().field())) {
                Term t = terms.term();
                String value = t.text();
                int numDocs = reader.docFreq(t);
                stats.put(value, numDocs);
                if (terms.next()) continue;
                break;
            }
            LinkedHashMap<String, Integer> linkedHashMap = stats;
            return linkedHashMap;
        }
        finally {
            terms.close();
        }
    }
}

