/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.border.Border;

class FormInputButton
extends JButton
implements ObjectPainter,
Movable {
    private DocView I;
    private Border OEAB = this.getBorder();
    private DInputElement black;
    private ObjectBox checkAwtTree;

    FormInputButton(DocView docView, DElement dElement, String string) {
        super(string);
        this.I = docView;
        this.black = (DInputElement)dElement;
        String string2 = this.black.getValue();
        if (string2 != null) {
            this.setText(string2);
        } else {
            this.setText(string);
            this.black.setValue(string);
        }
        this.I();
        this.validateTree();
    }

    public void paintComponent(Graphics graphics) {
        if (this.isShowing()) {
            super.paintComponent(graphics);
        } else {
            String string = this.black.getValue();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            fontMetrics = ((Component)this).getFontMetrics(this.getFont());
            int n = fontMetrics.getDescent();
            int n2 = fontMetrics.stringWidth(string);
            graphics.setColor(Color.lightGray);
            graphics.fill3DRect(0, 0, this.getBounds().width, this.getBounds().height, true);
            if (!this.black.getDisabled()) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(Color.gray);
            }
            graphics.drawString(string, (this.getBounds().width - n2) / 2, this.getBounds().height / 2 + n);
        }
    }

    private void I() {
        this.setEnabled(!this.black.getDisabled());
    }

    public void onElementAttrChange(DElement dElement, DAttr dAttr) {
        String string = this.black.getValue();
        if (string != null && !string.equals(this.getText())) {
            this.OEAB();
            this.setText(string);
            this.checkAwtTree.invalidate();
            this.checkAwtTree.reqReflow();
        } else {
            this.I();
        }
    }

    private void OEAB() {
        if (this.checkAwtTree != null) {
            String string = this.getText();
            CSSAttribs cSSAttribs = this.checkAwtTree.getCSSAttribs();
            Font font = cSSAttribs.getTestedFont(string);
            if (!font.equals(this.getFont())) {
                this.setFont(font);
            }
        }
    }

    public void dispose() {
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setBox(ObjectBox objectBox) {
        this.checkAwtTree = objectBox;
        this.I.checkAwtTree(objectBox, this);
    }

    public ObjectBox getBox() {
        return this.checkAwtTree;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int n, int n2) {
        this.setSize(n, n2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics graphics) {
    }

    public void syncDom(int n, int n2, boolean bl) {
        this.setLocation(n, n2);
        this.setVisible(bl);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.I.onComponentEvent(this, aWTEvent)) {
            super.processEvent(aWTEvent);
        }
    }

    public void setBorderVisible(boolean bl) {
        if (!bl) {
            this.setBorder(null);
        } else {
            this.setBorder(this.OEAB);
        }
    }

    public void setFontHints(CSSAttribs cSSAttribs) {
        this.OEAB();
    }
}

