/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.workers;

import foxtrot.Task;
import foxtrot.workers.SingleWorkerThread;
import java.util.LinkedList;
import java.util.List;

public class MultiWorkerThread
extends SingleWorkerThread {
    private final List threads = new LinkedList();

    protected String getThreadName() {
        return "Foxtrot Multi Worker Thread Runner #" + MultiWorkerThread.nextSequence();
    }

    protected void run(final Task task) {
        Thread thread = new Thread(Thread.currentThread().getThreadGroup(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                MultiWorkerThread multiWorkerThread;
                try {
                    multiWorkerThread = MultiWorkerThread.this;
                    synchronized (multiWorkerThread) {
                        MultiWorkerThread.this.threads.add(Thread.currentThread());
                    }
                    MultiWorkerThread.this.runTask(task);
                }
                finally {
                    multiWorkerThread = MultiWorkerThread.this;
                    synchronized (multiWorkerThread) {
                        MultiWorkerThread.this.threads.remove(Thread.currentThread());
                    }
                }
            }
        }, this.getThreadName());
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWorkerThread() {
        MultiWorkerThread multiWorkerThread = this;
        synchronized (multiWorkerThread) {
            return this.threads.contains(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasPendingTasks() {
        MultiWorkerThread multiWorkerThread = this;
        synchronized (multiWorkerThread) {
            return super.hasPendingTasks() || this.threads.size() > 0;
        }
    }
}

