/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.FileUtils;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;

public final class MRUList<T>
implements Iterable<T> {
    private final LinkedHashSet<T> fQueue;
    private final Comparator<T> fComparator;
    private final int fLimit;

    public static Comparator<File> getCanonicalFileComparator() {
        return new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return FileUtils.compareCanonicalPaths(file, file2);
            }
        };
    }

    public MRUList(int n) {
        this(n, null, null);
    }

    public MRUList(int n, Comparator<T> comparator) {
        this(n, comparator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MRUList(int n, Comparator<T> comparator, T[] TArray) {
        this.fLimit = n;
        this.fQueue = new LinkedHashSet();
        this.fComparator = comparator;
        if (TArray != null) {
            LinkedHashSet<T> linkedHashSet = this.fQueue;
            synchronized (linkedHashSet) {
                for (int i = TArray.length - 1; i >= 0; --i) {
                    this.add(TArray[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T t) {
        LinkedHashSet<T> linkedHashSet = this.fQueue;
        synchronized (linkedHashSet) {
            Iterator iterator;
            if (this.fComparator != null) {
                iterator = this.fQueue.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (this.fComparator.compare(e, t) != 0) continue;
                    iterator.remove();
                }
            } else {
                this.fQueue.remove(t);
            }
            if (this.fLimit > 0 && this.fQueue.size() == this.fLimit) {
                iterator = this.fQueue.iterator();
                iterator.next();
                iterator.remove();
            }
            this.fQueue.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedHashSet<T> linkedHashSet = this.fQueue;
        synchronized (linkedHashSet) {
            this.fQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getLeastRecentlyUsed() {
        LinkedHashSet<T> linkedHashSet = this.fQueue;
        synchronized (linkedHashSet) {
            return this.fQueue.size() == 0 ? null : (T)this.fQueue.iterator().next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(T t) {
        LinkedHashSet<T> linkedHashSet = this.fQueue;
        synchronized (linkedHashSet) {
            this.fQueue.remove(t);
        }
    }

    public int size() {
        return this.fQueue.size();
    }

    public int getLimit() {
        return this.fLimit;
    }

    public boolean contains(T t) {
        return this.fQueue.contains(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        LinkedHashSet<T> linkedHashSet = this.fQueue;
        synchronized (linkedHashSet) {
            Vector<T> vector = new Vector<T>(this.fQueue);
            Collections.reverse(vector);
            return vector.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] toArray(T[] TArray) {
        LinkedHashSet<T> linkedHashSet = this.fQueue;
        synchronized (linkedHashSet) {
            Vector<T> vector = new Vector<T>(this.fQueue);
            Collections.reverse(vector);
            return vector.toArray(TArray);
        }
    }
}

