/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import java.io.PrintWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;

public final class DebugUtils {
    private static volatile int DEFAULT_STACK_TRACE_DEPTH = 1;
    private static final PrintWriter out = new PrintWriter(System.out, true);
    private static final PrintWriter err = new PrintWriter(System.err, true);
    private static final boolean areAssertionsEnabled;

    private DebugUtils() {
    }

    public static void setDefaultStackTraceDepth(int n) {
        DEFAULT_STACK_TRACE_DEPTH = n;
    }

    public static boolean areAssertionsEnabled() {
        return areAssertionsEnabled;
    }

    public static boolean warning(String string) {
        if (string == null) {
            return true;
        }
        DebugUtils.outputStackTrace(2, string, "Warning", DEFAULT_STACK_TRACE_DEPTH, err);
        return true;
    }

    public static boolean warning(String string, int n) {
        if (string == null) {
            return true;
        }
        DebugUtils.outputStackTrace(2, string, "Warning", n, err);
        return true;
    }

    public static boolean trace(Object ... objectArray) {
        if (objectArray == null) {
            DebugUtils.outputStackTrace(2, "null", "Trace", DEFAULT_STACK_TRACE_DEPTH, out);
            return true;
        }
        if (objectArray.length == 0) {
            DebugUtils.outputStackTrace(2, "", "Trace", DEFAULT_STACK_TRACE_DEPTH, out);
            return true;
        }
        StrBuilder strBuilder = new StrBuilder();
        strBuilder.setNullText("null");
        for (int i = 0; i < objectArray.length; ++i) {
            strBuilder.append(objectArray[i]);
            if (i == objectArray.length - 1) continue;
            strBuilder.append(",").appendNewLine();
        }
        DebugUtils.outputStackTrace(2, strBuilder.toString(), "Trace", DEFAULT_STACK_TRACE_DEPTH, out);
        return true;
    }

    public static String argStr(Object ... objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StrBuilder strBuilder = new StrBuilder();
        strBuilder.setNullText("null");
        for (int i = 0; i < objectArray.length; ++i) {
            strBuilder.append(objectArray[i]);
            if (i == objectArray.length - 1) continue;
            strBuilder.append(",");
        }
        return strBuilder.toString();
    }

    public static boolean outputException(Throwable throwable) {
        if (throwable == null) {
            return true;
        }
        DebugUtils.outputStackTrace(2, "", "Handled exception", 1, err);
        throwable.printStackTrace(err);
        return true;
    }

    public static boolean dumpStack() {
        DebugUtils.outputStackTrace(2, "", "Stack dump", Integer.MAX_VALUE, out);
        return true;
    }

    public static boolean dumpStack(int n) {
        DebugUtils.outputStackTrace(2, "", "Stack dump", n, out);
        return true;
    }

    private static void outputStackTrace(int n, String string, String string2, int n2, PrintWriter printWriter) {
        assert (printWriter != null);
        assert (n >= 0);
        Throwable throwable = new Throwable();
        throwable.fillInStackTrace();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        StrBuilder strBuilder = new StrBuilder();
        strBuilder.append(string2).append(StringUtils.isNotBlank((String)string) ? ": " + string + " " : " ");
        if (n2 <= 0) {
            printWriter.println(strBuilder.toString());
            return;
        }
        int n3 = 0;
        n3 = n2 == Integer.MAX_VALUE ? stackTraceElementArray.length : Math.min(n2 + n, stackTraceElementArray.length);
        if (n3 - n > 0) {
            strBuilder.appendNewLine();
        }
        for (int i = n; i < n3; ++i) {
            strBuilder.append("\tat ").append(stackTraceElementArray[i].toString());
            if (i == n3 - 1) continue;
            strBuilder.appendNewLine();
        }
        printWriter.println(strBuilder.toString());
    }

    public static void main(String[] stringArray) {
        assert (DebugUtils.warning("some message"));
        int n = 1;
        String string = "string";
        Object object = new Object();
        assert (DebugUtils.trace(n, string, object, null));
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("test exception");
        assert (DebugUtils.outputException(illegalArgumentException));
        assert (DebugUtils.dumpStack());
    }

    static {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        areAssertionsEnabled = bl;
    }
}

