/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.transaction.server;

import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;

public class ServerTransaction
implements Transaction,
Serializable {
    static final long serialVersionUID = 4552277137549765374L;
    public final TransactionManager mgr;
    public final long id;

    public ServerTransaction(TransactionManager transactionManager, long l) {
        this.mgr = transactionManager;
        this.id = l;
    }

    public int hashCode() {
        return (int)this.id ^ this.mgr.hashCode();
    }

    public boolean equals(Object object) {
        try {
            ServerTransaction serverTransaction = (ServerTransaction)object;
            return this.id == serverTransaction.id && this.mgr.equals(serverTransaction.mgr);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public void commit() throws UnknownTransactionException, CannotCommitException, RemoteException {
        this.mgr.commit(this.id);
    }

    public void commit(long l) throws UnknownTransactionException, CannotCommitException, TimeoutExpiredException, RemoteException {
        this.mgr.commit(this.id, l);
    }

    public void abort() throws UnknownTransactionException, CannotAbortException, RemoteException {
        this.mgr.abort(this.id);
    }

    public void abort(long l) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException, RemoteException {
        this.mgr.abort(this.id, l);
    }

    public void join(TransactionParticipant transactionParticipant, long l) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.mgr.join(this.id, transactionParticipant, l);
    }

    public int getState() throws UnknownTransactionException, RemoteException {
        return this.mgr.getState(this.id);
    }

    public boolean isNested() {
        return false;
    }

    public String toString() {
        return new String(this.getClass().getName() + " [manager=" + this.mgr + ", id=" + this.id + "]");
    }
}

