/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.EmulatorLocalDevice;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.SearchServicesRunnable;
import com.intel.bluetooth.SearchServicesThread;
import com.intel.bluetooth.ServiceRecordImpl;
import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

class EmulatorSearchServices
implements SearchServicesRunnable {
    private EmulatorLocalDevice localDevice;
    private BluetoothStack bluetoothStack;

    EmulatorSearchServices(EmulatorLocalDevice localDevice, BluetoothStack bluetoothStack) {
        this.localDevice = localDevice;
        this.bluetoothStack = bluetoothStack;
    }

    public int runSearchServices(SearchServicesThread sst, int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        String[] uuidSetStrings = new String[uuidSet.length];
        for (int i = 0; i < uuidSet.length; ++i) {
            uuidSetStrings[i] = uuidSet[i].toString();
        }
        sst.searchServicesStartedCallback();
        try {
            long remoteDeviceAddress = RemoteDeviceHelper.getAddress((RemoteDevice)device);
            long[] handles = this.localDevice.getDeviceManagerService().searchServices(remoteDeviceAddress, uuidSetStrings);
            if (sst.isTerminated()) {
                return 2;
            }
            if (handles == null) {
                return 6;
            }
            if (handles.length != 0) {
                ServiceRecordImpl[] records = new ServiceRecordImpl[handles.length];
                int[] attrIDs = sst.getAttrSet();
                for (int i = 0; i < handles.length; ++i) {
                    records[i] = new ServiceRecordImpl(this.bluetoothStack, sst.getDevice(), handles[i]);
                    EmulatorSearchServices.populateServicesRecordAttributeValues(this.localDevice, records[i], attrIDs, remoteDeviceAddress, handles[i]);
                }
                DebugLog.debug((String)"SearchServices finished", (long)sst.getTransID());
                listener.servicesDiscovered(sst.getTransID(), (ServiceRecord[])records);
            }
            if (sst.isTerminated()) {
                return 2;
            }
            if (handles.length != 0) {
                return 1;
            }
            return 4;
        }
        catch (Throwable e) {
            DebugLog.debug((String)("SearchServices " + sst.getTransID()), (Throwable)e);
            return 3;
        }
    }

    static boolean populateServicesRecordAttributeValues(EmulatorLocalDevice localDevice, ServiceRecordImpl serviceRecord, int[] attrIDs, long remoteDeviceAddress, long handle) throws IOException {
        byte[] blob = localDevice.getDeviceManagerService().getServicesRecordBinary(remoteDeviceAddress, handle);
        ServiceRecordImpl temp = new ServiceRecordImpl(null, null, handle);
        temp.loadByteArray(blob);
        boolean anyRetrived = false;
        for (int i = 0; i < attrIDs.length; ++i) {
            int id = attrIDs[i];
            DataElement element = temp.getAttributeValue(id);
            serviceRecord.populateAttributeValue(id, element);
            if (element == null) continue;
            anyRetrived = true;
        }
        return anyRetrived;
    }
}

