/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.webbrowser;

import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlComponentClient;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.HtmlUtils;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.PopupWindowListener;
import com.mathworks.html.StatusTextChangedEvent;
import com.mathworks.html.StatusTextListener;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.webbrowser.WebBrowserGroup;
import com.mathworks.mde.webbrowser.WebBrowserUtils;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.html.HTMLBrowserPanel;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.HtmlActionsToolBar;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.HtmlConversionUtils;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import com.mathworks.mlwidgets.html.MJHtmlPanelPopupListener;
import com.mathworks.mlwidgets.html.MatlabHtmlActions;
import com.mathworks.mlwidgets.html.StatusChangedListener;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.util.PostVMInit;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class WebBrowser
extends DTClientBase
implements HtmlComponentClient {
    private static List<WebBrowser> sBrowsers = new Vector<WebBrowser>();
    private static WebBrowser sActiveBrowser;
    private HTMLBrowserPanel fBrowser;
    private MJStatusBar fStatusBar;
    private Vector<BrowserAction> fQueue = new Vector();

    private WebBrowser(boolean bl, boolean bl2) {
        this(null, bl, bl2);
    }

    private WebBrowser(HtmlComponent<MatlabHtmlActions> htmlComponent, boolean bl, boolean bl2) {
        this.setLayout(new BorderLayout());
        this.setName("Web Browser");
        this.setClientName(this.getName());
        this.fStatusBar = new MJStatusBar();
        this.fStatusBar.setName("HTML Status Bar");
        this.setStatusBar(this.fStatusBar);
        sActiveBrowser = this;
        sBrowsers.add(this);
        this.setGroup((DTGroupPropertyProvider)WebBrowserGroup.getInstance());
        this.setBounds(10, 10, 600, 600);
        this.setMultipleInstances(true);
        this.setDontMergeMenu(true);
        this.setPermitUserUndock(false);
        this.setDontReopen(true);
        this.setIcon(WebBrowserUtils.getIcon());
        this.setSmallIcon(WebBrowserUtils.getSmallIcon());
        this.finishBuilding(htmlComponent, bl, bl2);
    }

    private void finishBuilding(final HtmlComponent<MatlabHtmlActions> htmlComponent, final boolean bl, final boolean bl2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WebBrowser.this.finishBuildingEdt((HtmlComponent<MatlabHtmlActions>)htmlComponent, bl, bl2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void finishBuildingEdt(HtmlComponent<MatlabHtmlActions> htmlComponent, boolean bl, boolean bl2) {
        MLDesktop.getInstance().addClient((Component)((Object)this), WebBrowserUtils.getWebGroupName(), true, null, true, (DTClientListener)new DTCL());
        if (htmlComponent == null) {
            htmlComponent = WebBrowser.buildHtmlComponent();
        }
        WebBrowser.addNewWindowListener(htmlComponent);
        this.fBrowser = new HTMLBrowserPanel(htmlComponent, null);
        if (bl) {
            HtmlActionsToolBar htmlActionsToolBar = new HtmlActionsToolBar(this.fBrowser.getHtmlComponent().getActions());
            this.add((Component)htmlActionsToolBar, "North");
            if (bl2) {
                this.fBrowser.addAddressBox(htmlActionsToolBar);
            }
        }
        this.fBrowser.addStatusChangedListener((StatusChangedListener)new MyStatusChangedListener());
        htmlComponent.addPageChangedListener((PageChangedListener)new MyPageChangedListener());
        htmlComponent.addStatusTextListener((StatusTextListener)new MyMouseOverLinkListener());
        this.add((Component)this.fBrowser, "Center");
        this.flushQueue(this.fBrowser);
    }

    private static void addNewWindowListener(HtmlComponent<MatlabHtmlActions> htmlComponent) {
        HtmlConversionUtils.visitBrowser(htmlComponent, (HtmlConversionUtils.BrowserVisitor)new HtmlConversionUtils.BrowserVisitor(){

            public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
                mJHtmlPanel.setPopupWindowListener((PopupWindowListener)new WebBrowserPopupListener());
            }

            public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
            }
        });
    }

    private static HtmlComponent<MatlabHtmlActions> buildHtmlComponent() {
        return HtmlComponentFactory.buildHtmlComponent((HtmlComponentFactory.HtmlComponentType[])new HtmlComponentFactory.HtmlComponentType[]{HtmlComponentFactory.HtmlComponentType.FOLLOW_PREFERENCE, HtmlComponentFactory.HtmlComponentType.HTMLPANEL, HtmlComponentFactory.HtmlComponentType.HTMLRENDERER});
    }

    public static WebBrowser getActiveBrowser() {
        return sActiveBrowser;
    }

    public static WebBrowser createBrowser() {
        return WebBrowser.createBrowser(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebBrowser createBrowser(boolean bl, boolean bl2) {
        if (SwingUtilities.isEventDispatchThread()) {
            return new WebBrowser(bl, bl2);
        }
        CreateBrowser createBrowser = new CreateBrowser(bl, bl2);
        try {
            AWTUtilities.invokeAndWait((Runnable)createBrowser);
        }
        finally {
            return createBrowser.getBrowser();
        }
    }

    private synchronized void doWhenReady(BrowserAction browserAction) {
        if (this.fBrowser != null && this.fQueue.isEmpty()) {
            browserAction.whenReady(this.fBrowser);
        } else {
            this.fQueue.add(browserAction);
        }
    }

    private synchronized boolean doNextQueueItem(final HTMLBrowserPanel hTMLBrowserPanel) {
        if (!this.fQueue.isEmpty()) {
            final BrowserAction browserAction = this.fQueue.remove(0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    browserAction.whenReady(hTMLBrowserPanel);
                }
            });
        }
        return !this.fQueue.isEmpty();
    }

    private void flushQueue(HTMLBrowserPanel hTMLBrowserPanel) {
        boolean bl = true;
        while (bl) {
            bl = this.doNextQueueItem(hTMLBrowserPanel);
        }
    }

    public boolean isInitialized() {
        return this.fBrowser != null && this.fBrowser.getHtmlComponent().isInitialized();
    }

    public void setCurrentLocation(final String string) {
        MLDesktop.getInstance().showClient((Component)((Object)this), null, true);
        this.setWaitCursor(true);
        this.doWhenReady(new BrowserAction(){

            @Override
            public void whenReady(HTMLBrowserPanel hTMLBrowserPanel) {
                hTMLBrowserPanel.setCurrentLocation(string);
            }
        });
    }

    public String getCurrentLocation() {
        return this.fBrowser != null ? this.fBrowser.getHtmlComponent().getCurrentLocation() : null;
    }

    public void setHtmlText(final String string) {
        MLDesktop.getInstance().showClient((Component)((Object)this), null, true);
        this.setWaitCursor(true);
        this.doWhenReady(new BrowserAction(){

            @Override
            public void whenReady(HTMLBrowserPanel hTMLBrowserPanel) {
                hTMLBrowserPanel.setHtmlText(string);
            }
        });
    }

    public String getHtmlText() {
        return this.fBrowser != null ? this.fBrowser.getHtmlComponent().getHtmlText() : null;
    }

    public void reload() {
        if (this.fBrowser != null) {
            this.setWaitCursor(true);
            this.fBrowser.getHtmlComponent().reload();
        }
    }

    public void close() {
        Desktop desktop = MatlabDesktopServices.getDesktop();
        desktop.closeClient((Component)((Object)this));
    }

    public boolean requestFocusInWindow() {
        if (this.fBrowser != null) {
            return this.fBrowser.getHtmlComponent().getComponent().requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public void requestFocus() {
        super.requestFocus();
        this.requestFocusInWindow();
    }

    public void setWaitCursor(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setAllWaitCursors(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebBrowser.this.setAllWaitCursors(bl);
                }
            });
        }
    }

    private void setAllWaitCursors(boolean bl) {
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.fBrowser != null) {
                this.fBrowser.setWaitCursor(true);
            }
        } else {
            this.setCursor(Cursor.getDefaultCursor());
            if (this.fBrowser != null) {
                this.fBrowser.setWaitCursor(false);
            }
        }
    }

    public static void main(String[] stringArray) {
        if (!Matlab.isMatlabAvailable()) {
            PostVMInit.perform((boolean)true, (boolean)false);
        }
        WebBrowser webBrowser = WebBrowser.createBrowser();
        webBrowser.setCurrentLocation("http://www.mathworks.com");
    }

    public void executeScript(final String string) {
        this.doWhenReady(new BrowserAction(){

            @Override
            public void whenReady(HTMLBrowserPanel hTMLBrowserPanel) {
                hTMLBrowserPanel.executeScript(string);
            }
        });
    }

    public void executeScript(final String string, final HtmlDataListener<String> htmlDataListener) {
        this.doWhenReady(new BrowserAction(){

            @Override
            public void whenReady(HTMLBrowserPanel hTMLBrowserPanel) {
                hTMLBrowserPanel.executeScript(string, htmlDataListener);
            }
        });
    }

    public HtmlComponent getHtmlComponent() {
        return this.fBrowser == null ? null : this.fBrowser.getHtmlComponent();
    }

    public RendererType getRendererType() {
        HtmlComponent htmlComponent = this.getHtmlComponent();
        if (htmlComponent instanceof MJHtmlPanel || htmlComponent instanceof HtmlPanel) {
            return RendererType.HTMLPANEL;
        }
        return RendererType.HTMLRENDERER;
    }

    private class MyMouseOverLinkListener
    implements StatusTextListener {
        private String fText;

        private MyMouseOverLinkListener() {
        }

        public void statusChanged(StatusTextChangedEvent statusTextChangedEvent) {
            if (WebBrowser.this.fStatusBar != null) {
                this.fText = statusTextChangedEvent.getStatusText();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (MyMouseOverLinkListener.this.fText.length() == 0) {
                            WebBrowser.this.fStatusBar.clearText();
                        } else {
                            WebBrowser.this.fStatusBar.setText(MyMouseOverLinkListener.this.fText);
                        }
                    }
                });
            }
        }
    }

    private class MyPageChangedListener
    implements PageChangedListener {
        private MyPageChangedListener() {
        }

        public void pageChanged(final PageChangedEvent pageChangedEvent) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.setTitlesAndCursor(pageChangedEvent);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MyPageChangedListener.this.setTitlesAndCursor(pageChangedEvent);
                    }
                });
            }
        }

        private void setTitlesAndCursor(PageChangedEvent pageChangedEvent) {
            String string;
            String string2 = pageChangedEvent.getFullUrl();
            if (string2.equals(string = pageChangedEvent.getTitle()) && string.startsWith("text://")) {
                string = HTMLUtils.sRes.getString("icecontainer.address_box_untitled");
            }
            String string3 = HtmlUtils.correctUrl((String)string2);
            String string4 = HtmlUtils.correctUrl((String)string);
            WebBrowser.this.setTitle(string4);
            if (string3.equals(string4)) {
                int n = string4.lastIndexOf(47);
                if (n >= 0 && n < string4.length()) {
                    WebBrowser.this.setShortTitle(string4.substring(n + 1));
                }
            } else {
                WebBrowser.this.setShortTitle(string);
            }
        }
    }

    private class MyStatusChangedListener
    implements StatusChangedListener {
        private MyStatusChangedListener() {
        }

        public void statusChanged(StatusChangedListener.StatusChangedEvent statusChangedEvent) {
            if (statusChangedEvent != null) {
                if (statusChangedEvent.isBusy()) {
                    WebBrowser.this.setWaitCursor(true);
                } else {
                    WebBrowser.this.setWaitCursor(false);
                }
            }
        }
    }

    private class DTCL
    extends DTClientAdapter {
        private boolean iActive = false;

        private DTCL() {
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
            sBrowsers.remove((Object)WebBrowser.this);
            WebBrowser.this.fBrowser.getHtmlComponent().dispose();
            if (sActiveBrowser == WebBrowser.this) {
                if (!sBrowsers.isEmpty()) {
                    sActiveBrowser = (WebBrowser)((Object)sBrowsers.get(sBrowsers.size() - 1));
                } else {
                    sActiveBrowser = null;
                }
            }
        }

        public void clientActivated(DTClientEvent dTClientEvent) {
            sActiveBrowser = WebBrowser.this;
            this.iActive = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DTCL.this.iActive) {
                        WebBrowser.this.requestFocus();
                    }
                }
            });
        }

        public void clientDeactivated(DTClientEvent dTClientEvent) {
            this.iActive = false;
        }
    }

    private static interface BrowserAction {
        public void whenReady(HTMLBrowserPanel var1);
    }

    private static class CreateBrowser
    implements Runnable {
        private boolean iInRunMethod = false;
        private StringBuffer iCreationLog = new StringBuffer();
        private boolean iWantToolbar;
        private boolean iWantAddressBox;
        private Throwable iBrowserException;
        private WebBrowser iBrowser;

        private CreateBrowser(boolean bl, boolean bl2) {
            this.iWantToolbar = bl;
            this.iWantAddressBox = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setInRunMethod(true);
            try {
                this.iCreationLog.append("\nIn CreateBrowser.run().");
                try {
                    this.iBrowser = new WebBrowser(this.iWantToolbar, this.iWantAddressBox);
                    this.iCreationLog.append("\nCreated new web browser: ").append(this.iBrowser.toString());
                }
                catch (Throwable throwable) {
                    this.iCreationLog.append("\nEncountered a problem creating a web browser: ").append(throwable.getMessage());
                    this.iBrowserException = throwable;
                }
                this.iCreationLog.append("\nExiting CreateBrowser.run().  iBrowser is ");
                if (this.iBrowser != null) {
                    this.iCreationLog.append("NOT ");
                }
                this.iCreationLog.append("null");
            }
            finally {
                this.setInRunMethod(false);
            }
        }

        private WebBrowser getBrowser() {
            this.assertBrowserCreation();
            return this.iBrowser;
        }

        private synchronized void setInRunMethod(boolean bl) {
            this.iInRunMethod = bl;
        }

        private synchronized boolean isInRunMethod() {
            return this.iInRunMethod;
        }

        private void assertBrowserCreation() {
            if (this.iBrowser == null) {
                if (this.isInRunMethod()) {
                    this.iCreationLog.append("\nAccessed getBrowser() before run() method completed.");
                }
                if (this.iBrowserException != null) {
                    this.iBrowserException.printStackTrace();
                }
                assert (false) : this.iCreationLog.toString();
            }
        }
    }

    private static class WebBrowserPopupListener
    extends MJHtmlPanelPopupListener {
        private WebBrowserPopupListener() {
        }

        protected Container createPopupComponent(MJHtmlPanel mJHtmlPanel) {
            return new WebBrowser((HtmlComponent)mJHtmlPanel, false, false);
        }
    }

    public static enum RendererType {
        HTMLRENDERER,
        HTMLPANEL;

    }
}

