/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.profiler;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.desk.MLMenuMergeTag;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.html.HTMLBrowserToolbar;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.PageChangedListener;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJStartup;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.Prefs;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTClientPropertyProvider;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListDataEvent;
import javax.swing.text.JTextComponent;

public class Profiler
extends DTClientBase {
    private static final String RESDIR = "com.mathworks.mde.profiler.resources.";
    private static final ResourceBundle SRES = ResourceBundle.getBundle("com.mathworks.mde.profiler.resources.RES_Profiler");
    private static final String SDEFAULTPAGETEXT = "<html><head><title></title>\n<link rel=stylesheet href=\"docstyle1.css\" type=\"text/css\">\n</head>\n<body bgcolor=#ffffff>\n\n<a name=\"profiler_for_improving_performance\"></a><!-- H1 --><a name=\"5978\"></a><p><font size=+2 color=\"#990000\"><b>" + SRES.getString("message.profiler_title") + "</b></font><br class=\"hdr\">\n" + "<p><a name=\"10802\"></a>" + MessageFormat.format(SRES.getString("message.profiler_description"), "<code><a href=\"matlab:doc('matlab/profile');\">profile</a></code>") + "</p>\n" + "<p><a name=\"8179\"></a>" + MessageFormat.format(SRES.getString("message.profiler_moreHelp"), "<a href=\"matlab:helpview(fullfile(docroot, 'matlab', 'helptargets.map'), 'measuring_performance');\">" + SRES.getString("message.profiler_moreHelpUrl")) + "</a>.</p>\n" + "\n" + "<!-- Copyright 2001-2011 The MathWorks, Inc. -->\n" + "</body>\n" + "</html>";
    private static Profiler sProfiler;
    private static boolean sMATLABProfilerRunning;
    private static long sProfilerStartTime;
    private static long sProfilerStopTime;
    private MJButton fProfileOnOffButton;
    private MJLabel fTimerDisplay;
    private MJStatusBar fStatusBar;
    private CustomComboBox fRunCodeField;
    private HTMLRenderer fHtmlPanel;
    private ProfilerTimer fProfilerTimer;
    private Matlab fMatlab = new Matlab();
    private DefaultComboBoxModel fComboModel;
    private StopStartButton fStopStartIcon;
    private ProfilerCompletionObserver fProfilerObserver = new ProfilerCompletionObserver();
    private MyPageChangedListener fPageChangedListener = new MyPageChangedListener();
    private boolean fIsRunningCode = false;
    private static final String ON = "on";
    private static final String OFF = "off";
    private static final String PROFILER = "Profiler";
    private AtomicBoolean fIsParallelOptionsAvailable = new AtomicBoolean(false);
    private static TemporaryFilesManager sParallelTempFiles;
    private MJComboBox fLabIndexField;
    private DefaultComboBoxModel fLabIndexComboModel;
    private static final String LABCHANGECALLBACKFCN = "dctChangeLab";
    private static final String MTEMPMANAGER = "dctProfTempDataManager";
    private int[] fSelectedLabs;
    private boolean fCallbackEnabled = true;

    private synchronized void addParallelProfilerOpts() {
        if (!this.fIsParallelOptionsAvailable.get()) {
            this.fPageChangedListener.setClearHistory(true);
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Profiler.this.setToolBars((JToolBar[])Profiler.this.createParallelToolbars());
                        Profiler.this.fHtmlPanel.setHomeUrl("matlab:mpiprofview(0)");
                    }
                });
            }
            catch (Throwable throwable) {
                Log.logThrowable((Throwable)throwable);
            }
            this.fIsParallelOptionsAvailable.set(true);
        }
    }

    private MJToolBar[] createParallelToolbars() {
        this.fLabIndexComboModel = new DefaultComboBoxModel();
        this.fLabIndexField = new MJComboBox((ComboBoxModel)this.fLabIndexComboModel);
        this.fLabIndexField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (Profiler.this.fCallbackEnabled) {
                        CompletionObserver completionObserver = new CompletionObserver(){

                            public void completed(int n, Object object) {
                            }
                        };
                        Profiler.this.fMatlab.feval(Profiler.LABCHANGECALLBACKFCN, new Object[]{"" + (1 + Profiler.this.fLabIndexField.getSelectedIndex())}, completionObserver);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Could not execute this command from the profiler, make sure MATLAB is running and the Distributed Computing Toolbox is available.");
                    Log.logException((Exception)exception);
                }
            }
        });
        this.fLabIndexField.setName("Parallel Profiler Lab Selector");
        MJToolBar mJToolBar = new MJToolBar();
        mJToolBar.setFloatable(false);
        mJToolBar.add((Component)this.fLabIndexField);
        MJToolBar[] mJToolBarArray = new MJToolBar[]{new ProfilerToolbar(), mJToolBar};
        return mJToolBarArray;
    }

    private void createAndAddStandardToolbar() {
        final MJLabel mJLabel = new MJLabel(SRES.getString("toolbar.run_code"));
        mJLabel.setLabelFor(this.fRunCodeField.getEditor().getEditorComponent());
        mJLabel.setArmed(false);
        MJToolBar mJToolBar = new MJToolBar(){

            public void setArmed(boolean bl) {
                mJLabel.setArmed(bl);
                String string = Profiler.isProfilerRunning() ? SRES.getString("toolbar.off") : SRES.getString("toolbar.on");
                if (bl) {
                    Profiler.this.fProfileOnOffButton.setText(string);
                } else {
                    Profiler.this.fProfileOnOffButton.setText(MJUtilities.exciseAmpersand((String)string));
                }
            }
        };
        mJToolBar.setFloatable(false);
        mJToolBar.addGap();
        mJToolBar.add((Component)this.fProfileOnOffButton);
        mJToolBar.addGap(10);
        mJToolBar.add((Component)mJLabel);
        mJToolBar.addGap();
        mJToolBar.add((Component)((Object)this.fRunCodeField));
        mJToolBar.addGap();
        mJToolBar.add((Component)((Object)this.fStopStartIcon));
        mJToolBar.add((Component)this.fTimerDisplay);
        mJToolBar.setName(SRES.getString("toolbar.bottomToolbarName"));
        MJToolBar[] mJToolBarArray = new MJToolBar[]{new ProfilerToolbar(), mJToolBar};
        this.setToolBars((JToolBar[])mJToolBarArray);
    }

    private synchronized void ensureStandardProfilerOpts() {
        if (this.fIsParallelOptionsAvailable.get()) {
            this.fPageChangedListener.setClearHistory(true);
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Profiler.this.createAndAddStandardToolbar();
                        Profiler.this.fHtmlPanel.setHomeUrl("matlab:profview(0)");
                    }
                });
            }
            catch (Throwable throwable) {
                Log.logThrowable((Throwable)throwable);
            }
            this.fIsParallelOptionsAvailable.set(false);
        }
    }

    protected Profiler(boolean bl) {
        Object object;
        AccessibleContext accessibleContext;
        this.setName(PROFILER);
        this.setLayout(new BorderLayout(0, 0));
        this.setSmallIcon(ApplicationIcon.PROFILER.getIcon());
        this.setIcon(PlatformInfo.isWindows() ? ApplicationIcon.PROFILER_32x32.getIcon() : ApplicationIcon.PROFILER_48x48.getIcon());
        this.setWantTopSeparator(true);
        this.setOnTopWhenUndocked(false);
        this.fHtmlPanel = new ProfilerHtmlRenderer();
        this.fHtmlPanel.addMouseOverLinkListener((ActionListener)new MyMouseListener());
        this.fHtmlPanel.addPageChangedListener((PageChangedListener)this.fPageChangedListener);
        this.fHtmlPanel.setHomeUrl("matlab:profview(0)");
        this.fHtmlPanel.setFont(Prefs.getFontPref((String)"HelpHTML_Browser_ProportionalFont_R13"));
        this.add((Component)this.fHtmlPanel, "Center");
        this.fStatusBar = new MJStatusBar();
        this.fStatusBar.setName("Profiler Status Bar");
        this.setStatusBar(this.fStatusBar);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getModifiers() != 0 || actionEvent.getSource().equals(Profiler.this.fProfileOnOffButton)) {
                    SwingUtilities.invokeLater(new ExecuteCodeThread(actionEvent));
                }
            }
        };
        this.fProfileOnOffButton = new NoShrinkingButton(MJUtilities.exciseAmpersand((String)SRES.getString("toolbar.on")));
        this.fProfileOnOffButton.setFocusTraversable(false);
        this.updateProfilerOnOffButton();
        this.fProfileOnOffButton.addActionListener(actionListener);
        this.fProfileOnOffButton.setName("Time display");
        this.fProfilerTimer = new ProfilerTimer();
        this.fTimerDisplay = new MJLabel();
        if (!Profiler.isProfilerRunning()) {
            if (sProfilerStopTime != -1L && sProfilerStartTime != -1L) {
                this.updateTimeDisplay(Math.round((float)(sProfilerStopTime - sProfilerStartTime) / 1000.0f));
            } else {
                this.updateTimeDisplay(0);
            }
        } else {
            this.fProfilerTimer.profilerOpenedWhileRunning();
        }
        this.fRunCodeField = new CustomComboBox();
        this.fRunCodeField.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new ExecuteCodeThread(keyEvent));
                }
            }
        });
        this.fRunCodeField.addActionListener(actionListener);
        this.fRunCodeField.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Component component = Profiler.this.fRunCodeField.getEditor().getEditorComponent();
                if (component instanceof JTextComponent) {
                    ((JTextComponent)component).selectAll();
                }
            }
        });
        this.fRunCodeField.setEditable(true);
        this.fComboModel = new DefaultComboBoxModel();
        this.fRunCodeField.setModel(this.fComboModel);
        this.fRunCodeField.setName("Profiler Run Code Combobox");
        Component component = this.fRunCodeField.getEditor().getEditorComponent();
        if (component instanceof Accessible && (accessibleContext = (object = (Accessible)((Object)component)).getAccessibleContext()) != null) {
            accessibleContext.setAccessibleName(MJUtilities.exciseAmpersand((String)SRES.getString("toolbar.run_code")));
        }
        this.fStopStartIcon = new StopStartButton();
        this.createAndAddStandardToolbar();
        object = MLDesktop.getInstance();
        accessibleContext = object.hasMainFrame() ? null : DTLocation.createExternal((int)10, (int)10, (int)800, (int)600);
        object.addClient((Component)((Object)this), PROFILER, true, (DTLocation)accessibleContext, true, null);
        this.setMenuBar((JMenuBar)this.createMenuBar());
        if (bl) {
            this.fHtmlPanel.setHtmlText(SDEFAULTPAGETEXT);
        }
        this.getParentDesktop().addClientListener((Component)((Object)this), (DTClientListener)new DTClientAdapter(){

            public void clientClosing(DTClientEvent dTClientEvent) {
                if (MLDesktop.getInstance() != null && !MLDesktop.getInstance().isAttemptingClose() && Profiler.isProfilerRunning()) {
                    if (Profiler.this.fIsRunningCode) {
                        MJOptionPane.showMessageDialog((Component)((Object)sProfiler), (Object)SRES.getString("message.cant_stop_profiler"), (String)SRES.getString("title.profiler"), (int)1);
                        ((DTClientPropertyProvider)dTClientEvent.getClient()).putClientProperty((Object)DTClientProperty.VETO_CLOSE, (Object)Boolean.TRUE);
                    } else {
                        int n = MJOptionPane.showConfirmDialog((Component)((Object)sProfiler), (Object)SRES.getString("message.stop_profiler"), (String)SRES.getString("title.profiler"), (int)1);
                        if (n == 0) {
                            Profiler.this.executeProfileOff();
                        } else if (n != 1) {
                            ((DTClientPropertyProvider)dTClientEvent.getClient()).putClientProperty((Object)DTClientProperty.VETO_CLOSE, (Object)Boolean.TRUE);
                        } else {
                            Profiler.this.fProfilerTimer.stop();
                        }
                    }
                }
            }

            public void clientClosed(DTClientEvent dTClientEvent) {
                if (sParallelTempFiles != null) {
                    if (!sParallelTempFiles.removeAllTempFiles()) {
                        System.err.println("Error: All profiler temp files could not be deleted. Check " + sParallelTempFiles.getTempLocation());
                    }
                    Profiler.this.fMatlab.evalConsoleOutput("dctProfTempDataManager closeFig");
                }
            }

            public void clientOpened(DTClientEvent dTClientEvent) {
                if (Profiler.isProfilerRunning()) {
                    Profiler.this.fProfilerTimer.profilerOpenedWhileRunning();
                } else if (sProfilerStopTime != -1L && sProfilerStartTime != -1L) {
                    Profiler.this.updateTimeDisplay(Math.round((float)(sProfilerStopTime - sProfilerStartTime) / 1000.0f));
                }
            }
        });
    }

    private static void removeProfilerAction(Container container, AbstractAction abstractAction) {
        for (int i = 0; i != container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!(component instanceof AbstractButton) || ((AbstractButton)component).getAction() == null || !((AbstractButton)component).getAction().equals(abstractAction)) continue;
            container.remove(component);
            break;
        }
    }

    private MJMenuBar createMenuBar() {
        MJMenuBar mJMenuBar = new MJMenuBar();
        MJMenu mJMenu = new MJMenu();
        mJMenuBar.add((JMenu)mJMenu);
        DTMenuMergeTag.FILE.setTag((JMenuItem)mJMenu);
        MJMenuItem mJMenuItem = new MJMenuItem((Action)this.fHtmlPanel.getActions().fPrintAction);
        DTMenuMergeTag.PRINT.setTag((JMenuItem)mJMenuItem);
        mJMenu.add((JMenuItem)mJMenuItem);
        MJMenu mJMenu2 = new MJMenu();
        DTMenuMergeTag.EDIT.setTag((JMenuItem)mJMenu2);
        mJMenuBar.add((JMenu)mJMenu2);
        MJMenuItem mJMenuItem2 = new MJMenuItem((Action)this.fHtmlPanel.getActions().fCopyAction);
        DTMenuMergeTag.COPY.setTag((JMenuItem)mJMenuItem2);
        mJMenu2.add((JMenuItem)mJMenuItem2);
        MJMenuItem mJMenuItem3 = new MJMenuItem((Action)this.fHtmlPanel.getActions().fFindAction);
        MLMenuMergeTag.FIND.setTag((JMenuItem)mJMenuItem3);
        mJMenu2.add((JMenuItem)mJMenuItem3);
        return mJMenuBar;
    }

    public void requestFocus() {
        this.fHtmlPanel.requestFocus();
    }

    private static synchronized Profiler getInstance(boolean bl) {
        if (null == sProfiler) {
            sProfiler = new Profiler(bl);
        }
        sProfiler.ensureStandardProfilerOpts();
        return sProfiler;
    }

    public static Profiler getInstance() {
        return Profiler.getInstance(true);
    }

    public static synchronized Profiler getInstanceWithParallelOpts() {
        if (null == sProfiler) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        sProfiler = new Profiler(false);
                    }
                });
            }
            catch (Throwable throwable) {
                Log.logThrowable((Throwable)throwable);
            }
        }
        sProfiler.addParallelProfilerOpts();
        return sProfiler;
    }

    private void setStatusText(String string) {
        if (string.length() == 0) {
            this.fStatusBar.clearText();
        } else {
            this.fStatusBar.setText(string);
        }
    }

    private void showProfiler() {
        MLDesktop.getInstance().showClient((Component)((Object)sProfiler), null, true);
    }

    public static void start() {
        if (!Profiler.isProfilerRunning()) {
            sProfilerStartTime = System.currentTimeMillis();
            Profiler.setProfilerRunning(true);
            if (null != sProfiler) {
                sProfiler.startProfiler();
            }
        }
    }

    public static void stop() {
        if (Profiler.isProfilerRunning()) {
            sProfilerStopTime = System.currentTimeMillis();
            Profiler.setProfilerRunning(false);
            if (null != sProfiler) {
                Profiler.sProfiler.fPageChangedListener.setClearHistory(true);
                sProfiler.stopProfiler();
            }
        }
    }

    public static void clear() {
        if (Profiler.isProfilerRunning()) {
            sProfilerStartTime = System.currentTimeMillis();
        }
        if (null != sProfiler) {
            sProfiler.clearProfiler();
        }
    }

    public static void invoke() {
        Profiler.setHtmlText(SDEFAULTPAGETEXT);
    }

    public static void setCommandText(String string) {
        Profiler.getInstance(false);
        Profiler.sProfiler.fRunCodeField.getEditor().setItem(string);
    }

    public static void setCurrentLocation(String string) {
        Profiler.getInstance(false);
        Profiler.sProfiler.fHtmlPanel.setCurrentLocation(string);
        sProfiler.showProfiler();
    }

    public static void setCurrentLocationParallel(String string) {
        Profiler.getInstanceWithParallelOpts();
        Profiler.sProfiler.fHtmlPanel.setCurrentLocation(string);
        sProfiler.showProfiler();
    }

    public static void setHtmlText(String string) {
        Profiler.getInstance(false);
        Profiler.sProfiler.fHtmlPanel.setHtmlText(string);
        sProfiler.showProfiler();
    }

    public static void setHtmlTextParallel(String string) {
        Profiler.getInstanceWithParallelOpts();
        Profiler.sProfiler.fHtmlPanel.setHtmlText(string);
        sProfiler.showProfiler();
    }

    public static TemporaryFilesManager getTempFilesManager() {
        if (sParallelTempFiles == null) {
            sParallelTempFiles = new TemporaryFilesManager();
        }
        return sParallelTempFiles;
    }

    public static void setNumLabsParallel(int n, int n2) {
        Profiler.getInstanceWithParallelOpts();
        sProfiler.setNumLabs(n, n2);
    }

    public static int[] getSelectedLabsFromHtml() {
        Profiler.getInstanceWithParallelOpts();
        return Profiler.sProfiler.fSelectedLabs;
    }

    private void setSelectedLabsFromHtml(int[] nArray) {
        this.fSelectedLabs = nArray;
    }

    public void setSelectedLab(final int n) {
        final int n2 = -1 * this.fLabIndexField.getItemCount();
        if (this.fIsParallelOptionsAvailable.get()) {
            Profiler.runOnAwtThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Profiler.this.fCallbackEnabled = false;
                    try {
                        if (n > 0) {
                            Profiler.this.fLabIndexField.setSelectedIndex(n - 1);
                        } else if (n > n2) {
                            Profiler.this.fLabIndexField.setSelectedIndex(Profiler.this.fLabIndexField.getItemCount() + n);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.err.println("The Parallel Profiler has not been initialized correctly. Run MPIPROFILE VIEWER in PMODE. See the Distributed Computing Toolbox documentation.");
                    }
                    finally {
                        Profiler.this.fCallbackEnabled = true;
                    }
                }
            });
        }
    }

    public void setNumLabs(final int n, final int n2) {
        Profiler.runOnAwtThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Profiler.this.fCallbackEnabled = false;
                try {
                    Profiler.this.fLabIndexComboModel.removeAllElements();
                    for (int i = 1; i <= n; ++i) {
                        Profiler.this.fLabIndexComboModel.addElement("lab " + i);
                    }
                    Profiler.this.fLabIndexComboModel.addElement("Aggregate");
                    sProfiler.setSelectedLab(n2);
                }
                finally {
                    Profiler.this.fCallbackEnabled = true;
                }
            }
        });
    }

    private static void runOnAwtThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static String getHtmlText() {
        Profiler.getInstance();
        return Profiler.sProfiler.fHtmlPanel.getHtmlText();
    }

    public static String getHtmlTextParallel() {
        Profiler.getInstanceWithParallelOpts();
        return Profiler.sProfiler.fHtmlPanel.getHtmlText();
    }

    private void updateProfilerOnOffButton() {
        if (Profiler.isProfilerRunning()) {
            this.fProfileOnOffButton.setText(SRES.getString("toolbar.off"));
            this.fProfileOnOffButton.setActionCommand(OFF);
            this.fProfileOnOffButton.getAccessibleContext().setAccessibleName(SRES.getString("toolbar.off.acc"));
        } else {
            this.fProfileOnOffButton.setText(SRES.getString("toolbar.on"));
            this.fProfileOnOffButton.setActionCommand(ON);
            this.fProfileOnOffButton.getAccessibleContext().setAccessibleName(SRES.getString("toolbar.on.acc"));
        }
    }

    private void startProfilerMethod() {
        this.setWaitCursor(true);
        this.fProfilerTimer.reset();
        this.fProfilerTimer.start();
        this.updateProfilerOnOffButton();
        this.fStopStartIcon.turnOn();
    }

    private void startProfiler() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.startProfilerMethod();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Profiler.this.startProfilerMethod();
                }
            });
        }
    }

    private void stopProfilerMethod() {
        this.setWaitCursor(false);
        this.fProfilerTimer.stop();
        this.fStopStartIcon.turnOff();
        this.updateProfilerOnOffButton();
    }

    private void stopProfiler() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.stopProfilerMethod();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Profiler.this.stopProfilerMethod();
                }
            });
        }
    }

    private void clearProfilerMethod() {
        this.fProfilerTimer.reset();
    }

    private void clearProfiler() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.clearProfilerMethod();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Profiler.this.clearProfilerMethod();
                }
            });
        }
    }

    private void addCodeToCombobox(String string) {
        this.fComboModel.removeElement(string);
        this.fComboModel.insertElementAt(string, 0);
        this.fRunCodeField.getEditor().setItem(string);
        this.fRunCodeField.setSelectedItem(string);
    }

    private void updateTimeDisplay(int n) {
        Integer n2 = n;
        Object[] objectArray = new Object[]{n2.toString()};
        String string = MessageFormat.format(SRES.getString("toolbar.time_display"), objectArray);
        this.fTimerDisplay.setText(string);
    }

    public static void main(String[] stringArray) {
        if (!Matlab.isMatlabAvailable()) {
            MJStartup.init();
        }
        Profiler.getInstance();
    }

    private void setWaitCursor(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (bl) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.fHtmlPanel.setWaitCursor(true);
            } else {
                this.setCursor(Cursor.getDefaultCursor());
                this.fHtmlPanel.setWaitCursor(false);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        Profiler.this.setCursor(Cursor.getPredefinedCursor(3));
                        Profiler.this.fHtmlPanel.setWaitCursor(true);
                    } else {
                        Profiler.this.setCursor(Cursor.getDefaultCursor());
                        Profiler.this.fHtmlPanel.setWaitCursor(false);
                    }
                }
            });
        }
    }

    private void executeProfileOff() {
        if (!this.fIsParallelOptionsAvailable.get()) {
            this.fMatlab.evalConsoleOutput("profile off");
        } else {
            this.fMatlab.evalConsoleOutput("mpiprofile off");
        }
    }

    private boolean isProfilerGUIOpen() {
        return this.getParentDesktop().isClientShowing((Component)((Object)this));
    }

    private static boolean isProfilerRunning() {
        return sMATLABProfilerRunning;
    }

    private static void setProfilerRunning(boolean bl) {
        sMATLABProfilerRunning = bl;
    }

    private static int getProfilerTimeRunning() {
        return Math.round((float)(System.currentTimeMillis() - sProfilerStartTime) / 1000.0f);
    }

    static {
        sMATLABProfilerRunning = false;
        sProfilerStartTime = -1L;
        sProfilerStopTime = -1L;
    }

    private static class NoShrinkingButton
    extends MJButton {
        private Dimension iLargestSize = null;

        NoShrinkingButton(String string) {
            super(string);
            if (!PlatformInfo.isMacintosh()) {
                this.setMargin(new Insets(0, 0, 0, 0));
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.iLargestSize == null || dimension.getHeight() > this.iLargestSize.getHeight() || dimension.getWidth() > this.iLargestSize.getWidth()) {
                this.iLargestSize = dimension;
            }
            return this.iLargestSize;
        }
    }

    private static class CustomComboBox
    extends MJComboBox {
        private CustomComboBox() {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
        }
    }

    private class ProfilerTimer {
        private Timer fTimer;

        ProfilerTimer() {
            this.fTimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Profiler.this.updateTimeDisplay(Profiler.getProfilerTimeRunning());
                }
            });
        }

        public void start() {
            if (this.fTimer.isRunning()) {
                if (Profiler.this.isProfilerGUIOpen()) {
                    this.fTimer.restart();
                } else {
                    this.fTimer.stop();
                }
            } else if (Profiler.this.isProfilerGUIOpen()) {
                this.fTimer.start();
            }
        }

        private void profilerOpenedWhileRunning() {
            Profiler.this.updateTimeDisplay(Profiler.getProfilerTimeRunning());
            this.fTimer.start();
        }

        public void stop() {
            Profiler.this.updateTimeDisplay(Profiler.getProfilerTimeRunning());
            this.fTimer.stop();
        }

        public void reset() {
            Profiler.this.updateTimeDisplay(0);
        }
    }

    private class MyPageChangedListener
    implements PageChangedListener {
        private boolean iClearHistory = false;

        private MyPageChangedListener() {
        }

        public void setClearHistory(boolean bl) {
            this.iClearHistory = bl;
        }

        public void pageChanged(PageChangedListener.PageChangedEvent pageChangedEvent) {
            if (sProfiler.fIsParallelOptionsAvailable.get()) {
                String[] stringArray = pageChangedEvent.getTitle().split(", ");
                try {
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    int n3 = Integer.parseInt(stringArray[2]);
                    int[] nArray = new int[n3 + 1];
                    nArray[0] = n;
                    for (int i = 0; i < n3; ++i) {
                        nArray[i + 1] = Integer.parseInt(stringArray[3 + i]);
                    }
                    sProfiler.setSelectedLabsFromHtml(nArray);
                    if (n2 != Profiler.this.fLabIndexField.getItemCount() - 1) {
                        sProfiler.setNumLabs(n2, n);
                    } else {
                        sProfiler.setSelectedLab(n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Parallel Profiler Warning: An unexpected error while parsing the title of a profiler page.");
                }
            }
            if (this.iClearHistory) {
                this.iClearHistory = false;
                sProfiler.fHtmlPanel.clearHistory();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Profiler.this.setStatusText("");
                }
            });
        }
    }

    private class MyMouseListener
    implements ActionListener {
        private MyMouseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Profiler.this.setStatusText(actionEvent.getActionCommand());
        }
    }

    private static class TemporaryFilesManager {
        private String fTempDir;

        private TemporaryFilesManager() {
        }

        private synchronized boolean removeAllTempFiles() {
            boolean bl = true;
            if (this.fTempDir != null) {
                bl = this.deleteDirectory(new File(this.fTempDir));
                this.fTempDir = null;
            }
            return bl;
        }

        private boolean deleteDirectory(File file) {
            if (file.exists()) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    file2.delete();
                }
            }
            return file.delete();
        }

        public synchronized String getTempLocation() {
            return this.fTempDir;
        }

        public synchronized boolean setTempLocation(String string) {
            this.removeAllTempFiles();
            this.fTempDir = string;
            return new File(string).mkdir();
        }
    }

    private class ProfilerCompletionObserver
    implements MatlabListener {
        private ProfilerCompletionObserver() {
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            Profiler.this.fIsRunningCode = false;
            if (Matlab.getExecutionStatus((int)matlabEvent.getStatus()) != 0) {
                Profiler.this.executeProfileOff();
            }
            Profiler.this.fProfileOnOffButton.setEnabled(true);
            if (!sProfiler.fIsParallelOptionsAvailable.get()) {
                Profiler.this.fRunCodeField.setEnabled(true);
            }
        }
    }

    private class ExecuteCodeThread
    implements Runnable {
        private EventObject fEvent;
        private final int ON = 1;
        private final int OFF = 2;

        public ExecuteCodeThread(EventObject eventObject) {
            this.fEvent = eventObject;
        }

        @Override
        public void run() {
            Object object;
            int n = 2;
            if (this.fEvent.getSource() instanceof MJButton) {
                object = (MJButton)this.fEvent.getSource();
                Profiler.this.setWaitCursor(true);
                if (object.getActionCommand().equals(Profiler.ON)) {
                    n = 1;
                }
            } else if (!Profiler.this.fRunCodeField.isPopupVisible()) {
                n = 1;
            } else {
                return;
            }
            Profiler.this.fProfileOnOffButton.setEnabled(false);
            if (n == 1) {
                object = (String)Profiler.this.fRunCodeField.getEditor().getItem();
                if (((String)object).length() == 0) {
                    Profiler.this.fMatlab.eval("profile on", (MatlabListener)Profiler.this.fProfilerObserver);
                } else {
                    Profiler.this.fIsRunningCode = true;
                    Profiler.this.fRunCodeField.setEnabled(false);
                    Profiler.this.fMatlab.evalConsoleOutput("profile on");
                    Profiler.this.fProfileOnOffButton.setText(SRES.getString("toolbar.off"));
                    Profiler.this.fProfileOnOffButton.getAccessibleContext().setAccessibleName(SRES.getString("toolbar.off.acc"));
                    MLExecuteServices.executeCommand((String)object);
                    Profiler.this.fMatlab.eval("profile viewer", (MatlabListener)Profiler.this.fProfilerObserver);
                    Profiler.this.addCodeToCombobox((String)object);
                }
            } else {
                Profiler.this.fMatlab.eval("profile viewer", (MatlabListener)Profiler.this.fProfilerObserver);
            }
        }
    }

    private class StopStartButton
    extends MJButton {
        private ImageIcon fOnIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/mathworks/mde/profiler/resources/profiler_on.gif"));
        private ImageIcon fOffIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/mathworks/mde/profiler/resources/profiler_off.gif"));

        StopStartButton() {
            if (Profiler.isProfilerRunning()) {
                this.setIcon(this.fOnIcon);
            } else {
                this.setIcon(this.fOffIcon);
            }
            this.setFocusTraversable(false);
            this.setBorderPainted(false);
            this.setName("Profiler Start Stop Button");
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        public void turnOn() {
            this.setIcon(this.fOnIcon);
        }

        public void turnOff() {
            this.setIcon(this.fOffIcon);
        }
    }

    private class ProfilerToolbar
    extends HTMLBrowserToolbar {
        ProfilerToolbar() {
            super(Profiler.this.fHtmlPanel, true, SRES.getString("toolbar.home"));
            this.setName(SRES.getString("toolbar.topToolbarName"));
        }

        protected void addDefaultItems() {
            super.addDefaultItems();
            Profiler.removeProfilerAction((Container)((Object)this), (AbstractAction)((Profiler)Profiler.this).fHtmlPanel.getActions().fReloadAction);
        }
    }

    private static class ProfilerHtmlRenderer
    extends HTMLRenderer {
        private ProfilerHtmlRenderer() {
        }

        protected MJPopupMenu createPopupMenu() {
            MJPopupMenu mJPopupMenu = super.createPopupMenu();
            Profiler.removeProfilerAction((Container)mJPopupMenu, (AbstractAction)this.getActions().fReloadAction);
            return mJPopupMenu;
        }
    }
}

