/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.mathworks.mde.help.search.HelpBrowserSearchResult;
import com.mathworks.mde.help.search.HighlightProvider;
import com.mathworks.mde.help.search.ResultsGroup;
import com.mathworks.mde.help.search.ResultsGrouper;
import com.mathworks.mlwidgets.help.search.RankedSearchResult;
import com.mathworks.mlwidgets.help.search.SearchResults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class SearchResultsContainer
implements Iterable<HelpBrowserSearchResult>,
ListModel {
    private final SearchResults<? extends RankedSearchResult> fRealResults;
    private final HelpBrowserSearchResult[] fWrappedResults;
    private final HighlightProvider fHighlightProvider;
    private final SearchResultExceptionHandler fHandler;
    private List<ResultsGroup> fGroups;
    private boolean fPopulationComplete = false;
    private boolean fInUse = true;

    public SearchResultsContainer(HighlightProvider highlightProvider, SearchResults<? extends RankedSearchResult> searchResults) {
        this(highlightProvider, searchResults, null);
    }

    public SearchResultsContainer(HighlightProvider highlightProvider, SearchResults<? extends RankedSearchResult> searchResults, SearchResultExceptionHandler searchResultExceptionHandler) {
        this.fRealResults = searchResults;
        this.fWrappedResults = new HelpBrowserSearchResult[searchResults.getNumResults()];
        this.fHighlightProvider = highlightProvider;
        this.fHandler = searchResultExceptionHandler;
        this.populateResults();
    }

    private void populateResults() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                SearchResultsContainer.this.finishPopulating();
            }
        });
        thread.start();
    }

    @Override
    public int getSize() {
        return this.fWrappedResults.length;
    }

    public HelpBrowserSearchResult getElementAt(int n) {
        block3: {
            if (this.fWrappedResults[n] == null) {
                try {
                    this.fWrappedResults[n] = new HelpBrowserSearchResult((RankedSearchResult)this.fRealResults.getResult(n), this.fHighlightProvider);
                }
                catch (Exception exception) {
                    if (this.fHandler == null) break block3;
                    this.fHandler.handleException();
                }
            }
        }
        return this.fWrappedResults[n];
    }

    public int getIndexOf(HelpBrowserSearchResult helpBrowserSearchResult) {
        this.finishPopulating();
        for (int i = 0; i < this.fWrappedResults.length; ++i) {
            HelpBrowserSearchResult helpBrowserSearchResult2 = this.fWrappedResults[i];
            if (helpBrowserSearchResult2 == null || !helpBrowserSearchResult2.equals(helpBrowserSearchResult)) continue;
            return i;
        }
        return -1;
    }

    public void sort(Comparator<HelpBrowserSearchResult> comparator, boolean bl) {
        this.fGroups = null;
        this.finishPopulating();
        if (comparator != null) {
            Arrays.sort(this.fWrappedResults, comparator);
        } else {
            Arrays.sort(this.fWrappedResults);
        }
        if (bl) {
            this.reverseSort();
        }
    }

    public void sortAndGroup(Comparator<HelpBrowserSearchResult> comparator, boolean bl, ResultsGrouper resultsGrouper) {
        this.sort(comparator, bl);
        this.groupResults(resultsGrouper);
    }

    void cleanUp() {
        this.fInUse = false;
    }

    private void groupResults(ResultsGrouper resultsGrouper) {
        this.finishPopulating();
        ArrayList<ResultsGroup> arrayList = new ArrayList<ResultsGroup>();
        ResultsGroup resultsGroup = null;
        for (int i = 0; i < this.fWrappedResults.length; ++i) {
            HelpBrowserSearchResult helpBrowserSearchResult = this.fWrappedResults[i];
            if (resultsGroup != null && resultsGrouper.isInGroup(resultsGroup, helpBrowserSearchResult)) continue;
            if (resultsGroup != null) {
                resultsGroup.markLastResult(i);
            }
            resultsGroup = resultsGrouper.createNewGroup(this, helpBrowserSearchResult);
            resultsGroup.setFirstResult(i);
            arrayList.add(resultsGroup);
        }
        if (resultsGroup != null) {
            resultsGroup.markLastResult(this.fWrappedResults.length);
        }
        this.fGroups = arrayList;
    }

    public List<ResultsGroup> getGroups() {
        if (this.fGroups != null) {
            return Collections.unmodifiableList(this.fGroups);
        }
        return null;
    }

    public void reverseSort() {
        SearchResultsContainer.reverseArray(this.fWrappedResults);
        if (this.fGroups != null) {
            this.reverseGroups();
        }
    }

    private static void reverseArray(HelpBrowserSearchResult[] helpBrowserSearchResultArray) {
        for (int i = 0; i < helpBrowserSearchResultArray.length / 2; ++i) {
            HelpBrowserSearchResult helpBrowserSearchResult = helpBrowserSearchResultArray[i];
            helpBrowserSearchResultArray[i] = helpBrowserSearchResultArray[helpBrowserSearchResultArray.length - i - 1];
            helpBrowserSearchResultArray[helpBrowserSearchResultArray.length - i - 1] = helpBrowserSearchResult;
        }
    }

    private void reverseGroups() {
        Collections.reverse(this.fGroups);
        for (ResultsGroup resultsGroup : this.fGroups) {
            resultsGroup.reverseInContainer();
        }
    }

    private synchronized void finishPopulating() {
        if (this.fPopulationComplete) {
            return;
        }
        boolean bl = this.doBasicPopulation();
        this.fPopulationComplete = true;
        if (bl) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    SearchResultsContainer.this.populateHighlights();
                }
            });
            thread.start();
        }
    }

    private boolean doBasicPopulation() {
        for (int i = 0; i < this.fWrappedResults.length; ++i) {
            HelpBrowserSearchResult helpBrowserSearchResult;
            if (this.fWrappedResults[i] != null || (helpBrowserSearchResult = this.getElementAt(i)) != null) continue;
            return false;
        }
        return true;
    }

    private void populateHighlights() {
        HelpBrowserSearchResult[] helpBrowserSearchResultArray = new HelpBrowserSearchResult[this.fWrappedResults.length];
        System.arraycopy(this.fWrappedResults, 0, helpBrowserSearchResultArray, 0, this.fWrappedResults.length);
        for (HelpBrowserSearchResult helpBrowserSearchResult : helpBrowserSearchResultArray) {
            if (!this.fInUse) {
                return;
            }
            helpBrowserSearchResult.getHighlights();
        }
    }

    @Override
    public Iterator<HelpBrowserSearchResult> iterator() {
        this.finishPopulating();
        return new Iterator<HelpBrowserSearchResult>(){
            private int iIndex = 0;

            @Override
            public boolean hasNext() {
                return this.iIndex < SearchResultsContainer.this.fWrappedResults.length;
            }

            @Override
            public HelpBrowserSearchResult next() {
                if (this.iIndex < SearchResultsContainer.this.fWrappedResults.length) {
                    return SearchResultsContainer.this.fWrappedResults[this.iIndex++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
    }

    public static interface SearchResultExceptionHandler {
        public void handleException();
    }
}

