/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.html.HtmlUtils;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mlwidgets.html.HTMLUtils;

class UrlDisplayBehavior {
    private final String fUrl;
    private final DisplayBehavior fDisplayBehavior;
    private static final String LOCAL_HOST = "localhost";

    UrlDisplayBehavior(String string) {
        this(string, true);
    }

    UrlDisplayBehavior(String string, boolean bl) {
        if (HelpBrowserUtils.isWebAddress((String)string) && bl) {
            this.fUrl = string;
            this.fDisplayBehavior = DisplayBehavior.OPEN_URL_IN_SYSTEM_BROWSER;
        } else {
            this.fUrl = this.getLocalizedLocation(string);
            this.fDisplayBehavior = !this.compareBaseUrls(string, this.fUrl) ? DisplayBehavior.OPEN_CHANGED_URL_IN_HELP_BROWSER : DisplayBehavior.OPEN_URL_IN_HELP_BROWSER;
        }
    }

    String getUrl() {
        return this.fUrl;
    }

    DisplayBehavior getDisplayBehavior() {
        return this.fDisplayBehavior;
    }

    private String getLocalizedLocation(String string) {
        String string2 = string;
        String string3 = HTMLUtils.getUrlStringFromLocation((String)LOCAL_HOST, (String)string);
        String string4 = HelpBrowserUtils.getQueryStringValue((String)string3, (String)"lang");
        if (string4 == null || !string4.equalsIgnoreCase("en")) {
            string2 = HelpUtils.getLocalizedFilename((String)string2);
        }
        return string2;
    }

    private boolean compareBaseUrls(String string, String string2) {
        String string3 = HtmlUtils.getBaseUrl((String)string);
        string3 = string3.replace('\\', '/');
        String string4 = HtmlUtils.getBaseUrl((String)string2);
        string4 = string4.replace('\\', '/');
        return string3.equalsIgnoreCase(string4);
    }

    static enum DisplayBehavior {
        OPEN_URL_IN_SYSTEM_BROWSER,
        OPEN_URL_IN_HELP_BROWSER,
        OPEN_CHANGED_URL_IN_HELP_BROWSER;

    }
}

