/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.html.BrowserRequest;
import com.mathworks.html.RequestHandler;
import com.mathworks.mde.help.MLHelpBrowser;
import com.mathworks.mde.help.UrlDisplayBehavior;
import com.mathworks.mlwidgets.html.LinkClickedHandler;
import javax.swing.SwingUtilities;

class InstalledLinkClickedHandler
implements LinkClickedHandler,
RequestHandler {
    private final MLHelpBrowser fMLHelpBrowser;

    InstalledLinkClickedHandler(MLHelpBrowser mLHelpBrowser) {
        this.fMLHelpBrowser = mLHelpBrowser;
    }

    public boolean handleRequest(BrowserRequest browserRequest) {
        if (!browserRequest.isTargetOnly() && browserRequest.getOrigin() == BrowserRequest.Origin.USER_INTERACTION) {
            return this.handleLinkClicked(browserRequest.getUrl(), false);
        }
        return false;
    }

    public void linkClicked(String string) {
        this.handleLinkClicked(string, true);
    }

    private boolean handleLinkClicked(String string, boolean bl) {
        UrlDisplayBehavior urlDisplayBehavior = new UrlDisplayBehavior(string);
        switch (urlDisplayBehavior.getDisplayBehavior()) {
            case OPEN_URL_IN_SYSTEM_BROWSER: {
                this.openInSystemBrowser(urlDisplayBehavior.getUrl());
                return true;
            }
            case OPEN_URL_IN_HELP_BROWSER: {
                if (bl) {
                    this.openInHelpBrowser(urlDisplayBehavior.getUrl());
                    return true;
                }
                return false;
            }
            case OPEN_CHANGED_URL_IN_HELP_BROWSER: {
                this.openInHelpBrowser(urlDisplayBehavior.getUrl());
                return true;
            }
        }
        return false;
    }

    void openInSystemBrowser(String string) {
        this.fMLHelpBrowser.openInSystemBrowser(string);
    }

    void openInHelpBrowser(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstalledLinkClickedHandler.this.fMLHelpBrowser.setCurrentLocation(string);
            }
        });
    }
}

