/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.help.HelpBrowser;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.help.ClassicHelpPanel;
import com.mathworks.mlwidgets.html.HTMLRendererActions;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SimpleDOMParser;
import com.mathworks.mwswing.SimpleElement;
import com.mathworks.services.Prefs;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.DropdownButton;
import com.mathworks.widgets.desk.ComponentIcon;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarFactory;
import com.mathworks.widgets.desk.DTToolBarInfo;
import com.mathworks.widgets.desk.DTToolBarRegistry;
import com.mathworks.widgets.desk.DTToolSet;
import com.mathworks.xml.XMLUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class HelpBrowserToolBar {
    private static final String TOOL_NAME_PREFIX = "help.";
    private static final String BACK = "back";
    private static final String FORWARD = "forward";
    private static final String RELOAD = "reload";
    private static final String PRINT = "print";
    private static final String FIND = "find";
    private static final String ADDRESS = "address";
    private static final String ACTIONS = "actions";
    private JToolBar fToolBar;
    private DTToolBarConfiguration fToolBarConfig;
    private DTToolBarInfo fToolBarInfo;
    private MouseListener fContextListener;
    private Insets fOriginalMargin;
    private Border fOriginalBorder;

    HelpBrowserToolBar(JComponent jComponent) {
        DTToolSet dTToolSet = HelpBrowserToolBar.createToolSet(jComponent);
        List<String> list = HelpBrowserToolBar.createVisibleKeysList();
        this.fToolBarConfig = new DTToolBarConfiguration(list);
        this.fToolBarInfo = new DTToolBarInfo("help", HelpUtils.getLocalizedString((String)"help.title"), dTToolSet, this.fToolBarConfig);
        this.fToolBar = DTToolBarFactory.createToolBar((DTToolBarInfo)this.fToolBarInfo, (DTToolBarConfiguration)this.fToolBarConfig, (Object)((Object)HelpBrowser.getInstance()));
        this.fOriginalMargin = this.fToolBar.getMargin();
        this.fOriginalBorder = this.fToolBar.getBorder();
        if (Matlab.isMatlabAvailable()) {
            MJPopupMenu mJPopupMenu = this.createCustomizePopup();
            this.fContextListener = HelpBrowserToolBar.createContextListener(mJPopupMenu);
            this.fToolBar.addMouseListener(this.fContextListener);
            MLDesktop.getInstance().getToolBarRegistry().register(this.fToolBarInfo.getKey(), (DTToolBarRegistry.Registrant)new HelpBrowserToolBarRegistrant());
        }
    }

    JToolBar getComponent() {
        return this.fToolBar;
    }

    void configureAsSubToolBar() {
        this.fToolBar.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.fToolBar.setMargin(new Insets(0, 0, 0, 0));
    }

    void configureAsStandalone() {
        this.fToolBar.setBorder(this.fOriginalBorder);
        this.fToolBar.setMargin(this.fOriginalMargin);
    }

    private static DTToolSet createToolSet(JComponent jComponent) {
        HelpBrowser helpBrowser = HelpBrowser.getInstance();
        HTMLRendererActions hTMLRendererActions = helpBrowser.getHelpPanel().getHTMLRenderer().getActions();
        DTToolSet dTToolSet = new DTToolSet();
        dTToolSet.add("help.back", (Action)hTMLRendererActions.fGoBackAction);
        dTToolSet.add("help.forward", (Action)hTMLRendererActions.fGoForwardAction);
        dTToolSet.add("help.reload", (Action)hTMLRendererActions.fReloadAction);
        dTToolSet.add("help.print", (Action)hTMLRendererActions.fPrintAction);
        dTToolSet.add("help.find", (Action)hTMLRendererActions.fFindAction);
        dTToolSet.add("help.actions", HelpUtils.getLocalizedString((String)"hb.toolbar.actions"), (Component)HelpBrowserToolBar.createActionButton(helpBrowser.getHelpPanel()), (Icon)DocumentIcon.ACTIONS.getIcon());
        dTToolSet.add("help.address", HelpUtils.getLocalizedString((String)"hb.toolbar.location"), (Component)jComponent, (Icon)ComponentIcon.COMBO_BOX.getIcon());
        return dTToolSet;
    }

    private static DropdownButton createActionButton(ClassicHelpPanel classicHelpPanel) {
        DropdownButton dropdownButton = new DropdownButton();
        if (PlatformInfo.isMacintosh()) {
            dropdownButton.setMargin(new Insets(5, 6, 6, 6));
        }
        dropdownButton.setIcon((Icon)DocumentIcon.ACTIONS.getIcon());
        dropdownButton.setDisabledIcon(UIManager.getLookAndFeel().getDisabledIcon((JComponent)dropdownButton, DocumentIcon.ACTIONS.getIcon()));
        dropdownButton.setToolTipText("Actions");
        dropdownButton.setName("HelpActionsButton");
        MJToolBar.configureButton((MJButton)dropdownButton);
        JPopupMenu jPopupMenu = dropdownButton.getPopupMenu();
        HTMLRendererActions hTMLRendererActions = classicHelpPanel.getHTMLRenderer().getActions();
        jPopupMenu.add((Action)hTMLRendererActions.fGoBackAction);
        jPopupMenu.add((Action)hTMLRendererActions.fGoForwardAction);
        jPopupMenu.add((Action)hTMLRendererActions.fReloadAction);
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)hTMLRendererActions.fPrintAction);
        jPopupMenu.add((Action)hTMLRendererActions.fFindAction);
        jPopupMenu.addSeparator();
        if (Matlab.isMatlabAvailable()) {
            jPopupMenu.add((Action)hTMLRendererActions.fEvalSelectionAction);
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add((Action)hTMLRendererActions.fViewSourceAction);
        return dropdownButton;
    }

    private static List<String> createVisibleKeysList() {
        Vector<String> vector = new Vector<String>();
        vector.add("help.back");
        vector.add("help.forward");
        vector.add("help.actions");
        vector.add("help.address");
        return vector;
    }

    private MJPopupMenu createCustomizePopup() {
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        mJPopupMenu.add((Action)new MJAbstractAction(ExplorerResources.getString((String)"toolbar.popup.customize")){

            public void actionPerformed(ActionEvent actionEvent) {
                MLDesktop.getInstance().showToolBarCustomizationPanel(HelpBrowserToolBar.this.fToolBarInfo.getKey());
            }
        });
        return mJPopupMenu;
    }

    private static MouseListener createContextListener(final MJPopupMenu mJPopupMenu) {
        return new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (MJUtilities.isMacintoshPopupTrigger((MouseEvent)mouseEvent) || !PlatformInfo.isMacintosh() && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    mJPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfig() {
        OutputStreamWriter outputStreamWriter = null;
        try {
            File file = HelpBrowserToolBar.getSavedConfigFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = this.fToolBarConfig.toXML(document, null);
            document.appendChild(element);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
            XMLUtils.serializeXML((Object)document, (Object)outputStreamWriter, (String)"utf-8");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DTToolBarConfiguration loadSavedConfig() {
        File file = HelpBrowserToolBar.getSavedConfigFile();
        DTToolBarConfiguration dTToolBarConfiguration = this.fToolBarConfig;
        BufferedReader bufferedReader = null;
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf-8"));
                SimpleDOMParser simpleDOMParser = new SimpleDOMParser();
                SimpleElement simpleElement = simpleDOMParser.parse((Reader)bufferedReader);
                dTToolBarConfiguration = new DTToolBarConfiguration(simpleElement);
                dTToolBarConfiguration = DTToolBarFactory.reconcile((DTToolSet)this.fToolBarInfo.getToolSet(), (DTToolBarConfiguration)dTToolBarConfiguration, (DTToolBarConfiguration)this.fToolBarConfig);
                fileInputStream.close();
            }
            catch (Exception exception) {
                dTToolBarConfiguration = this.fToolBarConfig;
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return dTToolBarConfiguration;
    }

    private static File getSavedConfigFile() {
        return new File(new File(Prefs.getPropertyDirectory()), "help_browser_toolbar.xml");
    }

    private class HelpBrowserToolBarRegistrant
    implements DTToolBarRegistry.Registrant {
        private HelpBrowserToolBarRegistrant() {
            this.updateToolBars(HelpBrowserToolBar.this.fToolBarInfo.getKey(), HelpBrowserToolBar.this.loadSavedConfig());
        }

        public String getToolBarLabel(String string) {
            return HelpBrowserToolBar.this.fToolBarInfo.getLabel();
        }

        public DTToolBarInfo getToolBarInfo(String string) {
            return HelpBrowserToolBar.this.fToolBarInfo;
        }

        public DTToolBarConfiguration getToolBarConfiguration(String string) {
            return HelpBrowserToolBar.this.fToolBarConfig;
        }

        public void updateToolBars(String string, DTToolBarConfiguration dTToolBarConfiguration) {
            HelpBrowserToolBar.this.fToolBarConfig = dTToolBarConfiguration;
            HelpBrowserToolBar.this.saveConfig();
            DTToolBarFactory.udpateToolBar((JToolBar)HelpBrowserToolBar.this.fToolBar, (DTToolSet)HelpBrowserToolBar.this.fToolBarInfo.getToolSet(), (DTToolBarConfiguration)dTToolBarConfiguration, (Object)((Object)HelpBrowser.getInstance()));
            for (int i = 0; i < HelpBrowserToolBar.this.fToolBar.getComponentCount(); ++i) {
                HelpBrowserToolBar.this.fToolBar.getComponent(i).removeMouseListener(HelpBrowserToolBar.this.fContextListener);
                if (!(HelpBrowserToolBar.this.fToolBar.getComponent(i) instanceof JButton)) continue;
                HelpBrowserToolBar.this.fToolBar.getComponent(i).addMouseListener(HelpBrowserToolBar.this.fContextListener);
            }
        }
    }
}

