/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.mde.help.DocCenterLocationPanel;
import com.mathworks.mde.help.DocCenterProductsPanel;
import com.mathworks.mde.help.HelpOnSelectionPanel;
import com.mathworks.mde.help.HelpPrefsComponentPanel;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.LanguagePrefsPanel;
import com.mathworks.mlwidgets.help.HelpPopup;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.JComponent;

class DocCenterPrefsPanel
implements HelpPrefsComponentPanel {
    private final MJPanel fPanel;
    private DocCenterLocationPanel fDocCenterLocationPanel;
    private final DocCenterProductsPanel fDocCenterProductsPanel;
    private final HelpOnSelectionPanel fHelpOnSelectionPanel;
    private LanguagePrefsPanel fLanguagePrefsPanel;

    DocCenterPrefsPanel() {
        boolean bl = HelpUtils.canOverrideDocLocale();
        this.fPanel = new MJPanel();
        this.fPanel.putClientProperty((Object)"mwjavaguitest.instance", (Object)this);
        this.fPanel.setName("DocCenterPrefsPanel");
        this.fPanel.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 4, 131072));
        if (HelpPrefs.isDocLocationOnWebSupported()) {
            this.fDocCenterLocationPanel = new DocCenterLocationPanel();
            this.fPanel.add((Component)this.fDocCenterLocationPanel.getComponent());
        }
        this.fDocCenterProductsPanel = new DocCenterProductsPanel();
        this.fPanel.add((Component)this.fDocCenterProductsPanel.getComponent());
        if (bl) {
            this.fLanguagePrefsPanel = new LanguagePrefsPanel();
            this.fPanel.add((Component)this.fLanguagePrefsPanel.getComponent());
        }
        this.fHelpOnSelectionPanel = new HelpOnSelectionPanel();
        this.fPanel.add((Component)this.fHelpOnSelectionPanel.getComponent());
    }

    @Override
    public void savePrefs() {
        if (this.fDocCenterLocationPanel != null) {
            HelpPrefs.setDocCenterLocation((String)this.fDocCenterLocationPanel.getSelectedLocation());
        }
        boolean bl = this.fDocCenterProductsPanel.getShowUninstalledProducts();
        HelpPrefs.saveSelectedDocCenterProducts((boolean)bl, (String)this.fDocCenterProductsPanel.getSelectedInstalledProducts(), (String)this.fDocCenterProductsPanel.getSelectedUninstalledProducts());
        if (this.fLanguagePrefsPanel != null) {
            HelpPrefs.setDocLocale((Locale)this.fLanguagePrefsPanel.getSelectedLocale());
        }
        HelpPopup.setShowHelpBrowserPreference((boolean)this.fHelpOnSelectionPanel.usingHelpBrowser());
    }

    @Override
    public void resetPrefs() {
        this.fDocCenterProductsPanel.resetSelectedProducts();
    }

    @Override
    public boolean validateOptions() {
        boolean bl = true;
        if (this.fDocCenterProductsPanel.isProductFilterEnabled() && this.fDocCenterProductsPanel.getSelectedInstalledProducts().length() == 0 && this.fDocCenterProductsPanel.getSelectedUninstalledProducts().length() == 0) {
            MJOptionPane.showMessageDialog((Component)this.fPanel, (Object)HelpUtils.getLocalizedString((String)"filter.selection_error"));
            bl = false;
        }
        return bl;
    }

    @Override
    public void dispose() {
        DocCenterProductsPanel.removeListeners();
        DocCenterLocationPanel.removeListeners();
    }

    public JComponent getComponent() {
        return this.fPanel;
    }
}

