/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.help.helpui.SearchHelper;
import com.mathworks.helpsearch.DocSearchEngineFactory;
import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductResolver;
import com.mathworks.helpsearch.suggestion.DocumentationSuggestionProvider;
import com.mathworks.helpsearch.suggestion.SearchEngineSuggestionProvider;
import com.mathworks.mde.help.DocCenterBrowserInvoker;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.suggestion.FullSuggestionRequest;
import com.mathworks.mlwidgets.help.DocCenterSearchHelper;
import com.mathworks.mlwidgets.help.DocCenterUtils;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchField;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.sections.ToolstripSections;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.ComponentBuilder;
import com.mathworks.widgets.SearchTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class DocCenterBrowserSearchBox
implements ComponentBuilder {
    private static final int SUGGESTION_POPUP_WIDTH = 450;
    private final int MAX_PER_GROUP = 5;
    private final JComponent fComponent = new SearchPanel();
    private final SearchTextField fSearchTextField;
    private PopupList fPopupList;

    public DocCenterBrowserSearchBox() {
        this.fComponent.putClientProperty("mwjavaguitest.instance", this);
        this.fComponent.setName("SearchComponent");
        this.fComponent.setLayout(new BorderLayout());
        this.fComponent.setOpaque(false);
        this.fSearchTextField = new SearchTextField(HelpUtils.getLocalizedString((String)"doccenter.web.search"));
        this.fSearchTextField.addSearchTextFieldListener((SearchTextField.Listener)new SearchActionListener());
        this.fSearchTextField.getComponent().setName("SearchField");
        this.fSearchTextField.enableFocusRelinquishing();
        this.fPopupList = new PopupList(new DefaultListModel()){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.fPopupList.setName("SuggestionPopupList");
        this.fPopupList.addListActionListener(new ListActionListener(){

            public void listItemSelected(ListActionEvent listActionEvent) {
                ListItem listItem = listActionEvent.getListItem();
                Action action = (Action)listItem.getAttributes().getAttribute(TSFactory.ACTION_ATTRIBUTE);
                if (action != null) {
                    DocCenterBrowserSearchBox.this.hideSuggestionPopup();
                    action.actionPerformed((ActionEvent)listActionEvent);
                }
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DocCenterBrowserSearchBox.this.isSuggestionPopupVisible()) {
                    DocCenterBrowserSearchBox.this.updateModel(DocCenterBrowserSearchBox.this.fSearchTextField.getSearchText());
                } else {
                    DocCenterBrowserSearchBox.this.fPopupList.requestFocus();
                    DocCenterBrowserSearchBox.this.fPopupList.setSelectedIndex(1);
                    DocCenterBrowserSearchBox.this.fPopupList.repaint();
                }
            }
        };
        String string = "DOWN";
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string);
        this.fSearchTextField.getComponent().getInputMap().put(keyStroke, "none");
        this.fComponent.getInputMap(1).put(keyStroke, string);
        this.fComponent.getActionMap().put(string, abstractAction);
        this.fComponent.setLayout(new BorderLayout());
        this.fComponent.add((Component)this.fSearchTextField.getComponent(), "Center");
        this.fComponent.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    protected SearchHelper getSearchHelper() {
        return DocCenterSearchHelper.getInstance();
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public DocumentationSuggestionProvider getSuggestionProvider() throws IOException {
        SearchHelper searchHelper = this.getSearchHelper();
        SearchConfig searchConfig = searchHelper.getSearchConfig();
        DocumentationSet documentationSet = searchHelper.getDocumentationSet();
        SearchEngine searchEngine = DocSearchEngineFactory.createSearchEngine((SearchConfig)searchConfig, (DocumentationSet)documentationSet);
        return new SearchEngineSuggestionProvider(searchEngine, (SearchField)DocumentationSearchField.BODY, (ProductResolver)documentationSet);
    }

    public Collection<InformationType> getTypesToSuggest() {
        return EnumSet.of(InformationType.FUNCTIONS, InformationType.SYSTEM_OBJECTS);
    }

    public void updateModel(final String string) {
        try {
            DefaultListModel defaultListModel;
            if (string.length() > 1) {
                FullSuggestionRequest fullSuggestionRequest = new FullSuggestionRequest(this.getSuggestionProvider(), this.getTypesToSuggest(), string, 5);
                defaultListModel = fullSuggestionRequest.getModel();
            } else {
                defaultListModel = new DefaultListModel();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DocCenterBrowserSearchBox.this.fSearchTextField.getSearchText().equals(string)) {
                        DocCenterBrowserSearchBox.this.fPopupList.setModel((ListModel)defaultListModel);
                        if (defaultListModel.isEmpty()) {
                            DocCenterBrowserSearchBox.this.hideSuggestionPopup();
                        } else {
                            DocCenterBrowserSearchBox.this.showSuggestionPopup();
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void hideSuggestionPopup() {
        if (!this.isSuggestionPopupVisible()) {
            Overlay overlay = (Overlay)this.fComponent.getClientProperty("PopupComponent");
            overlay.dispose();
            this.fSearchTextField.requestFocus();
            this.fComponent.putClientProperty("PopupComponent", null);
        }
    }

    private void showSuggestionPopup() {
        this.fPopupList.setFocusable(false);
        this.resetSuggestionPopupSize();
        if (this.isSuggestionPopupVisible()) {
            Overlay overlay = ToolstripSections.showPopup((JComponent)this.fComponent, (JComponent)this.fPopupList);
            this.fComponent.putClientProperty("PopupComponent", overlay);
        } else {
            OverlayManager overlayManager = OverlayManagers.get((Component)this.fPopupList);
            overlayManager.packOverlay((Component)this.fPopupList);
        }
        this.fPopupList.setFocusable(true);
    }

    public boolean isSuggestionPopupVisible() {
        Overlay overlay = (Overlay)this.fComponent.getClientProperty("PopupComponent");
        return overlay == null;
    }

    private void resetSuggestionPopupSize() {
        this.fPopupList.setPreferredSize(null);
        Dimension dimension = this.fPopupList.getPreferredSize();
        dimension.width = 450;
        this.fPopupList.setPreferredSize(dimension);
    }

    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        if (!string.equals(this.getText())) {
            this.fSearchTextField.setSearchText(string);
        }
    }

    public String getText() {
        return this.fSearchTextField.getSearchText();
    }

    private class SearchPanel
    extends MJPanel {
        private SearchPanel() {
        }

        public Dimension getPreferredSize() {
            int n = 22;
            if (PlatformInfo.isMacintosh()) {
                n = 28;
            }
            return new Dimension(198, n);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public boolean requestFocusInWindow() {
            DocCenterBrowserSearchBox.this.fSearchTextField.requestFocus();
            return true;
        }

        public boolean isFocusOwner() {
            return true;
        }
    }

    private class SearchActionListener
    implements SearchTextField.Listener {
        private SearchActionListener() {
        }

        public void search(String string) {
            if (string != null && string.length() > 0) {
                String string2 = DocCenterUtils.buildDocCenterSearchUrl((String)string);
                DocCenterBrowserSearchBox.this.hideSuggestionPopup();
                DocCenterBrowserInvoker.getInstance().setCurrentLocation(string2);
            }
        }

        public void searchTextChanged(final String string) {
            new Thread(){

                @Override
                public void run() {
                    DocCenterBrowserSearchBox.this.updateModel(string);
                }
            }.start();
        }

        public void searchCleared() {
        }
    }
}

