/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.functionbrowser;

import com.mathworks.mlwidgets.help.search.DocSearchResult;
import com.mathworks.mlwidgets.help.search.SearchCompletionObserver;
import com.mathworks.mlwidgets.help.search.SearchException;
import com.mathworks.mlwidgets.help.search.SearchResults;
import java.util.ArrayList;
import java.util.List;

class SearchObserverGroup {
    private final List<CancellableSearchObserver> fObserverArray = new ArrayList<CancellableSearchObserver>();

    SearchObserverGroup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CancellableSearchObserver addObserver(SearchCompletionObserver searchCompletionObserver) {
        if (searchCompletionObserver == null) {
            return null;
        }
        List<CancellableSearchObserver> list = this.fObserverArray;
        synchronized (list) {
            for (CancellableSearchObserver cancellableSearchObserver : this.fObserverArray) {
                if (cancellableSearchObserver.getObserver() != searchCompletionObserver) continue;
                return cancellableSearchObserver;
            }
            CancellableSearchObserver cancellableSearchObserver = new CancellableSearchObserver((SearchCompletionObserver<DocSearchResult>)searchCompletionObserver);
            this.fObserverArray.add(cancellableSearchObserver);
            return cancellableSearchObserver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        List<CancellableSearchObserver> list = this.fObserverArray;
        synchronized (list) {
            for (CancellableSearchObserver cancellableSearchObserver : this.fObserverArray) {
                cancellableSearchObserver.cancel();
            }
        }
    }

    int getObserverCount() {
        return this.fObserverArray.size();
    }

    class CancellableSearchObserver
    implements SearchCompletionObserver<DocSearchResult> {
        private volatile boolean fCancelled = false;
        private final SearchCompletionObserver<DocSearchResult> fObserver;

        public CancellableSearchObserver(SearchCompletionObserver<DocSearchResult> searchCompletionObserver) {
            this.fObserver = searchCompletionObserver;
        }

        SearchCompletionObserver getObserver() {
            return this.fObserver;
        }

        private void cancel() {
            this.fCancelled = true;
        }

        private boolean isCancelled() {
            return this.fCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completed() {
            List list = SearchObserverGroup.this.fObserverArray;
            synchronized (list) {
                SearchObserverGroup.this.fObserverArray.remove(this);
            }
        }

        public void searchComplete(SearchResults<DocSearchResult> searchResults) {
            this.completed();
            if (this.isCancelled()) {
                return;
            }
            this.fObserver.searchComplete(searchResults);
        }

        public void searchFailed(SearchException searchException) {
            this.completed();
            this.fObserver.searchFailed(searchException);
        }
    }
}

