/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.explorer;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.MenuSection;
import com.mathworks.mde.editor.plugins.matlab.EditorSaveRunAndPublishUtils;
import com.mathworks.mde.editor.plugins.matlab.RunMenuUtils;
import com.mathworks.mde.explorer.Explorer;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.data.RunConfiguration;
import com.mathworks.mlwidgets.dialog.PathChange;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.DynamicMenuContext;
import com.mathworks.mlwidgets.explorer.model.actions.DynamicMenuContributor;
import com.mathworks.mlwidgets.explorer.model.actions.DynamicMenuUtils;
import com.mathworks.mlwidgets.explorer.model.editorfs.EditorFileSystem;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.widgets.PopupMenuCustomizer;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JPopupMenu;

final class RunConfigurationUtils {
    private static final MenuSection MAIN_SECTION = new MenuSection("mainRunConfigurationSection");

    private RunConfigurationUtils() {
    }

    static MenuSection[] getSections() {
        return new MenuSection[]{MAIN_SECTION};
    }

    static Comparator<MenuSection> getSectionComparator() {
        return new Comparator<MenuSection>(){

            @Override
            public int compare(MenuSection menuSection, MenuSection menuSection2) {
                return Arrays.asList(RunConfigurationUtils.getSections()).indexOf(menuSection) - Arrays.asList(RunConfigurationUtils.getSections()).indexOf(menuSection2);
            }
        };
    }

    static DynamicMenuContributor<FileSystemEntry> getMenuContributor() {
        return new DynamicMenuContributor<FileSystemEntry>(){

            public void contribute(DynamicMenuContext<FileSystemEntry> dynamicMenuContext) {
                if (((FileSystemEntry[])dynamicMenuContext.getContext())[0].isReal()) {
                    List list = RunConfigurationUtils.getConfigurations(((FileSystemEntry[])dynamicMenuContext.getContext())[0]);
                    for (RunConfiguration runConfiguration : list) {
                        dynamicMenuContext.addComponent(MAIN_SECTION, (Component)((Object)new RunMenuItem(runConfiguration)));
                    }
                }
            }
        };
    }

    static PopupMenuCustomizer getPopupMenuCustomizer(final FileTable fileTable) {
        return new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                ArrayList<DynamicMenuContributor<FileSystemEntry>> arrayList = new ArrayList<DynamicMenuContributor<FileSystemEntry>>();
                arrayList.add(RunConfigurationUtils.getMenuContributor());
                DynamicMenuUtils.updateMenu((JPopupMenu)jPopupMenu, arrayList, (Object[])fileTable.getSelectedItems().toArray(new FileSystemEntry[fileTable.getSelectedItems().size()]), RunConfigurationUtils.getSectionComparator(), (MenuSection[])RunConfigurationUtils.getSections());
            }
        };
    }

    static void runDefaultConfiguration(File file) {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        RunConfiguration runConfiguration = (RunConfiguration)configurationManager.getMostRecentlyActionedConfigurationForFileOrDefault(file, RunConfiguration.TYPE, true, false);
        RunConfigurationUtils.run(runConfiguration);
    }

    static boolean isFileDirty(File file) {
        return EditorFileSystem.getInstance().isDirty(new FileLocation(file));
    }

    static boolean isAnyFileDirty(ActionInput actionInput) {
        for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
            if (!fileSystemEntry.isReal() || !RunConfigurationUtils.isFileDirty(fileSystemEntry.getLocation().toFile())) continue;
            return true;
        }
        return false;
    }

    static void run(final RunConfiguration runConfiguration) {
        ConfigurationManager.getInstance().setMostRecentlyActionedConfigurationForFile((AbstractFileConfiguration)runConfiguration);
        final File file = runConfiguration.getAssociatedFile();
        new PathChange(WindowUtils.getFrameForComponent((Component)((Object)Explorer.getInstance())), Explorer.I18N_NAME, ExplorerResources.getString((String)"msg.ToRun"), file.getAbsolutePath(), file, new CompletionObserver(){

            public void completed(int n, Object object) {
                if (RunConfigurationUtils.isFileDirty(file)) {
                    Editor editor = MLEditorServices.getEditorApplication().getEditor((StorageLocation)new FileStorageLocation(file));
                    EditorSaveRunAndPublishUtils.saveFileAndDoConfigurationAction(editor, (AbstractFileConfiguration)runConfiguration, runConfiguration.getType(), null);
                } else {
                    ConfigurationManager.getInstance().doConfigurationAction((AbstractFileConfiguration)runConfiguration, (Component)((Object)Explorer.getInstance()));
                }
            }
        }, "matlab_env_csh", true);
    }

    private static List<RunConfiguration> getConfigurations(FileSystemEntry fileSystemEntry) {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        ArrayList<RunConfiguration> arrayList = new ArrayList<RunConfiguration>();
        if (fileSystemEntry.isReal()) {
            File file = new File(fileSystemEntry.getLocation().toString());
            List<RunConfiguration> list = RunMenuUtils.getConfigurationsStartingWithMostRecentlyUsed((List<RunConfiguration>)configurationManager.getConfigurationsForFile(file, RunConfiguration.TYPE), file);
            arrayList.addAll(list);
        }
        if (arrayList.isEmpty()) {
            arrayList.add((RunConfiguration)configurationManager.getDefaultConfigurationForFile(new File(fileSystemEntry.getLocation().toString()), RunConfiguration.TYPE, true));
        }
        return arrayList;
    }

    private static boolean isDefault(RunConfiguration runConfiguration) {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        RunConfiguration runConfiguration2 = (RunConfiguration)configurationManager.getMostRecentlyActionedConfigurationForFile(runConfiguration.getAssociatedFile(), RunConfiguration.TYPE);
        RunConfiguration runConfiguration3 = (RunConfiguration)configurationManager.getDefaultConfigurationForFile(runConfiguration.getAssociatedFile(), RunConfiguration.TYPE, false);
        return runConfiguration2 != null && runConfiguration2.equals((Object)runConfiguration) || runConfiguration2 == null && runConfiguration3 != null && runConfiguration3.equals((Object)runConfiguration) || configurationManager.getConfigurationsForFile(runConfiguration.getAssociatedFile(), RunConfiguration.TYPE).isEmpty();
    }

    private static class EditConfigurationsAction
    extends MJAbstractAction {
        private final File fFile;

        EditConfigurationsAction(File file) {
            super(ExplorerResources.getString((String)"context.run.configurations.edit"));
            this.fFile = file;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditorSaveRunAndPublishUtils.showConfigurationEditor(this.fFile, RunConfiguration.TYPE);
        }
    }

    private static class RunMenuItem
    extends MJMenuItem {
        RunMenuItem(final RunConfiguration runConfiguration) {
            super(runConfiguration.getMatlabExpressionToRun());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RunConfigurationUtils.run(runConfiguration);
                }
            });
        }
    }
}

