/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.matlab;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorSyntaxHighlighting;
import com.mathworks.mde.editor.EditorOptions;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.text.AbstractEditorLanguagePanel;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.matlab.MatlabFunctionIndentingScheme;
import com.mathworks.widgets.text.matlab.comment.CommentWrappingPreferences;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.MSyntaxHighlighting;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightPrefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class MPreferencesPanel
extends AbstractEditorLanguagePanel {
    public static final String MAX_COMMENT_WIDTH_SPINNER_NAME = "MaxWidthSpinner";
    public static final String VARIABLE_QUICK_RENAME_NAME = "VariableQuickRename";
    public static final String AUTOWRAP_COMMENTS_CHECKBOX_NAME = "AutowrapCommentsCheckBox";
    public static final String FUNCTION_INDENTING_COMBOBOX_NAME = "FunctionIndentingComboBox";
    public static final String START_AT_COMMENT_RADIOBUTTON_NAME = "StartAtCommentRadioButton";
    public static final String START_AT_LINE_RADIOBUTTON_NAME = "StartAtLineRadioButton";
    public static final String COLOR_PREFS_HYPERLINK_NAME = "ColorPrefLink";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(MPreferencesPanel.class.getPackage().getName() + ".resources.RES_matlab");
    private static final ResourceBundle PREFS_BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private static final int MIN_COMMENT_WIDTH = 1;
    private static final int MAX_COMMENT_WIDTH = 500;
    private static final int MAX_COMMENT_STEP = 5;
    private MJComboBox fFunctionComboBox;
    private MJSpinner fMaxCommentWidthSpinner;
    private MJRadioButton fStartAtLineRadioButton;
    private MJRadioButton fStartAtCommentRadioButton;
    private MJCheckBox fAutowrapCheckbox;
    private MJCheckBox fVariableQuickRename;

    public void build() {
        this.fMaxCommentWidthSpinner = MPreferencesPanel.createMaxWidthSpinner();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.fStartAtLineRadioButton = MPreferencesPanel.createMaxWidthStartAtLineRadioButton(buttonGroup);
        this.fStartAtCommentRadioButton = MPreferencesPanel.createMaxWidthStartAtCommentRadioButton(buttonGroup);
        this.fFunctionComboBox = MPreferencesPanel.createFunctionIndentComboBox();
        this.fAutowrapCheckbox = MPreferencesPanel.createAutoWrapCheckBox();
        this.setSyntaxHighlightingComponent(MPreferencesPanel.createColorPreferencesHyperlink());
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(BUNDLE.getString("prefs.commentFormatting"), this.createCommentFormattingSection());
        hashMap.put(BUNDLE.getString("prefs.refactoringSupport"), this.createRefactoringSection());
        this.setAdditionalSections(hashMap);
        this.setAdditionalSmartIndentingComponent(this.createFunctionIndentingFormatSection());
    }

    private static JComponent createColorPreferencesHyperlink() {
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(BUNDLE.getString("prefs.setColors"), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                MLPrefsDialogServices.showPrefsDialog((String)PREFS_BUNDLE.getString("area.colors"));
            }
        });
        hyperlinkTextLabel.getComponent().setName(COLOR_PREFS_HYPERLINK_NAME);
        return hyperlinkTextLabel.getComponent();
    }

    private JComponent createCommentFormattingSection() {
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("2dlu, pref, 3dlu, pref, 3dlu, pref", "pref, pref, 3dlu, pref"));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(BUNDLE.getString("prefs.maxWidth"), cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.fMaxCommentWidthSpinner, cellConstraints.xy(4, 1));
        panelBuilder.add((Component)this.fStartAtLineRadioButton, cellConstraints.xy(6, 1));
        panelBuilder.add((Component)this.fStartAtCommentRadioButton, cellConstraints.xy(6, 2));
        panelBuilder.add((Component)this.fAutowrapCheckbox, cellConstraints.xyw(1, 4, 6));
        return panelBuilder.getPanel();
    }

    private JComponent createRefactoringSection() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fVariableQuickRename = new MJCheckBox(BUNDLE.getString("prefs.VariableQuickRename"), VariableHighlightPrefs.isVariableQuickRename());
        this.fVariableQuickRename.setName(VARIABLE_QUICK_RENAME_NAME);
        mJPanel.add((Component)this.fVariableQuickRename, (Object)"West");
        return mJPanel;
    }

    private static MJRadioButton createMaxWidthStartAtLineRadioButton(ButtonGroup buttonGroup) {
        MJRadioButton mJRadioButton = new MJRadioButton(BUNDLE.getString("prefs.startFromLine"));
        mJRadioButton.setName(START_AT_LINE_RADIOBUTTON_NAME);
        mJRadioButton.setSelected(!CommentWrappingPreferences.isWrapFromStartOfComment());
        buttonGroup.add((AbstractButton)mJRadioButton);
        return mJRadioButton;
    }

    private static MJRadioButton createMaxWidthStartAtCommentRadioButton(ButtonGroup buttonGroup) {
        MJRadioButton mJRadioButton = new MJRadioButton(BUNDLE.getString("prefs.startFromComment"));
        mJRadioButton.setName(START_AT_COMMENT_RADIOBUTTON_NAME);
        mJRadioButton.setSelected(CommentWrappingPreferences.isWrapFromStartOfComment());
        buttonGroup.add((AbstractButton)mJRadioButton);
        return mJRadioButton;
    }

    private static MJSpinner createMaxWidthSpinner() {
        MJSpinner mJSpinner = new MJSpinner((SpinnerModel)new SpinnerNumberModel(CommentWrappingPreferences.getMaximumCommentWidth(), 1, 500, 5));
        mJSpinner.setDefaultEditorAccessibleName("Maximum comment width spinner");
        mJSpinner.setName(MAX_COMMENT_WIDTH_SPINNER_NAME);
        return mJSpinner;
    }

    private static MJCheckBox createAutoWrapCheckBox() {
        MJCheckBox mJCheckBox = new MJCheckBox(BUNDLE.getString("prefs.autoWrapComments"), CommentWrappingPreferences.isAutowrappingComments());
        mJCheckBox.setName(AUTOWRAP_COMMENTS_CHECKBOX_NAME);
        return mJCheckBox;
    }

    private JComponent createFunctionIndentingFormatSection() {
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("2dlu, pref, 3dlu, pref", "pref"));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(BUNDLE.getString("prefs.functionIndentingFormat"), cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.fFunctionComboBox, cellConstraints.xy(4, 1));
        return panelBuilder.getPanel();
    }

    private static MJComboBox createFunctionIndentComboBox() {
        MJComboBox mJComboBox = new MJComboBox((Object[])MatlabFunctionIndentingScheme.values());
        mJComboBox.getAccessibleContext().setAccessibleName("Function indenting format");
        mJComboBox.setName(FUNCTION_INDENTING_COMBOBOX_NAME);
        mJComboBox.setSelectedItem((Object)EditorOptions.getMatlabIndentingScheme());
        return mJComboBox;
    }

    public MWKit getModifiableKit() {
        return null;
    }

    public String getSampleCode() {
        return null;
    }

    public EditorSyntaxHighlighting getSyntaxHighlighting() {
        return MSyntaxHighlighting.INSTANCE;
    }

    public EditorLanguage getLanguage() {
        return MLanguage.INSTANCE;
    }

    public void commit() {
        super.commit();
        EditorOptions.setMatlabIndentingScheme((MatlabFunctionIndentingScheme)this.fFunctionComboBox.getSelectedItem());
        CommentWrappingPreferences.setMaximumCommentWidth((int)((Integer)this.fMaxCommentWidthSpinner.getValue()));
        CommentWrappingPreferences.setAutowrappingComments((boolean)this.fAutowrapCheckbox.isSelected());
        CommentWrappingPreferences.setWrapFromStartOfComment((boolean)this.fStartAtCommentRadioButton.isSelected());
        VariableHighlightPrefs.setVariableQuickRename((this.fVariableQuickRename != null && this.fVariableQuickRename.isSelected() ? 1 : 0) != 0);
    }
}

