/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.breakpoints;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.debug.DebugListener;
import com.mathworks.matlab.api.debug.Debugger;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.breakpoints.DebugAdapter;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpoint;
import com.mathworks.mde.editor.breakpoints.MatlabBreakpointUtils;
import com.mathworks.mde.editor.breakpoints.MatlabDebugInterestNotifier;
import com.mathworks.mlservices.MatlabDebugServices;
import com.mathworks.util.FileUtils;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.glazedlists.DisposableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.Validate;

public class MatlabDebugger
implements Debugger<MatlabBreakpoint, File> {
    private final MatlabDebugInterestNotifier fDebugInterestNotifier;
    private final List<Runnable> fQueuedMatlabOperations = new Vector<Runnable>();
    private boolean fInterestsRegisteredAndQueueFlushed = false;
    private EventList<MatlabBreakpoint> fBreakpoints = GlazedLists.threadSafeList((EventList)new SortedList((EventList)new BasicEventList(), BREAKPOINT_COMPARATOR));
    private static final Comparator<MatlabBreakpoint> BREAKPOINT_COMPARATOR = MatlabDebugger.createBreakpointComparator();

    public MatlabDebugger() {
        this.fDebugInterestNotifier = new MatlabDebugInterestNotifier(this.createRegistrationListener());
        this.fDebugInterestNotifier.addDebugListener(this.createDebugListener());
    }

    public void dispose() {
        this.fDebugInterestNotifier.dispose();
    }

    private MatlabDebugInterestNotifier.RegistrationListener createRegistrationListener() {
        return new MatlabDebugInterestNotifier.RegistrationListener(){

            @Override
            public void registrationComplete() {
                MatlabDebugger.this.populateBreakpointsListFromMatlab();
                MatlabDebugger.this.flushQueuedMatlabOperations();
            }
        };
    }

    private synchronized void flushQueuedMatlabOperations() {
        for (Runnable runnable : this.fQueuedMatlabOperations) {
            runnable.run();
        }
        this.fQueuedMatlabOperations.clear();
        this.fInterestsRegisteredAndQueueFlushed = true;
    }

    private void runOrQueueMatlabOperationEvalConsoleOutput(final String string) {
        this.runOrQueueMatlabOperation(new Runnable(){

            @Override
            public void run() {
                EditorUtils.getMatlab().evalConsoleOutput(string);
            }
        });
    }

    private void runOrQueueMatlabOperation(final String string, final Object[] objectArray, final CompletionObserver completionObserver) {
        this.runOrQueueMatlabOperation(new Runnable(){

            @Override
            public void run() {
                EditorUtils.getMatlab().feval(string, objectArray, completionObserver);
            }
        });
    }

    private synchronized void runOrQueueMatlabOperation(Runnable runnable) {
        if (this.fInterestsRegisteredAndQueueFlushed) {
            runnable.run();
        } else {
            this.fQueuedMatlabOperations.add(runnable);
        }
    }

    public void addDebugListener(DebugListener<MatlabBreakpoint> debugListener) {
        this.fDebugInterestNotifier.addDebugListener(debugListener);
    }

    public void removeDebugListener(DebugListener<MatlabBreakpoint> debugListener) {
        this.fDebugInterestNotifier.removeDebugListener(debugListener);
    }

    public DisposableList<MatlabBreakpoint> getBreakpoints() {
        return new DisposableList(GlazedLists.readOnlyList(this.fBreakpoints), new TransformedList[0]);
    }

    public DisposableList<MatlabBreakpoint> getBreakpoints(File file) {
        DisposableList<MatlabBreakpoint> disposableList = this.getBreakpoints();
        FilterList<MatlabBreakpoint> filterList = MatlabBreakpointUtils.createFilterList(disposableList, file);
        return new DisposableList(filterList, new TransformedList[]{disposableList});
    }

    public void setBreakpoint(MatlabBreakpoint matlabBreakpoint, CompletionObserver completionObserver) {
        Validate.notNull((Object)matlabBreakpoint, (String)"The given breakpoint cannot be null.");
        String string = MatlabBreakpointUtils.convertFileToStringPath(matlabBreakpoint.getFile());
        String string2 = "internal.matlab.desktop.editor.setBreakpoint";
        Object[] objectArray = new Object[]{string, matlabBreakpoint};
        this.runOrQueueMatlabOperation(string2, objectArray, completionObserver);
    }

    public void clearBreakpoint(MatlabBreakpoint matlabBreakpoint) {
        Validate.notNull((Object)matlabBreakpoint, (String)"The given breakpoint cannot be null.");
        String string = MatlabBreakpointUtils.convertFileToStringPath(matlabBreakpoint.getFile());
        String string2 = "builtin('dbclear','" + StringUtils.quoteSingleQuotes((String)string) + "', '" + matlabBreakpoint.getOneBasedLineNumber() + MatlabBreakpointUtils.createAnonymousTag(matlabBreakpoint.getAnonymousIndex()) + "')";
        this.runOrQueueMatlabOperationEvalConsoleOutput(string2);
    }

    public void continueExecution() {
        this.runOrQueueMatlabOperation(new Runnable(){

            @Override
            public void run() {
                MatlabDebugServices.dbCommandNoEcho((int)4);
            }
        });
    }

    public void clearAndSet(Collection<MatlabBreakpoint> collection, File file, CompletionObserver completionObserver) {
        Validate.notNull(collection, (String)"The given breakpoints list cannot be null.");
        MatlabDebugger.validateBreakpointsAllAssociatedWithFile(collection, file);
        Validate.notNull((Object)file, (String)"The given file cannot be null.");
        String string = MatlabBreakpointUtils.convertFileToStringPath(file);
        String string2 = "internal.matlab.desktop.editor.clearAndSetBreakpointsForFile";
        Object[] objectArray = new Object[]{string, collection};
        this.runOrQueueMatlabOperation(string2, objectArray, completionObserver);
    }

    private void populateBreakpointsListFromMatlab() {
        String string = "internal.matlab.desktop.editor.breakpointsForAllFiles";
        this.runOrQueueMatlabOperation(string, null, this.createBreakpointsForAllFilesCompletionObserver());
    }

    private CompletionObserver createBreakpointsForAllFilesCompletionObserver() {
        return new CompletionObserver(){

            public void completed(int n, Object object) {
                assert (Matlab.getExecutionStatus((int)n) == 0) : "It should not be possible for this function to fail.";
                assert (MatlabDebugger.this.fBreakpoints.isEmpty()) : "The internal list of breakpoints should be empty.";
                List list = (List)object;
                MatlabDebugger.this.fBreakpoints.addAll((Collection)list);
            }
        };
    }

    private DebugListener<MatlabBreakpoint> createDebugListener() {
        return new DebugAdapter<MatlabBreakpoint>(){

            @Override
            public void breakpointsCleared() {
                MatlabDebugger.this.fBreakpoints.clear();
            }

            @Override
            public void breakpointsAdded(Collection<MatlabBreakpoint> collection) {
                MatlabDebugger.this.doAddOrUpdateBreakpoints(collection);
            }

            @Override
            public void breakpointsRemoved(Collection<MatlabBreakpoint> collection) {
                MatlabDebugger.this.doBreakpointsRemoved(collection);
            }
        };
    }

    private void doAddOrUpdateBreakpoints(Collection<MatlabBreakpoint> collection) {
        for (MatlabBreakpoint matlabBreakpoint : collection) {
            int n = Collections.binarySearch(this.fBreakpoints, matlabBreakpoint, BREAKPOINT_COMPARATOR);
            if (n >= 0) {
                this.fBreakpoints.set(n, (Object)matlabBreakpoint);
                continue;
            }
            this.fBreakpoints.add((Object)matlabBreakpoint);
        }
    }

    private void doBreakpointsRemoved(Collection<MatlabBreakpoint> collection) {
        for (MatlabBreakpoint matlabBreakpoint : collection) {
            int n = Collections.binarySearch(this.fBreakpoints, matlabBreakpoint, BREAKPOINT_COMPARATOR);
            if (n < 0) continue;
            this.fBreakpoints.remove(n);
        }
    }

    private static Comparator<MatlabBreakpoint> createBreakpointComparator() {
        return new Comparator<MatlabBreakpoint>(){

            @Override
            public int compare(MatlabBreakpoint matlabBreakpoint, MatlabBreakpoint matlabBreakpoint2) {
                int n = matlabBreakpoint.getFile().getPath().compareTo(matlabBreakpoint2.getFile().getPath());
                int n2 = Integer.valueOf(matlabBreakpoint.getZeroBasedLineNumber()).compareTo(matlabBreakpoint2.getZeroBasedLineNumber());
                int n3 = Integer.valueOf(matlabBreakpoint.getAnonymousIndex()).compareTo(matlabBreakpoint2.getAnonymousIndex());
                if (n != 0) {
                    return n;
                }
                if (n2 != 0) {
                    return n2;
                }
                return n3;
            }
        };
    }

    private static void validateBreakpointsAllAssociatedWithFile(Collection<MatlabBreakpoint> collection, File file) {
        for (MatlabBreakpoint matlabBreakpoint : collection) {
            Validate.isTrue((boolean)FileUtils.areFilesTheSame((File)file, (File)matlabBreakpoint.getFile()), (String)"The breakpoint does not have the expected file.");
        }
    }
}

