/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.breakpoints;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.services.message.MWMessage;
import com.mathworks.util.Log;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang.Validate;

class MatlabDebugInterestRegistrant {
    private final CountDownLatch fCountDownLatch = new CountDownLatch(1);
    private final MessageHandler fHandler;
    private final MatlabMCR fMatlab = new MatlabMCR();
    private final Object fUnregistrationCookie;

    MatlabDebugInterestRegistrant(EventType eventType, MessageHandler messageHandler) {
        Validate.notNull((Object)((Object)eventType), (String)"The event type cannot be null.");
        Validate.notNull((Object)messageHandler, (String)"The handler cannot be null.");
        Validate.isTrue((boolean)Matlab.isMatlabAvailable(), (String)"MATLAB must be available.");
        this.fUnregistrationCookie = this.fMatlab.registerInterest(1, eventType.getMatlabEventId(), this.createCompletionObserver());
        this.fHandler = messageHandler;
    }

    private CompletionObserver createCompletionObserver() {
        return new CompletionObserver(){

            public void completed(int n, Object object) {
                MWMessage mWMessage = (MWMessage)object;
                if (MatlabDebugInterestRegistrant.isRegistrationAcknowledgementMessage(mWMessage)) {
                    MatlabDebugInterestRegistrant.this.fCountDownLatch.countDown();
                } else {
                    MatlabDebugInterestRegistrant.this.fHandler.handleMessage(mWMessage);
                }
            }
        };
    }

    public void dispose() {
        this.fMatlab.unregisterInterest(this.fUnregistrationCookie);
    }

    public synchronized void waitForRegistration() {
        try {
            this.fCountDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Log.logException((Exception)interruptedException);
        }
    }

    private static boolean isRegistrationAcknowledgementMessage(MWMessage mWMessage) {
        assert (mWMessage != null) : "The given MWMessage cannot be null.";
        return (Integer)mWMessage.get((Object)"eventid") == -8;
    }

    public static enum EventType {
        BREAKPOINT_HIT(0x4000000),
        BREAKPOINT_ADDED(Integer.MIN_VALUE),
        BREAKPOINT_REMOVED(0x20000000),
        BREAKPOINTS_CLEARED(0x40000000);

        private final int fMatlabEventId;

        private EventType(int n2) {
            this.fMatlabEventId = n2;
        }

        private int getMatlabEventId() {
            return this.fMatlabEventId;
        }
    }

    public static interface MessageHandler {
        public void handleMessage(MWMessage var1);
    }
}

