/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.editor.DialogFactory;
import com.mathworks.mde.editor.EditorOptions;
import com.mathworks.mde.editor.EditorUiUtils;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.PopupAction;
import com.mathworks.mde.editor.codepad.Codepad;
import com.mathworks.mwswing.TextComponentUtils;
import com.mathworks.util.ArrayUtils;
import com.mathworks.util.Log;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.SyntaxTextPaneUtilities;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.text.DocumentUtils;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.STPModelInterface;
import com.mathworks.widgets.text.STPViewInterface;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.MTree;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.JumpList;

public class EditorViewUtils {
    public static final String NO_FUNCTIONS_FOUND = EditorUtils.lookup("menuitem.Nofunctionsfound");

    private EditorViewUtils() {
    }

    static int boundAndShiftLineNumber(STPInterface sTPInterface, int n) {
        int n2 = Math.max(1, n);
        return Math.min(n2, sTPInterface.getNumLines()) - 1;
    }

    static int boundPosition(STPInterface sTPInterface, int n) {
        return Math.min(sTPInterface.getLength(), Math.max(n, 0));
    }

    public static void goToLine(STPInterface sTPInterface, int n) {
        EditorViewUtils.goToLine(sTPInterface, n, false);
    }

    public static void goToLine(STPInterface sTPInterface, int n, boolean bl) {
        try {
            int n2 = EditorViewUtils.boundAndShiftLineNumber(sTPInterface, n);
            int n3 = DocumentUtils.getLineStartAfterWhitespace((BaseDocument)((BaseDocument)sTPInterface.getDocument()), (int)n2);
            int n4 = bl ? sTPInterface.getLineEndNoEOL(n2) : n3;
            sTPInterface.selectAndCenterIfNotVisible(n4, n3);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    public static void goToPositionAndHighlight(STPInterface sTPInterface, int n, int n2) {
        sTPInterface.selectAndCenterIfNotVisible(n2, n);
    }

    public static void goToLine(STPInterface sTPInterface, int n, int n2) {
        Validate.isTrue((n >= 0 ? 1 : 0) != 0, (String)"The given line number cannot be less than zero.");
        try {
            int n3 = EditorViewUtils.boundAndShiftLineNumber(sTPInterface, n);
            int n4 = n2 >= 1 ? n2 - 1 : 0;
            int n5 = sTPInterface.getLineStart(n3);
            int n6 = sTPInterface.getLineEndNoEOL(n3);
            int n7 = Math.min(n6, n5 + n4);
            sTPInterface.selectAndCenterIfNotVisible(n7, n7);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    public static int[] getMFunctionLinePositions(STPInterface sTPInterface) {
        return SyntaxTextPaneUtilities.isMCode((STPInterface)sTPInterface) ? MDocumentUtils.getZeroBasedLineNumbersOfFunctions((BaseDocument)((BaseDocument)sTPInterface.getDocument())) : ArrayUtils.EmptyPrimitives.INT;
    }

    public static void openSelection(STPInterface sTPInterface, StorageLocation storageLocation, Frame frame) {
        String string = EditorViewUtils.getSelectionOrIdentifierFromCaretLoc(sTPInterface, frame, "error.selectionNewlineErrorOpen");
        if (string == null) {
            return;
        }
        JumpList.checkAddEntry((JTextComponent)sTPInterface.getActiveTextComponent(), (int)sTPInterface.getCaretPosition());
        int[] nArray = EditorViewUtils.getMFunctionLinePositions(sTPInterface);
        for (int i = 0; i != nArray.length; ++i) {
            if (!EditorUtils.getFunctionName((STPModelInterface)sTPInterface, nArray[i]).equals(string)) continue;
            EditorViewUtils.goToLine(sTPInterface, nArray[i] + 1);
            return;
        }
        String string2 = StringUtils.quoteSingleQuotes((String)string);
        if (storageLocation instanceof FileStorageLocation && EditorViewUtils.doesFileExistInPrivateDirectory(((FileStorageLocation)storageLocation).getFile().getParentFile(), string)) {
            String string3 = EditorViewUtils.buildPrivatePath(StringUtils.quoteSingleQuotes((String)((FileStorageLocation)storageLocation).getFile().getParent()), string);
            EditorUtils.getMatlab().eval("try open('" + string3 + "'); catch " + "try open('" + string2 + "'); catch edit('" + string2 + "'); end" + ";end;", EditorUtils.getShowErrorDialogCompletionObserver(frame));
        } else {
            EditorUtils.getMatlab().eval("try, open('" + string2 + "'); catch, edit('" + string2 + "'); end", EditorUtils.getShowErrorDialogCompletionObserver(frame));
        }
    }

    private static boolean doesFileExistInPrivateDirectory(File file, String string) {
        assert (file != null) : "File cannot be null";
        File file2 = new File(EditorViewUtils.buildPrivatePath(file.getAbsolutePath(), string));
        return file2.exists() && file2.isFile();
    }

    private static String buildPrivatePath(String string, String string2) {
        String string3;
        String string4 = string3 = string.endsWith("private") ? string + File.separator + string2 : string + File.separator + "private" + File.separator + string2;
        if (!MLFileUtils.isMFile((String)string3)) {
            string3 = string3 + ".m";
        }
        return string3;
    }

    public static String getSelectionOrIdentifierFromCaretLoc(STPInterface sTPInterface, Component component, String string) {
        String string2 = sTPInterface.getSelectedText() == null || sTPInterface.getSelectedText().length() == 0 ? TextComponentUtils.getFunctionAtCaret((JTextComponent)sTPInterface.getActiveTextComponent(), (boolean)true) : sTPInterface.getSelectedText();
        string2 = EditorViewUtils.checkForNewlines(string2, component, string);
        return string2;
    }

    public static String checkForNewlines(String string, Component component, String string2) {
        if (string == null) {
            return string;
        }
        while (string.startsWith("\n")) {
            string = string.substring(string.indexOf(10) + 1);
        }
        while (string.endsWith("\n")) {
            string = string.substring(0, string.lastIndexOf(10));
        }
        if (string.contains("\n")) {
            if (component != null) {
                DialogFactory.showErrorMessage(component, EditorUtils.lookup(string2));
            }
            return null;
        }
        return string;
    }

    public static void addEndOfFileNewLineIfNecessary(STPInterface sTPInterface) {
        boolean bl;
        boolean bl2 = bl = EditorOptions.isAutoTerminateLastLine() && !sTPInterface.getText().endsWith(sTPInterface.getTerminator());
        if (bl) {
            try {
                int n = sTPInterface.getSelectionDot();
                int n2 = sTPInterface.getSelectionMark();
                sTPInterface.insert(sTPInterface.getLength(), sTPInterface.getTerminator());
                if (sTPInterface.getSelectionDot() != n) {
                    sTPInterface.getCaret().setDot(n2);
                    if (n != n2) {
                        sTPInterface.getCaret().moveDot(n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
        }
    }

    public static Object[] getCellTitles(Codepad codepad, int[] nArray) {
        Object[] objectArray = codepad.getCellTitles(nArray);
        int n = 0;
        while (n != nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] + 1;
        }
        return objectArray;
    }

    public static void showGotoDialog(Editor editor, Codepad codepad) {
        int[] nArray = ArrayUtils.EmptyPrimitives.INT;
        Object[] objectArray = ArrayUtils.EmptyObjects.STRING;
        if (codepad != null && (nArray = codepad.getExplicitCellStartLines()).length > 0) {
            objectArray = EditorViewUtils.getCellTitles(codepad, nArray);
        }
        BaseDocument baseDocument = (BaseDocument)editor.getDocument();
        int[] nArray2 = ArrayUtils.EmptyPrimitives.INT;
        String[] stringArray = ArrayUtils.EmptyObjects.STRING;
        if (EditorViewUtils.isMatlabLanguage(editor)) {
            nArray2 = MDocumentUtils.getOneBasedLineNumbersOfFunctions((BaseDocument)baseDocument);
            List list = MDocumentUtils.getFunctionNames((BaseDocument)baseDocument);
            stringArray = list.toArray(new String[list.size()]);
        }
        int n = DocumentUtils.getLineNumberFromPosition((BaseDocument)baseDocument, (int)editor.getCaretPosition()) + 1;
        n = DialogFactory.getEditorDialogProvider().showGotoDialog(EditorUiUtils.getParentFrame(editor.getComponent()), n, stringArray, nArray2, objectArray, nArray, editor.getLongName());
        if (n != -1) {
            editor.goToLine(n, false);
            editor.getComponent().requestFocus();
        }
    }

    private static boolean isMatlabLanguage(Editor editor) {
        return editor.getLanguage() instanceof MLanguage;
    }

    public static void scrollTextAvoidingWindow(final STPInterface sTPInterface, final Window window) {
        Validate.notNull((Object)window, (String)"Window cannot be null.");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SyntaxTextPaneUtilities.scrollSelToView((STPViewInterface)sTPInterface, (Rectangle)window.getBounds());
            }
        });
    }

    public static void smartIndent(STPInterface sTPInterface) {
        EditorKit editorKit = sTPInterface.getEditorKit();
        if (editorKit instanceof BaseKit) {
            try {
                Position position = sTPInterface.getDocument().createPosition(sTPInterface.getCaret().getDot());
                Position position2 = sTPInterface.getDocument().createPosition(sTPInterface.getCaret().getMark());
                Action action = ((BaseKit)editorKit).getActionByName("select-all");
                action.actionPerformed(new ActionEvent(sTPInterface.getActiveTextComponent(), 0, null));
                Action action2 = ((BaseKit)editorKit).getActionByName("format");
                action2.actionPerformed(new ActionEvent(sTPInterface.getActiveTextComponent(), 0, null));
                sTPInterface.getCaret().setDot(position2.getOffset());
                sTPInterface.getCaret().moveDot(position.getOffset());
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
        }
    }

    public static PopupAction[] createFunctionPopupActions(Editor editor) {
        return EditorViewUtils.createFunctionPopupActions(editor, true);
    }

    public static PopupAction[] createFunctionPopupActions(Editor editor, boolean bl) {
        PopupCallback popupCallback = new PopupCallback(editor);
        int[] nArray = EditorViewUtils.getZeroBasedFunctionLineNumbers(editor);
        if (nArray.length == 0) {
            if (bl) {
                return new PopupAction[]{new PopupAction(popupCallback)};
            }
            return new PopupAction[0];
        }
        ArrayList<PopupAction> arrayList = new ArrayList<PopupAction>();
        PopupAction popupAction = null;
        for (int i = 0; i < nArray.length; ++i) {
            String string = EditorViewUtils.getFunctionName(editor, nArray[i]);
            PopupAction popupAction2 = new PopupAction(popupCallback, string, nArray[i]);
            arrayList.add(popupAction2);
            if (i != 0) continue;
            popupAction = popupAction2;
        }
        Collections.sort(arrayList, new PopupComparator());
        if (EditorViewUtils.getFirstClassName(editor) == null) {
            arrayList.remove((Object)popupAction);
            arrayList.add(0, popupAction);
        }
        return arrayList.toArray(new PopupAction[arrayList.size()]);
    }

    private static int[] getZeroBasedFunctionLineNumbers(Editor editor) {
        return EditorViewUtils.isMatlabLanguage(editor) ? MDocumentUtils.getZeroBasedLineNumbersOfFunctions((BaseDocument)((BaseDocument)editor.getDocument())) : ArrayUtils.EmptyPrimitives.INT;
    }

    private static String getFunctionName(Editor editor, int n) {
        return EditorViewUtils.isMatlabLanguage(editor) ? MDocumentUtils.getFunctionName((BaseDocument)((BaseDocument)editor.getDocument()), (int)n) : null;
    }

    private static String getFirstClassName(Editor editor) {
        return EditorViewUtils.isMatlabLanguage(editor) ? MDocumentUtils.getFirstClassName((MTree)MDocumentUtils.getMTree((BaseDocument)((BaseDocument)editor.getDocument()))) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertAtCaret(STPInterface sTPInterface, String string) {
        Validate.notNull((Object)sTPInterface, (String)"'pane' cannot be null");
        Validate.notNull((Object)string, (String)"'textToInsert' cannot be null");
        try {
            sTPInterface.startBlockEdit();
            sTPInterface.delete(sTPInterface.getSelectionStart(), sTPInterface.getSelectionEnd());
            sTPInterface.insert(sTPInterface.getCaretPosition(), string);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            sTPInterface.endBlockEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertAndSmartIndentAtCaret(STPInterface sTPInterface, String string) {
        Validate.notNull((Object)sTPInterface, (String)"'pane' cannot be null");
        Validate.notNull((Object)string, (String)"'textToInsert' cannot be null");
        try {
            sTPInterface.startBlockEdit();
            sTPInterface.delete(sTPInterface.getSelectionStart(), sTPInterface.getSelectionEnd());
            EditorViewUtils.insertAndSmartIndent(sTPInterface, string, sTPInterface.getCaretPosition());
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            sTPInterface.endBlockEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertAndSmartIndent(STPInterface sTPInterface, String string, int n) {
        Validate.notNull((Object)sTPInterface, (String)"'pane' cannot be null");
        Validate.notNull((Object)string, (String)"'textToInsert' cannot be null");
        try {
            sTPInterface.startBlockEdit();
            sTPInterface.insert(n, string);
            Position position = sTPInterface.getDocument().createPosition(sTPInterface.getSelectionStart());
            Position position2 = sTPInterface.getDocument().createPosition(sTPInterface.getSelectionEnd());
            sTPInterface.select(n, n + string.length());
            sTPInterface.getSmartIndentAction().actionPerformed(new ActionEvent(sTPInterface.getActiveTextComponent(), 0, null));
            sTPInterface.select(position.getOffset(), position2.getOffset());
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            sTPInterface.endBlockEdit();
        }
    }

    private static class PopupComparator
    implements Comparator<PopupAction> {
        private PopupComparator() {
        }

        @Override
        public int compare(PopupAction popupAction, PopupAction popupAction2) {
            return popupAction.getName().compareToIgnoreCase(popupAction2.getName());
        }
    }

    private static class PopupCallback
    implements PopupAction.Callback {
        private final Editor fEditor;

        private PopupCallback(Editor editor) {
            this.fEditor = editor;
        }

        @Override
        public void gotoLine(int n) {
            this.fEditor.goToLine(n + 1, false);
        }

        @Override
        public void requestFocusInPane() {
            this.fEditor.getComponent().requestFocus();
        }

        @Override
        public String getDefaultLabel() {
            return NO_FUNCTIONS_FOUND;
        }
    }
}

