/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorToolstripTabContributor;
import com.mathworks.mde.editor.ActionManager;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mde.editor.EditorToolSetFactory;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.EditorViewToolSetFactory;
import com.mathworks.mde.editor.codepad.CodepadToolSetFactory;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import com.mathworks.widgets.datamodel.StorageLocationUtils;
import com.mathworks.widgets.debug.DebuggerManager;
import com.mathworks.widgets.text.STPInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.apache.commons.lang.Validate;

public class EditorToolstripTabFactory {
    private final Editor fEditor;
    private final ActionManager fActionManager;
    private List<ToolstripTab> fTabs;
    private EditorToolSetFactory fEditorToolSetFactory;
    private EditorViewToolSetFactory fViewToolSetFactory;
    private final STPInterface fSyntaxTextPane;
    private CodepadToolSetFactory fCodepadToolSetFactory;

    public EditorToolstripTabFactory(Editor editor, ActionManager actionManager) {
        Validate.notNull((Object)editor, (String)"'editor' cannot be null");
        Validate.notNull((Object)actionManager, (String)"'actionManager' cannot be null");
        this.fEditor = editor;
        this.fActionManager = actionManager;
        this.fTabs = new ArrayList<ToolstripTab>();
        this.fSyntaxTextPane = this.fActionManager.getSyntaxTextPane();
    }

    public List<ToolstripTab> createTabs() {
        assert (this.fTabs.isEmpty()) : "Previous tabs weren't disposed!";
        this.addEditorTab();
        this.addPublishTab();
        this.addViewTab();
        return Collections.unmodifiableList(this.fTabs);
    }

    private void addEditorTab() {
        this.fEditorToolSetFactory = new EditorToolSetFactory(this.fEditor, this.fActionManager);
        boolean bl = DebuggerManager.isDebugging() || EditorStartup.getInDebugMode();
        TSTabConfiguration tSTabConfiguration = this.fEditorToolSetFactory.getTabConfig(this.fEditor.isMCode(), bl);
        List<EditorToolstripTabContributor> list = this.getOrderedApplicableContributors();
        ArrayList<TSToolSet> arrayList = new ArrayList<TSToolSet>();
        arrayList.add(this.fEditorToolSetFactory.getToolSet());
        for (EditorToolstripTabContributor editorToolstripTabContributor : list) {
            editorToolstripTabContributor.contributeToEditorTab(tSTabConfiguration, this.fEditorToolSetFactory.getToolSet().getContents(), this.fEditor);
            arrayList.addAll(editorToolstripTabContributor.getSupportingToolSets());
        }
        this.addTab(tSTabConfiguration, arrayList.toArray(new TSToolSet[arrayList.size()]));
        this.populateRunOrContinueActionInEditorActionMap(bl);
    }

    private void populateRunOrContinueActionInEditorActionMap(boolean bl) {
        if (bl) {
            this.contributeRunOrContinueActionToActionMap(DebuggerManager.getInstance().getContinueActionNoEcho());
        } else {
            this.contributeRunOrContinueActionToActionMap(this.fEditorToolSetFactory.getToolSet().getAction("run"));
        }
    }

    private void contributeRunOrContinueActionToActionMap(Action action) {
        this.fActionManager.getSyntaxTextPane().getActionMap().put("debug-continue", action);
    }

    private void addTab(TSTabConfiguration tSTabConfiguration, TSToolSet[] tSToolSetArray) {
        this.fTabs.add(TSFactory.createTab((TSTabConfiguration)tSTabConfiguration, null, (boolean)true, (TSToolSet[])tSToolSetArray));
        this.registerKeyBindings(Arrays.asList(tSToolSetArray));
    }

    private void registerKeyBindings(List<TSToolSet> list) {
        for (TSToolSet tSToolSet : list) {
            TSFactory.populate((ExtendedInputMap)((ExtendedInputMap)this.fSyntaxTextPane.getInputMap()), (ActionMap)this.fSyntaxTextPane.getActionMap(), (KeyBindingManager)MatlabKeyBindings.getManager(), (TSToolSet[])new TSToolSet[]{tSToolSet});
        }
    }

    private void addPublishTab() {
        if (this.fEditor.isMCode() && StorageLocationUtils.isOrWillBeBackedByFile((StorageLocation)this.fEditor.getStorageLocation())) {
            this.fCodepadToolSetFactory = new CodepadToolSetFactory(this.fEditor, this.fActionManager);
            TSToolSet[] tSToolSetArray = this.fCodepadToolSetFactory.getToolSets();
            this.addTab(this.fCodepadToolSetFactory.getTabConfig(), tSToolSetArray);
        }
    }

    private void addViewTab() {
        this.fViewToolSetFactory = new EditorViewToolSetFactory(this.fEditor, this.fActionManager);
        TSToolSet[] tSToolSetArray = this.fViewToolSetFactory.getToolSets();
        this.addTab(this.fViewToolSetFactory.getTabConfig(), tSToolSetArray);
    }

    private List<EditorToolstripTabContributor> getOrderedApplicableContributors() {
        ArrayList<EditorToolstripTabContributor> arrayList = new ArrayList<EditorToolstripTabContributor>();
        Collection<EditorToolstripTabContributor> collection = EditorToolstripTabFactory.getToolstripTabContributors();
        for (EditorToolstripTabContributor editorToolstripTabContributor : collection) {
            if (!editorToolstripTabContributor.isApplicable(this.fEditor)) continue;
            arrayList.add(editorToolstripTabContributor);
        }
        EditorUtils.sortPrioritizables(arrayList);
        return arrayList;
    }

    static Collection<EditorToolstripTabContributor> getToolstripTabContributors() {
        return ClasspathOSGiManager.getInstance().getImplementors(EditorToolstripTabContributor.class);
    }

    public void disposeTabs() {
        for (ToolstripTab toolstripTab : this.fTabs) {
            TSFactory.disposeTab((ToolstripTab)toolstripTab);
        }
        this.fTabs.clear();
        if (this.fEditorToolSetFactory != null) {
            this.fEditorToolSetFactory.dispose();
        }
        if (this.fViewToolSetFactory != null) {
            this.fViewToolSetFactory.dispose();
        }
        if (this.fCodepadToolSetFactory != null) {
            this.fCodepadToolSetFactory.dispose();
        }
    }
}

