/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.mde.cmdwin.CmdWinDocument;
import com.mathworks.mde.cmdwin.CmdWinMLIF;
import com.mathworks.mde.cmdwin.XCmdWndView;
import com.mathworks.mlservices.MLExecutionEvent;
import com.mathworks.mlservices.MLExecutionListener;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.datatransfer.DragAndDropUtilities;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class XCaret
extends DefaultCaret
implements CaretListener,
MLExecutionListener,
DocumentListener {
    private static XCmdWndView sCWView = null;
    private static CmdWinDocument sCWDoc;
    private int fInsertDot;
    private static volatile boolean sMatlabBusy;
    private boolean fAfterThePrompt = true;
    private boolean fFlashVisible = false;
    private Timer fBlinky = null;
    private static int BLINK_RATE;
    private boolean fGainingFocus = false;
    private int fVisibilityWidth = 10;
    protected char[] dotChar = new char[]{' '};
    private static boolean sAdjustToViewPrompt;
    private static XCaret sXCaret;
    private static volatile boolean sDoNotAdjustCaret;
    private static final String XCARET_CHANGELISTENER_PROPERTY = "xcaret.changelistener.";

    private XCaret() {
    }

    static void adjustSelection(Caret caret) {
        if (caret instanceof XCaret) {
            sXCaret.adjustSelection();
            return;
        }
        if (!XCaret.hasSelection(caret)) {
            return;
        }
        int n = caret.getDot();
        int n2 = caret.getMark();
        boolean bl = sCWDoc.isInOrBeforeThePrompt(n);
        boolean bl2 = sCWDoc.isInOrBeforeThePrompt(n2);
        if (!bl && !bl2) {
            return;
        }
        if (bl && bl2) {
            return;
        }
        int n3 = bl ? n2 : n;
        int n4 = sCWDoc.getAfterThePrompt();
        caret.setDot(n4);
        caret.moveDot(n3);
    }

    void adjustSelection() {
        int n;
        int n2 = this.getDot();
        int n3 = this.getMark();
        boolean bl = sCWDoc.isInOrBeforeThePrompt(n2);
        boolean bl2 = sCWDoc.isInOrBeforeThePrompt(n3);
        if (!bl && !bl2) {
            return;
        }
        if (bl && bl2) {
            XCaret.combineCarets();
            return;
        }
        int n4 = this.getInsertDot();
        int n5 = bl ? n2 : n3;
        int n6 = n = bl ? n3 : n2;
        if (n4 <= n) {
            n5 = sCWDoc.getAfterThePrompt();
            this.setDot(n5);
            this.moveDot(n);
        } else {
            this.setDot(n4);
        }
    }

    @Override
    protected void adjustVisibility(Rectangle rectangle) {
        if (sDoNotAdjustCaret) {
            return;
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (this.getDot() == sCWDoc.getAfterThePrompt() && sCWDoc.getInUsePromptLength() != 0) {
            rectangle2.x = 0;
        } else if (sAdjustToViewPrompt) {
            if (sCWDoc.isAfterThePrompt(this.getDot())) {
                rectangle2.x = 0;
            }
            sAdjustToViewPrompt = false;
        } else if (rectangle2.width < this.fVisibilityWidth && this.getDot() == this.getMark()) {
            rectangle2.width = this.fVisibilityWidth * 2;
            rectangle2.x -= this.fVisibilityWidth;
            if (rectangle2.x < 0) {
                rectangle2.x = 0;
            }
        }
        super.adjustVisibility(rectangle2);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        int n = caretEvent.getDot();
        if (sCWDoc.isAfterThePrompt(n)) {
            if (this.fBlinky != null) {
                this.repaintPlaceHolder();
            }
            this.fInsertDot = n;
        }
        this.checkForMoveAcrossPrompt(n);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    void checkForMoveAcrossPrompt(int n) {
        if (!sCWView.isFocusOwner()) {
            return;
        }
        if (this.fAfterThePrompt != sCWDoc.isAfterThePrompt(n)) {
            if (sCWDoc.isAfterThePrompt(n)) {
                sCWView.setCaretColor(sCWView.getFgColor());
                try {
                    Rectangle rectangle = sCWView.modelToView(n);
                    this.damage(rectangle);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                this.setBlinkRate(BLINK_RATE);
                this.setVisible(true);
                if (this.fBlinky != null) {
                    this.fFlashVisible = false;
                    this.repaintPlaceHolder();
                    this.fBlinky.stop();
                }
            } else {
                if (BLINK_RATE > 0) {
                    sCWView.setCaretColor(sCWView.getDisabledTextColor());
                }
                this.setBlinkRate(0);
                this.setVisible(true);
                try {
                    Rectangle rectangle = sCWView.modelToView(n);
                    this.damage(rectangle);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (this.fBlinky == null && BLINK_RATE > 0) {
                    this.fBlinky = new Timer(BLINK_RATE, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            XCaret.this.fFlashVisible = !XCaret.this.fFlashVisible;
                            XCaret.this.repaintPlaceHolder();
                        }
                    });
                }
                if (BLINK_RATE > 0 && this.fBlinky != null) {
                    this.fBlinky.start();
                }
            }
            this.fAfterThePrompt = sCWDoc.isAfterThePrompt(n);
        }
    }

    static void dragDropEnd() {
        DragAndDropUtilities.dragDropEndSendEvent((JTextComponent)sCWView);
        XCaret.combineCarets();
    }

    static void combineCarets() {
        sAdjustToViewPrompt = true;
        Caret caret = sCWView.getCaret();
        if (caret instanceof XCaret) {
            XCaret xCaret = (XCaret)caret;
            xCaret.setDot(xCaret.getInsertDot());
        } else {
            caret.setDot(caret.getDot());
        }
    }

    private void doHyperLinkCheck(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && sCWDoc.isClickInHyperLink(mouseEvent.getPoint())) {
            sCWDoc.goToHyperLink(mouseEvent.getPoint());
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.checkForMoveAcrossPrompt(this.getDot());
        super.focusGained(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setVisible(false);
    }

    static boolean hasSelection(Caret caret) {
        int n;
        int n2 = caret.getDot();
        return n2 != (n = caret.getMark());
    }

    public static XCaret getInstance() {
        return sXCaret;
    }

    int getInsertDot() {
        return this.fInsertDot;
    }

    @Override
    public void install(JTextComponent jTextComponent) {
        jTextComponent.getDocument().addDocumentListener(this);
        super.install(jTextComponent);
        if (sCWView == null) {
            sCWView = (XCmdWndView)this.getComponent();
            sCWDoc = (CmdWinDocument)sCWView.getDocument();
            FontMetrics fontMetrics = sCWView.getFontMetrics(sCWView.getFont());
            this.fVisibilityWidth = fontMetrics.getMaxAdvance();
            XCaret.installScrollListeners();
        }
        this.fInsertDot = jTextComponent.getInputContext() != null ? sCWView.getInputMethodRequests().getCommittedTextLength() : this.getDot();
        sCWView.addCaretListener(this);
        this.setBlinkRate(BLINK_RATE);
    }

    private static void installScrollListeners() {
        MJScrollPane mJScrollPane = sCWView.getScrollPane();
        XCaret.installScrollBarListener(mJScrollPane.getVerticalScrollBar());
        XCaret.installScrollBarListener(mJScrollPane.getHorizontalScrollBar());
    }

    private static void deinstallScrollListeners() {
        MJScrollPane mJScrollPane = sCWView.getScrollPane();
        XCaret.deinstallScrollBarListener(mJScrollPane.getVerticalScrollBar());
        XCaret.deinstallScrollBarListener(mJScrollPane.getHorizontalScrollBar());
    }

    private static void installScrollBarListener(final JScrollBar jScrollBar) {
        if (jScrollBar != null) {
            ChangeListener changeListener = new ChangeListener(){
                boolean fAdjusting;

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    boolean bl = jScrollBar.getModel().getValueIsAdjusting();
                    if (bl != this.fAdjusting) {
                        this.fAdjusting = bl;
                        XCaret.setScrollBarsAdjusting(this.fAdjusting);
                    }
                }
            };
            jScrollBar.getModel().addChangeListener(changeListener);
            jScrollBar.putClientProperty(XCARET_CHANGELISTENER_PROPERTY + jScrollBar.getOrientation(), changeListener);
        }
    }

    private static void deinstallScrollBarListener(JScrollBar jScrollBar) {
        ChangeListener changeListener;
        if (jScrollBar != null && (changeListener = (ChangeListener)jScrollBar.getClientProperty(XCARET_CHANGELISTENER_PROPERTY + jScrollBar.getOrientation())) != null) {
            jScrollBar.getModel().removeChangeListener(changeListener);
        }
    }

    @Override
    public void deinstall(JTextComponent jTextComponent) {
        XCaret.deinstallScrollListeners();
        sCWView.removeCaretListener(this);
        this.setVisible(false);
        super.deinstall(jTextComponent);
        sCWDoc.removeDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        int n = documentEvent.getOffset();
        int n2 = this.getDot();
        if (sCWDoc.isAfterThePrompt(n2)) {
            this.fInsertDot = n2;
        } else if (sCWDoc.isInOrBeforeThePrompt(n)) {
            this.fInsertDot += documentEvent.getLength();
            XCaret.combineCarets();
        }
    }

    boolean isSelectionEditable() {
        return this.selectionBelowPrompt();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 8) != 0 && PlatformInfo.isXWindows()) {
            return;
        }
        if (mouseEvent.getClickCount() == 2 || mouseEvent.getClickCount() == 3) {
            return;
        }
        this.doHyperLinkCheck(mouseEvent);
        super.mouseClicked(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (sCWDoc.isClickInHyperLink(mouseEvent.getPoint())) {
            XCmdWndView.setLinkCursor(Cursor.getPredefinedCursor(12), sCWDoc.getLinks(mouseEvent.getPoint()));
        } else if (XCaret.hasSelection(this) && sCWView.getRecognizer().isClickInSelection(mouseEvent)) {
            XCmdWndView.setLinkCursor(Cursor.getDefaultCursor(), "");
        } else {
            XCmdWndView.setLinkCursor(Cursor.getPredefinedCursor(2), "");
        }
        super.mouseMoved(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        Component component = mouseEvent.getComponent();
        if (!component.isFocusOwner()) {
            this.fGainingFocus = true;
        }
        super.mousePressed(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        this.fGainingFocus = false;
        super.mouseReleased(mouseEvent);
    }

    @Override
    public void setSelectionVisible(boolean bl) {
        super.setSelectionVisible(true);
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        int n = this.getInsertDot();
        int n2 = this.getDot();
        if (sCWView.isOverwriteMode() && sCWDoc.isAfterThePrompt(this.getDot()) && n == n2) {
            this.drawBlockCaret(n2, graphics);
        } else {
            super.paint(graphics);
        }
        if (!this.fFlashVisible) {
            return;
        }
        if (n != n2) {
            if (sCWDoc.isAfterThePrompt(n2)) {
                return;
            }
            Rectangle rectangle = null;
            try {
                rectangle = sCWView.modelToView(n);
            }
            catch (Exception exception) {
                return;
            }
            if (rectangle == null) {
                return;
            }
            if (!sCWView.isOverwriteMode()) {
                graphics.setColor(sCWView.getFgColor());
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
            } else {
                this.drawBlockCaret(n, graphics);
            }
        }
    }

    private void drawBlockCaret(int n, Graphics graphics) {
        JTextComponent jTextComponent = this.getComponent();
        try {
            Rectangle rectangle = sCWView.modelToView(n);
            if (rectangle == null) {
                return;
            }
            this.width = sCWView.getFontMetrics(sCWView.getFont()).getMaxAdvance();
            this.dotChar[0] = sCWView.getText(n, 1).charAt(0);
            graphics.setColor(jTextComponent.getCaretColor());
            int n2 = graphics.getFontMetrics().charWidth(this.dotChar[0]);
            if (n2 == 0) {
                n2 = graphics.getFontMetrics().charWidth(' ');
            }
            graphics.setColor(sCWView.getFgColor());
            graphics.fillRect(rectangle.x, rectangle.y, n2, this.height);
            if (!Character.isWhitespace(this.dotChar[0])) {
                graphics.setColor(sCWView.getBackground());
                int n3 = graphics.getFontMetrics(sCWView.getFont()).getAscent();
                graphics.drawChars(this.dotChar, 0, 1, rectangle.x, rectangle.y + n3);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    @Override
    protected synchronized void damage(Rectangle rectangle) {
        if (sCWDoc.isAfterThePrompt(this.getDot()) && sCWView.isOverwriteMode()) {
            if (rectangle != null) {
                int n = sCWView.getFontMetrics(sCWView.getFont()).getMaxAdvance();
                this.x = rectangle.x;
                this.y = rectangle.y;
                this.width = n;
                this.height = rectangle.height;
                this.repaint();
                try {
                    Rectangle rectangle2 = sCWView.modelToView(this.getInsertDot());
                    this.x = rectangle2.x;
                    this.y = rectangle2.y;
                    this.height = rectangle2.height;
                    this.repaint();
                }
                catch (BadLocationException badLocationException) {}
            }
        } else {
            super.damage(rectangle);
        }
    }

    private void removeInstalledHighlight() {
        sCWView.getHighlighter().removeAllHighlights();
        if (this == sCWView.getCaret()) {
            this.setDot(this.getDot());
        }
    }

    void removeSelection() {
        this.removeInstalledHighlight();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        int n = documentEvent.getOffset();
        int n2 = documentEvent.getLength();
        int n3 = n + n2;
        int n4 = this.getDot();
        if (sCWDoc.isInOrBeforeThePrompt(n4)) {
            this.fInsertDot = n3 <= this.fInsertDot ? (this.fInsertDot -= n2) : n;
        }
    }

    private void repaintPlaceHolder() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = XCaret.this.getInsertDot();
                Rectangle rectangle = null;
                int n2 = 10;
                try {
                    rectangle = sCWView.modelToView(n);
                    if (rectangle == null) {
                        return;
                    }
                    if (sCWView.isOverwriteMode()) {
                        n2 = sCWView.getFontMetrics(sCWView.getFont()).getMaxAdvance();
                        sCWView.repaint(rectangle.x, rectangle.y, n2, rectangle.height);
                    } else {
                        sCWView.repaint(rectangle.x - 4, rectangle.y, n2, rectangle.height);
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        });
    }

    private boolean selectionBelowPrompt() {
        int n;
        int n2 = this.getDot();
        if (n2 == (n = this.getMark())) {
            return false;
        }
        return sCWDoc.isAfterThePrompt(n2) && sCWDoc.isAfterThePrompt(n);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.fBlinky != null) {
            this.fFlashVisible = bl;
            if (bl && this.fBlinky.getDelay() != 0) {
                this.fBlinky.start();
            } else {
                this.fBlinky.stop();
                this.repaintPlaceHolder();
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        MLExecutionEvent mLExecutionEvent = (MLExecutionEvent)changeEvent;
        if (sMatlabBusy != mLExecutionEvent.isCommandBusy() || CmdWinMLIF.isInBangMode()) {
            sMatlabBusy = mLExecutionEvent.isCommandBusy() && !CmdWinMLIF.isInBangMode();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (sCWView.isFocusOwner()) {
                        XCaret.this.setVisible(!sMatlabBusy);
                    }
                }
            });
        }
        if (!sMatlabBusy) {
            sDoNotAdjustCaret = false;
        }
    }

    private static void setScrollBarsAdjusting(boolean bl) {
        if (sMatlabBusy && bl) {
            sDoNotAdjustCaret = true;
        }
    }

    static {
        sMatlabBusy = false;
        BLINK_RATE = MJUtilities.getCaretBlinkRate();
        sAdjustToViewPrompt = false;
        sXCaret = new XCaret();
    }
}

