/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.mde.cmdwin.CmdWinPrefs;
import com.mathworks.mwswing.GraphicsUtils;
import com.mathworks.services.ColorPrefs;
import com.mathworks.util.Log;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.JTextArea;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.WrappedPlainView;

public class CmdWinSyntaxUI
extends BasicTextAreaUI {
    CmdWinSyntaxUI() {
    }

    @Override
    public View create(Element element) {
        Document document = element.getDocument();
        Object object = document.getProperty("i18n");
        if (object != null && object.equals(Boolean.TRUE)) {
            return super.create(element);
        }
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)jTextComponent;
            View view = jTextArea.getLineWrap() ? new SyntaxWrappedPlainView(element, jTextArea.getWrapStyleWord()) : new SyntaxPlainView(element);
            return view;
        }
        return null;
    }

    private static Color getColorFromPrefs(String string) {
        if (string == null) {
            return ColorPrefs.getTextColor();
        }
        if (string.equals("CWLink")) {
            return CmdWinPrefs.getHtmlLinkColor();
        }
        return ColorPrefs.getColorPref((String)string);
    }

    private static class SyntaxPlainView
    extends PlainView {
        private static AttributeSet sAttributes;
        private static int sLineStart;

        public SyntaxPlainView(Element element) {
            super(element);
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            Map map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
            if (map != null) {
                ((Graphics2D)graphics).addRenderingHints(map);
            }
            super.paint(graphics, shape);
        }

        @Override
        protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            if (sAttributes == null) {
                return super.drawUnselectedText(graphics, n, n2, n3, n4);
            }
            Object[] objectArray = null;
            objectArray = (Object[])sAttributes.getAttribute("SyntaxTokens");
            if (objectArray != null) {
                int n5;
                int n6 = n;
                int[] nArray = (int[])objectArray[0];
                int[] nArray2 = new int[nArray.length];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                String[] stringArray = (String[])objectArray[1];
                for (int i = 0; i < nArray2.length; ++i) {
                    nArray2[i] = nArray2[i] + sLineStart;
                }
                int[] nArray3 = (int[])sAttributes.getAttribute("LinkStartTokens");
                int[] nArray4 = null;
                if (nArray3 != null) {
                    nArray4 = new int[nArray3.length];
                    System.arraycopy(nArray3, 0, nArray4, 0, nArray3.length);
                    for (int i = 0; i < nArray4.length; ++i) {
                        if (nArray4[i] == -1) continue;
                        nArray4[i] = nArray4[i] + sLineStart;
                    }
                }
                int[] nArray5 = (int[])sAttributes.getAttribute("BoldStartTokens");
                int[] nArray6 = null;
                if (nArray5 != null) {
                    nArray6 = new int[nArray5.length];
                    System.arraycopy(nArray5, 0, nArray6, 0, nArray5.length);
                    for (n5 = 0; n5 < nArray6.length; ++n5) {
                        if (nArray6[n5] == -1) continue;
                        nArray6[n5] = nArray6[n5] + sLineStart;
                    }
                }
                n5 = -1;
                int n7 = -1;
                int n8 = 0;
                while (n8 < nArray2.length) {
                    if (nArray2[n8] >= n3) {
                        n5 = n8;
                        break;
                    }
                    n7 = n8++;
                }
                if (n5 == -1) {
                    if (n7 == -1) {
                        return super.drawUnselectedText(graphics, n, n2, n3, n4);
                    }
                    n6 = this.drawColoredTextSegment(CmdWinSyntaxUI.getColorFromPrefs(stringArray[n7]), graphics, n, n2, n3, n4, nArray4, nArray6, n7);
                    return n6;
                }
                if (n3 < nArray2[n5]) {
                    n6 = n5 > 0 ? (nArray2[n5] > n4 ? this.drawColoredTextSegment(CmdWinSyntaxUI.getColorFromPrefs(stringArray[n5 - 1]), graphics, n, n2, n3, n4, nArray4, nArray6, n5 - 1) : this.drawColoredTextSegment(CmdWinSyntaxUI.getColorFromPrefs(stringArray[n5 - 1]), graphics, n, n2, n3, nArray2[n5], nArray4, nArray6, n5 - 1)) : (nArray2[n5] > n4 ? super.drawUnselectedText(graphics, n, n2, n3, n4) : super.drawUnselectedText(graphics, n, n2, n3, nArray2[n5]));
                }
                for (n8 = n5; n8 < nArray2.length; ++n8) {
                    if (n8 + 1 >= nArray2.length || nArray2[n8 + 1] >= n4 || nArray2[n8 + 1] <= nArray2[n8]) {
                        if (nArray2[n8] >= n4) break;
                        n6 = this.drawColoredTextSegment(CmdWinSyntaxUI.getColorFromPrefs(stringArray[n8]), graphics, n6, n2, nArray2[n8], n4, nArray4, nArray6, n8);
                        break;
                    }
                    n6 = this.drawColoredTextSegment(CmdWinSyntaxUI.getColorFromPrefs(stringArray[n8]), graphics, n6, n2, nArray2[n8], nArray2[n8 + 1], nArray4, nArray6, n8);
                }
                return n6;
            }
            return super.drawUnselectedText(graphics, n, n2, n3, n4);
        }

        private int drawColoredTextSegment(Color color, Graphics graphics, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int n5) {
            int n6 = n;
            try {
                graphics.setColor(color);
                Document document = this.getDocument();
                Segment segment = new Segment();
                document.getText(n3, n4 - n3, segment);
                Font font = graphics.getFont();
                if (nArray2 != null && n5 < nArray2.length && nArray2[n5] != -1) {
                    graphics.setFont(font.deriveFont(1));
                }
                if (nArray != null && n5 < nArray.length && nArray[n5] != -1) {
                    int n7 = graphics.getFontMetrics().stringWidth(segment.toString());
                    graphics.drawLine(n, n2 + 2, n + n7, n2 + 2);
                }
                n6 = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n3);
                graphics.setFont(font);
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
            return n6;
        }

        @Override
        protected void drawLine(int n, Graphics graphics, int n2, int n3) {
            try {
                Element element = this.getElement().getElement(n);
                sLineStart = element.getStartOffset();
                sAttributes = element.getAttributes();
                super.drawLine(n, graphics, n2, n3);
                sAttributes = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
        }
    }

    private static class SyntaxWrappedPlainView
    extends WrappedPlainView {
        private static AttributeSet sAttributes;
        private static int sLineStart;

        public SyntaxWrappedPlainView(Element element, boolean bl) {
            super(element, bl);
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            RenderingHints renderingHints = GraphicsUtils.getAntialiasingRenderingHints();
            if (renderingHints != null) {
                ((Graphics2D)graphics).addRenderingHints(renderingHints);
            }
            super.paint(graphics, shape);
        }

        @Override
        protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            if (sAttributes == null) {
                return super.drawUnselectedText(graphics, n, n2, n3, n4);
            }
            Object[] objectArray = null;
            objectArray = (Object[])sAttributes.getAttribute("SyntaxTokens");
            if (objectArray != null) {
                int n5;
                int n6 = n;
                String[] stringArray = (String[])objectArray[1];
                int[] nArray = (int[])objectArray[0];
                int[] nArray2 = new int[nArray.length];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                for (int i = 0; i < nArray2.length; ++i) {
                    nArray2[i] = nArray2[i] + sLineStart;
                }
                int[] nArray3 = (int[])sAttributes.getAttribute("LinkStartTokens");
                int[] nArray4 = null;
                if (nArray3 != null) {
                    nArray4 = new int[nArray3.length];
                    System.arraycopy(nArray3, 0, nArray4, 0, nArray3.length);
                    for (int i = 0; i < nArray4.length; ++i) {
                        if (nArray4[i] == -1) continue;
                        nArray4[i] = nArray4[i] + sLineStart;
                    }
                }
                int[] nArray5 = (int[])sAttributes.getAttribute("BoldStartTokens");
                int[] nArray6 = null;
                if (nArray5 != null) {
                    nArray6 = new int[nArray5.length];
                    System.arraycopy(nArray5, 0, nArray6, 0, nArray5.length);
                    for (n5 = 0; n5 < nArray6.length; ++n5) {
                        if (nArray6[n5] == -1) continue;
                        nArray6[n5] = nArray6[n5] + sLineStart;
                    }
                }
                n5 = -1;
                int n7 = -1;
                int n8 = 0;
                while (n8 < nArray2.length) {
                    if (nArray2[n8] >= n3) {
                        n5 = n8;
                        break;
                    }
                    n7 = n8++;
                }
                if (n5 == -1) {
                    if (n7 == -1) {
                        return super.drawUnselectedText(graphics, n, n2, n3, n4);
                    }
                    n6 = this.drawColoredTextSegment(CmdWinSyntaxUI.getColorFromPrefs(stringArray[n7]), graphics, n, n2, n3, n4, nArray4, nArray6, n7);
                    return n6;
                }
                if (n3 < nArray2[n5]) {
                    n6 = n5 > 0 ? (nArray2[n5] > n4 ? this.drawColoredTextSegment(CmdWinSyntaxUI.getColorFromPrefs(stringArray[n5 - 1]), graphics, n, n2, n3, n4, nArray4, nArray6, n5 - 1) : this.drawColoredTextSegment(CmdWinSyntaxUI.getColorFromPrefs(stringArray[n5 - 1]), graphics, n, n2, n3, nArray2[n5], nArray4, nArray6, n5 - 1)) : (nArray2[n5] > n4 ? super.drawUnselectedText(graphics, n, n2, n3, n4) : super.drawUnselectedText(graphics, n, n2, n3, nArray2[n5]));
                }
                for (n8 = n5; n8 < nArray2.length; ++n8) {
                    if (n8 + 1 >= nArray2.length || nArray2[n8 + 1] >= n4 || nArray2[n8 + 1] <= nArray2[n8]) {
                        if (nArray2[n8] >= n4) break;
                        n6 = this.drawColoredTextSegment(CmdWinSyntaxUI.getColorFromPrefs(stringArray[n8]), graphics, n6, n2, nArray2[n8], n4, nArray4, nArray6, n8);
                        break;
                    }
                    n6 = this.drawColoredTextSegment(CmdWinSyntaxUI.getColorFromPrefs(stringArray[n8]), graphics, n6, n2, nArray2[n8], nArray2[n8 + 1], nArray4, nArray6, n8);
                }
                return n6;
            }
            return super.drawUnselectedText(graphics, n, n2, n3, n4);
        }

        private int drawColoredTextSegment(Color color, Graphics graphics, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int n5) {
            int n6 = n;
            try {
                graphics.setColor(color);
                Document document = this.getDocument();
                Segment segment = new Segment();
                document.getText(n3, n4 - n3, segment);
                Font font = graphics.getFont();
                if (nArray2 != null && n5 < nArray2.length && nArray2[n5] != -1) {
                    graphics.setFont(font.deriveFont(1));
                }
                if (nArray != null && n5 < nArray.length && nArray[n5] != -1) {
                    int n7 = graphics.getFontMetrics().stringWidth(segment.toString());
                    graphics.drawLine(n, n2 + 2, n + n7, n2 + 2);
                }
                n6 = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n3);
                graphics.setFont(font);
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
            return n6;
        }

        @Override
        protected void drawLine(int n, int n2, Graphics graphics, int n3, int n4) {
            try {
                Element element = this.getElement();
                Element element2 = element.getElement(element.getElementIndex(n));
                sLineStart = element2.getStartOffset();
                sAttributes = element2.getAttributes();
                super.drawLine(n, n2, graphics, n3, n4);
                sAttributes = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
        }
    }
}

