/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdhist;

import com.mathworks.mde.cmdhist.CmdHistory;
import com.mathworks.services.Prefs;
import com.mathworks.services.SystemServices;
import com.mathworks.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class CmdHistoryIO {
    private static final int HISTORY_SIZE = 200000;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String HISTORY_FILE_NAME = "history.m";
    private static final String HISTORY_FILE_BACKUP_NAME = "history.temp";
    private static File sCurrentSaveFile = new File(Prefs.getPropertyDirectory(), "history.m");
    private static String sDateStr = null;
    private static String sTimeStr = null;

    private CmdHistoryIO() {
    }

    public static void setCurrentSaveFile(File file) {
        sCurrentSaveFile = file;
    }

    public static File getCurrentSaveFile() {
        return sCurrentSaveFile;
    }

    public static File getMainHistoryFile() {
        return new File(Prefs.getPropertyDirectory(), HISTORY_FILE_NAME);
    }

    private static File getTempHistoryFile() {
        return new File(Prefs.getPropertyDirectory(), HISTORY_FILE_BACKUP_NAME);
    }

    static void loadHistory() {
        if (sCurrentSaveFile != null) {
            CmdHistoryIO.loadHistory(sCurrentSaveFile);
        }
    }

    static void loadHistory(File file) {
        for (String string : CmdHistoryIO.readHistory(file, true)) {
            CmdHistory.getInstance().add(string);
        }
    }

    public static List<String> readHistory() {
        return CmdHistoryIO.readHistory(CmdHistoryIO.getMainHistoryFile(), false);
    }

    public static synchronized List<String> readHistory(File file) {
        return CmdHistoryIO.readHistory(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<String> readHistory(File file, boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (file.exists()) {
            BufferedReader bufferedReader = null;
            try {
                String string;
                InputStreamReader inputStreamReader;
                String string2 = FileUtils.getFileEncoding();
                if (string2 != null) {
                    inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), string2);
                    bufferedReader = new LineNumberReader(inputStreamReader);
                } else {
                    inputStreamReader = new InputStreamReader(new FileInputStream(file));
                    bufferedReader = new LineNumberReader(inputStreamReader);
                }
                file.length();
                long l = file.length();
                if (l > 200000L) {
                    ((LineNumberReader)bufferedReader).skip(l - 200000L);
                }
                boolean bl2 = true;
                while ((string = ((LineNumberReader)bufferedReader).readLine()) != null) {
                    if (bl2 && !string.startsWith("%--")) {
                        linkedList.add("%-- Unknown date --%");
                    }
                    linkedList.add(string);
                    bl2 = false;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (bl) {
            linkedList.add(CmdHistoryIO.createStartingTagLine());
        }
        return linkedList;
    }

    static void saveHistory() {
        if (sCurrentSaveFile != null) {
            CmdHistoryIO.saveHistory(sCurrentSaveFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void saveHistory(File file) {
        File file2 = CmdHistoryIO.getTempHistoryFile();
        OutputStreamWriter outputStreamWriter = null;
        try {
            String string = FileUtils.getFileEncoding();
            outputStreamWriter = string != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file2), string) : new OutputStreamWriter(new FileOutputStream(file2));
            CmdHistory.getInstance().resetAtTop();
            while (CmdHistory.getInstance().hasNext()) {
                String string2 = (String)CmdHistory.getInstance().next();
                outputStreamWriter.write(string2, 0, string2.length());
                outputStreamWriter.write(NEWLINE);
            }
        }
        catch (Exception exception) {
            file2.delete();
            return;
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            if (file.exists()) {
                file.delete();
            }
            file2.renameTo(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static String createStartingTagLine() {
        if (sDateStr == null || sTimeStr == null) {
            sDateStr = SystemServices.formatDateTime((Date)new Date());
        }
        return "%-- " + sDateStr + " --%";
    }

    static void addStartingTagLine() {
        CmdHistory.getInstance().add(CmdHistoryIO.createStartingTagLine());
    }
}

