/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.archive.zip.commonscompress;

import com.mathworks.install.archive.Archive;
import com.mathworks.install.archive.MissingEntryException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;

final class ZipArchive
implements Archive {
    private final ZipFile zipFile;
    private final File file;

    ZipArchive(File file) throws IOException {
        this.zipFile = new ZipFile(file);
        this.file = file;
    }

    @Override
    public InputStream getInputStream(String string) throws IOException {
        ZipArchiveEntry zipArchiveEntry = this.zipFile.getEntry(string);
        if (zipArchiveEntry == null) {
            ZipArchiveEntry zipArchiveEntry2 = this.zipFile.getEntry(FilenameUtils.normalize((String)string));
            if (zipArchiveEntry2 == null) {
                throw new MissingEntryException(string);
            }
            return this.zipFile.getInputStream(zipArchiveEntry2);
        }
        return this.zipFile.getInputStream(zipArchiveEntry);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void closeQuietly() {
        ZipFile.closeQuietly((ZipFile)this.zipFile);
    }

    @Override
    public String[] getEntries() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.zipFile.getEntries();
        while (enumeration.hasMoreElements()) {
            arrayList.add(((ArchiveEntry)enumeration.nextElement()).getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

