/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.workflowui;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.ProjectIcon;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJTree;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.TreeUtils;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.api.DeploymentProcessMonitor;
import com.mathworks.project.api.SubProcessType;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.MatlabExpression;
import com.mathworks.project.impl.model.Workflow;
import com.mathworks.project.impl.model.WorkflowStep;
import com.mathworks.project.impl.model.WorkflowStepResult;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.project.impl.workflowui.WorkflowDialog;
import com.mathworks.project.impl.workflowui.WorkflowTreeModel;
import com.mathworks.util.Converter;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.BusyAffordance;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class WorkflowTree {
    private final MJTree fTree;
    private final Configuration fConfiguration;
    private final BusyAffordance fBusyAffordance;
    private final Timer fRefreshTimer;
    private final JPopupMenu fContextMenu;
    private final MJAbstractAction fResetStepAction;
    private final MJAbstractAction fRunToStepAction;
    private final MJAbstractAction fRunAction;
    private final MJAbstractAction fHelpAction;
    private final Converter<WorkflowStep, DeploymentProcess> fRunner;
    private boolean fWalkThroughStepsWhileRunning;
    private boolean fAutoSelection;
    private int fContextMenuRow;
    private WorkflowStep fRunningStep;
    private TreeSelectionListener fTreeSelectionListener;
    private MouseAdapter fMouseAdapter;
    private ActionListener fTimerActionListener;
    private PropertyChangeListener fPropertyChangeListener;

    public WorkflowTree(Configuration configuration, final ParameterRunnable<WorkflowStep> parameterRunnable, Converter<WorkflowStep, DeploymentProcess> converter) {
        this.fConfiguration = configuration;
        this.fBusyAffordance = new BusyAffordance(BusyAffordance.AffordanceSize.SIZE_16x16);
        this.fBusyAffordance.getComponent().setSize(16, 16);
        this.fRunner = converter;
        WorkflowTreeModel workflowTreeModel = new WorkflowTreeModel(configuration);
        this.fTree = new MJTree((TreeModel)workflowTreeModel);
        this.fTree.setName(this.getClass().getSimpleName());
        this.fTree.setShowsRootHandles(this.isHierarchical());
        this.fTree.setCellRenderer((TreeCellRenderer)new Renderer());
        this.fTreeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (!WorkflowTree.this.fAutoSelection) {
                    WorkflowTree.this.fWalkThroughStepsWhileRunning = false;
                }
                if (WorkflowTree.this.fTree.getSelectionPath() != null) {
                    WorkflowStep workflowStep = (WorkflowStep)WorkflowTree.this.fTree.getSelectionPath().getLastPathComponent();
                    if (workflowStep.getSubSteps().isEmpty()) {
                        WorkflowTree.this.fRunAction.putValue("SmallIcon", (Object)WorkflowDialog.RUN_STEP_ICON);
                    } else {
                        WorkflowTree.this.fRunAction.putValue("SmallIcon", (Object)WorkflowDialog.RUN_MULTI_STEP_ICON);
                    }
                    parameterRunnable.run((Object)workflowStep);
                }
            }
        };
        this.fTree.addTreeSelectionListener(this.fTreeSelectionListener);
        this.fTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                WorkflowTree.this.fWalkThroughStepsWhileRunning = false;
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                WorkflowTree.this.fWalkThroughStepsWhileRunning = false;
            }
        });
        this.fContextMenu = new JPopupMenu();
        this.fRunAction = new MJAbstractAction(BuiltInResources.getString("context.run"), CommonIcon.DOWN.getIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowStep workflowStep = WorkflowTree.this.getContextMenuStep();
                if (workflowStep != null) {
                    WorkflowTree.this.runToStep(workflowStep, workflowStep);
                }
            }
        };
        this.fRunAction.setComponentName("context.run");
        this.fContextMenu.add((Action)this.fRunAction);
        this.fRunToStepAction = new MJAbstractAction(BuiltInResources.getString("context.runToStep"), CommonIcon.REDO.getIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowStep workflowStep = WorkflowTree.this.getContextMenuStep();
                if (workflowStep != null) {
                    WorkflowTree.this.runToStep(workflowStep, WorkflowTree.this.fConfiguration.getTarget().getWorkflow().getSteps().get(0));
                }
            }
        };
        this.fRunToStepAction.setComponentName("context.runToStep");
        this.fContextMenu.add((Action)this.fRunToStepAction);
        this.fContextMenu.addSeparator();
        this.fResetStepAction = new MJAbstractAction(BuiltInResources.getString("context.resetStep"), CommonIcon.REFRESH.getIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowStep workflowStep = WorkflowTree.this.getContextMenuStep();
                if (workflowStep != null) {
                    WorkflowTree.this.reset(workflowStep);
                }
            }
        };
        this.fResetStepAction.setComponentName("context.resetStep");
        this.fContextMenu.add((Action)this.fResetStepAction);
        this.fContextMenu.addSeparator();
        this.fHelpAction = new MJAbstractAction(BuiltInResources.getString("context.help"), CommonIcon.HELP.getIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowStep workflowStep = WorkflowTree.this.getContextMenuStep();
                String string = PluginManager.resolveHelpMapPath(WorkflowTree.this.fConfiguration.getTarget().getHelpMapPath());
                MLHelpServices.cshDisplayTopic((Object)WorkflowTree.this.fTree.getParent(), (String)string, (String)workflowStep.getHelpKey());
            }
        };
        this.fHelpAction.setComponentName("context.help");
        this.fContextMenu.add((Action)this.fHelpAction);
        this.fMouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(mouseEvent);
                this.handlePopUp(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(mouseEvent);
                this.handlePopUp(mouseEvent);
            }

            private void handlePopUp(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    WorkflowTree.this.fContextMenuRow = WorkflowTree.this.fTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (WorkflowTree.this.fContextMenuRow > -1) {
                        WorkflowStep workflowStep = WorkflowTree.this.getContextMenuStep();
                        WorkflowTree.this.fResetStepAction.setEnabled(WorkflowTree.this.fConfiguration.getWorkflowStepResult(workflowStep) != WorkflowStepResult.SKIPPED && WorkflowTree.this.canReset(workflowStep) && (workflowStep.getScript() != null || !workflowStep.getSubSteps().isEmpty()));
                        WorkflowTree.this.fRunAction.setEnabled(WorkflowTree.this.fConfiguration.isStepAccessible(workflowStep) && (workflowStep.getScript() != null || !workflowStep.getSubSteps().isEmpty()));
                        WorkflowTree.this.fTree.setSelectionRow(WorkflowTree.this.fContextMenuRow);
                        WorkflowTree.this.fContextMenu.getSubElements()[WorkflowTree.this.fContextMenu.getSubElements().length - 2].getComponent().setVisible(workflowStep.getHelpKey() != null);
                        WorkflowTree.this.fContextMenu.getSubElements()[WorkflowTree.this.fContextMenu.getSubElements().length - 1].getComponent().setVisible(workflowStep.getHelpKey() != null);
                        WorkflowTree.this.fContextMenu.show((Component)WorkflowTree.this.fTree, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        };
        this.fTree.addMouseListener((MouseListener)this.fMouseAdapter);
        this.fTree.setRootVisible(false);
        TreeUtils.expandAllNodes((JTree)this.fTree);
        if (this.fTree.getRowCount() > 0) {
            this.fTree.setSelectionRow(0);
        }
        this.fTimerActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WorkflowTree.this.fTree.revalidate();
                WorkflowTree.this.fTree.repaint();
            }
        };
        this.fRefreshTimer = new Timer(100, this.fTimerActionListener);
        this.fRefreshTimer.setRepeats(true);
        this.fPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().startsWith("__step_visible:")) {
                    String string = propertyChangeEvent.getPropertyName().replace("__step_visible:", "__skip:");
                    WorkflowTree.this.fConfiguration.getVariableGraph().setValue(string, (Boolean)propertyChangeEvent.getNewValue() == false);
                    String string2 = propertyChangeEvent.getPropertyName().replace("__step_visible:", "__result:");
                    if (propertyChangeEvent.getNewValue().equals(Boolean.FALSE)) {
                        WorkflowTree.this.fConfiguration.getVariableGraph().setValue(string2, (Object)WorkflowStepResult.SKIPPED);
                    } else {
                        WorkflowTree.this.fConfiguration.getVariableGraph().setValue(string2, null);
                    }
                    WorkflowTree.this.updateSteps();
                    WorkflowTree.this.fTree.updateUI();
                    TreeUtils.expandAllNodes((JTree)WorkflowTree.this.fTree);
                }
            }
        };
        this.fConfiguration.addPropertyChangeListener(this.fPropertyChangeListener);
    }

    public void updateSteps() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                WorkflowStep workflowStep = WorkflowTree.this.fConfiguration.getTarget().getWorkflow().getSteps().iterator().next();
                WorkflowTree.this.updateStep(workflowStep, false);
            }
        };
        runnable.run();
        this.getComponent().revalidate();
        this.getComponent().repaint();
    }

    public boolean updateStep(WorkflowStep workflowStep, boolean bl) {
        boolean bl2 = bl;
        if (!workflowStep.isLeaf()) {
            Object object2;
            if (!this.fConfiguration.isStepVisible(workflowStep)) {
                return bl2;
            }
            for (Object object2 : workflowStep.getSubSteps()) {
                bl2 = this.updateStep((WorkflowStep)object2, bl2);
                if (this.fConfiguration.getWorkflowStepResult((WorkflowStep)object2) != WorkflowStepResult.ERROR) continue;
                break;
            }
            boolean bl3 = workflowStep.getParent() == null ? true : this.fConfiguration.isStepAccessible(workflowStep.getSubSteps().iterator().next());
            this.fConfiguration.setWorkflowStepAccessible(workflowStep, bl3);
            this.fConfiguration.setWorkflowStepExecutable(workflowStep, bl3);
            object2 = WorkflowStepResult.COMPLETED;
            for (WorkflowStep workflowStep2 : workflowStep.getSubSteps()) {
                WorkflowStepResult workflowStepResult = this.fConfiguration.getWorkflowStepResult(workflowStep2);
                if (workflowStepResult == WorkflowStepResult.COMPLETED || this.fConfiguration.isWorkflowStepSkipped(workflowStep2)) continue;
                object2 = workflowStepResult == WorkflowStepResult.ERROR ? workflowStepResult : null;
                if (bl2) break;
                this.fConfiguration.setWorkflowStepResult(workflowStep2, (WorkflowStepResult)((Object)object2));
                break;
            }
            if (this.fConfiguration.isWorkflowStepSkipped(workflowStep) && bl3 && object2 != WorkflowStepResult.COMPLETED) {
                this.fConfiguration.setWorkflowStepResult(workflowStep, WorkflowStepResult.SKIPPED);
            } else if (this.fConfiguration.getWorkflowStepResult(workflowStep) != object2) {
                this.fConfiguration.setWorkflowStepResult(workflowStep, (WorkflowStepResult)((Object)object2));
            }
        } else {
            this.fConfiguration.setWorkflowStepAccessible(workflowStep, !bl2);
            this.fConfiguration.setWorkflowStepExecutable(workflowStep, !bl2);
            if (!bl2) {
                WorkflowStepResult workflowStepResult = this.fConfiguration.getWorkflowStepResult(workflowStep);
                boolean bl4 = this.fConfiguration.isWorkflowStepSkipped(workflowStep);
                if (bl4 && (workflowStepResult == null || workflowStepResult == WorkflowStepResult.DEFAULT)) {
                    workflowStepResult = WorkflowStepResult.SKIPPED;
                    this.fConfiguration.setWorkflowStepResult(workflowStep, workflowStepResult);
                }
                if (!bl4 && workflowStepResult != WorkflowStepResult.COMPLETED && workflowStepResult != WorkflowStepResult.ERROR) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    private boolean canReset(WorkflowStep workflowStep) {
        if (this.fConfiguration.getWorkflowStepResult(workflowStep) != null && this.fConfiguration.getWorkflowStepResult(workflowStep) != WorkflowStepResult.DEFAULT) {
            return true;
        }
        for (WorkflowStep workflowStep2 : workflowStep.getSubSteps()) {
            if (!this.canReset(workflowStep2)) continue;
            return true;
        }
        return false;
    }

    private boolean isHierarchical() {
        Workflow workflow = this.fConfiguration.getTarget().getWorkflow();
        for (WorkflowStep workflowStep : workflow.getSteps()) {
            if (workflowStep.getSubSteps().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public JComponent getComponent() {
        return this.fTree;
    }

    public void notifyStepRunning(WorkflowStep workflowStep) {
        this.fRunningStep = workflowStep;
        this.fBusyAffordance.start();
        this.fRefreshTimer.start();
    }

    public void notifyStopped() {
        this.fBusyAffordance.stop();
        this.fRefreshTimer.stop();
        this.fRunningStep = null;
        this.fTree.revalidate();
        this.fTree.repaint();
    }

    public void repaint() {
        this.getComponent().repaint();
    }

    public void dispose() {
        this.fTree.removeTreeSelectionListener(this.fTreeSelectionListener);
        this.fConfiguration.removePropertyChangeListener(this.fPropertyChangeListener);
        this.fTree.removeMouseListener((MouseListener)this.fMouseAdapter);
        this.fTree.setCellRenderer(null);
        this.fBusyAffordance.stop();
        this.fRefreshTimer.stop();
        this.fRefreshTimer.removeActionListener(this.fTimerActionListener);
    }

    private WorkflowStep getContextMenuStep() {
        TreePath treePath = this.fTree.getPathForRow(this.fContextMenuRow);
        return treePath != null ? (WorkflowStep)treePath.getLastPathComponent() : null;
    }

    public void reset(WorkflowStep workflowStep) {
        List<WorkflowStep> list = this.fConfiguration.getTarget().getWorkflow().getFlattenedSteps();
        int n = list.indexOf(workflowStep);
        MatlabExpression matlabExpression = this.fConfiguration.getTarget().getWorflowResetCode();
        for (int i = n; i < list.size(); ++i) {
            WorkflowStep workflowStep2 = list.get(i);
            if (this.fConfiguration.getWorkflowStepResult(workflowStep2) == null) continue;
            this.fConfiguration.setWorkflowStepResult(workflowStep2, null);
            if (matlabExpression == null) continue;
            matlabExpression.evaluate(this.fConfiguration.getProject(), false, new String[]{"'" + workflowStep2.getKey() + "'"});
        }
        this.updateSteps();
    }

    private void resetChildrenRecursively(List<WorkflowStep> list) {
        for (WorkflowStep workflowStep : list) {
            this.fConfiguration.setWorkflowStepResult(workflowStep, null);
            this.resetChildrenRecursively(workflowStep.getSubSteps());
        }
    }

    private static boolean calculateStepsToExecute(List<WorkflowStep> list, WorkflowStep workflowStep, WorkflowStep workflowStep2, List<WorkflowStep> list2) {
        list2.add(workflowStep2);
        for (WorkflowStep workflowStep3 : workflowStep2.getSubSteps()) {
            boolean bl = WorkflowTree.calculateStepsToExecute(list, workflowStep, workflowStep3, list2);
            if (!bl) continue;
            return true;
        }
        return !workflowStep2.getParentHierachy().contains(workflowStep) && list.indexOf(workflowStep2) >= list.indexOf(workflowStep);
    }

    public void selectStep(WorkflowStep workflowStep) {
        Stack<WorkflowStep> stack = new Stack<WorkflowStep>();
        while (workflowStep != null) {
            stack.push(workflowStep);
            workflowStep = workflowStep.getParent();
        }
        Object[] objectArray = new Object[1 + stack.size()];
        objectArray[0] = this.fTree.getModel().getRoot();
        for (int i = 1; i < objectArray.length; ++i) {
            objectArray[i] = stack.pop();
        }
        this.fTree.setSelectionPath(new TreePath(objectArray));
    }

    public void runToStep(final WorkflowStep workflowStep, WorkflowStep workflowStep2) {
        this.fWalkThroughStepsWhileRunning = true;
        final ArrayList<WorkflowStep> arrayList = new ArrayList<WorkflowStep>();
        List<WorkflowStep> list = this.fConfiguration.getTarget().getWorkflow().getFlattenedSteps();
        int n = list.indexOf(workflowStep);
        if (list.size() > n + 1) {
            this.reset(workflowStep);
        }
        WorkflowTree.calculateStepsToExecute(list, workflowStep, workflowStep2, arrayList);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!arrayList.isEmpty()) {
                    WorkflowStep workflowStep3 = WorkflowTree.this.findRunnableStep(arrayList);
                    if (workflowStep3 == null) {
                        WorkflowTree.this.fWalkThroughStepsWhileRunning = false;
                        return;
                    }
                    if (WorkflowTree.this.fWalkThroughStepsWhileRunning) {
                        WorkflowTree.this.fAutoSelection = true;
                        WorkflowTree.this.selectStep(workflowStep3);
                        WorkflowTree.this.fAutoSelection = false;
                    }
                    arrayList.remove(workflowStep3);
                    if (!workflowStep3.equals(workflowStep) && WorkflowTree.this.fConfiguration.isWorkflowStepSkipped(workflowStep3) && !workflowStep.getParentHierachy().contains(workflowStep3)) {
                        WorkflowTree.this.fConfiguration.setWorkflowStepResult(workflowStep3, WorkflowStepResult.SKIPPED);
                        LinkedList<WorkflowStep> linkedList = new LinkedList<WorkflowStep>();
                        linkedList.addAll(workflowStep3.getSubSteps());
                        while (!linkedList.isEmpty()) {
                            WorkflowStep workflowStep2 = (WorkflowStep)linkedList.remove(0);
                            arrayList.remove(workflowStep2);
                            linkedList.addAll(workflowStep2.getSubSteps());
                        }
                        MJUtilities.runOnEventDispatchThread((Runnable)this);
                    } else if (workflowStep3.getScript() != null) {
                        DeploymentProcess deploymentProcess = (DeploymentProcess)WorkflowTree.this.fRunner.convert((Object)workflowStep3);
                        if (deploymentProcess != null) {
                            final 11 var3_5 = this;
                            deploymentProcess.addMonitor(new DeploymentProcessMonitor(){

                                public void finished() {
                                    MJUtilities.runOnEventDispatchThread((Runnable)var3_5);
                                }

                                public void subProcessStarted(SubProcessType subProcessType) {
                                }

                                public void commandStarted(String string) {
                                }

                                public void commandOutput(String string) {
                                }

                                public void commandError(String string) {
                                }

                                public void failed() {
                                }

                                public void canceled() {
                                }
                            });
                            deploymentProcess.start();
                        }
                    } else {
                        this.run();
                    }
                } else if (workflowStep.getScript() == null) {
                    WorkflowTree.this.fConfiguration.setWorkflowStepResult(workflowStep, WorkflowStepResult.COMPLETED);
                }
            }
        };
        runnable.run();
    }

    private WorkflowStep findRunnableStep(List<WorkflowStep> list) {
        for (WorkflowStep workflowStep : list) {
            WorkflowStepResult workflowStepResult = this.fConfiguration.getWorkflowStepResult(workflowStep);
            if (workflowStepResult != null && workflowStepResult.equals((Object)WorkflowStepResult.COMPLETED)) continue;
            return workflowStep;
        }
        return null;
    }

    private class Renderer
    extends DefaultTreeCellRenderer {
        private final BufferedImage iBusyImage = new BufferedImage(16, 16, 2);

        private Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (!(object instanceof WorkflowStep)) {
                return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            }
            WorkflowStep workflowStep = (WorkflowStep)object;
            boolean bl5 = WorkflowTree.this.fConfiguration.isStepAccessible(workflowStep);
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            WorkflowStepResult workflowStepResult = WorkflowTree.this.fConfiguration.getWorkflowStepResult(workflowStep);
            if (workflowStepResult != null) {
                this.setIcon(workflowStepResult.getIcon());
            } else {
                this.setIcon(ProjectIcon.WORKFLOW_STEP.getIcon());
            }
            if (workflowStep.equals(WorkflowTree.this.fRunningStep)) {
                Graphics2D graphics2D = (Graphics2D)this.iBusyImage.getGraphics();
                graphics2D.setColor(WorkflowTree.this.fTree.getBackground());
                graphics2D.fillRect(0, 0, 16, 16);
                WorkflowTree.this.fBusyAffordance.paintAffordance(graphics2D);
                graphics2D.dispose();
                this.setIcon(new ImageIcon(this.iBusyImage));
            } else if (!bl5) {
                this.setIcon(this.getDisabledIcon());
            }
            return component;
        }
    }
}

