/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.textfield;

import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.textfield.FormatTipContent;
import com.mathworks.project.impl.textfield.FormattedTextField;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.tree.TreeUtils;
import com.sun.awt.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;

public final class FormatTip {
    private TooltipWindow fToolTip;
    private Window fParentWindow;
    private FormatTipContent fContent;
    private Timer fFocusTimer;
    public static final Color BACKGROUND = new Color(221, 234, 248);
    public static final Color BORDER = new Color(20, 85, 148);

    public void close() {
        if (this.fToolTip != null) {
            this.fToolTip.dispose();
            this.fToolTip = null;
        }
        this.fContent = null;
        if (this.fFocusTimer != null) {
            this.fFocusTimer.stop();
            this.fFocusTimer = null;
        }
        this.fParentWindow = null;
    }

    public static boolean isInstance(Window window) {
        return window instanceof TooltipWindow;
    }

    public void update(FormattedTextField formattedTextField) {
        this.fParentWindow = SwingUtilities.windowForComponent(formattedTextField.getComponent());
        FormatTipContent formatTipContent = formattedTextField.getTipProvider().getTipComponent(formattedTextField);
        if (formatTipContent == null || !this.focusedWindowIsRelevant() || !FormatTip.isShowing(formattedTextField.getComponent())) {
            this.close();
        } else {
            int n;
            Cloneable cloneable;
            if (formatTipContent.getToken() != null) {
                cloneable = formattedTextField.getTokenRect(formatTipContent.getToken());
                n = (int)(((Rectangle)cloneable).getX() + ((Rectangle)cloneable).getWidth() / 2.0);
            } else {
                n = (int)formattedTextField.getComponent().getPreferredSize().getWidth();
            }
            if (this.fToolTip != null && this.fContent.getComponent().equals(formatTipContent.getComponent())) {
                cloneable = this.fToolTip.computeScreenAnchorPoint(formattedTextField.getComponent(), n);
                if (!((Point)cloneable).equals(this.fToolTip.getScreenAnchorPoint())) {
                    this.fToolTip.setSizeAndLocation(n);
                }
                return;
            }
            if (this.fToolTip == null) {
                this.fToolTip = new TooltipWindow(formattedTextField.getComponent());
            }
            this.fToolTip.update(formatTipContent.getComponent(), n);
            this.fToolTip.setFocusableWindowState(false);
            this.fToolTip.setVisible(true);
            this.fToolTip.setFocusableWindowState(true);
            this.startFocusTimer();
            this.fContent = formatTipContent;
        }
    }

    private static boolean isShowing(Component component) {
        if (!component.isShowing()) {
            return false;
        }
        JViewport jViewport = (JViewport)TreeUtils.findAncestorComponent((Component)component, JViewport.class);
        if (jViewport == null) {
            return true;
        }
        if (jViewport.getViewSize().equals(jViewport.getView().getSize()) && (jViewport = (JViewport)TreeUtils.findAncestorComponent((Component)jViewport.getParent(), JViewport.class)) == null) {
            return true;
        }
        Point point = component.getLocation();
        point = SwingUtilities.convertPoint(component.getParent(), point, jViewport.getView());
        point.y += component.getHeight();
        return jViewport.getViewRect().contains(point);
    }

    private boolean focusedWindowIsRelevant() {
        return this.fParentWindow != null && this.fParentWindow.isFocused() || this.fToolTip != null && this.fToolTip.isFocused();
    }

    private void startFocusTimer() {
        if (this.fFocusTimer == null) {
            this.fFocusTimer = new Timer(20, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!FormatTip.this.focusedWindowIsRelevant()) {
                        FormatTip.this.close();
                    }
                }
            });
            this.fFocusTimer.setRepeats(true);
            this.fFocusTimer.start();
        }
    }

    private static class TooltipWindow
    extends MJDialog {
        private final Component fParent;
        private Component fContent;
        private Point fScreenAnchorPoint;
        private Point fAnchorPoint;
        private boolean fAbove;

        TooltipWindow(Component component) {
            this.fParent = component;
            this.setUndecorated(true);
            this.setAlwaysOnTop(true);
            if (!PlatformInfo.isLinux()) {
                AWTUtilities.setWindowOpaque((Window)((Object)this), (boolean)false);
            } else {
                this.setBackground(BACKGROUND);
            }
            this.setLayout(new BorderLayout());
        }

        public void update(Component component, int n) {
            if (component.getParent() != null) {
                component.getParent().remove(component);
            }
            if (PlatformInfo.isLinux()) {
                MJPanel mJPanel = new MJPanel();
                mJPanel.setBackground(BACKGROUND);
                mJPanel.setBorder((Border)new LineBorder(BORDER));
                mJPanel.add(component);
                this.fContent = mJPanel;
            } else {
                this.fContent = component;
            }
            this.getContentPane().removeAll();
            this.getContentPane().add(this.fContent);
            this.setSizeAndLocation(n);
        }

        private void setSizeAndLocation(int n) {
            this.setSize((int)this.fContent.getPreferredSize().getWidth() + (PlatformInfo.isLinux() ? 0 : 28), (int)this.fContent.getPreferredSize().getHeight() + (PlatformInfo.isLinux() ? 0 : 24));
            Point point = this.fParent.getLocation();
            SwingUtilities.convertPointToScreen(point, this.fParent);
            Point point2 = this.computeScreenAnchorPoint(this.fParent, n);
            this.setLocation(point2.x - this.getWidth() / 2, point2.y);
            int n2 = this.fParent.getWidth() - (n + this.getWidth() / 2);
            if (n2 < 0) {
                this.setLocation(this.getX() + n2, this.getY());
            }
            this.fScreenAnchorPoint = point2;
            this.fAnchorPoint = point2;
            SwingUtilities.convertPointFromScreen(this.fAnchorPoint, (Component)((Object)this));
            this.repaint();
        }

        private Point computeScreenAnchorPoint(Component component, int n) {
            Point point = new Point(n, component.getHeight());
            SwingUtilities.convertPointToScreen(point, component);
            boolean bl = this.fAbove = point.getY() + (double)this.getHeight() >= Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            if (this.fAbove) {
                point = new Point(n, component.getY() - this.getHeight());
                SwingUtilities.convertPointToScreen(point, component);
            }
            return point;
        }

        public Point getScreenAnchorPoint() {
            return this.fScreenAnchorPoint;
        }

        public void paint(Graphics graphics) {
            if (PlatformInfo.isLinux()) {
                super.paint(graphics);
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n = (int)this.fAnchorPoint.getX();
            int n2 = n - 4;
            int n3 = n + 4;
            int n4 = this.fAbove ? this.getHeight() - 8 : 8;
            int n5 = this.fAbove ? this.getHeight() : 0;
            int n6 = this.fAbove ? 0 : this.getHeight() - 5 - 1;
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(new Line2D.Double(n, n5, n2, n4), true);
            generalPath.append(new Line2D.Double(n2, n4, 0.0, n4), true);
            generalPath.append(new Line2D.Double(0.0, n4, 0.0, n6), true);
            generalPath.append(new Line2D.Double(0.0, n6, this.getWidth() - 5 - 1, n6), true);
            generalPath.append(new Line2D.Double(this.getWidth() - 5 - 1, n6, this.getWidth() - 5 - 1, n4), true);
            generalPath.append(new Line2D.Double(this.getWidth() - 5 - 1, n4, n3, n4), true);
            generalPath.append(new Line2D.Double(n3, n4, n, n5), true);
            float f = 0.2f;
            int n7 = this.fAbove ? n4 + 1 : this.getHeight() - 5;
            int n8 = this.fAbove ? 5 : n4 + 5;
            int n9 = this.fAbove ? n4 : this.getHeight() - 6;
            for (int i = 0; i < 5; ++i) {
                graphics2D.setColor(new Color(0.0f, 0.0f, 0.0f, f));
                graphics2D.drawLine(this.getWidth() - 5 + i, n8 + i, this.getWidth() - 5 + i, n9 + i);
                graphics2D.drawLine(5 + i, n7 + i, this.getWidth() - 5 + i, n7 + i);
                f /= 2.0f;
            }
            if (!PlatformInfo.isLinux()) {
                graphics2D.setColor(new Color(0.86f, 0.92f, 0.97f, 0.93f));
            } else {
                graphics2D.setColor(new Color(0.86f, 0.92f, 0.97f));
            }
            graphics2D.fill(generalPath);
            graphics2D.setColor(BORDER);
            graphics2D.draw(generalPath);
            if (!PlatformInfo.isLinux()) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(TreeUtils.findComponents((Component)((Object)this), JTextComponent.class));
                arrayList.addAll(TreeUtils.findComponents((Component)((Object)this), JLabel.class));
                arrayList.addAll(TreeUtils.findComponents((Component)((Object)this), JCheckBox.class));
                for (Component component : arrayList) {
                    graphics2D.setColor(new Color(0.86f, 0.92f, 0.97f, 0.95f));
                    Point point = component.getLocation();
                    point = SwingUtilities.convertPoint(component.getParent(), point, (Component)((Object)this));
                    graphics2D.fill(new RoundRectangle2D.Double(point.x, point.y, component.getWidth(), component.getHeight(), 10.0, 10.0));
                }
            }
            graphics2D.dispose();
            this.paintComponents(graphics);
        }
    }
}

