/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.textfield;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.project.impl.textfield.FormattedTextField;
import com.mathworks.project.impl.textfield.FormattedTextFieldPainter;
import com.mathworks.project.impl.textfield.Token;
import com.mathworks.services.ColorPrefs;
import com.mathworks.util.Holder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class DefaultFormattedTextFieldPainter
implements FormattedTextFieldPainter {
    @Override
    public Map<Token, Rectangle> paint(FormattedTextField formattedTextField, final Graphics2D graphics2D) {
        String string;
        HashMap<Token, Rectangle> hashMap = new HashMap<Token, Rectangle>();
        final JComponent jComponent = formattedTextField.getComponent();
        int n = ((Component)jComponent).getHeight() / 2 + graphics2D.getFontMetrics().getAscent() / 2;
        int n2 = 1;
        Color color = formattedTextField.isEditable() ? ColorPrefs.getTextColor() : new Color(0xAAAAAA);
        graphics2D.setColor(UIManager.getColor("TextField.background"));
        graphics2D.fillRect(0, 0, ((Component)jComponent).getWidth(), ((Component)jComponent).getHeight());
        graphics2D.setFont(jComponent.getFont());
        if (formattedTextField.getText().length() == 0 && (string = formattedTextField.getPrompt()) != null) {
            graphics2D.setColor(new Color(100, 100, 100));
            graphics2D.drawString(string, n2, n);
        }
        graphics2D.setColor(ColorUtils.getTextSelectionBackgroundColor());
        if (!formattedTextField.isEditable() || formattedTextField.getSelectedFieldToken() == null) {
            graphics2D.fill(formattedTextField.getSelectionRect());
        }
        graphics2D.setColor(color);
        int n3 = 0;
        for (Token object : formattedTextField.getTokens()) {
            boolean bl;
            String string2 = this.maskPromptChars(object.getText());
            final int n4 = (int)graphics2D.getFontMetrics().getStringBounds(string2, graphics2D).getWidth();
            hashMap.put(object, new Rectangle(n2, 0, n4, graphics2D.getFontMetrics().getHeight()));
            boolean bl2 = bl = formattedTextField.isEditable() && this.hasBorder(object);
            if (bl) {
                final boolean bl3 = formattedTextField.isEditable() && formattedTextField.getSelectedFieldToken() == object;
                final int n5 = n2;
                this.withAntialiasing(graphics2D, new Runnable(){

                    @Override
                    public void run() {
                        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n5, 1.0, n4 + 4, jComponent.getHeight() - 2, 10.0, 10.0);
                        graphics2D.setColor(ColorUtils.getTextSelectionBackgroundColor());
                        if (bl3) {
                            graphics2D.fill(double_);
                        }
                        graphics2D.setColor(new Color(0xAAAAAA));
                        graphics2D.draw(double_);
                    }
                });
                graphics2D.setColor(color);
                n2 += 2;
            }
            this.drawWithSelection(formattedTextField, graphics2D, color, n3, string2, n2, n);
            n3 += string2.length();
            n2 += n4;
            if (!bl) continue;
            n2 += 4;
            ((Rectangle)hashMap.get((Object)object)).width += 4;
        }
        if (formattedTextField.isEditable() && formattedTextField.getCaret().isOn()) {
            Token token;
            graphics2D.setColor(color);
            Token token2 = formattedTextField.getTokenForCharIndex(formattedTextField.getInsertionPoint());
            if (token2 != null) {
                Token token3;
                String string3 = this.maskPromptChars(token2.getText());
                int n6 = formattedTextField.getTokenOffsetAtCharIndex(formattedTextField.getInsertionPoint());
                Rectangle rectangle = (Rectangle)hashMap.get(token2);
                String string4 = string3.substring(0, n6);
                n2 = (int)(rectangle.getX() + graphics2D.getFontMetrics().getStringBounds(string4, graphics2D).getWidth());
                if (formattedTextField.isEditable() && this.hasBorder(token2)) {
                    n2 += 2;
                } else if (formattedTextField.getInsertionPoint() > 0 && (token3 = formattedTextField.getTokenForCharIndex(formattedTextField.getInsertionPoint() - 1)) != null && formattedTextField.isEditable() && this.hasBorder(token3)) {
                    n2 -= 4;
                }
            } else if (formattedTextField.getInsertionPoint() > 0 && (token = formattedTextField.getTokenForCharIndex(formattedTextField.getInsertionPoint() - 1)) != null && formattedTextField.isEditable() && this.hasBorder(token)) {
                n2 -= 4;
            }
            graphics2D.drawLine(n2, 1, n2, ((Component)jComponent).getHeight() - 2);
        }
        return hashMap;
    }

    protected void drawWithSelection(FormattedTextField formattedTextField, Graphics2D graphics2D, Color color, int n, String string, int n2, int n3) {
        int n4 = Math.min(formattedTextField.getSelectionStart(), formattedTextField.getSelectionEnd());
        int n5 = Math.max(formattedTextField.getSelectionStart(), formattedTextField.getSelectionEnd());
        final LinkedList linkedList = new LinkedList();
        final TreeSet treeSet = new TreeSet();
        final StringBuilder stringBuilder = new StringBuilder();
        final Holder holder = new Holder((Object)false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (stringBuilder.length() > 0) {
                    linkedList.add(stringBuilder.toString());
                    if (((Boolean)holder.get()).booleanValue()) {
                        treeSet.add(stringBuilder.toString());
                    }
                    stringBuilder.setLength(0);
                }
            }
        };
        for (int i = 0; i < string.length(); ++i) {
            boolean bl;
            boolean bl2 = bl = n + i >= n4 && n + i < n5;
            if (bl != (Boolean)holder.get()) {
                runnable.run();
                holder.set((Object)bl);
            }
            stringBuilder.append(string.charAt(i));
        }
        runnable.run();
        for (String string2 : linkedList) {
            graphics2D.setColor(treeSet.contains(string2) ? ColorUtils.getTextSelectionForegroundColor() : color);
            graphics2D.drawString(string2, n2, n3);
            n2 += (int)graphics2D.getFontMetrics().getStringBounds(string2, graphics2D).getWidth();
        }
    }

    protected void withAntialiasing(Graphics2D graphics2D, Runnable runnable) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        runnable.run();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    protected boolean hasBorder(Token token) {
        return false;
    }

    protected boolean isPromptChar(char c) {
        return false;
    }

    protected String maskPromptChars(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            if (this.isPromptChar(string.charAt(i))) {
                stringBuilder.append(' ');
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }
}

