/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui.table;

import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.settingsui.ParamUtils;
import com.mathworks.project.impl.settingsui.ParamValuePopup;
import com.mathworks.project.impl.settingsui.table.AbstractSettingsCellEditor;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.widgets.SyntaxTextPane;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public final class MultilineTextCellEditor
extends AbstractSettingsCellEditor {
    private final PropertyTable<Param> fTable;
    private final ParamValuePopup fPopup;
    private final JTextComponent fTextField;
    private final JScrollPane fScrollPane;
    private final AdjustmentListener fScrollListener;
    private static final int VISIBLE_LINES = 10;

    public MultilineTextCellEditor(final PropertyTable<Param> propertyTable, final int n, final int n2, Configuration configuration, Param param) {
        super(configuration, param);
        this.fTable = propertyTable;
        this.fPopup = new ParamValuePopup(param.getKey());
        String string = configuration.getParamSyntax(param.getKey());
        if (string == null) {
            this.fTextField = new MJTextArea(10, 1);
        } else {
            this.fTextField = ParamUtils.createSyntaxTextPane(10, 1);
            ParamUtils.updateSyntax((SyntaxTextPane)this.fTextField, string);
        }
        this.fPopup.setParentCallback(new ReturnRunnable<Window>(){

            public Window run() {
                return SwingUtilities.windowForComponent(MultilineTextCellEditor.this.fTable.getComponent());
            }
        });
        this.fPopup.setContentCallback(new ReturnRunnable<Component>(){

            public Component run() {
                return new MJScrollPane((Component)MultilineTextCellEditor.this.fTextField);
            }
        });
        this.fPopup.setAnchorCallback(new ReturnRunnable<Point>(){

            public Point run() {
                Point point = MultilineTextCellEditor.this.fTable.getCellRect(n, n2).getLocation();
                MultilineTextCellEditor.this.fTable.convertPointToScreen(point);
                return point;
            }
        });
        this.fPopup.setWidthCallback(new ReturnRunnable<Integer>(){

            public Integer run() {
                return (int)MultilineTextCellEditor.this.fTable.getCellRect(n, n2).getWidth();
            }
        });
        this.fPopup.setCancelCallback(new Runnable(){

            @Override
            public void run() {
                MultilineTextCellEditor.this.fTable.setOverrideStopEditingOnFocusLost(false);
                MultilineTextCellEditor.this.fTable.stopEditing(true);
            }
        });
        this.fPopup.setCommitCallback(new Runnable(){

            @Override
            public void run() {
                MultilineTextCellEditor.this.fTable.setOverrideStopEditingOnFocusLost(false);
                MultilineTextCellEditor.this.fTable.stopEditing(false);
            }
        });
        this.fScrollPane = (JScrollPane)TreeUtils.findAncestorComponent((Component)propertyTable.getComponent(), JScrollPane.class);
        if (this.fScrollPane != null) {
            this.fScrollListener = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    if (MultilineTextCellEditor.this.fPopup.isShowing()) {
                        Rectangle rectangle = propertyTable.getCellRect(n, n2);
                        rectangle.height = 5;
                        rectangle.width = 5;
                        if (MultilineTextCellEditor.this.fScrollPane.getViewport().getViewRect().contains(rectangle)) {
                            MultilineTextCellEditor.this.fPopup.adjustPopupSizeAndPosition();
                        } else {
                            MultilineTextCellEditor.this.fPopup.close();
                        }
                    }
                }
            };
            this.fScrollPane.getVerticalScrollBar().addAdjustmentListener(this.fScrollListener);
        } else {
            this.fScrollListener = null;
        }
    }

    @Override
    public void setData(Object object, String string) {
        this.fTextField.setText(object == null ? "" : object.toString());
        this.fTable.setOverrideStopEditingOnFocusLost(true);
        this.fPopup.show();
    }

    @Override
    public Object getData() {
        return this.fTextField.getText();
    }

    @Override
    public JComponent getComponent() {
        return null;
    }

    @Override
    public void dispose() {
        this.fPopup.close();
        if (this.fScrollPane != null) {
            this.fScrollPane.getVerticalScrollBar().removeAdjustmentListener(this.fScrollListener);
        }
    }

    @Override
    public void activate() {
    }
}

