/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.filesetui;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJHelpButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.FileReferenceMode;
import com.mathworks.project.impl.model.SpecialFile;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.services.Prefs;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ReferenceOptionDialog {
    private static ReferenceOptionDialog sInstance;
    private static final Color BACKGROUND_COLOR;
    private final SpecialFile fFile;
    private final Configuration fConfiguration;
    private final MJDialog fDialog;
    private final FileSetEditor fEditor;
    private final String fReferenceModePreferenceKey;
    private final String fLocationPreferencePanelName;
    private final List<FileReferenceMode> fSupportedModes;
    private final PropertyChangeListener fConfigurationChangeListener;
    private final MulticastChangeListener fConfigurationChangeDelegates;
    private DialogPanel fPanel;

    public static void show(SpecialFile specialFile, Configuration configuration, FileSetEditor fileSetEditor, String string) {
        File file;
        List<FileReferenceMode> list;
        if (sInstance != null) {
            sInstance.dispose();
        }
        if ((list = ReferenceOptionDialog.getSupportedReferenceModes(specialFile, file = configuration.getSpecialFileLocation(specialFile), string)).size() == 1) {
            fileSetEditor.getFileSet().setReferenceMode(file, list.get(0));
            fileSetEditor.addAndSelect(new File[]{file}, true);
        } else {
            sInstance = new ReferenceOptionDialog(specialFile, configuration, fileSetEditor, string);
            sInstance.show();
        }
    }

    private ReferenceOptionDialog(SpecialFile specialFile, Configuration configuration, FileSetEditor fileSetEditor, String string) {
        this.fFile = specialFile;
        this.fConfiguration = configuration;
        this.fEditor = fileSetEditor;
        this.fReferenceModePreferenceKey = "DeployToolPrefsDefaultReferenceMode." + specialFile.getKey();
        this.fLocationPreferencePanelName = string;
        this.fConfigurationChangeDelegates = new MulticastChangeListener();
        this.fConfigurationChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(ReferenceOptionDialog.this.fFile.getKey())) {
                    ReferenceOptionDialog.this.fConfigurationChangeDelegates.stateChanged(new ChangeEvent(this));
                }
            }
        };
        File file = configuration.getSpecialFileLocation(specialFile);
        this.fSupportedModes = ReferenceOptionDialog.getSupportedReferenceModes(specialFile, file, string);
        Window window = SwingUtilities.windowForComponent(fileSetEditor.getComponent());
        this.fDialog = window instanceof Frame ? new MJDialog((Frame)window) : new MJDialog((Dialog)window);
        this.fDialog.setUndecorated(true);
        this.fDialog.setName("ReferenceOptionDialog");
        this.fPanel = new DialogPanel();
        this.fDialog.setContentPane((Container)this.fPanel.getComponent());
        this.runOnLocationChange(new Runnable(){

            @Override
            public void run() {
                FileReferenceMode fileReferenceMode = ReferenceOptionDialog.this.fPanel.getSelectedMode();
                ReferenceOptionDialog.this.fPanel = new DialogPanel();
                ReferenceOptionDialog.this.fPanel.setSelectedMode(fileReferenceMode);
                ReferenceOptionDialog.this.fDialog.setContentPane((Container)ReferenceOptionDialog.this.fPanel.getComponent());
                ReferenceOptionDialog.this.fDialog.pack();
                WindowUtils.ensureOnScreen((Window)sInstance.fDialog);
                ReferenceOptionDialog.this.fDialog.getRootPane().getDefaultButton().requestFocus();
                ReferenceOptionDialog.this.fDialog.repaint();
            }
        });
        this.fDialog.pack();
        this.fConfiguration.addPropertyChangeListener(this.fConfigurationChangeListener);
    }

    private void show() {
        Point point = this.fEditor.getComponent().getLocation();
        SwingUtilities.convertPointToScreen(point, this.fEditor.getComponent());
        this.fDialog.setLocation(point);
        this.fDialog.pack();
        this.fDialog.show();
        WindowUtils.ensureOnScreen((Window)this.fDialog);
        this.fDialog.getRootPane().getDefaultButton().requestFocus();
    }

    private void dispose() {
        this.fConfiguration.removePropertyChangeListener(this.fConfigurationChangeListener);
        this.fDialog.setVisible(false);
        this.fDialog.dispose();
    }

    private FileReferenceMode getDefaultLinkingMode() {
        String string = Prefs.getStringPref((String)this.fReferenceModePreferenceKey, (String)FileReferenceMode.DIRECT.toString());
        FileReferenceMode fileReferenceMode = FileReferenceMode.DIRECT;
        try {
            fileReferenceMode = FileReferenceMode.valueOf(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.fSupportedModes.contains((Object)fileReferenceMode)) {
            fileReferenceMode = this.fSupportedModes.get(0);
        }
        return fileReferenceMode;
    }

    private void saveDefaultLinkingMode(Map<FileReferenceMode, ? extends JToggleButton> map) {
        Prefs.setStringPref((String)this.fReferenceModePreferenceKey, (String)ReferenceOptionDialog.getSelectedKey(map).toString());
    }

    private JComponent createPreferenceLinkPanel(final Map<FileReferenceMode, ? extends JToggleButton> map) {
        HyperlinkTextLabel.HyperlinkHandler hyperlinkHandler = new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                MLPrefsDialogServices.showPrefsDialog((String)ReferenceOptionDialog.this.fLocationPreferencePanelName);
            }
        };
        final HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(MessageFormat.format(BuiltInResources.getString("referencedialog.preference.link"), this.fFile.getName()), hyperlinkHandler);
        hyperlinkTextLabel.getComponent().setName("link.preferences");
        final HyperlinkTextLabel hyperlinkTextLabel2 = new HyperlinkTextLabel(MessageFormat.format(BuiltInResources.getString("referencedialog.preference.link.change.required"), this.fFile.getName()), hyperlinkHandler);
        hyperlinkTextLabel.getComponent().setName("link.preferences");
        final MJLabel mJLabel = new MJLabel((Icon)DialogIcon.ERROR_12x12.getIcon());
        final MJPanel mJPanel = new MJPanel();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileReferenceMode fileReferenceMode = (FileReferenceMode)((Object)ReferenceOptionDialog.getSelectedKey(map));
                if (fileReferenceMode != null) {
                    mJPanel.removeAll();
                    mJPanel.revalidate();
                    mJPanel.repaint();
                    CellConstraints cellConstraints = new CellConstraints();
                    File file = ReferenceOptionDialog.this.fConfiguration.getSpecialFileLocation(ReferenceOptionDialog.this.fFile);
                    if (!fileReferenceMode.isLocationPortable(file)) {
                        mJPanel.setLayout((LayoutManager)new FormLayout("fill:d, 3dlu, fill:d", "p"));
                        mJPanel.add((Component)mJLabel, (Object)cellConstraints.xy(1, 1));
                        mJPanel.add((Component)hyperlinkTextLabel2.getComponent(), (Object)cellConstraints.xy(3, 1));
                    } else {
                        mJPanel.setLayout((LayoutManager)new FormLayout("fill:d", "p"));
                        mJPanel.add((Component)hyperlinkTextLabel.getComponent(), (Object)cellConstraints.xy(1, 1));
                    }
                    mJPanel.revalidate();
                    mJPanel.repaint();
                    ReferenceOptionDialog.this.fDialog.pack();
                }
            }
        };
        runnable.run();
        ReferenceOptionDialog.runOnChange(map.values(), runnable);
        this.runOnLocationChange(runnable);
        return mJPanel;
    }

    private JPanel createOkCancelButtons(final Map<FileReferenceMode, ? extends JToggleButton> map, final String string, final String string2) {
        JPanel jPanel;
        Object object;
        final MJButton mJButton = new MJButton(BuiltInResources.getString("button.ok"));
        mJButton.setName("button.ok");
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = ReferenceOptionDialog.this.fConfiguration.getSpecialFileLocation(ReferenceOptionDialog.this.fFile);
                FileReferenceMode fileReferenceMode = (FileReferenceMode)((Object)ReferenceOptionDialog.getSelectedKey(map));
                ReferenceOptionDialog.this.fEditor.getFileSet().setReferenceMode(file, fileReferenceMode);
                ReferenceOptionDialog.this.fEditor.addAndSelect(new File[]{file}, true);
                ReferenceOptionDialog.this.saveDefaultLinkingMode(map);
                ReferenceOptionDialog.this.dispose();
            }
        });
        MJButton mJButton2 = new MJButton(BuiltInResources.getString("button.cancel"));
        mJButton2.setName("button.cancel");
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReferenceOptionDialog.this.dispose();
            }
        });
        if (string != null && string2 != null) {
            object = new MJHelpButton();
            object.setName("button.help");
            object.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string3 = PluginManager.resolveHelpMapPath(string);
                    MLHelpServices.cshDisplayTopic((Object)ReferenceOptionDialog.this.fDialog, (String)string3, (String)string2);
                }
            });
            jPanel = PlatformInfo.isMacintosh() ? ButtonBarFactory.buildHelpBar((JButton)object, (JButton)mJButton2, (JButton)mJButton) : ButtonBarFactory.buildOKCancelHelpBar((JButton)mJButton, (JButton)mJButton2, (JButton)object);
        } else {
            jPanel = ButtonBarFactory.buildOKCancelBar((JButton)mJButton, (JButton)mJButton2);
        }
        object = new Runnable(){

            @Override
            public void run() {
                FileReferenceMode fileReferenceMode = (FileReferenceMode)((Object)ReferenceOptionDialog.getSelectedKey(map));
                if (fileReferenceMode != null) {
                    File file = ReferenceOptionDialog.this.fConfiguration.getSpecialFileLocation(ReferenceOptionDialog.this.fFile);
                    mJButton.setEnabled(fileReferenceMode.isLocationPortable(file));
                }
            }
        };
        object.run();
        ReferenceOptionDialog.runOnChange(map.values(), (Runnable)object);
        this.runOnLocationChange((Runnable)object);
        this.fDialog.getRootPane().setDefaultButton((JButton)mJButton);
        return jPanel;
    }

    private static List<FileReferenceMode> getSupportedReferenceModes(SpecialFile specialFile, File file, String string) {
        ArrayList<FileReferenceMode> arrayList = new ArrayList<FileReferenceMode>();
        for (FileReferenceMode fileReferenceMode : specialFile.getSupportedReferenceModes()) {
            if (string == null && !fileReferenceMode.isLocationPortable(file)) continue;
            arrayList.add(fileReferenceMode);
        }
        return arrayList;
    }

    private void runOnLocationChange(final Runnable runnable) {
        this.fConfigurationChangeDelegates.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MJUtilities.runOnEventDispatchThread((Runnable)runnable);
            }
        });
    }

    private static void runOnChange(Collection<? extends JToggleButton> collection, final Runnable runnable) {
        for (JToggleButton jToggleButton : collection) {
            jToggleButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    runnable.run();
                }
            });
        }
    }

    private static <K, V extends JToggleButton> K getSelectedKey(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!((JToggleButton)entry.getValue()).isSelected()) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        BACKGROUND_COLOR = ColorUtils.convertToCurrentColorScheme((Color)new Color(242, 241, 246), (Color)UIManager.getColor("control"));
    }

    private class DialogPanel {
        private final MJPanel iPanel = new MJPanel();
        private final Map<FileReferenceMode, MJRadioButton> iButtons;

        DialogPanel() {
            Object object;
            Object object22;
            this.iPanel.setBackground(BACKGROUND_COLOR);
            this.iPanel.setBorder(new MJPopupMenu().getBorder());
            MJLabel mJLabel = new MJLabel(MessageFormat.format(BuiltInResources.getString("referencedialog.prompt"), ReferenceOptionDialog.this.fFile.getName()));
            this.iButtons = new LinkedHashMap<FileReferenceMode, MJRadioButton>();
            ButtonGroup buttonGroup = new ButtonGroup();
            FileReferenceMode fileReferenceMode = ReferenceOptionDialog.this.getDefaultLinkingMode();
            File file = ReferenceOptionDialog.this.fConfiguration.getSpecialFileLocation(ReferenceOptionDialog.this.fFile);
            for (Object object22 : ReferenceOptionDialog.this.fSupportedModes) {
                object = new MJRadioButton(((FileReferenceMode)((Object)object22)).getOptionText(ReferenceOptionDialog.this.fFile.getName(), file));
                object.setName("option." + ((Enum)object22).toString());
                object.setOpaque(false);
                if (object22 == fileReferenceMode) {
                    object.setSelected(true);
                }
                this.iButtons.put((FileReferenceMode)((Object)object22), (MJRadioButton)object);
                buttonGroup.add((AbstractButton)object);
            }
            JPanel jPanel = ReferenceOptionDialog.this.createOkCancelButtons(this.iButtons, ReferenceOptionDialog.this.fConfiguration.getTarget().getHelpMapPath(), ReferenceOptionDialog.this.fFile.getHelpTopicKey());
            jPanel.setBackground(BACKGROUND_COLOR);
            object22 = ReferenceOptionDialog.this.createPreferenceLinkPanel(this.iButtons);
            ((JComponent)object22).setBackground(BACKGROUND_COLOR);
            object = new StringBuilder();
            ((StringBuilder)object).append("3dlu, p, 3dlu, ");
            for (int i = 0; i < this.iButtons.size(); ++i) {
                if (i < this.iButtons.size() - 1) {
                    ((StringBuilder)object).append("p, 3dlu, ");
                    continue;
                }
                ((StringBuilder)object).append("p, 8dlu, ");
            }
            if (ReferenceOptionDialog.this.fLocationPreferencePanelName != null) {
                ((StringBuilder)object).append(" p, 8dlu, ");
            }
            ((StringBuilder)object).append(" p, 3dlu ");
            this.iPanel.setLayout((LayoutManager)new FormLayout("3dlu, p, 3dlu", ((StringBuilder)object).toString()));
            CellConstraints cellConstraints = new CellConstraints();
            this.iPanel.add((Component)mJLabel, (Object)cellConstraints.xy(2, 2));
            int n = 4;
            for (MJRadioButton mJRadioButton : this.iButtons.values()) {
                this.iPanel.add((Component)mJRadioButton, (Object)cellConstraints.xy(2, n));
                n += 2;
            }
            if (object22 != null) {
                this.iPanel.add((Component)object22, (Object)cellConstraints.xy(2, n));
                n += 2;
            }
            this.iPanel.add((Component)jPanel, (Object)cellConstraints.xy(2, n));
        }

        JComponent getComponent() {
            return this.iPanel;
        }

        FileReferenceMode getSelectedMode() {
            return (FileReferenceMode)((Object)ReferenceOptionDialog.getSelectedKey(this.iButtons));
        }

        void setSelectedMode(FileReferenceMode fileReferenceMode) {
            MJRadioButton mJRadioButton = this.iButtons.get((Object)fileReferenceMode);
            if (mJRadioButton != null) {
                mJRadioButton.setSelected(true);
            }
        }
    }
}

