/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.desktop;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlwidgets.dialog.PopupDialog;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.validation.ValidatableTextField;
import com.mathworks.mwswing.validation.ValidationListener;
import com.mathworks.mwswing.validation.Validity;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.ProjectNameValidator;
import com.mathworks.project.impl.ProjectPrefs;
import com.mathworks.project.impl.model.Project;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

final class RenameDialog {
    private RenameDialog() {
    }

    static void invoke(final Project project, Component component) {
        final PopupDialog popupDialog = new PopupDialog();
        final MJButton mJButton = new MJButton(BuiltInResources.getString("button.ok"));
        MJButton mJButton2 = new MJButton(BuiltInResources.getString("button.cancel"));
        final ValidatableTextField validatableTextField = new ValidatableTextField(new ProjectNameValidator(project.getFile()).withoutHelp());
        validatableTextField.setColumns(25);
        validatableTextField.setText(project.getConfiguration().getName());
        JPanel jPanel = ButtonBarFactory.buildOKCancelBar((JButton)mJButton, (JButton)mJButton2);
        jPanel.setOpaque(false);
        CellConstraints cellConstraints = new CellConstraints();
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("3dlu, fill:d, 3dlu, fill:d:grow, 3dlu", "3dlu, d, 8dlu:grow, d, 3dlu"));
        mJPanel.add((Component)new MJLabel(BuiltInResources.getString("rename.prompt.label")), (Object)cellConstraints.xy(2, 2));
        mJPanel.add((Component)validatableTextField, (Object)cellConstraints.xy(4, 2));
        mJPanel.add((Component)jPanel, (Object)cellConstraints.xyw(2, 4, 3));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = validatableTextField.getText().trim();
                if (!string.toLowerCase(Locale.ENGLISH).startsWith(".prj".toLowerCase(Locale.ENGLISH))) {
                    string = string + ".prj";
                }
                File file = new File(project.getFile().getParentFile(), string);
                project.setFile(file);
                ProjectPrefs.LAST_OPEN_FILE.set(file.getAbsolutePath());
                popupDialog.hide();
            }
        });
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                popupDialog.hide();
            }
        });
        validatableTextField.addValidationListener(new ValidationListener(){

            public void validityChanged(Validity validity, Validity validity2) {
                mJButton.setEnabled(validity2 != Validity.INVALID);
            }
        });
        validatableTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    mJButton.doClick();
                }
            }
        });
        mJButton.setEnabled(validatableTextField.getValidity() != Validity.INVALID);
        popupDialog.addSection(BuiltInResources.getString("rename.title"), mJPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                validatableTextField.requestFocus();
                validatableTextField.selectAll();
            }
        });
        popupDialog.show(component, 0, component.getHeight());
    }
}

