/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MouseUtils;
import com.mathworks.mwswing.dialog.MJFolderChooser;
import com.mathworks.mwswing.validation.ValidationListener;
import com.mathworks.mwswing.validation.Validity;
import com.mathworks.project.impl.BrowseButton;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.DeployToolTestUtils;
import com.mathworks.project.impl.DocumentCellRenderer;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.ProjectLocationValidator;
import com.mathworks.project.impl.ProjectNameValidator;
import com.mathworks.project.impl.ProjectPrefs;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.project.impl.model.ProjectType;
import com.mathworks.project.impl.model.Target;
import com.mathworks.project.impl.model.XslInput;
import com.mathworks.project.impl.plugin.PluginManager;
import com.mathworks.util.FileUtils;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.TextFieldWithBalloonTip;
import com.mathworks.widgets.ValidatableWithHelp;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class NewOrOpenDialog {
    private final TextFieldWithBalloonTip fNameField;
    private final TextFieldWithBalloonTip fLocationField;
    private final TargetSelector fTargetSelector;
    private final MJList fRecentProjectList;
    private final MJTabbedPane fTabs;
    private final MJButton fNewOkButton;
    private final MJButton fOpenOkButton;
    private final MJFrame fDialog = new MJFrame();
    private static NewOrOpenDialog sInstance;

    private NewOrOpenDialog(String[] stringArray, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        ProjectType projectType;
        ProjectType projectType22;
        this.fLocationField = new TextFieldWithBalloonTip((ValidatableWithHelp)new ProjectLocationValidator());
        this.fLocationField.getTextField().setName("newproject.location");
        this.fLocationField.getTextField().setColumns(35);
        this.fNameField = new TextFieldWithBalloonTip((ValidatableWithHelp)new ProjectNameValidator(new ReturnRunnable<File>(){

            public File run() {
                return new File(NewOrOpenDialog.this.fLocationField.getText().trim());
            }
        }));
        this.fNameField.getTextField().setColumns(35);
        this.fNameField.getTextField().setName("newproject.name");
        BrowseButton browseButton = new BrowseButton();
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(NewOrOpenDialog.this.fLocationField.getText());
                if (!file.exists() || !file.isDirectory()) {
                    file = file.getParentFile();
                }
                if (file == null || !file.exists()) {
                    file = MatlabPath.getCurrentDirectory();
                }
                MJFolderChooser.browseForFolder((Component)NewOrOpenDialog.this.fDialog, (String)BuiltInResources.getString("prompt.location"), (ActionListener)new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = actionEvent.getActionCommand();
                        if (string != null && string.length() > 1) {
                            NewOrOpenDialog.this.fLocationField.setText(string);
                        }
                    }
                }, (File)file);
            }
        });
        browseButton.setName("newproject.browse");
        this.fTargetSelector = new ComboBoxTargetSelector(stringArray);
        HashSet<String> hashSet = new HashSet<String>();
        for (ProjectType projectType22 : this.fTargetSelector.getTypes()) {
            hashSet.add(projectType22.getTarget().getPlugin().getKey());
        }
        if (hashSet.size() > 1) {
            bl = false;
        }
        this.fRecentProjectList = new MJList();
        this.fRecentProjectList.getSelectionModel().setSelectionMode(0);
        this.fRecentProjectList.setName("openproject.recent");
        this.fRecentProjectList.setCellRenderer((ListCellRenderer)new DocumentCellRenderer());
        this.fRecentProjectList.setListData(new Vector<File>(ProjectManager.getRecentProjects(Integer.MAX_VALUE)));
        if (this.fRecentProjectList.getModel().getSize() > 0) {
            this.fRecentProjectList.setSelectedIndex(0);
        }
        this.fRecentProjectList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (MouseUtils.isDoubleClickEvent((MouseEvent)mouseEvent)) {
                    NewOrOpenDialog.this.doOpen((File)NewOrOpenDialog.this.fRecentProjectList.getSelectedValue());
                }
            }
        });
        this.fRecentProjectList.setVisibleRowCount(6);
        if (this.fRecentProjectList.getModel().getSize() == 0) {
            this.fRecentProjectList.setFixedCellHeight(18);
        }
        Iterator<ProjectType> iterator = new MJAbstractAction(BuiltInResources.getString("button.cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                NewOrOpenDialog.this.fDialog.setVisible(false);
                NewOrOpenDialog.this.fDialog.dispose();
                sInstance = null;
            }
        };
        projectType22 = new MJAbstractAction(BuiltInResources.getString("button.ok")){

            public void actionPerformed(ActionEvent actionEvent) {
                NewOrOpenDialog.this.doNew();
            }
        };
        this.fTargetSelector.addChangeListener(new ChangeListener((MJAbstractAction)projectType22){
            final /* synthetic */ MJAbstractAction val$newOkAction;
            {
                this.val$newOkAction = mJAbstractAction;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ProjectType projectType = NewOrOpenDialog.this.fTargetSelector.getSelectedType();
                this.val$newOkAction.setEnabled(projectType != null);
            }
        });
        projectType22.setTip(null);
        iterator.setTip(null);
        this.fNewOkButton = new MJButton((Action)((Object)projectType22));
        this.fNewOkButton.setName("newproject.ok");
        MJButton mJButton = new MJButton(iterator);
        mJButton.setName("newproject.cancel");
        JPanel jPanel = ButtonBarFactory.buildRightAlignedBar((JButton)this.fNewOkButton, (JButton)mJButton);
        ValidationListener validationListener = new ValidationListener(){

            public void validityChanged(Validity validity, Validity validity2) {
                NewOrOpenDialog.this.fNewOkButton.setEnabled(validity2 != Validity.INVALID);
            }
        };
        this.fNameField.getTextField().addValidationListener(validationListener);
        this.fLocationField.getTextField().addValidationListener(validationListener);
        MJButton mJButton2 = new MJButton(BuiltInResources.getString("button.browse"));
        mJButton2.setName("openproject.browse");
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewOrOpenDialog.browseForProject((Component)NewOrOpenDialog.this.fDialog, new ParameterRunnable<File>(){

                    public void run(File file) {
                        NewOrOpenDialog.this.doOpen(file);
                    }
                });
            }
        });
        final MJAbstractAction mJAbstractAction = new MJAbstractAction(BuiltInResources.getString("button.ok")){

            public void actionPerformed(ActionEvent actionEvent) {
                NewOrOpenDialog.this.doOpen((File)NewOrOpenDialog.this.fRecentProjectList.getSelectedValue());
            }
        };
        mJAbstractAction.setTip(null);
        this.fOpenOkButton = new MJButton((Action)mJAbstractAction);
        this.fOpenOkButton.setName("openproject.ok");
        MJButton mJButton3 = new MJButton(iterator);
        mJButton3.setName("openproject.cancel");
        JPanel jPanel2 = ButtonBarFactory.buildRightAlignedBar((JButton)mJButton2, (JButton)this.fOpenOkButton, (JButton)mJButton3);
        jPanel2.setOpaque(false);
        mJAbstractAction.setEnabled(this.fRecentProjectList.getSelectedIndex() != -1);
        this.fRecentProjectList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                mJAbstractAction.setEnabled(NewOrOpenDialog.this.fRecentProjectList.getSelectedIndex() != -1);
            }
        });
        File file = MatlabPath.getCurrentDirectory();
        File file2 = FileUtils.getNextNamedFile((File)file, (String)"Untitled", (String)".prj", (FileFilter[])new FileFilter[0]);
        this.fLocationField.setText(file.getAbsolutePath());
        this.fNameField.setText(file2.getName());
        this.fNewOkButton.setEnabled(this.fNameField.getTextField().getValidity() != Validity.INVALID && this.fLocationField.getTextField().getValidity() != Validity.INVALID);
        String string = ProjectPrefs.LAST_SELECTED_TARGET_KEY.get();
        Target target = PluginManager.getLicensedTarget(string);
        List<ProjectType> list = this.fTargetSelector.getTypes();
        if (target != null) {
            this.fTargetSelector.setSelectedType(target.getProjectTypes().get(0));
        } else {
            projectType = NewOrOpenDialog.getProjectTypeByName(string);
            if (projectType != null) {
                this.fTargetSelector.setSelectedType(projectType);
            } else if (!list.isEmpty()) {
                this.fTargetSelector.setSelectedType(list.get(0));
            }
        }
        this.fDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NewOrOpenDialog.this.fDialog.dispose();
                sInstance = null;
            }
        });
        projectType = new CellConstraints();
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("d:grow, " + (PlatformInfo.isMacintosh() ? "1dlu" : "3dlu") + ", p", "center:p"));
        mJPanel.setOpaque(false);
        mJPanel.add((Component)this.fLocationField.getTextField(), (Object)projectType.xy(1, 1));
        mJPanel.add((Component)((Object)browseButton), (Object)projectType.xy(3, 1));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new FormLayout("10dlu, d, 4dlu, fill:d:grow, 3dlu", "10dlu, p, 4dlu, p, " + (bl ? "" : "4dlu, p, ") + " 8dlu:grow, p, 4dlu"));
        mJPanel2.add((Component)new MJLabel(BuiltInResources.getString("newproject.label.name")), (Object)projectType.xy(2, 2));
        mJPanel2.add((Component)this.fNameField.getTextField(), (Object)projectType.xy(4, 2));
        mJPanel2.add((Component)new MJLabel(BuiltInResources.getString("newproject.label.location")), (Object)projectType.xy(2, 4));
        mJPanel2.add((Component)mJPanel, (Object)projectType.xy(4, 4));
        if (!bl) {
            mJPanel2.add((Component)new MJLabel(BuiltInResources.getString("newproject.label.target")), (Object)projectType.xy(2, 6));
            mJPanel2.add((Component)this.fTargetSelector.getComponent(), (Object)projectType.xy(4, 6));
        }
        mJPanel2.add((Component)jPanel, (Object)projectType.xyw(2, bl ? 6 : 8, 3));
        jPanel.setOpaque(false);
        mJPanel2.setOpaque(false);
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new FormLayout("3dlu, fill:d:grow, 3dlu", "3dlu, d, 3dlu, fill:d:grow, 8dlu, p, 4dlu"));
        mJPanel3.setOpaque(false);
        mJPanel3.add((Component)new MJLabel(BuiltInResources.getString("openproject.recent.prompt")), (Object)projectType.xy(2, 2));
        mJPanel3.add((Component)new MJScrollPane((Component)this.fRecentProjectList), (Object)projectType.xy(2, 4));
        mJPanel3.add((Component)jPanel2, (Object)projectType.xy(2, 6));
        this.fTabs = new MJTabbedPane(1){

            public void requestFocus() {
                if (this.getSelectedIndex() == 0) {
                    String string = NewOrOpenDialog.this.fNameField.getText();
                    if (string.endsWith(".prj")) {
                        NewOrOpenDialog.this.fNameField.getTextField().setSelectAllOnFocus(false);
                        NewOrOpenDialog.this.fNameField.getTextField().select(0, string.length() - ".prj".length());
                        NewOrOpenDialog.this.fNameField.getTextField().requestFocus();
                        Timer timer = new Timer(300, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                NewOrOpenDialog.this.fNameField.getTextField().setSelectAllOnFocus(true);
                            }
                        });
                        timer.setRepeats(false);
                        timer.start();
                    } else {
                        NewOrOpenDialog.this.fNameField.getTextField().selectAll();
                        NewOrOpenDialog.this.fNameField.getTextField().requestFocus();
                    }
                } else {
                    NewOrOpenDialog.this.fRecentProjectList.requestFocus();
                }
            }
        };
        this.fTabs.setName("neworopen.tabs");
        this.fTabs.addTab("  " + BuiltInResources.getString("tab.newproject") + "  ", (Component)mJPanel2);
        this.fTabs.addTab(" " + BuiltInResources.getString("tab.openproject") + " ", (Component)mJPanel3);
        this.fTabs.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                NewOrOpenDialog.this.setAppropriateDefaultButton();
            }
        });
        this.fDialog.setLayout((LayoutManager)new FormLayout("3dlu, fill:d:grow, 3dlu", "2dlu, fill:d:grow, 3dlu"));
        this.fDialog.add((Component)this.fTabs, (Object)projectType.xy(2, 2));
        this.fDialog.setTitle(this.hasDeploymentOptions() ? BuiltInResources.getString("newproject.title.deployment") : BuiltInResources.getString("newproject.title.codegen"));
        if (bl && (object3 = ((Target)(object2 = this.fTargetSelector.getSelectedType().getTarget())).getNewWindowTitle()) != null) {
            object = object3.evaluateString(new XslInput(ProjectManager.createStaticXslInput()));
            String string2 = ((Target)object2).getResourceString((String)object);
            this.fDialog.setTitle(string2);
        }
        this.fDialog.setName("dialog.newopen");
        this.setAppropriateDefaultButton();
        this.fDialog.pack();
        this.fDialog.setMinimumSize(this.fDialog.getSize());
        object2 = MLDesktop.getInstance().getMainFrame();
        object3 = ProjectGUI.getInstance().getCurrentClient();
        if (object3 != null && object3.getComponent().isShowing() && (object = SwingUtilities.windowForComponent(object3.getComponent())) != null && !object.equals(object2)) {
            object2 = object;
        }
        this.fDialog.setLocationRelativeTo((Component)object2);
        this.fTabs.requestFocus();
    }

    private void setAppropriateDefaultButton() {
        if (this.fTabs.getSelectedIndex() == 0) {
            this.fDialog.getRootPane().setDefaultButton((JButton)this.fNewOkButton);
        } else {
            this.fDialog.getRootPane().setDefaultButton((JButton)this.fOpenOkButton);
        }
    }

    private void doNew() {
        this.fDialog.setVisible(false);
        this.fDialog.dispose();
        sInstance = null;
        ProjectGUI.getInstance().createAndOpen(this.getSelectedNewProjectFile(), this.fTargetSelector.getSelectedType());
    }

    private void doOpen(File file) {
        ProjectGUI.getInstance().open(file);
        this.fDialog.setVisible(false);
        this.fDialog.dispose();
        sInstance = null;
    }

    public static void invoke() {
        NewOrOpenDialog.invoke(false);
    }

    public static void invoke(boolean bl) {
        NewOrOpenDialog.invoke(bl, (String)null);
    }

    public static void invoke(boolean bl, String string) {
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        NewOrOpenDialog.invoke(bl, stringArray);
    }

    public static void invoke(boolean bl, String[] stringArray) {
        NewOrOpenDialog.invoke(bl, stringArray, false);
    }

    public static void invoke(boolean bl, String string, boolean bl2) {
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        NewOrOpenDialog.invoke(bl, stringArray, bl2);
    }

    public static void invoke(final boolean bl, final String[] stringArray, final boolean bl2) {
        ProjectGUI.init();
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (PluginManager.getLicensedTargets().isEmpty()) {
                    return;
                }
                if (sInstance != null) {
                    sInstance.getDialog().setVisible(true);
                } else {
                    sInstance = new NewOrOpenDialog(stringArray, bl2);
                    sInstance.getDialog().setVisible(true);
                    if (bl) {
                        sInstance.getTabs().setSelectedIndex(1);
                    } else {
                        sInstance.getTabs().setSelectedIndex(0);
                    }
                }
            }
        });
    }

    private MJTabbedPane getTabs() {
        return this.fTabs;
    }

    private MJFrame getDialog() {
        return this.fDialog;
    }

    private File getSelectedNewProjectFile() {
        String string = this.fNameField.getText().trim();
        if (!string.endsWith(".prj")) {
            string = string + ".prj";
        }
        return new File(new File(this.fLocationField.getText().trim()), string);
    }

    public static void browseForProject(Component component, ParameterRunnable<File> parameterRunnable) {
        if (DeployToolTestUtils.isUsingSimpleFileDialogs()) {
            File[] fileArray = DeployToolTestUtils.showSimpleFileChooser();
            if (fileArray != null) {
                if (fileArray.length != 1) {
                    throw new IllegalStateException("Only one file can be selected here");
                }
                parameterRunnable.run((Object)fileArray[0]);
            }
        } else {
            MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
            mJFileChooserPerPlatform.addChoosableFileFilter(new FilePatternFilter(){

                public String getDescription() {
                    return BuiltInResources.getString("filter.projectfile");
                }

                public String[] getPatterns() {
                    return new String[]{"*.prj"};
                }
            });
            mJFileChooserPerPlatform.setCurrentDirectory(MatlabPath.getCurrentDirectory());
            mJFileChooserPerPlatform.showOpenDialog(component);
            if (mJFileChooserPerPlatform.getState() != 1) {
                parameterRunnable.run((Object)mJFileChooserPerPlatform.getSelectedFile());
            }
        }
    }

    private boolean hasDeploymentOptions() {
        for (ProjectType projectType : this.fTargetSelector.getTypes()) {
            if (!PluginManager.isDeploymentTarget(projectType.getTarget())) continue;
            return true;
        }
        return false;
    }

    private static ProjectType getProjectTypeByName(String string) {
        for (Target target : PluginManager.getLicensedTargets()) {
            for (ProjectType projectType : PluginManager.getLicensedProjectTypes(target)) {
                if (!projectType.getName().equals(string)) continue;
                return projectType;
            }
        }
        return null;
    }

    private static class ComboBoxTargetSelector
    implements TargetSelector {
        private final MJComboBox fComboBox = new MJComboBox();

        ComboBoxTargetSelector(String[] stringArray) {
            this.fComboBox.setName("newproject.target");
            this.fComboBox.setRenderer((ListCellRenderer)new TargetComboBoxRenderer());
            List<Target> list = PluginManager.getLicensedTargets();
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Target target : list) {
                if (stringArray != null && !Arrays.asList(stringArray).contains(target.getPlugin().getKey())) continue;
                for (ProjectType projectType : PluginManager.getLicensedProjectTypes(target)) {
                    if (!treeSet.add(projectType.getName().trim())) continue;
                    this.fComboBox.addItem((Object)projectType);
                }
            }
        }

        @Override
        public JComponent getComponent() {
            return this.fComboBox;
        }

        @Override
        public ProjectType getSelectedType() {
            return (ProjectType)this.fComboBox.getSelectedItem();
        }

        @Override
        public void setSelectedType(ProjectType projectType) {
            this.fComboBox.setSelectedItem((Object)projectType);
        }

        @Override
        public List<ProjectType> getTypes() {
            ArrayList<ProjectType> arrayList = new ArrayList<ProjectType>();
            for (int i = 0; i < this.fComboBox.getModel().getSize(); ++i) {
                arrayList.add((ProjectType)this.fComboBox.getModel().getElementAt(i));
            }
            return arrayList;
        }

        @Override
        public void addChangeListener(final ChangeListener changeListener) {
            this.fComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    changeListener.stateChanged(new ChangeEvent(ComboBoxTargetSelector.this));
                }
            });
        }
    }

    private static interface TargetSelector {
        public JComponent getComponent();

        public ProjectType getSelectedType();

        public void setSelectedType(ProjectType var1);

        public List<ProjectType> getTypes();

        public void addChangeListener(ChangeListener var1);
    }

    private static class TargetComboBoxRenderer
    extends DefaultListCellRenderer {
        private TargetComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ProjectType projectType = (ProjectType)object;
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setText(projectType.getName());
            this.setIcon(projectType.getIcon());
            return component;
        }
    }
}

