/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl;

import com.mathworks.util.ParameterRunnable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class InterruptibleQueue<T> {
    private final long fInterval;
    private final ParameterRunnable<List<T>> fProcessor;
    private final Object fForceSignal;
    private final Object fDeadSignal;
    private final Object fQueueLock;
    private final List<T> fQueue;
    private final Thread fThread;
    private volatile boolean fStarted;
    private volatile boolean fDisposed;

    public InterruptibleQueue(long l, ParameterRunnable<List<T>> parameterRunnable) {
        this.fInterval = l;
        this.fProcessor = parameterRunnable;
        this.fForceSignal = new Object();
        this.fDeadSignal = new Object();
        this.fQueueLock = new Object();
        this.fQueue = new LinkedList<T>();
        this.fThread = new Thread(new Runnable(){

            @Override
            public void run() {
                InterruptibleQueue.this.loop();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(T t) {
        Object object = this.fQueueLock;
        synchronized (object) {
            this.fQueue.add(t);
            if (!this.fStarted) {
                this.fThread.start();
                this.fStarted = true;
            }
        }
    }

    public void dispose() {
        this.fDisposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAndWait() {
        this.fDisposed = true;
        this.force();
        try {
            Object object = this.fDeadSignal;
            synchronized (object) {
                this.fDeadSignal.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPendingRequests() {
        Object object = this.fQueueLock;
        synchronized (object) {
            this.fQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void force() {
        Object object = this.fForceSignal;
        synchronized (object) {
            this.fForceSignal.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loop() {
        ArrayList<T> arrayList;
        while (!this.fDisposed) {
            try {
                arrayList = this.fForceSignal;
                synchronized (arrayList) {
                    this.fForceSignal.wait(this.fInterval);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Object object = this.fQueueLock;
            synchronized (object) {
                arrayList = new ArrayList<T>(this.fQueue);
                this.fQueue.clear();
            }
            if (arrayList.isEmpty()) continue;
            this.fProcessor.run(arrayList);
        }
        arrayList = this.fDeadSignal;
        synchronized (arrayList) {
            this.fDeadSignal.notifyAll();
        }
    }
}

