/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search;

import com.mathworks.search.SearchException;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CompoundSearchExpression
extends SearchExpression {
    private List<SearchExpression> fExpressions;

    @Override
    public void accept(SearchVisitor visitor) throws SearchException {
        visitor.visit(this);
    }

    public CompoundSearchExpression() {
        this.fExpressions = new ArrayList<SearchExpression>();
    }

    public CompoundSearchExpression(Collection<SearchExpression> expressions) {
        this.fExpressions = new ArrayList<SearchExpression>(expressions);
    }

    public CompoundSearchExpression(SearchExpression ... expressions) {
        this();
        for (SearchExpression expr : expressions) {
            this.addExpression(expr);
        }
    }

    public void addExpression(SearchExpression expression) {
        this.fExpressions.add(expression);
    }

    public List<SearchExpression> getExpressions() {
        return Collections.unmodifiableList(this.fExpressions);
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.getFieldString());
        s.append('(');
        int baseLength = s.length();
        for (SearchExpression expr : this.fExpressions) {
            if (s.length() > baseLength) {
                s.append(' ');
            }
            s.append(expr.getOperatorString());
            s.append(expr.toString());
        }
        s.append(')');
        return s.toString();
    }
}

