/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlservices;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlservices.MatlabDebugObserver;
import com.mathworks.services.Prefs;
import com.mathworks.services.message.MWMessage;
import com.mathworks.util.FileUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class MatlabDebugServices {
    public static final int NEVER = 0;
    public static final int ALWAYS = 1;
    public static final int USE_IDS = 2;
    public static final int DBSTEP = 1;
    public static final int DBSTEPIN = 2;
    public static final int DBSTEPOUT = 3;
    public static final int DBCONT = 4;
    public static final int DBQUIT = 5;
    public static final int DBCLEAR = 6;
    public static final int DBCLEARFILE = 7;
    public static final int DBCLEARALL = 8;
    public static final int DBSTOP = 9;
    public static final int DBTOGGLESTOPIF = 10;
    public static final int DBCHANGEWORKSPACECONTEXT = 11;
    public static final String MATLAB_BASE_WS = "<Base>";
    public static final int CURRENT_WORKSPACE_CONTEXT = 0;
    private static final int BREAKPOINTS_REPLY = 1;
    private static final int BREAKCONDS_REPLY = 2;
    private static final int STACK_MESSAGE = 3;
    private static Vector sCompletionObservers = new Vector();
    private static Vector sUnregisteredCompletionObservers;
    private static Object[] sInterestCookies;
    private static final DebugDispatch sDebugCallbackAndDispatch;
    private static final StackDispatch sStackDispatch;
    private static final StackCallback sStackCallback;
    private static Matlab sMatlab;
    private static int sStopConditions;
    private static boolean sStopConditionsSet;
    private static boolean sInDebugMode;
    private static boolean sDebugModeSet;
    private static StackInfo sWS_SCOPEStackInfo;
    private MatlabDebugObserver fCompletionObserver = null;
    private static final DefaultMatlabDebugObserver sDefaultObserver;
    private static int sStopIfError;
    private static int sStopIfCaughtError;
    private static int sStopIfWarning;
    private static int sStopIfNanInf;
    private static String[] sErrorID;
    private static String[] sCaughtErrorID;
    private static String[] sWarningID;
    private static String illegalStateErrorMsg;
    private static final String sDBStackString = "dbstack";
    private static final Object[] sDBStackArgs;
    private static volatile boolean sInKeyboardMode;

    public static void initialize() {
    }

    public static boolean isInitialized() {
        return sStopConditionsSet && sDebugModeSet;
    }

    public static Matlab getMatlab() {
        return sMatlab;
    }

    public static void addDefaultObserverListener(MatlabDebugObserver matlabDebugObserver) {
        DefaultMatlabDebugObserver.sMatlabDebugObservers.add(MatlabDebugObserver.class, matlabDebugObserver);
        if (MatlabDebugServices.isInitialized()) {
            matlabDebugObserver.doDebugMode(MatlabDebugServices.isMatlabDebugMode());
            if (MatlabDebugServices.isMatlabDebugMode() && sWS_SCOPEStackInfo != null) {
                matlabDebugObserver.doWorkspaceChange(sWS_SCOPEStackInfo);
            }
        }
    }

    public static void removeDefaultObserverListener(MatlabDebugObserver matlabDebugObserver) {
        DefaultMatlabDebugObserver.sMatlabDebugObservers.remove(MatlabDebugObserver.class, matlabDebugObserver);
    }

    public static void executeDBstack(Matlab matlab, MatlabListener matlabListener) {
        matlab.feval(sDBStackString, sDBStackArgs, 2, matlabListener);
    }

    public static void executeDBstack(Matlab matlab, CompletionObserver completionObserver) {
        matlab.feval(sDBStackString, sDBStackArgs, 2, completionObserver);
    }

    public static StackInfo createStackInfo(Object object) {
        assert (object instanceof Object[]);
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])((Object[])objectArray[0])[1];
        int n = objectArray2.length;
        StackInfo stackInfo = null;
        if (n > 0) {
            int n2;
            String[] stringArray = new String[n];
            String[] stringArray2 = new String[n];
            int[] nArray = new int[n];
            for (n2 = 0; n2 != n; ++n2) {
                Object[] objectArray3 = (Object[])objectArray2[n2];
                stringArray[n2] = (String)objectArray3[0];
                stringArray2[n2] = (String)objectArray3[1];
                if (stringArray[n2].length() == 0) {
                    stringArray[n2] = stringArray2[n2];
                }
                nArray[n2] = (int)Math.abs(((double[])objectArray3[2])[0]);
            }
            int n3 = (int)((double[])objectArray[1])[0];
            n2 = n3 > n ? -1 : n3 - 1;
            stackInfo = new StackInfo(stringArray, stringArray2, nArray, n2);
        }
        return stackInfo;
    }

    public static String getStackLevelChangeCommand(int n) {
        String string;
        block3: {
            block2: {
                string = "";
                if (n >= 0) break block2;
                n = -n;
                for (int i = 0; i < n; ++i) {
                    string = string + "dbdown;";
                }
                break block3;
            }
            if (n <= 0) break block3;
            for (int i = 0; i < n; ++i) {
                string = string + "dbup;";
            }
        }
        return string;
    }

    public static int getStopIfErrorState() throws IllegalStateException {
        if (sStopConditionsSet) {
            return sStopIfError;
        }
        throw new IllegalStateException(illegalStateErrorMsg);
    }

    public static String[] getStopIfErrorIdentifiers() throws IllegalStateException {
        if (sStopConditionsSet) {
            if (sErrorID != null && sErrorID.length > 0) {
                String[] stringArray = new String[sErrorID.length];
                for (int i = 0; i < sErrorID.length; ++i) {
                    stringArray[i] = new String(sErrorID[i]);
                }
                return stringArray;
            }
            return null;
        }
        throw new IllegalStateException(illegalStateErrorMsg);
    }

    public static int getStopIfCaughtErrorState() throws IllegalStateException {
        if (sStopConditionsSet) {
            return sStopIfCaughtError;
        }
        throw new IllegalStateException(illegalStateErrorMsg);
    }

    public static String[] getStopIfCaughtErrorIdentifiers() throws IllegalStateException {
        if (sStopConditionsSet) {
            if (sCaughtErrorID != null && sCaughtErrorID.length > 0) {
                String[] stringArray = new String[sCaughtErrorID.length];
                for (int i = 0; i < sCaughtErrorID.length; ++i) {
                    stringArray[i] = new String(sCaughtErrorID[i]);
                }
                return stringArray;
            }
            return null;
        }
        throw new IllegalStateException(illegalStateErrorMsg);
    }

    public static int getStopIfWarningState() throws IllegalStateException {
        if (sStopConditionsSet) {
            return sStopIfWarning;
        }
        throw new IllegalStateException(illegalStateErrorMsg);
    }

    public static String[] getStopIfWarningIdentifiers() throws IllegalStateException {
        if (sStopConditionsSet) {
            if (sWarningID != null && sWarningID.length > 0) {
                String[] stringArray = new String[sWarningID.length];
                for (int i = 0; i < sWarningID.length; ++i) {
                    stringArray[i] = new String(sWarningID[i]);
                }
                return stringArray;
            }
            return null;
        }
        throw new IllegalStateException(illegalStateErrorMsg);
    }

    public static int getStopIfNanInfState() throws IllegalStateException {
        if (sStopConditionsSet) {
            return sStopIfNanInf;
        }
        throw new IllegalStateException(illegalStateErrorMsg);
    }

    public static boolean isGraphicalDebuggingEnabled() {
        return Prefs.getBooleanPref((String)"EditorGraphicalDebugging", (boolean)true);
    }

    public static boolean isMatlabDebugMode() throws IllegalStateException {
        if (sDebugModeSet) {
            return sInDebugMode;
        }
        throw new IllegalStateException(illegalStateErrorMsg);
    }

    public static boolean isMatlabKeyboardMode() {
        return sInKeyboardMode;
    }

    public static StackInfo getMatlabStackInfo() throws IllegalStateException {
        if (sDebugModeSet) {
            return sWS_SCOPEStackInfo;
        }
        throw new IllegalStateException(illegalStateErrorMsg);
    }

    public int getStopConditions() {
        return sStopConditions;
    }

    public boolean isDebugMode() {
        return sInDebugMode;
    }

    public void initFileBreakpoints(String string) {
        if (sMatlab != null && this.fCompletionObserver != null) {
            String string2 = "mdbstatus ('" + string + "')";
            sMatlab.eval(string2, (CompletionObserver)new InterestCallback(1, string, this.fCompletionObserver), 512);
        }
    }

    public static void dbCommand(int n) {
        MatlabDebugServices.dbCommand(n, null, 0);
    }

    public static void dbCommandNoEcho(int n) {
        MatlabDebugServices.commandSwitchyard(n, null, 0, false);
    }

    public static void dbCommand(int n, String string) {
        MatlabDebugServices.dbCommand(n, string, 0);
    }

    public static void dbCommand(int n, int n2) {
        MatlabDebugServices.dbCommand(n, " ", n2);
    }

    public static void dbCommand(int n, String string, int n2) {
        MatlabDebugServices.commandSwitchyard(n, string, n2, true);
    }

    private static void commandSwitchyard(int n, String string, int n2, boolean bl) {
        if (sMatlab == null) {
            return;
        }
        switch (n) {
            case 9: {
                if (string == null || n2 < 0) break;
                MatlabDebugServices.doSetBreakpoint(string, n2);
                break;
            }
            case 6: {
                if (string == null || n2 < 0) break;
                MatlabDebugServices.doRemoveBreakpoint(string, n2);
                break;
            }
            case 8: {
                MatlabDebugServices.doClearAll();
                break;
            }
            case 7: {
                if (string == null) break;
                MatlabDebugServices.doClearFile(string);
                break;
            }
            case 1: {
                MatlabDebugServices.doStep(bl);
                break;
            }
            case 2: {
                MatlabDebugServices.doStepIn(bl);
                break;
            }
            case 3: {
                MatlabDebugServices.doStepOut(bl);
                break;
            }
            case 4: {
                MatlabDebugServices.doDBCont(bl);
                break;
            }
            case 5: {
                MatlabDebugServices.doDBQuit();
                break;
            }
            case 10: {
                MatlabDebugServices.doToggleStopState(n2);
                break;
            }
            case 11: {
                MatlabDebugServices.doChangeWorkspace(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInDebugMode(boolean bl) {
        sDebugModeSet = true;
        if (bl != sInDebugMode) {
            sInDebugMode = bl;
            if (!sInDebugMode) {
                sInKeyboardMode = false;
            }
            sDefaultObserver.doDebugMode(sInDebugMode);
            if (sCompletionObservers != null) {
                Vector vector = sCompletionObservers;
                synchronized (vector) {
                    for (int i = 0; i < sCompletionObservers.size(); ++i) {
                        ((MatlabDebugObserver)sCompletionObservers.elementAt(i)).doDebugMode(bl);
                    }
                }
            }
        }
    }

    private static void doChangeWorkspace(int n) {
        String string = "";
        string = MatlabDebugServices.getStackLevelChangeCommand(n);
        if (sMatlab != null) {
            if (n != 0) {
                sMatlab.evalNoOutput(string);
            } else {
                MatlabDebugServices.executeDBstack(sMatlab, sStackDispatch);
            }
        }
    }

    private static void doSetBreakpoint(String string, int n) {
        sMatlab.evalConsoleOutput("dbstop '" + string + "' " + (n + 1));
    }

    private static void doRemoveBreakpoint(String string, int n) {
        sMatlab.evalConsoleOutput("dbclear '" + string + "' " + (n + 1));
    }

    private static void doDBQuit() {
        MLExecuteServices.consoleEval(MatlabDebugServices.getIfDebugModeCommand("dbquit"), 1024);
    }

    private static void doDBCont(boolean bl) {
        if (bl) {
            MLExecuteServices.consoleEval("dbcont");
        } else {
            MLExecuteServices.consoleEval(MatlabDebugServices.getIfDebugModeCommand("dbcont"), 1024);
        }
    }

    private static void doToggleStopState(int n) {
        String string = "";
        boolean bl = false;
        if ((n & 1) != 0) {
            string = "error";
            boolean bl2 = bl = (sStopConditions & 1) != 0;
        }
        if ((n & 0x10) != 0) {
            string = "all error";
            boolean bl3 = bl = (sStopConditions & 0x10) != 0;
        }
        if ((n & 2) != 0) {
            string = "warning";
            boolean bl4 = bl = (sStopConditions & 2) != 0;
        }
        if ((n & 8) != 0) {
            string = "naninf";
            boolean bl5 = bl = (sStopConditions & 8) != 0;
        }
        if (!string.equals("")) {
            String string2 = bl ? "dbclear if " + string : "dbstop if " + string;
            sMatlab.evalConsoleOutput(string2);
        }
    }

    private static void doClearAll() {
        sMatlab.evalConsoleOutput("builtin('dbclear', 'all')");
    }

    private static void doClearFile(String string) {
        sMatlab.evalConsoleOutput("dbclear all in '" + string + "'");
    }

    private static void doStep(boolean bl) {
        if (bl) {
            MLExecuteServices.consoleEval("dbstep");
        } else {
            MLExecuteServices.consoleEval(MatlabDebugServices.getIfDebugModeCommand("dbstep"), 1024);
        }
    }

    private static void doStepIn(boolean bl) {
        if (bl) {
            MLExecuteServices.consoleEval("dbstep in");
        } else {
            MLExecuteServices.consoleEval(MatlabDebugServices.getIfDebugModeCommand("dbstep in"), 1024);
        }
    }

    private static void doStepOut(boolean bl) {
        if (bl) {
            MLExecuteServices.consoleEval("dbstep out");
        } else {
            MLExecuteServices.consoleEval(MatlabDebugServices.getIfDebugModeCommand("dbstep out"), 1024);
        }
    }

    private static String getIfDebugModeCommand(String string) {
        return "if system_dependent('IsDebugMode')==1, " + string + "; end";
    }

    static /* synthetic */ String[] access$902(String[] stringArray) {
        sErrorID = stringArray;
        return stringArray;
    }

    static /* synthetic */ String[] access$1102(String[] stringArray) {
        sCaughtErrorID = stringArray;
        return stringArray;
    }

    static /* synthetic */ String[] access$1302(String[] stringArray) {
        sWarningID = stringArray;
        return stringArray;
    }

    static /* synthetic */ int access$800() {
        return sStopIfError;
    }

    static /* synthetic */ int access$1000() {
        return sStopIfCaughtError;
    }

    static /* synthetic */ int access$1200() {
        return sStopIfWarning;
    }

    static /* synthetic */ int access$1400() {
        return sStopIfNanInf;
    }

    static {
        sDebugCallbackAndDispatch = new DebugDispatch();
        sStackDispatch = new StackDispatch();
        sStackCallback = new StackCallback();
        sMatlab = null;
        sStopConditions = 0;
        sStopConditionsSet = false;
        sInDebugMode = false;
        sDebugModeSet = false;
        sWS_SCOPEStackInfo = null;
        sDefaultObserver = new DefaultMatlabDebugObserver();
        sStopIfError = 0;
        sStopIfCaughtError = 0;
        sStopIfWarning = 0;
        sStopIfNanInf = 0;
        illegalStateErrorMsg = "MatlabDebugServices has not yet initialized.";
        sDBStackArgs = new Object[]{"-completenames"};
        sInKeyboardMode = false;
        if (Matlab.isMatlabAvailable()) {
            sMatlab = new Matlab();
        }
        if (sMatlab != null && sInterestCookies == null) {
            sMatlab.eval("mdbstatus", (CompletionObserver)new InterestCallback(2), 512);
            MatlabDebugServices.executeDBstack(sMatlab, new InterestCallback(3));
            sInterestCookies = new Object[9];
            MatlabDebugServices.sInterestCookies[0] = sMatlab.registerInterest(1, 0x4000000, (CompletionObserver)sDebugCallbackAndDispatch);
            MatlabDebugServices.sInterestCookies[1] = sMatlab.registerInterest(1, 0x8000000, (CompletionObserver)sDebugCallbackAndDispatch);
            MatlabDebugServices.sInterestCookies[2] = sMatlab.registerInterest(1, 0x2000000, (CompletionObserver)sDebugCallbackAndDispatch);
            MatlabDebugServices.sInterestCookies[3] = sMatlab.registerInterest(1, 0x10000000, (CompletionObserver)sDebugCallbackAndDispatch);
            MatlabDebugServices.sInterestCookies[4] = sMatlab.registerInterest(1, Integer.MIN_VALUE, (CompletionObserver)sDebugCallbackAndDispatch);
            MatlabDebugServices.sInterestCookies[5] = sMatlab.registerInterest(1, 0x40000000, (CompletionObserver)sDebugCallbackAndDispatch);
            MatlabDebugServices.sInterestCookies[6] = sMatlab.registerInterest(1, 0x20000000, (CompletionObserver)sDebugCallbackAndDispatch);
            MatlabDebugServices.sInterestCookies[7] = sMatlab.registerInterest(3, Integer.MIN_VALUE, (CompletionObserver)sStackCallback);
            MatlabDebugServices.sInterestCookies[8] = sMatlab.registerInterest(1, 0x1000000, (CompletionObserver)sDebugCallbackAndDispatch);
        }
    }

    public static class StackInfo {
        private String[] fWorkspaceNames;
        private String[] fFullNames;
        private int[] fLineNumbers;
        private int fCurrentIndex = -1;

        private StackInfo(String[] stringArray, String[] stringArray2, int[] nArray, int n) {
            if (stringArray == null || stringArray2 == null || nArray == null) {
                throw new IllegalArgumentException("Null variables passed in. " + stringArray + " " + stringArray2 + " " + nArray);
            }
            if (n >= stringArray2.length) {
                throw new IllegalArgumentException("Variable currentIndex is not valid: " + n);
            }
            if (stringArray.length != stringArray2.length || stringArray.length != nArray.length) {
                throw new IllegalArgumentException("List sizes do not correspond." + stringArray.length + " " + stringArray2.length + " " + nArray.length);
            }
            this.fFullNames = stringArray;
            this.fWorkspaceNames = new String[stringArray2.length + 1];
            System.arraycopy(stringArray2, 0, this.fWorkspaceNames, 0, stringArray2.length);
            this.fWorkspaceNames[stringArray2.length] = MatlabDebugServices.MATLAB_BASE_WS;
            this.fLineNumbers = nArray;
            if (n == -1) {
                n = this.fWorkspaceNames.length - 1;
            }
            this.fCurrentIndex = n;
        }

        public String[] getWorkspaceNames() {
            return this.fWorkspaceNames;
        }

        public String[] getFullFilenames() {
            return this.fFullNames;
        }

        public int getCurrentEntryIndex() {
            return this.fCurrentIndex;
        }

        public int[] getLineNumbers() {
            return this.fLineNumbers;
        }
    }

    public static class BreakpointInfo {
        private final String fCondition;
        private final int fLineNumber;
        private final int fAnonIndex;

        public BreakpointInfo(int n, String string, int n2) {
            this.fCondition = string;
            this.fLineNumber = n;
            this.fAnonIndex = n2;
        }

        public int getLineNumber() {
            return this.fLineNumber;
        }

        public int getAnonIndex() {
            return this.fAnonIndex;
        }

        public String getCondition() {
            return this.fCondition;
        }
    }

    public static class MatlabStopIf {
        private int fStopIfError = MatlabDebugServices.access$800();
        private int fStopIfCaughtError = MatlabDebugServices.access$1000();
        private int fStopIfWarning = MatlabDebugServices.access$1200();
        private int fStopIfNanInf = MatlabDebugServices.access$1400();
        private String[] fErrorID;
        private String[] fCaughtErrorID;
        private String[] fWarningID;
        private static final String sConstIfError = "if error ";
        private static final String sConstIfWarning = "if warning ";
        private static final String sConstIfCaughtError = "if caught error ";
        private static final String sConstIfNanInf = "if naninf ";
        private static final String sConstStop = "dbstop ";
        private static final String sConstClear = "dbclear ";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MatlabStopIf() {
            int n;
            String[] stringArray;
            if (sErrorID != null && sErrorID.length > 0) {
                stringArray = sErrorID;
                synchronized (stringArray) {
                    this.fErrorID = new String[sErrorID.length];
                    for (n = 0; n < sErrorID.length; ++n) {
                        this.fErrorID[n] = new String(sErrorID[n]);
                    }
                }
            }
            if (sCaughtErrorID != null && sCaughtErrorID.length > 0) {
                stringArray = sCaughtErrorID;
                synchronized (stringArray) {
                    this.fCaughtErrorID = new String[sCaughtErrorID.length];
                    for (n = 0; n < sCaughtErrorID.length; ++n) {
                        this.fCaughtErrorID[n] = new String(sCaughtErrorID[n]);
                    }
                }
            }
            if (sWarningID != null && sWarningID.length > 0) {
                stringArray = sWarningID;
                synchronized (stringArray) {
                    this.fWarningID = new String[sWarningID.length];
                    for (n = 0; n < sWarningID.length; ++n) {
                        this.fWarningID[n] = new String(sWarningID[n]);
                    }
                }
            }
        }

        public void setStopIfError(int n, String[] stringArray) {
            if (n == 0) {
                this.fStopIfError = 0;
            } else if (n == 1) {
                this.fStopIfError = 1;
            } else if (n == 2 && stringArray != null && stringArray.length > 0) {
                this.fStopIfError = 2;
                this.fErrorID = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.fErrorID[i] = new String(stringArray[i]);
                }
            } else {
                this.fStopIfError = 0;
            }
        }

        public void setStopIfCaughtError(int n, String[] stringArray) {
            if (n == 0) {
                this.fStopIfCaughtError = 0;
            } else if (n == 1) {
                this.fStopIfCaughtError = 1;
            } else if (n == 2 && stringArray != null && stringArray.length > 0) {
                this.fStopIfCaughtError = 2;
                this.fCaughtErrorID = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.fCaughtErrorID[i] = new String(stringArray[i]);
                }
            } else {
                this.fStopIfCaughtError = 0;
            }
        }

        public void setStopIfWarning(int n, String[] stringArray) {
            if (n == 0) {
                this.fStopIfWarning = 0;
            } else if (n == 1) {
                this.fStopIfWarning = 1;
            } else if (n == 2 && stringArray != null && stringArray.length > 0) {
                this.fStopIfWarning = 2;
                this.fWarningID = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.fWarningID[i] = new String(stringArray[i]);
                }
            } else {
                this.fStopIfWarning = 0;
            }
        }

        public void setStopIfNanInf(int n) {
            this.fStopIfNanInf = n == 1 ? 1 : 0;
        }

        public void sendToMATLAB() {
            int n;
            StringBuffer stringBuffer = new StringBuffer(300);
            if (this.fStopIfError == 1) {
                stringBuffer.append("dbclear if error;");
                stringBuffer.append(sConstStop);
                stringBuffer.append(sConstIfError);
                stringBuffer.append(";");
            } else if (this.fStopIfError == 0) {
                stringBuffer.append(sConstClear);
                stringBuffer.append(sConstIfError);
                stringBuffer.append(";");
            } else {
                stringBuffer.append("dbclear if error;");
                for (n = 0; n < this.fErrorID.length; ++n) {
                    stringBuffer.append(sConstStop);
                    stringBuffer.append(sConstIfError);
                    stringBuffer.append(this.fErrorID[n]);
                    stringBuffer.append(";");
                }
            }
            if (this.fStopIfWarning == 1) {
                stringBuffer.append("dbclear if warning;");
                stringBuffer.append(sConstStop);
                stringBuffer.append(sConstIfWarning);
                stringBuffer.append(";");
            } else if (this.fStopIfWarning == 0) {
                stringBuffer.append(sConstClear);
                stringBuffer.append(sConstIfWarning);
                stringBuffer.append(";");
            } else {
                stringBuffer.append("dbclear if warning;");
                for (n = 0; n < this.fWarningID.length; ++n) {
                    stringBuffer.append(sConstStop);
                    stringBuffer.append(sConstIfWarning);
                    stringBuffer.append(this.fWarningID[n]);
                    stringBuffer.append(";");
                }
            }
            if (this.fStopIfCaughtError == 1) {
                stringBuffer.append("dbclear if caught error;");
                stringBuffer.append(sConstStop);
                stringBuffer.append(sConstIfCaughtError);
                stringBuffer.append(";");
            } else if (this.fStopIfCaughtError == 0) {
                stringBuffer.append(sConstClear);
                stringBuffer.append(sConstIfCaughtError);
                stringBuffer.append(";");
            } else {
                stringBuffer.append("dbclear if caught error;");
                for (n = 0; n < this.fCaughtErrorID.length; ++n) {
                    stringBuffer.append(sConstStop);
                    stringBuffer.append(sConstIfCaughtError);
                    stringBuffer.append(this.fCaughtErrorID[n]);
                    stringBuffer.append(";");
                }
            }
            if (this.fStopIfNanInf == 1) {
                stringBuffer.append(sConstStop);
                stringBuffer.append(sConstIfNanInf);
                stringBuffer.append(";");
            } else if (this.fStopIfNanInf == 0) {
                stringBuffer.append(sConstClear);
                stringBuffer.append(sConstIfNanInf);
                stringBuffer.append(";");
            }
            sMatlab.evalNoOutput(stringBuffer.toString());
        }
    }

    private static class DefaultMatlabDebugObserver
    implements MatlabDebugObserver {
        private static EventListenerList sMatlabDebugObservers = new EventListenerList();

        private DefaultMatlabDebugObserver() {
        }

        @Override
        public void doDBStop(String string, int n) {
            Object[] objectArray = sMatlabDebugObservers.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != MatlabDebugObserver.class) continue;
                MatlabDebugObserver matlabDebugObserver = (MatlabDebugObserver)objectArray[i + 1];
                matlabDebugObserver.doDBStop(string, n);
            }
        }

        @Override
        public void doDBClearAll() {
            Object[] objectArray = sMatlabDebugObservers.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != MatlabDebugObserver.class) continue;
                MatlabDebugObserver matlabDebugObserver = (MatlabDebugObserver)objectArray[i + 1];
                matlabDebugObserver.doDBClearAll();
            }
        }

        @Override
        public void doDBCont() {
            Object[] objectArray = sMatlabDebugObservers.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != MatlabDebugObserver.class) continue;
                MatlabDebugObserver matlabDebugObserver = (MatlabDebugObserver)objectArray[i + 1];
                matlabDebugObserver.doDBCont();
            }
        }

        @Override
        public void doDBQuit() {
            Object[] objectArray = sMatlabDebugObservers.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != MatlabDebugObserver.class) continue;
                MatlabDebugObserver matlabDebugObserver = (MatlabDebugObserver)objectArray[i + 1];
                matlabDebugObserver.doDBQuit();
            }
        }

        @Override
        public void doSetBreakpoints(String string, List<BreakpointInfo> list) {
            Object[] objectArray = sMatlabDebugObservers.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != MatlabDebugObserver.class) continue;
                MatlabDebugObserver matlabDebugObserver = (MatlabDebugObserver)objectArray[i + 1];
                matlabDebugObserver.doSetBreakpoints(string, list);
            }
        }

        @Override
        public void doRemoveBreakpoints(String string, int[] nArray) {
            Object[] objectArray = sMatlabDebugObservers.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != MatlabDebugObserver.class) continue;
                MatlabDebugObserver matlabDebugObserver = (MatlabDebugObserver)objectArray[i + 1];
                matlabDebugObserver.doRemoveBreakpoints(string, nArray);
            }
        }

        @Override
        public void doStopConditions(int n) {
            Object[] objectArray = sMatlabDebugObservers.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != MatlabDebugObserver.class) continue;
                MatlabDebugObserver matlabDebugObserver = (MatlabDebugObserver)objectArray[i + 1];
                matlabDebugObserver.doStopConditions(n);
            }
        }

        @Override
        public void doDebugMode(boolean bl) {
            Object[] objectArray = sMatlabDebugObservers.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != MatlabDebugObserver.class) continue;
                MatlabDebugObserver matlabDebugObserver = (MatlabDebugObserver)objectArray[i + 1];
                matlabDebugObserver.doDebugMode(bl);
            }
        }

        @Override
        public void doWorkspaceChange(StackInfo stackInfo) {
            if (stackInfo != null) {
                sWS_SCOPEStackInfo = stackInfo;
                Object[] objectArray = sMatlabDebugObservers.getListenerList();
                for (int i = 0; i < objectArray.length; i += 2) {
                    if (objectArray[i] != MatlabDebugObserver.class) continue;
                    MatlabDebugObserver matlabDebugObserver = (MatlabDebugObserver)objectArray[i + 1];
                    matlabDebugObserver.doWorkspaceChange(sWS_SCOPEStackInfo);
                }
            }
        }

        @Override
        public void doDbupDbdownChange(String string, int n) {
            Object[] objectArray = sMatlabDebugObservers.getListenerList();
            for (int i = 0; i < objectArray.length; i += 2) {
                if (objectArray[i] != MatlabDebugObserver.class) continue;
                MatlabDebugObserver matlabDebugObserver = (MatlabDebugObserver)objectArray[i + 1];
                matlabDebugObserver.doDbupDbdownChange(string, n);
            }
        }
    }

    static class DebugDispatch
    implements CompletionObserver {
        DebugDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(int n, Object object) {
            this.dispatchMessage(object, sDefaultObserver);
            if (sCompletionObservers != null) {
                Vector vector = sCompletionObservers;
                synchronized (vector) {
                    for (int i = 0; i < sCompletionObservers.size(); ++i) {
                        MatlabDebugObserver matlabDebugObserver = (MatlabDebugObserver)sCompletionObservers.elementAt(i);
                        this.dispatchMessage(object, matlabDebugObserver);
                    }
                }
            }
        }

        private void dispatchMessage(Object object, MatlabDebugObserver matlabDebugObserver) {
            MWMessage mWMessage = (MWMessage)object;
            Integer n = (Integer)mWMessage.findData("eventid");
            if (n == null) {
                return;
            }
            int n2 = n;
            switch (n2) {
                case 0x8000000: {
                    this.interestDebugGo(matlabDebugObserver);
                    break;
                }
                case 0x10000000: {
                    this.interestDebugExit(matlabDebugObserver);
                    break;
                }
                case 0x4000000: {
                    this.interestDebugStop(mWMessage, matlabDebugObserver);
                    break;
                }
                case 0x2000000: {
                    this.interestDebugStopIf(mWMessage, matlabDebugObserver);
                    break;
                }
                case -2147483648: {
                    this.interestDebugBPAdd(mWMessage, matlabDebugObserver);
                    break;
                }
                case 0x40000000: {
                    this.interestDebugBPClear(matlabDebugObserver);
                    break;
                }
                case 0x20000000: {
                    this.interestDebugBPDelete(mWMessage, matlabDebugObserver);
                    break;
                }
                case 0x1000000: {
                    this.interestDbupDbdown(mWMessage, matlabDebugObserver);
                }
            }
        }

        private void interestDebugExit(MatlabDebugObserver matlabDebugObserver) {
            matlabDebugObserver.doDBQuit();
            MatlabDebugServices.setInDebugMode(false);
        }

        private void interestDebugStop(MWMessage mWMessage, MatlabDebugObserver matlabDebugObserver) {
            if (mWMessage == null) {
                return;
            }
            MatlabDebugServices.setInDebugMode(true);
            String string = (String)mWMessage.findData("string");
            if (string != null && string.length() > 0) {
                String string2 = FileUtils.toJavaPath((String)string);
                Integer n = (Integer)mWMessage.findData("lineno");
                boolean bl = false;
                Integer n2 = (Integer)mWMessage.findData("prompt");
                if (n2 != null) {
                    bl = n2 == Matlab.KEYBOARD_PROMPT;
                }
                sInKeyboardMode = bl;
                matlabDebugObserver.doDBStop(string2, n - 1);
            }
        }

        private void interestDebugGo(MatlabDebugObserver matlabDebugObserver) {
            matlabDebugObserver.doDBCont();
        }

        private void interestDebugStopIf(MWMessage mWMessage, MatlabDebugObserver matlabDebugObserver) {
            int n;
            int n2;
            String[] stringArray;
            if (mWMessage == null) {
                return;
            }
            Integer n3 = (Integer)mWMessage.findData("value");
            int n4 = n3;
            sStopIfNanInf = (n4 & 8) != 0 ? 1 : 0;
            String[][] stringArray2 = (String[][])mWMessage.findData("string");
            sStopIfError = 0;
            if (stringArray2[1] != null && (stringArray = stringArray2[1]).length > 0) {
                if (stringArray[0].equals("all")) {
                    sStopIfError = 1;
                } else {
                    sStopIfError = 2;
                    n2 = stringArray.length;
                    MatlabDebugServices.access$902(new String[n2]);
                    for (n = 0; n < n2; ++n) {
                        sErrorID[n] = stringArray[n];
                    }
                }
            }
            sStopIfWarning = 0;
            if (stringArray2[2] != null && (stringArray = stringArray2[2]).length > 0) {
                if (stringArray[0].equals("all")) {
                    sStopIfWarning = 1;
                } else {
                    sStopIfWarning = 2;
                    n2 = stringArray.length;
                    MatlabDebugServices.access$1302(new String[n2]);
                    for (n = 0; n < n2; ++n) {
                        sWarningID[n] = stringArray[n];
                    }
                }
            }
            sStopIfCaughtError = 0;
            if (stringArray2[4] != null && (stringArray = stringArray2[4]).length > 0) {
                if (stringArray[0].equals("all")) {
                    sStopIfCaughtError = 1;
                } else {
                    sStopIfCaughtError = 2;
                    n2 = stringArray.length;
                    MatlabDebugServices.access$1102(new String[n2]);
                    for (n = 0; n < n2; ++n) {
                        sCaughtErrorID[n] = stringArray[n];
                    }
                }
            }
            sStopConditions = n4;
            sStopConditionsSet = true;
            matlabDebugObserver.doStopConditions(n4);
        }

        private void interestDebugBPAdd(MWMessage mWMessage, MatlabDebugObserver matlabDebugObserver) {
            MWMessage[] mWMessageArray = (MWMessage[])mWMessage.findData("result");
            if (mWMessageArray == null) {
                return;
            }
            int n = mWMessageArray.length;
            if (n <= 0) {
                return;
            }
            HashMap hashMap = new HashMap();
            for (int i = 0; i < n; ++i) {
                String string = (String)mWMessageArray[i].findData("string");
                if (string == null) continue;
                String string2 = FileUtils.toJavaPath((String)string);
                List<BreakpointInfo> list = (List)hashMap.get(string2);
                if (list == null) {
                    list = new ArrayList<BreakpointInfo>();
                    hashMap.put(string2, list);
                }
                Integer n2 = (Integer)mWMessageArray[i].findData("lineno");
                Object object = (Integer)mWMessageArray[i].findData("anonymous");
                String string3 = (String)mWMessageArray[i].findData("value");
                list.add(new BreakpointInfo(n2 - 1, string3, (Integer)object));
            }
            for (Object object : hashMap.keySet()) {
                matlabDebugObserver.doSetBreakpoints((String)object, (List)hashMap.get(object));
            }
        }

        private void interestDebugBPDelete(MWMessage mWMessage, MatlabDebugObserver matlabDebugObserver) {
            MWMessage[] mWMessageArray = (MWMessage[])mWMessage.findData("result");
            if (mWMessageArray == null) {
                return;
            }
            int n = mWMessageArray.length;
            if (n <= 0) {
                return;
            }
            String string = (String)mWMessageArray[0].findData("string");
            if (string == null) {
                return;
            }
            String string2 = FileUtils.toJavaPath((String)string);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                Integer n2 = (Integer)mWMessageArray[i].findData("lineno");
                nArray[i] = n2 - 1;
            }
            matlabDebugObserver.doRemoveBreakpoints(string2, nArray);
        }

        private void interestDebugBPClear(MatlabDebugObserver matlabDebugObserver) {
            matlabDebugObserver.doDBClearAll();
        }

        private void interestDbupDbdown(MWMessage mWMessage, MatlabDebugObserver matlabDebugObserver) {
            String string = (String)mWMessage.findData("string");
            if (string == null || string.equals("")) {
                string = MatlabDebugServices.MATLAB_BASE_WS;
            }
            int n = (Integer)mWMessage.findData("lineno") - 1;
            matlabDebugObserver.doDbupDbdownChange(string, n);
        }
    }

    static class StackDispatch
    implements CompletionObserver {
        StackDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(int n, Object object) {
            StackInfo stackInfo = MatlabDebugServices.createStackInfo(object);
            if (stackInfo != null) {
                sDefaultObserver.doWorkspaceChange(stackInfo);
                if (sCompletionObservers != null) {
                    Vector vector = sCompletionObservers;
                    synchronized (vector) {
                        for (int i = 0; i < sCompletionObservers.size(); ++i) {
                            MatlabDebugObserver matlabDebugObserver = (MatlabDebugObserver)sCompletionObservers.elementAt(i);
                            matlabDebugObserver.doWorkspaceChange(stackInfo);
                        }
                    }
                }
            }
        }
    }

    static class StackCallback
    implements CompletionObserver {
        StackCallback() {
        }

        public void completed(int n, Object object) {
            if (!MatlabDebugServices.isInitialized() || MatlabDebugServices.isMatlabDebugMode()) {
                MWMessage mWMessage = (MWMessage)object;
                Integer n2 = (Integer)mWMessage.findData("eventid");
                if (n2 == null) {
                    return;
                }
                int n3 = n2;
                if (n3 == Integer.MIN_VALUE) {
                    MatlabDebugServices.executeDBstack(sMatlab, sStackDispatch);
                }
            }
        }
    }

    static class InterestCallback
    implements CompletionObserver {
        int fReplyType;
        String fFilename;
        MatlabDebugObserver fObserver;

        public InterestCallback(int n, String string, MatlabDebugObserver matlabDebugObserver) {
            this.fReplyType = n;
            this.fFilename = string;
            this.fObserver = matlabDebugObserver;
        }

        public InterestCallback(int n) {
            this.fReplyType = n;
            this.fFilename = null;
            this.fObserver = null;
        }

        public void completed(int n, Object object) {
            if (this.fReplyType == 1) {
                this.handleBreakpoints((String)object);
            } else if (this.fReplyType == 2) {
                this.handleBreakConditions((String)object);
            } else if (this.fReplyType == 3) {
                InterestCallback.handleStackReply(n, object);
            }
        }

        private void handleBreakpoints(String string) {
            if (InterestCallback.isErrorReply(string)) {
                return;
            }
            if (this.fObserver == null || this.fFilename == null) {
                return;
            }
            int n = string.length();
            if (n > 0) {
                int n2 = 0;
                char[] cArray = new char[256];
                ArrayList<BreakpointInfo> arrayList = new ArrayList<BreakpointInfo>();
                while (n2 < n) {
                    while (n2 < n - 1 && !Character.isDigit(string.charAt(n2))) {
                        ++n2;
                    }
                    if (n2 >= n - 1) break;
                    int n3 = 0;
                    while (Character.isDigit(string.charAt(n2))) {
                        cArray[n3++] = string.charAt(n2++);
                    }
                    int n4 = Integer.valueOf(new String(cArray, 0, n3));
                    arrayList.add(new BreakpointInfo(n4 - 1, "", -1));
                    this.fObserver.doSetBreakpoints(this.fFilename, arrayList);
                }
            }
        }

        private static void handleStackReply(int n, Object object) {
            StackInfo stackInfo = MatlabDebugServices.createStackInfo(object);
            if (!sDebugModeSet) {
                boolean bl;
                boolean bl2 = bl = stackInfo != null;
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    boolean bl3;
                    boolean bl4 = bl3 = Matlab.getInputRequester((int)n) == Matlab.DEBUG_PROMPT || Matlab.getInputRequester((int)n) == Matlab.KEYBOARD_PROMPT;
                    if (bl != bl3) {
                        System.out.println("DEBUG MODE INCONSISTENT");
                        Thread.dumpStack();
                    }
                }
                sInDebugMode = !bl;
                MatlabDebugServices.setInDebugMode(bl);
            }
            sDefaultObserver.doWorkspaceChange(stackInfo);
        }

        private static boolean isErrorReply(String string) {
            assert (string != null) : "Response should not be null.";
            return string.length() > 3 && string.indexOf("???") == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleBreakConditions(String string) {
            int n = 0;
            if (InterestCallback.isErrorReply(string)) {
                return;
            }
            sStopConditionsSet = true;
            int n2 = string.length();
            if (n2 > 0) {
                Object object;
                int n3 = 0;
                for (int i = 0; i < n2 && (n3 = string.substring(i).indexOf(59)) != -1; i += n3 + 1) {
                    String string2;
                    int n4;
                    object = string.substring(i, i + n3);
                    if (((String)object).equals("error")) {
                        n4 = string.substring(i).indexOf(59);
                        string2 = string.substring(i, i + n4);
                        if (string2.equals("all")) {
                            sStopIfError = 1;
                            continue;
                        }
                        sStopIfError = 2;
                        MatlabDebugServices.access$902(this.initIdentifiers(string2));
                        continue;
                    }
                    if (((String)object).equals("caught error")) {
                        n4 = string.substring(i).indexOf(59);
                        string2 = string.substring(i, i + n4);
                        if (string2.equals("all")) {
                            sStopIfCaughtError = 1;
                            continue;
                        }
                        sStopIfCaughtError = 2;
                        MatlabDebugServices.access$1102(this.initIdentifiers(string2));
                        continue;
                    }
                    if (!((String)object).equals("warning")) continue;
                    n4 = string.substring(i).indexOf(59);
                    string2 = string.substring(i, i + n4);
                    if (string2.equals("all")) {
                        sStopIfWarning = 1;
                        continue;
                    }
                    sStopIfWarning = 2;
                    MatlabDebugServices.access$1302(this.initIdentifiers(string2));
                }
                sStopConditions = n;
                sDefaultObserver.doStopConditions(sStopConditions);
                if (sCompletionObservers != null) {
                    object = sCompletionObservers;
                    synchronized (object) {
                        for (int i = 0; i < sCompletionObservers.size(); ++i) {
                            ((MatlabDebugObserver)sCompletionObservers.elementAt(i)).doStopConditions(n);
                        }
                    }
                }
            }
        }

        private String[] initIdentifiers(String string) {
            int n;
            int n2 = string.length();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                n = string.substring(n3).indexOf(44);
                if (n == -1) {
                    return null;
                }
                n3 += n + 1;
                ++n4;
            }
            String[] stringArray = new String[n4];
            n3 = 0;
            n4 = 0;
            while (n3 < n2) {
                n = string.substring(n3).indexOf(44);
                if (n == -1) {
                    return null;
                }
                stringArray[n4] = string.substring(n3, n3 + n);
                n3 += n + 1;
                ++n4;
            }
            return stringArray;
        }
    }
}

