/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.cell;

import com.mathworks.util.Log;
import com.mathworks.widgets.text.DocumentUtils;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.cell.Cell;
import com.mathworks.widgets.text.mcode.cell.CellUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;

public class BaseDocumentCellInfo {
    private final BaseDocument fDoc;
    private List<BaseDocumentCell> fCells = new ArrayList<BaseDocumentCell>();
    private BaseDocumentCell fLastCell;

    public BaseDocumentCellInfo(BaseDocument baseDocument) {
        assert (baseDocument != null);
        this.fDoc = baseDocument;
    }

    public BaseDocument getDocument() {
        return this.fDoc;
    }

    public int[] getTitleLines() {
        this.checkTree();
        int[] nArray = new int[this.fCells.size()];
        int n = 0;
        for (BaseDocumentCell baseDocumentCell : this.fCells) {
            if (baseDocumentCell.fIsImplicit) continue;
            try {
                nArray[n++] = Utilities.getLineOffset((BaseDocument)this.fDoc, (int)baseDocumentCell.fStartPos.getOffset());
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
        }
        return Arrays.copyOf(nArray, n);
    }

    public int[] getAllCellStarts() {
        this.checkTree();
        int[] nArray = new int[this.fCells.size()];
        int n = 0;
        for (BaseDocumentCell baseDocumentCell : this.fCells) {
            try {
                nArray[n++] = Utilities.getLineOffset((BaseDocument)this.fDoc, (int)baseDocumentCell.fStartPos.getOffset());
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
        }
        return nArray;
    }

    public int[] getAllCellStartsAndEnds() {
        this.checkTree();
        int[] nArray = new int[this.fCells.size() * 2];
        int n = 0;
        for (BaseDocumentCell baseDocumentCell : this.fCells) {
            try {
                nArray[n++] = Utilities.getLineOffset((BaseDocument)this.fDoc, (int)baseDocumentCell.fStartPos.getOffset());
                nArray[n++] = Utilities.getLineOffset((BaseDocument)this.fDoc, (int)baseDocumentCell.fEndPos.getOffset());
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
        }
        return nArray;
    }

    private BaseDocumentCell getCurrentCell(int n, boolean bl) {
        if (bl) {
            this.checkTree();
        }
        BaseDocumentCell baseDocumentCell = null;
        for (BaseDocumentCell baseDocumentCell2 : this.fCells) {
            int n2 = baseDocumentCell2.fStartPos.getOffset();
            int n3 = baseDocumentCell2.fEndPos.getOffset();
            if (n2 <= n && n3 >= n) {
                baseDocumentCell = baseDocumentCell2;
            }
            if (n2 <= n) continue;
            break;
        }
        return baseDocumentCell;
    }

    public int getPrevCellStartLine(int n) {
        BaseDocumentCell baseDocumentCell = this.getCurrentCell(n, true);
        int n2 = -1;
        try {
            if (baseDocumentCell != null) {
                int n3 = DocumentUtils.getLineStartAfterWhitespace(this.fDoc, Utilities.getLineOffset((BaseDocument)this.fDoc, (int)baseDocumentCell.fStartPos.getOffset()));
                if (n > n3) {
                    n2 = Utilities.getLineOffset((BaseDocument)this.fDoc, (int)n3);
                } else {
                    int n4 = this.fCells.indexOf(baseDocumentCell) - 1;
                    if (n4 >= 0) {
                        n2 = Utilities.getLineOffset((BaseDocument)this.fDoc, (int)this.fCells.get(n4).fStartPos.getOffset());
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        return n2;
    }

    public int getNextCellStartLine(int n) {
        BaseDocumentCell baseDocumentCell = this.getCurrentCell(n, true);
        int n2 = -1;
        try {
            int n3;
            if (baseDocumentCell != null && (n3 = this.fCells.indexOf(baseDocumentCell) + 1) < this.fCells.size()) {
                n2 = Utilities.getLineOffset((BaseDocument)this.fDoc, (int)this.fCells.get(n3).fStartPos.getOffset());
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        return n2;
    }

    public int[] getStartAndEndOfCell(int n) {
        BaseDocumentCell baseDocumentCell = this.getCurrentCell(n, true);
        int[] nArray = null;
        try {
            if (baseDocumentCell != null) {
                nArray = baseDocumentCell.getRange(this.fDoc);
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        return nArray;
    }

    public String getCellTextAtCaret(int n) {
        BaseDocumentCell baseDocumentCell = this.getCurrentCell(n, true);
        try {
            return baseDocumentCell == null ? null : this.fDoc.getText(baseDocumentCell.getStartPosition(), baseDocumentCell.getLength());
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return null;
        }
    }

    public void storeCurrentCell(int n) {
        this.fLastCell = this.getCurrentCell(n, true);
    }

    public boolean isCellSameAsLast(int n) {
        return this.fLastCell == this.getCurrentCell(n, false);
    }

    public boolean isOneImplicitCell() {
        this.checkTree();
        return this.fCells.size() == 1 && this.fCells.get(0).fIsImplicit;
    }

    private void checkTree() {
        MTree mTree = MDocumentUtils.getMTree(this.fDoc);
        if (mTree.isValid()) {
            try {
                List<Cell> list = CellUtils.getCellLocationsAsList(mTree.findAsList(MTree.NodeType.CELL_TITLE), this.fDoc.getText(0, this.fDoc.getLength()));
                try {
                    this.fCells.clear();
                    for (Cell object : list) {
                        this.fCells.add(new BaseDocumentCell(object, this.fDoc));
                    }
                }
                catch (BadLocationException badLocationException) {
                    Log.log((String)"Error creating base document cells from regular cells (below). Please geck this diagnostic information and attach the file you are editing.\n");
                    for (Cell cell : list) {
                        Log.log((String)(cell.toString() + "\n"));
                    }
                    Log.logException((Exception)badLocationException);
                }
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
            try {
                int n = Utilities.getFirstNonWhiteFwd((BaseDocument)this.fDoc, (int)0);
                if (this.fCells.isEmpty() || this.fCells.get(0).fStartPos.getOffset() > n) {
                    this.addCellForWholeFile();
                }
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
            assert (!this.fCells.isEmpty()) : "Should be at least one cell.";
            int n = 0;
            for (int i = 1; i < this.fCells.size(); ++i) {
                if (this.fCells.get(i).fEndPos.getOffset() <= this.fCells.get(n).fEndPos.getOffset()) continue;
                n = i;
            }
            if (this.fCells.get(n).fEndPos.getOffset() < this.fDoc.getLength()) {
                BaseDocumentCell baseDocumentCell = this.fCells.get(n);
                this.fCells.remove(n);
                try {
                    this.fCells.add(n, new BaseDocumentCell(baseDocumentCell.fStartPos, this.fDoc.createPosition(this.fDoc.getLength()), baseDocumentCell.fIsImplicit));
                }
                catch (BadLocationException badLocationException) {
                    Log.logException((Exception)badLocationException);
                }
            }
        } else if (this.fCells.isEmpty() || this.fCells.size() == 1 && this.fCells.get(0).isEmpty()) {
            this.fCells.clear();
            this.addCellForWholeFile();
        }
    }

    private void addCellForWholeFile() {
        try {
            this.fCells.add(0, new BaseDocumentCell(this.fDoc.createPosition(0), this.fDoc.createPosition(this.fDoc.getLength()), true));
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    private static class BaseDocumentCell {
        private final Position fStartPos;
        private final Position fEndPos;
        private final boolean fIsImplicit;

        private BaseDocumentCell(Cell cell, BaseDocument baseDocument) throws BadLocationException {
            this(baseDocument.createPosition(Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(cell.getStartLine() - 1))), baseDocument.createPosition(DocumentUtils.getRowEndFromLine(baseDocument, cell.getEndLine() - 1)), cell.isStartImplicit());
        }

        private BaseDocumentCell(Position position, Position position2, boolean bl) {
            this.fStartPos = position;
            this.fEndPos = position2;
            this.fIsImplicit = bl;
        }

        private boolean isEmpty() {
            return this.fStartPos.getOffset() == this.fEndPos.getOffset();
        }

        private int[] getRange(BaseDocument baseDocument) throws BadLocationException {
            return new int[]{Utilities.getLineOffset((BaseDocument)baseDocument, (int)this.fStartPos.getOffset()), Utilities.getLineOffset((BaseDocument)baseDocument, (int)this.fEndPos.getOffset())};
        }

        private int getStartPosition() {
            return this.fStartPos.getOffset();
        }

        private int getLength() {
            return this.fEndPos.getOffset() - this.fStartPos.getOffset();
        }
    }
}

