/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode;

import com.mathworks.services.Prefs;
import com.mathworks.widgets.text.mcode.BaseDocumentMTreeProvider;
import com.mathworks.widgets.text.mcode.MTree;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;

class MTreeBaseDocumentCache {
    private static final String MTREE_DISABLED_PREF = "CodeParserServiceOn";
    private static final String MTREE_DISABLED_FILESIZE_LIMIT = "CodeParserServiceFileSizeLimit";
    private static final Map<BaseDocument, BaseDocumentMTreeProvider> REGISTERED_DOCS = new WeakHashMap<BaseDocument, BaseDocumentMTreeProvider>();

    private MTreeBaseDocumentCache() {
    }

    static MTree getMTree(BaseDocument baseDocument) {
        MTreeBaseDocumentCache.checkPreconditions(baseDocument);
        if (MTreeBaseDocumentCache.shouldBlockMtree(baseDocument)) {
            return new MTree(0, false);
        }
        if (!REGISTERED_DOCS.containsKey(baseDocument)) {
            REGISTERED_DOCS.put(baseDocument, new BaseDocumentMTreeProvider(baseDocument));
        }
        return REGISTERED_DOCS.get(baseDocument).getMTree();
    }

    private static boolean shouldBlockMtree(BaseDocument baseDocument) {
        return !Prefs.getBooleanPref((String)MTREE_DISABLED_PREF, (boolean)true) && Utilities.getRowCount((BaseDocument)baseDocument) > MTreeBaseDocumentCache.getFileLineLimitForMTree();
    }

    private static int getFileLineLimitForMTree() {
        return Prefs.getIntegerPref((String)MTREE_DISABLED_FILESIZE_LIMIT, (int)4000);
    }

    static void removeFromCache(BaseDocument baseDocument) {
        MTreeBaseDocumentCache.checkPreconditions(baseDocument);
        if (REGISTERED_DOCS.containsKey(baseDocument)) {
            REGISTERED_DOCS.get(baseDocument).cleanup();
            REGISTERED_DOCS.remove(baseDocument);
        }
    }

    private static void checkPreconditions(BaseDocument baseDocument) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method can only be called on the EDT.");
        }
        Validate.notNull((Object)baseDocument, (String)"Document cannot be null.");
    }
}

